/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.settle;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class SelectSettleDataPlugin
extends AbstractListPlugin
implements ListRowClickListener {
    private Log logger = LogFactory.getLog(SelectSettleDataPlugin.class);

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowClickListener((ListRowClickListener)this);
        this.addClickListeners(new String[]{"btncancel", "returndata"});
    }

    public void beforeBindData(EventObject e) {
    }

    public void beforePackageData(BeforePackageDataEvent e) {
    }

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        DynamicObject d = e.getRowData();
        if (columnDesc.getKey().equals("openinglocalcurrency")) {
            BigDecimal openingLocalCurrency = d.getBigDecimal("openinglocalcurrency");
            BigDecimal openingCurrency = BigDecimal.ZERO.compareTo(openingLocalCurrency) <= 0 ? openingLocalCurrency.setScale(2, 4) : BigDecimal.valueOf(0.0);
            e.setFormatValue((Object)openingCurrency);
        } else if (columnDesc.getKey().equals("openingoriginalcurrency")) {
            BigDecimal openingLocalCurrency = d.getBigDecimal("openinglocalcurrency");
            openingLocalCurrency = BigDecimal.ZERO.compareTo(openingLocalCurrency) <= 0 ? BigDecimal.valueOf(0.0) : openingLocalCurrency.setScale(2, 4).abs();
            e.setFormatValue((Object)openingLocalCurrency);
        } else if (columnDesc.getKey().equals("closinglocalcurrency")) {
            BigDecimal closingLocalCurrency = d.getBigDecimal("closinglocalcurrency");
            BigDecimal closingCurrency = BigDecimal.ZERO.compareTo(closingLocalCurrency) <= 0 ? closingLocalCurrency.setScale(2, 4) : BigDecimal.valueOf(0.0);
            e.setFormatValue((Object)closingCurrency);
        } else if (columnDesc.getKey().equals("closingoriginalcurrency")) {
            BigDecimal closingLocalCurrency = d.getBigDecimal("closinglocalcurrency");
            closingLocalCurrency = BigDecimal.ZERO.compareTo(closingLocalCurrency) <= 0 ? BigDecimal.valueOf(0.0) : closingLocalCurrency.setScale(2, 4).abs();
            e.setFormatValue((Object)closingLocalCurrency);
        }
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
    }

    public void listRowClick(ListRowClickEvent evt) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if ("btncancel".equals(sourceKey)) {
            this.getView().close();
        } else if ("returndata".equals(sourceKey)) {
            BillList billlistap = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c", (String)"SelectSettleDataPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
            } else {
                this.getView().returnDataToParent((Object)selectedRows);
                this.getView().close();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
    }
}

