/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.settle;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.enums.OrgFuncEnum;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.ictm.business.rulefetch.impl.AbstractRuleEnginServiceImpl;
import kd.taxc.ictm.business.rulefetch.impl.DefaultRuleCalculateServiceImpl;
import kd.taxc.ictm.business.rulefetch.impl.IctmRuleAccessConfigServiceImpl;
import kd.taxc.ictm.business.taxmain.IctmTaxMainCommonBusiness;
import kd.taxc.ictm.common.constant.IctmEntityConstant;
import kd.taxc.ictm.common.enums.MemberEntityItemNameEnum;
import kd.taxc.ictm.common.util.BigDecimalUtil;
import kd.taxc.ictm.formplugin.settle.rulefetch.GbbgDataEnginServiceImpl;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SettleFacility {
    private static Log logger = LogFactory.getLog(SettleFacility.class);
    private static final String Member_Entity_ItemName_Enum = "MemberEntityItemNameEnum";
    private static final String acctcustomer = "acctcustomer";
    private static final String acctsupplier = "acctsupplier";

    public static void calAndSaveData(List<Long> orgIds, Date startDate, Date endDate, Boolean saveUserEditData) {
        if (EmptyCheckUtils.isEmpty(orgIds) || startDate == null || endDate == null) {
            return;
        }
        List<DynamicObject> taxMains = IctmTaxMainCommonBusiness.getAllTaxMainByOrgId(orgIds);
        logger.info("\u83b7\u53d6\u6ce8\u518c\u5730\u5bf9\u5e94\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4e2a\u6570:{}", (Object)(org.apache.commons.collections4.CollectionUtils.isEmpty(taxMains) ? 0 : taxMains.size()));
        Map<Long, String> nsrmcMap = SettleFacility.getNsrmc(taxMains);
        logger.info("\u83b7\u53d6\u7ec4\u7ec7\u5bf9\u5e94\u7eb3\u7a0e\u4eba\u540d\u79f0:{}", (Object)(MapUtils.isEmpty(nsrmcMap) ? "" : SerializationUtils.toJsonString(nsrmcMap)));
        Map<Long, Long> countryIdMap = SettleFacility.getCountryIdMap(taxMains);
        logger.info("\u83b7\u53d6\u7ec4\u7ec7\u5bf9\u5e94\u5730\u533a:{}", (Object)(MapUtils.isEmpty(countryIdMap) ? "" : SerializationUtils.toJsonString(countryIdMap)));
        Map<Long, Long> zcBzMap = SettleFacility.getZcBzList(taxMains);
        logger.info("\u83b7\u53d6\u7ec4\u7ec7\u5bf9\u5e94\u6ce8\u518c\u5e01\u79cd:{}", (Object)(MapUtils.isEmpty(zcBzMap) ? "" : SerializationUtils.toJsonString(zcBzMap)));
        Map<Long, BigDecimal> zcjeMap = SettleFacility.getZczbJe(taxMains);
        logger.info("\u83b7\u53d6\u7ec4\u7ec7\u5bf9\u5e94\u6ce8\u518c\u5e01\u79cd:{}", (Object)(MapUtils.isEmpty(zcBzMap) ? "" : SerializationUtils.toJsonString(zcBzMap)));
        Map<Long, Long> ssgxdCountryId = SettleFacility.getSsgxd(taxMains);
        Map exchangeMap = SystemParamUtil.getAppParameterBatch((String)"ictm", (String)"exchange", orgIds);
        List<Long> allOrgIds = SettleFacility.getAllOrgIds(startDate, endDate, orgIds);
        List<DynamicObject> allTaxMains = IctmTaxMainCommonBusiness.getAllTaxMainByOrgId(allOrgIds);
        Map<Long, Long> acctcustomerMap = SettleFacility.getAcctcustomerMap(allTaxMains);
        Map<Long, Long> acctsupplierMap = SettleFacility.getAcctsupplierMap(allTaxMains);
        List<DynamicObject> bwbDyoList = SettleFacility.getBwbList(orgIds, startDate, endDate, nsrmcMap, countryIdMap, zcBzMap, zcjeMap, ssgxdCountryId, acctcustomerMap, acctsupplierMap, exchangeMap, saveUserEditData);
        SaveServiceHelper.save((DynamicObject[])bwbDyoList.toArray(new DynamicObject[0]));
    }

    public static List<Long> getAllOrgIds(Date startDate, Date endDate, List<Long> orgIds) {
        DynamicObjectCollection memberSettle = QueryServiceHelper.query((String)"ictm_member_settle", (String)"id,org,datagenermethod", (QFilter[])SettleFacility.getDateFilter(startDate, endDate).toArray());
        List<Long> orgsFromBb = memberSettle.stream().map(m -> m.getLong("org")).distinct().collect(Collectors.toList());
        orgsFromBb.addAll(orgIds);
        return orgsFromBb;
    }

    public static List<DynamicObject> getBwbList(List<Long> orgIds, Date startDate, Date endDate, Map<Long, String> nsrmcMap, Map<Long, Long> countryidMap, Map<Long, Long> zcBzMap, Map<Long, BigDecimal> zcjeMap, Map<Long, Long> ssgxdCountryId, Map<Long, Long> acctcustomerMap, Map<Long, Long> acctsupplierMap, Map<Long, Object> exchangeMap, Boolean saveUserData) {
        ArrayList<DynamicObject> bwbDyoList = new ArrayList<DynamicObject>(8);
        for (Long orgId : orgIds) {
            Long countryId;
            QFilter filter = new QFilter("org.id", "=", (Object)orgId).and("startdate", "=", (Object)startDate).and("enddate", "=", (Object)endDate);
            DynamicObject bwbDyo = BusinessDataServiceHelper.loadSingle((String)"ictm_member_settle", (QFilter[])filter.toArray());
            if (bwbDyo == null) {
                bwbDyo = BusinessDataServiceHelper.newDynamicObject((String)"ictm_member_settle");
            }
            bwbDyo.set("org", (Object)orgId);
            String taxpayerName = nsrmcMap.get(orgId);
            if (StringUtils.isEmpty((CharSequence)taxpayerName)) continue;
            bwbDyo.set("taxpayername", (Object)taxpayerName);
            bwbDyo.set("startdate", (Object)startDate);
            bwbDyo.set("enddate", (Object)endDate);
            if (bwbDyo.get("initstartdate") == null) {
                bwbDyo.set("initstartdate", (Object)startDate);
            }
            if (bwbDyo.get("initenddate") == null) {
                bwbDyo.set("initenddate", (Object)endDate);
            }
            if ((countryId = countryidMap.get(orgId)) == null) continue;
            bwbDyo.set("countryid", (Object)countryId);
            Long zcbz = zcBzMap.get(orgId);
            bwbDyo.set("capitalcurrency", (Object)zcbz);
            Long basecurrrency = SettleFacility.getAccountOrgBasecurrrency(orgId);
            if (basecurrrency == -1L) {
                basecurrrency = 0L;
            }
            bwbDyo.set("currency", (Object)basecurrrency);
            BigDecimal zcje = zcjeMap.get(orgId);
            bwbDyo.set("registeredcapital", (Object)zcje);
            Long ssgxd = ssgxdCountryId.get(orgId);
            if (ssgxd == null) continue;
            bwbDyo.set("taxjurisdiction", (Object)ssgxd);
            SettleFacility.fetchRuleValue(bwbDyo, acctcustomerMap, acctsupplierMap, saveUserData, false);
            BigDecimal nonrelateincome = bwbDyo.getBigDecimal("allincome").subtract(bwbDyo.getBigDecimal("relateincome"));
            bwbDyo.set("nonrelateincome", (Object)nonrelateincome);
            bwbDyo.set("remark", (Object)"");
            bwbDyo.set("datagenermethod", (Object)"gzqs");
            long currUserId = RequestContext.get().getCurrUserId();
            bwbDyo.set("creator", (Object)currUserId);
            bwbDyo.set("modifier", (Object)currUserId);
            Date date = new Date();
            bwbDyo.set("createtime", (Object)date);
            bwbDyo.set("modifytime", (Object)date);
            SettleFacility.setCnyField(exchangeMap, orgId, bwbDyo);
            bwbDyoList.add(bwbDyo);
        }
        return bwbDyoList;
    }

    public static void setCnyField(Map<Long, Object> exchangeMap, Long orgId, DynamicObject bwbDyo) {
        long currency = bwbDyo.get("capitalcurrency") instanceof Long ? bwbDyo.getLong("capitalcurrency") : bwbDyo.getLong("capitalcurrency.id");
        BigDecimal zcRate = SettleFacility.getRate(exchangeMap, orgId, currency, bwbDyo.getDate("enddate"));
        BigDecimal zcResult = bwbDyo.getBigDecimal("registeredcapital") == null ? BigDecimal.ZERO : bwbDyo.getBigDecimal("registeredcapital").multiply(zcRate).setScale(2, RoundingMode.HALF_UP);
        bwbDyo.set("registeredcapitalcny", (Object)zcResult);
        currency = bwbDyo.get("currency") instanceof Long ? bwbDyo.getLong("currency") : bwbDyo.getLong("currency.id");
        BigDecimal bwbRate = SettleFacility.getRate(exchangeMap, orgId, currency, bwbDyo.getDate("enddate"));
        for (String filed : IctmEntityConstant.SETTLE_NUM_FILEDS) {
            if ("registeredcapital".equalsIgnoreCase(filed)) continue;
            BigDecimal bwbResult = bwbDyo.getBigDecimal(filed) == null ? BigDecimal.ZERO : bwbDyo.getBigDecimal(filed).multiply(bwbRate).setScale(2, RoundingMode.HALF_UP);
            bwbDyo.set(filed + "cny", (Object)bwbResult);
        }
    }

    public static void fetchRuleValue(DynamicObject bwbDyo, Map<Long, Long> customerMap, Map<Long, Long> supplierMap, Boolean saveUserData, Boolean justHandleInter) {
        for (MemberEntityItemNameEnum nameEnum : MemberEntityItemNameEnum.values()) {
            if (justHandleInter.booleanValue() && !nameEnum.getIsNeed().booleanValue()) continue;
            ArrayList<RuleFetchMainDto> allRuleFetchMainDtos = new ArrayList<RuleFetchMainDto>(8);
            if (saveUserData.booleanValue() && SettleFacility.checkEdit(nameEnum, bwbDyo)) continue;
            Date startDate = bwbDyo.getDate("startdate");
            Date endDate = bwbDyo.getDate("enddate");
            long orgId = bwbDyo.get("org") instanceof Long ? bwbDyo.getLong("org") : bwbDyo.getLong("org.id");
            QFilter accessWhereFilter = new QFilter("itemname.id", "=", (Object)nameEnum.getItemId());
            QFilter sharingSchemeWhereFilter = new QFilter("ruleentity.rule.itemname.id", "in", (Object)nameEnum.getItemId());
            HashMap<String, Object> extendParamMap = new HashMap<String, Object>(8);
            extendParamMap.put(Member_Entity_ItemName_Enum, (Object)nameEnum);
            extendParamMap.put(acctcustomer, new HashSet<Long>(customerMap.values()));
            extendParamMap.put(acctsupplier, new HashSet<Long>(supplierMap.values()));
            RuleEngineParamDto engineParamDto = new RuleEngineParamDto(Long.valueOf(orgId), startDate, endDate, nameEnum.getItemId(), accessWhereFilter, sharingSchemeWhereFilter, extendParamMap);
            IctmRuleAccessConfigServiceImpl accessConfigService = new IctmRuleAccessConfigServiceImpl("ictm_declare_rule_config", "ictm_sharing_scheme");
            List<AbstractRuleEnginServiceImpl> enginServices = Stream.of(new GbbgDataEnginServiceImpl()).collect(Collectors.toList());
            List<RuleFetchMainDto> ruleFetchMains = new DefaultRuleCalculateServiceImpl().calculateRuleAccess(engineParamDto, enginServices, accessConfigService);
            BigDecimal result = BigDecimal.ZERO;
            if (ruleFetchMains != null && ruleFetchMains.size() > 0) {
                for (RuleFetchMainDto dto : ruleFetchMains) {
                    if (dto.getRuleFetchCellSummaryList() == null || dto.getRuleFetchCellSummaryList().size() <= 0) continue;
                    result = BigDecimalUtil.addObject(result, ((RuleFetchCellSummaryDto)dto.getRuleFetchCellSummaryList().get(0)).getAmount());
                }
                allRuleFetchMainDtos.addAll(ruleFetchMains);
            }
            bwbDyo.set(nameEnum.getField(), (Object)result);
            RuleFetchMainDto saveData = (RuleFetchMainDto)allRuleFetchMainDtos.get(0);
            saveData.setDatastatus("1");
            if (allRuleFetchMainDtos.size() > 1) {
                for (int i = 1; i < allRuleFetchMainDtos.size(); ++i) {
                    saveData.getRuleFetchCellSummaryList().addAll(((RuleFetchMainDto)allRuleFetchMainDtos.get(i)).getRuleFetchCellSummaryList());
                }
            }
            try {
                SettleFacility.callRuleFetchService(saveData);
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u53d6\u6570\u7ed3\u679c\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        }
    }

    public static boolean checkEdit(MemberEntityItemNameEnum nameEnum, DynamicObject bwbDyo) {
        String field = nameEnum.getField();
        Date startDate = bwbDyo.getDate("startdate");
        Date endDate = bwbDyo.getDate("enddate");
        long orgId = bwbDyo.get("org") instanceof Long ? bwbDyo.getLong("org") : bwbDyo.getLong("org.id");
        QFilter qFilter = new QFilter("org", "=", (Object)orgId).and("ruletable", "=", (Object)"ictm_declare_rule_config").and("reportitem", "=", (Object)("ictm_member_settle#" + field)).and("skssqq", "=", (Object)startDate).and("skssqz", "=", (Object)endDate);
        DynamicObject summary = QueryServiceHelper.queryOne((String)"bdtaxr_rule_fetch_summary", (String)"adjustamount", (QFilter[])qFilter.toArray());
        if (summary != null) {
            return summary.getBigDecimal("adjustamount").compareTo(BigDecimal.ZERO) != 0;
        }
        return false;
    }

    private static long callRuleFetchService(RuleFetchMainDto ruleFetchMainDto) {
        RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
        ruleFetchService.delRuleFetchData(Long.valueOf(ruleFetchService.existedMainId(ruleFetchMainDto)));
        return ruleFetchService.saveFetchResult(ruleFetchMainDto, false);
    }

    public static BigDecimal getRate(Map<Long, Object> exchangeMap, long orgId, long currency, Date endDate) {
        BigDecimal rate = BigDecimal.ZERO;
        if (currency == 0L) {
            return rate;
        }
        Long rategroupId = null;
        if (exchangeMap == null || exchangeMap.get(orgId) == null) {
            return rate;
        }
        Object value = exchangeMap.get(orgId);
        if (value instanceof Map) {
            Map exchangeConfig = (Map)value;
            rategroupId = Long.parseLong(String.valueOf(exchangeConfig.get("id")));
        } else if (value instanceof DynamicObject) {
            rategroupId = ((DynamicObject)value).getLong("id");
        }
        QFilter filter = new QFilter("exctable", "=", (Object)rategroupId).and("orgcur", "=", (Object)currency).and("cur", "=", (Object)1L).and("enable", "=", (Object)"1").and("effectdate", "<=", (Object)endDate).and("status", "=", (Object)"C");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_exrate_tree", (String)"orgcur,cur,excval,effectdate", (QFilter[])filter.toArray(), (String)"effectdate desc");
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            rate = dynamicObject.getBigDecimal("excval");
        }
        return rate;
    }

    public static Map<Long, String> getNsrmc(List<DynamicObject> taxMains) {
        HashMap<Long, String> longStringHashMap = new HashMap<Long, String>(8);
        if (taxMains == null || taxMains.size() == 0) {
            return longStringHashMap;
        }
        List registerplace = taxMains.stream().filter(p -> p.getBoolean("taxjurisdiction")).collect(Collectors.toList());
        for (DynamicObject taxMain : registerplace) {
            long orgId = taxMain.getLong("orgid.id");
            long taxationsys = taxMain.getLong("taxationsys.id");
            DynamicObjectCollection dynamicObjectCollection = taxMain.getDynamicObjectCollection("taxorg.entryentity");
            for (DynamicObject object : dynamicObjectCollection) {
                if (taxationsys != object.getLong("entry_taxationsys.id")) continue;
                String entryTaxpayer = object.getString("entry_taxpayer");
                longStringHashMap.put(orgId, entryTaxpayer);
            }
        }
        return longStringHashMap;
    }

    public static Map<Long, Long> getCountryIdMap(List<DynamicObject> taxMains) {
        HashMap<Long, Long> longStringHashMap = new HashMap<Long, Long>(8);
        if (taxMains == null || taxMains.size() == 0) {
            return longStringHashMap;
        }
        List registerplace = taxMains.stream().filter(p -> p.getBoolean("registerplace")).collect(Collectors.toList());
        for (DynamicObject dynamicObject : registerplace) {
            long orgId = dynamicObject.getLong("orgid.id");
            if (dynamicObject.get("taxationsys") == null) continue;
            Long countryid = dynamicObject.getLong("taxationsys.countryid.id");
            longStringHashMap.put(orgId, countryid);
        }
        return longStringHashMap;
    }

    public static Map<Long, Long> getZcBzList(List<DynamicObject> taxMains) {
        HashMap<Long, Long> longStringHashMap = new HashMap<Long, Long>(8);
        if (taxMains == null || taxMains.size() == 0) {
            return longStringHashMap;
        }
        List registerplace = taxMains.stream().filter(p -> p.getBoolean("registerplace")).collect(Collectors.toList());
        for (DynamicObject taxMain : registerplace) {
            long orgId = taxMain.getLong("orgid.id");
            if (taxMain.get("registeredcurrency") == null) continue;
            long registeredcurrency = taxMain.getLong("registeredcurrency.id");
            longStringHashMap.put(orgId, registeredcurrency);
        }
        return longStringHashMap;
    }

    public static Map<Long, BigDecimal> getZczbJe(List<DynamicObject> taxMains) {
        HashMap<Long, BigDecimal> longStringHashMap = new HashMap<Long, BigDecimal>(8);
        if (taxMains == null || taxMains.size() == 0) {
            return longStringHashMap;
        }
        List registerplace = taxMains.stream().filter(p -> p.getBoolean("registerplace")).collect(Collectors.toList());
        for (DynamicObject dynamicObject : registerplace) {
            long orgId = dynamicObject.getLong("orgid.id");
            BigDecimal registeredcurrency = dynamicObject.getBigDecimal("registeredcapital");
            longStringHashMap.put(orgId, registeredcurrency);
        }
        return longStringHashMap;
    }

    public static Map<Long, Long> getAcctcustomerMap(List<DynamicObject> taxMains) {
        HashMap<Long, Long> longStringHashMap = new HashMap<Long, Long>(8);
        if (taxMains == null || taxMains.size() == 0) {
            return longStringHashMap;
        }
        List registerplace = taxMains.stream().filter(p -> p.getBoolean("registerplace")).collect(Collectors.toList());
        for (DynamicObject dynamicObject : registerplace) {
            long orgId = dynamicObject.getLong("orgid.id");
            if (dynamicObject.get(acctcustomer) == null) continue;
            Long acctcustomer = dynamicObject.getLong("acctcustomer.id");
            longStringHashMap.put(orgId, acctcustomer);
        }
        return longStringHashMap;
    }

    public static Map<Long, Long> getAcctsupplierMap(List<DynamicObject> taxMains) {
        HashMap<Long, Long> longStringHashMap = new HashMap<Long, Long>(8);
        if (taxMains == null || taxMains.size() == 0) {
            return longStringHashMap;
        }
        List registerplace = taxMains.stream().filter(p -> p.getBoolean("registerplace")).collect(Collectors.toList());
        for (DynamicObject dynamicObject : registerplace) {
            long orgId = dynamicObject.getLong("orgid.id");
            if (dynamicObject.get(acctsupplier) == null) continue;
            Long acctsupplier = dynamicObject.getLong("acctsupplier.id");
            longStringHashMap.put(orgId, acctsupplier);
        }
        return longStringHashMap;
    }

    public static Map<Long, Long> getSsgxd(List<DynamicObject> taxMains) {
        HashMap<Long, Long> longStringHashMap = new HashMap<Long, Long>(8);
        if (taxMains == null || taxMains.size() == 0) {
            return longStringHashMap;
        }
        List registerplace = taxMains.stream().filter(p -> p.getBoolean("taxjurisdiction")).collect(Collectors.toList());
        for (DynamicObject dynamicObject : registerplace) {
            long orgId = dynamicObject.getLong("orgid.id");
            if (dynamicObject.get("taxationsys") == null) continue;
            Long countryid = dynamicObject.getLong("taxationsys.countryid.id");
            longStringHashMap.put(orgId, countryid);
        }
        return longStringHashMap;
    }

    public static Long getAccountOrgBasecurrrency(Long accountOrg) {
        Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)accountOrg);
        if (ObjectUtils.isNotEmpty((Object)baseAccountingInfo)) {
            return (Long)baseAccountingInfo.get("baseCurrencyID");
        }
        return -1L;
    }

    public static QFilter getDateFilter(Date startDate, Date endDate) {
        return new QFilter("initstartdate", "=", (Object)startDate).and("initenddate", "=", (Object)endDate);
    }

    public static List<Long> getOrgListHasPermissionAll() {
        TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)RequestContext.get().getCurrUserId(), (String)OrgFuncEnum.TAX.getNumber(), (boolean)true);
        if (listTaxResult.isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
            return (List)listTaxResult.getData();
        }
        return new ArrayList<Long>(8);
    }
}

