/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.settle.rulefetch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCardDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchDetailDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.ictm.business.rulefetch.impl.AbstractRuleEnginServiceImpl;
import kd.taxc.ictm.business.rulefetch.impl.DefaultRuleAccessConfigServiceImpl;
import kd.taxc.ictm.common.dto.RuleAccessDetailDto;
import kd.taxc.ictm.common.enums.EntryNameEnum;
import kd.taxc.ictm.common.enums.MemberEntityItemNameEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class GbbgDataEnginServiceImpl
extends AbstractRuleEnginServiceImpl {
    private static final String Member_Entity_ItemName_Enum = "MemberEntityItemNameEnum";
    private static final String acctcustomer = "acctcustomer";
    private static final String acctsupplier = "acctsupplier";

    @Override
    protected RuleFetchMainDto handleBuildRuleFetchMainDto(RuleEngineParamDto ruleEngineParamDto, List<RuleAccessDetailDto> ruleAccessDetails, DefaultRuleAccessConfigServiceImpl ruleAccessConfigService) {
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto(ruleEngineParamDto.getTaxOrgId(), ruleEngineParamDto.getSkssqq(), ruleEngineParamDto.getSkssqz(), ruleEngineParamDto.getTemplateId(), ruleEngineParamDto.getDraftPurpose());
        Map extendParams = ruleEngineParamDto.getExtendParams();
        MemberEntityItemNameEnum memberEntityItemNameEnum = (MemberEntityItemNameEnum)((Object)extendParams.get(Member_Entity_ItemName_Enum));
        Set customerIds = (Set)extendParams.get(acctcustomer);
        Set supplierIds = (Set)extendParams.get(acctsupplier);
        String field = memberEntityItemNameEnum.getField();
        Map<Long, List<RuleAccessDetailDto>> accessConfigIdAndAccessDetailMap = ruleAccessDetails.stream().collect(Collectors.groupingBy(p -> p.getAccessConfig().getLong("id")));
        for (Map.Entry<Long, List<RuleAccessDetailDto>> entry : accessConfigIdAndAccessDetailMap.entrySet()) {
            String ruleId = "";
            String ruleName = "";
            String projectId = "";
            DynamicObject accessConfig = entry.getValue().get(0).getAccessConfig();
            if (ObjectUtils.isNotEmpty((Object)accessConfig)) {
                ruleId = accessConfig.getString("id");
                ruleName = accessConfig.getString("name");
                projectId = accessConfig.getString("itemname.id");
            }
            AtomicReference<BigDecimal> originalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            AtomicReference<BigDecimal> fetchAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            RuleFetchCardDto cardDto = new RuleFetchCardDto(ruleName, ruleId, ruleName, ruleEngineParamDto.getTaxOrgId(), fetchAmount.get());
            entry.getValue().forEach(ruleAccessDetail -> {
                BigDecimal detailOriginalAmount = BigDecimal.ZERO;
                List<Object> amounts = new ArrayList(8);
                if (!(!memberEntityItemNameEnum.getIsNeed().booleanValue() || CollectionUtils.isEmpty((Collection)customerIds) && CollectionUtils.isEmpty((Collection)supplierIds))) {
                    for (Map<String, Object> map : ruleAccessDetail.getBizDataList()) {
                        BigDecimal value;
                        Long customerId = (Long)map.get("customer");
                        Long supplierId = (Long)map.get("supplier");
                        if (customerId == null || supplierId == null || !customerIds.contains(customerId) && !supplierIds.contains(supplierId) || (value = (BigDecimal)map.get(ruleAccessDetail.getAmountFieldNum())) == null) continue;
                        amounts.add(value);
                    }
                } else {
                    amounts = ruleAccessDetail.getBizDataList().stream().map(p -> (BigDecimal)p.get(ruleAccessDetail.getAmountFieldNum())).filter(Objects::nonNull).collect(Collectors.toList());
                }
                for (BigDecimal bigDecimal : amounts) {
                    detailOriginalAmount = detailOriginalAmount.add(bigDecimal);
                }
                originalAmount.set(((BigDecimal)originalAmount.get()).add(detailOriginalAmount));
                BigDecimal detailFetchAmount = this.convertFetchAmount(detailOriginalAmount, (RuleAccessDetailDto)ruleAccessDetail);
                fetchAmount.set(((BigDecimal)fetchAmount.get()).add(detailFetchAmount));
                RuleFetchDetailDto ruleFetchDetailDto = new RuleFetchDetailDto(ruleAccessDetail.getStartDate(), ruleAccessDetail.getEndDate(), ruleAccessDetail.getBizName(), ruleAccessDetail.getDataSource(), ruleAccessDetail.getAmountField(), ruleAccessDetail.getFetchType(), ruleAccessDetail.getFetchDirection(), detailFetchAmount, detailOriginalAmount, ruleAccessDetail.getAbsolute(), ruleAccessDetail.getFilterCondition());
                ruleFetchDetailDto.setConditionJson(ruleAccessDetail.getConditionJson());
                ruleFetchDetailDto.setAdvancedconfjson(ruleAccessDetail.getAdvancedConfJson());
                cardDto.getRuleFetchDetailList().add(ruleFetchDetailDto);
                cardDto.setAmount((BigDecimal)fetchAmount.get());
            });
            RuleFetchCellSummaryDto cellSummaryDto = new RuleFetchCellSummaryDto("ictm_declare_rule_config", ruleId, projectId, "", fetchAmount.get(), originalAmount.get());
            cellSummaryDto.getRuleFetchCardList().add(cardDto);
            cellSummaryDto.setReportItem("ictm_member_settle#" + field);
            ruleFetchMainDto.getRuleFetchCellSummaryList().add(cellSummaryDto);
        }
        return ruleFetchMainDto;
    }

    @Override
    protected Map<Long, String> getDatasourceSelectFields(RuleAccessDetailDto ruleAccessDetail) {
        EntryNameEnum entryNameEnum = EntryNameEnum.getEnumByEntryName(ruleAccessDetail.getEntityName());
        if (entryNameEnum == null) {
            return super.getDatasourceSelectFields(ruleAccessDetail);
        }
        HashMap<Long, String> result = new HashMap<Long, String>(entryNameEnum.getSelectFields().size() + 1);
        result.putAll(entryNameEnum.getSelectFields());
        result.put(ruleAccessDetail.getAmountField(), ruleAccessDetail.getAmountFieldNum());
        return result;
    }
}

