/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.formplugin.systemparam;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;

public class ControllingCompanyPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        List list;
        String controllingcompanyDetailStr = (String)this.getView().getFormShowParameter().getCustomParam("controllingcompanydetail");
        if (!StringUtils.isBlank((CharSequence)controllingcompanyDetailStr) && !(list = SerializationUtils.fromJsonStringToList((String)controllingcompanyDetailStr, Map.class)).isEmpty()) {
            this.updateEntryData("entryentity", list);
        }
    }

    private void updateEntryData(String entryName, List<Map<String, Object>> dataList) {
        if (!dataList.isEmpty()) {
            this.getModel().deleteEntryData(entryName);
            for (int i = 0; i < dataList.size(); ++i) {
                int row = this.getModel().createNewEntryRow(entryName);
                Map<String, Object> item = dataList.get(i);
                TaxResult orgDynamicObject = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)Long.parseLong((String)item.get("companyorg")));
                DynamicObject orgDy = (DynamicObject)orgDynamicObject.getData();
                this.getModel().setValue("companyorg", (Object)orgDy, row);
                this.getModel().setValue("startdate", (Object)DateUtils.stringToDate((String)((String)item.get("startdate"))), row);
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            List<Map<String, Object>> paraList = this.getMaps("entryentity");
            if (paraList == null) {
                return;
            }
            this.getView().returnDataToParent(paraList);
            this.getView().close();
        }
    }

    private List<Map<String, Object>> getMaps(String entityName) {
        DynamicObjectCollection entryEntityData = this.getModel().getEntryEntity(entityName);
        ArrayList<Map<String, Object>> paraList = new ArrayList<Map<String, Object>>(entryEntityData.size());
        ArrayList eventKeys = new ArrayList();
        String eventKeysCache = this.getPageCache().get("eventKeys_old");
        ArrayList eventKeysOld = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)eventKeysCache)) {
            eventKeysOld = (ArrayList)SerializationUtils.fromJsonString((String)eventKeysCache, ArrayList.class);
        }
        HashSet<Date> dateSet = new HashSet<Date>(16);
        int count = entryEntityData.size();
        for (int i = 0; i < entryEntityData.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntityData.get(i);
            if (!this.checkValid(dynamicObject)) {
                return null;
            }
            dateSet.add(dynamicObject.getDate("startdate"));
            HashMap<String, Object> para = new HashMap<String, Object>(20);
            para.put("companyorg", dynamicObject.getString("companyorg.id"));
            para.put("companyorgname", dynamicObject.getString("companyorg.name"));
            para.put("startdate", dynamicObject.get("startdate"));
            paraList.add(para);
        }
        int dateSetCount = dateSet.size();
        if (count != dateSetCount) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u6709\u6548\u671f\u8d77\uff0c\u8bf7\u4fee\u6539", (String)"ControllingCompanyPlugin_0", (String)"taxc-ictm", (Object[])new Object[0]));
            return null;
        }
        eventKeysOld.addAll(eventKeys);
        this.getPageCache().put("eventKeys_old", SerializationUtils.toJsonString((Object)eventKeysOld));
        return paraList;
    }

    private boolean checkValid(DynamicObject dynamicObject) {
        if (!StringUtils.isBlank((Object)dynamicObject.get("companyorg")) && !StringUtils.isBlank((Object)dynamicObject.get("startdate"))) {
            return true;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879", (String)"ControllingCompanyPlugin_1", (String)"taxc-ictm", (Object[])new Object[0]));
        return false;
    }
}

