/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.ictm.business.othertransdetail.OtherTransDetailBusiness;
import kd.taxc.ictm.common.dto.ValidatorResultDto;
import kd.taxc.ictm.common.enums.BigDecimalValueConditionEnum;
import kd.taxc.ictm.common.util.DateUtils;
import kd.taxc.ictm.opplugin.importdatavalidator.AbstractImportDataValidator;
import kd.taxc.ictm.opplugin.importdatavalidator.BigDecimalValueValidator;
import kd.taxc.ictm.opplugin.importdatavalidator.RelatedPartyValueValidator;
import kd.taxc.ictm.opplugin.importdatavalidator.TaxOrgValueValidator;
import kd.taxc.ictm.opplugin.importdatavalidator.YearValueValidator;

public class OtherTransDetailSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        Map vas = this.getOption().getVariables();
        if (vas.containsKey("importtype") && Stream.of("new", "override", "overridenew").anyMatch(p -> p.equals(vas.get("importtype")))) {
            e.addValidator((AbstractValidator)new OtherTransDetailImportValidator());
        }
    }

    public static class OtherTransDetailImportValidator
    extends AbstractValidator {
        public void validate() {
            List<String> orgNumbers = Arrays.stream(this.dataEntities).map(p -> p.getDataEntity().getDynamicObject("org").getString("number")).collect(Collectors.toList());
            TaxOrgValueValidator taxOrgValueValidator = new TaxOrgValueValidator(orgNumbers);
            List<String> relatedPartyNames = Arrays.stream(this.dataEntities).map(p -> p.getDataEntity().getDynamicObject("relatedparty").getString("name")).collect(Collectors.toList());
            AbstractImportDataValidator validator = new AbstractImportDataValidator.Builder().addValidator(taxOrgValueValidator).addValidator(new YearValueValidator()).addValidator(new RelatedPartyValueValidator(relatedPartyNames, false)).addValidator(new BigDecimalValueValidator("transamount", BigDecimal.ZERO, BigDecimalValueConditionEnum.GREATER_THAN, ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d\u22640", (String)"OtherTransDetailSaveOp_0", (String)"taxc-ictm", (Object[])new Object[0]))).build();
            HashMap<String, Object> extendParams = new HashMap<String, Object>(0);
            List<String> repeatDataUniqueKeys = this.getImportDataRepeatUniqueKeys();
            DynamicObjectCollection otherTransDetails = OtherTransDetailBusiness.getAllData();
            ArrayList<String> existUniqueKeys = new ArrayList<String>(otherTransDetails.size());
            for (DynamicObject otherTransDetail : otherTransDetails) {
                existUniqueKeys.add(this.getDatabaseDataUniqueKey(otherTransDetail));
            }
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                if (repeatDataUniqueKeys.contains(this.getImportDataUniqueKey(dataEntity.getDataEntity()))) continue;
                this.verifyImportData(dataEntity, validator, extendParams, existUniqueKeys);
            }
        }

        private List<String> getImportDataRepeatUniqueKeys() {
            Map<String, List<ExtendedDataEntity>> repeatData = Arrays.stream(this.dataEntities).collect(Collectors.groupingBy(p -> this.getImportDataUniqueKey(p.getDataEntity())));
            ArrayList<String> repeatUniqueKeys = new ArrayList<String>(repeatData.size());
            for (Map.Entry<String, List<ExtendedDataEntity>> entry : repeatData.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                ExtendedDataEntity data = entry.getValue().get(0);
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u6570\u636e\uff08\u7a0e\u52a1\u7ec4\u7ec7+\u5e74\u5ea6+\u5173\u8054\u65b9+\u4ea4\u6613\u63cf\u8ff0\uff09", (String)"OtherTransDetailSaveOp_1", (String)"taxc-ictm", (Object[])new Object[0]));
                repeatUniqueKeys.add(entry.getKey());
            }
            return repeatUniqueKeys;
        }

        private String getImportDataUniqueKey(DynamicObject data) {
            StringJoiner joiner = new StringJoiner("#");
            joiner.add(data.getDynamicObject("org").getString("number"));
            joiner.add(String.valueOf(DateUtils.getYear(data.getDate("year"))));
            joiner.add(data.getDynamicObject("relatedparty").getString("name"));
            joiner.add(data.getString("transactiondesc"));
            return joiner.toString();
        }

        private String getDatabaseDataUniqueKey(DynamicObject data) {
            StringJoiner joiner = new StringJoiner("#");
            joiner.add(data.getString("org.number"));
            joiner.add(String.valueOf(DateUtils.getYear(data.getDate("year"))));
            joiner.add(data.getString("relatedparty.name"));
            joiner.add(data.getString("transactiondesc"));
            return joiner.toString();
        }

        private boolean verifyImportData(ExtendedDataEntity data, AbstractImportDataValidator validator, Map<String, Object> extendParams, List<String> existUniqueKeys) {
            ValidatorResultDto validatorResult = validator.doValidate(data.getDataEntity(), extendParams);
            if (!validatorResult.getSuccess().booleanValue()) {
                this.addErrorMessage(data, validatorResult.getTipMessage());
                return false;
            }
            if (existUniqueKeys.contains(this.getImportDataUniqueKey(data.getDataEntity()))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0e\u7cfb\u7edf\u73b0\u6709\u4ea4\u6613\u6570\u636e\u91cd\u590d", (String)"OtherTransDetailSaveOp_2", (String)"taxc-ictm", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
    }
}

