/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.opplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.ictm.common.dto.ValidatorResultDto;
import kd.taxc.ictm.common.enums.BigDecimalValueConditionEnum;
import kd.taxc.ictm.common.util.DateUtils;
import kd.taxc.ictm.opplugin.importdatavalidator.AbstractImportDataValidator;
import kd.taxc.ictm.opplugin.importdatavalidator.BigDecimalValueValidator;
import kd.taxc.ictm.opplugin.importdatavalidator.RelatedPartyValueValidator;
import kd.taxc.ictm.opplugin.importdatavalidator.TaxOrgValueValidator;
import kd.taxc.ictm.opplugin.importdatavalidator.YearValueValidator;
import org.apache.commons.lang3.ObjectUtils;

public class RelatedFinancingSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        Map vas = this.getOption().getVariables();
        if (vas.containsKey("importtype") && Stream.of("new", "override", "overridenew").anyMatch(p -> p.equals(vas.get("importtype")))) {
            e.addValidator((AbstractValidator)new RelatedFinancingImportValidator());
        } else {
            e.addValidator(new AbstractValidator(){

                public void validate() {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        BigDecimal agreedinterestrate;
                        BigDecimal principalamount = dataEntity.getDataEntity().getBigDecimal("principalamount");
                        if (ObjectUtils.isEmpty((Object)principalamount)) {
                            dataEntity.setValue("principalamount", (Object)0);
                        }
                        if (!ObjectUtils.isEmpty((Object)(agreedinterestrate = dataEntity.getDataEntity().getBigDecimal("agreedinterestrate")))) continue;
                        dataEntity.setValue("agreedinterestrate", (Object)0);
                    }
                }
            });
        }
    }

    public static class RelatedFinancingImportValidator
    extends AbstractValidator {
        public void validate() {
            List list = Arrays.stream(this.dataEntities).map(p -> p.getDataEntity()).collect(Collectors.toList());
            List<String> orgNumbers = list.stream().map(p -> p.getDynamicObject("org").getString("number")).collect(Collectors.toList());
            TaxOrgValueValidator taxOrgValueValidator = new TaxOrgValueValidator(orgNumbers);
            List<String> relatedPartyNames = list.stream().map(p -> p.getDynamicObject("relatedparty").getString("name")).collect(Collectors.toList());
            AbstractImportDataValidator validator = new AbstractImportDataValidator.Builder().addValidator(taxOrgValueValidator).addValidator(new YearValueValidator()).addValidator(new RelatedPartyValueValidator(relatedPartyNames, false)).addValidator(new BigDecimalValueValidator("interestamount", BigDecimal.ZERO, BigDecimalValueConditionEnum.GREATER_THAN, ResManager.loadKDString((String)"\u5229\u606f\u91d1\u989d\u22640", (String)"RelatedFinancingSaveOp_0", (String)"taxc-ictm", (Object[])new Object[0]))).addValidator(new BigDecimalValueValidator("principalamount", BigDecimal.ZERO, BigDecimalValueConditionEnum.GREATER_THAN, ResManager.loadKDString((String)"\u672c\u91d1\u91d1\u989d\u22640", (String)"RelatedFinancingSaveOp_1", (String)"taxc-ictm", (Object[])new Object[0]))).addValidator(new BigDecimalValueValidator("agreedinterestrate", BigDecimal.ZERO, BigDecimalValueConditionEnum.GREATER_THAN, ResManager.loadKDString((String)"\u7ea6\u5b9a\u5229\u7387\u22640", (String)"RelatedFinancingSaveOp_2", (String)"taxc-ictm", (Object[])new Object[0]))).build();
            HashMap<String, Object> extendParams = new HashMap<String, Object>(0);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                BigDecimal agreedinterestrate;
                this.verifyImportData(dataEntity, validator, extendParams);
                BigDecimal principalamount = dataEntity.getDataEntity().getBigDecimal("principalamount");
                if (ObjectUtils.isEmpty((Object)principalamount)) {
                    dataEntity.setValue("principalamount", (Object)0);
                }
                if (!ObjectUtils.isEmpty((Object)(agreedinterestrate = dataEntity.getDataEntity().getBigDecimal("agreedinterestrate")))) continue;
                dataEntity.setValue("agreedinterestrate", (Object)0);
            }
        }

        private boolean verifyImportData(ExtendedDataEntity data, AbstractImportDataValidator validator, Map<String, Object> extendParams) {
            ValidatorResultDto validatorResult = validator.doValidate(data.getDataEntity(), extendParams);
            if (!validatorResult.getSuccess().booleanValue()) {
                this.addErrorMessage(data, validatorResult.getTipMessage());
                return false;
            }
            int year = DateUtils.getYear(data.getDataEntity().getDate("year"));
            Date yearStartDate = data.getDataEntity().getDate("yearstartdate");
            Date yearEndDate = data.getDataEntity().getDate("yearenddate");
            if (yearStartDate != null) {
                if (DateUtils.getYear(yearStartDate) < year) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u5e74\u5185\u5360\u7528\u8d77\u59cb\u65e5\u4f4d\u4e8e\u5e74\u5ea6\u5f00\u59cb\u524d", (String)"RelatedFinancingSaveOp_3", (String)"taxc-ictm", (Object[])new Object[0]));
                    return false;
                }
                if (DateUtils.getYear(yearStartDate) > year) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u5e74\u5185\u5360\u7528\u8d77\u59cb\u65e5\u4f4d\u4e8e\u5e74\u5ea6\u7ed3\u675f\u540e", (String)"RelatedFinancingSaveOp_4", (String)"taxc-ictm", (Object[])new Object[0]));
                    return false;
                }
            } else if (yearEndDate != null) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u5e74\u5185\u5360\u7528\u8d77\u59cb\u65e5\u4e3a\u7a7a", (String)"RelatedFinancingSaveOp_5", (String)"taxc-ictm", (Object[])new Object[0]));
                return false;
            }
            if (yearEndDate != null) {
                if (DateUtils.getYear(yearEndDate) < year) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u5e74\u5185\u5360\u7528\u622a\u6b62\u65e5\u4f4d\u4e8e\u5e74\u5ea6\u5f00\u59cb\u524d", (String)"RelatedFinancingSaveOp_6", (String)"taxc-ictm", (Object[])new Object[0]));
                    return false;
                }
                if (DateUtils.getYear(yearEndDate) > year) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u5e74\u5185\u5360\u7528\u622a\u6b62\u65e5\u4f4d\u4e8e\u5e74\u5ea6\u7ed3\u675f\u540e", (String)"RelatedFinancingSaveOp_7", (String)"taxc-ictm", (Object[])new Object[0]));
                    return false;
                }
                if (yearStartDate != null && yearStartDate.compareTo(yearEndDate) > 0) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u5e74\u5185\u5360\u7528\u622a\u6b62\u65e5\u4f4d\u4e8e\u5e74\u5185\u5360\u7528\u8d77\u59cb\u65e5\u524d", (String)"RelatedFinancingSaveOp_8", (String)"taxc-ictm", (Object[])new Object[0]));
                    return false;
                }
            } else if (yearStartDate != null) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u5e74\u5185\u5360\u7528\u622a\u6b62\u65e5\u4e3a\u7a7a", (String)"RelatedFinancingSaveOp_9", (String)"taxc-ictm", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
    }
}

