/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.opplugin.importdatavalidator;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.ictm.common.dto.ValidatorResultDto;
import kd.taxc.ictm.common.enums.BigDecimalValueConditionEnum;
import kd.taxc.ictm.opplugin.importdatavalidator.AbstractImportDataValidator;

public class BigDecimalValueValidator
extends AbstractImportDataValidator {
    public String valueKey;
    private BigDecimal compareValue;
    private BigDecimalValueConditionEnum condition;
    private String tipMsg;

    public BigDecimalValueValidator(String valueKey, BigDecimal compareValue, BigDecimalValueConditionEnum condition, String tipMsg) {
        this.valueKey = valueKey;
        this.compareValue = compareValue;
        this.condition = condition;
        this.tipMsg = tipMsg;
    }

    @Override
    public ValidatorResultDto doValidate(DynamicObject data, Map<String, Object> extendParams) {
        BigDecimal value = data.getBigDecimal(this.valueKey);
        if (value != null && !this.condition.checkCondition(value, this.compareValue)) {
            return new ValidatorResultDto(false, this.tipMsg);
        }
        return this.doNextValidate(data, extendParams);
    }
}

