/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.opplugin.importdatavalidator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.ictm.business.relatedparty.RelatedPartyBusiness;
import kd.taxc.ictm.common.dto.ValidatorResultDto;
import kd.taxc.ictm.opplugin.importdatavalidator.AbstractImportDataValidator;

public class RelatedPartyValueValidator
extends AbstractImportDataValidator {
    private boolean isContainNonRelatedParty;
    public DynamicObject[] relatedParties;

    public RelatedPartyValueValidator(List<String> relatedPartyNames, boolean isContainNonRelatedParty) {
        this.relatedParties = RelatedPartyBusiness.getDataByNames(relatedPartyNames);
        this.isContainNonRelatedParty = isContainNonRelatedParty;
    }

    @Override
    public ValidatorResultDto doValidate(DynamicObject data, Map<String, Object> extendParams) {
        String relatedPartyName = data.getDynamicObject("relatedparty").getString("name");
        if (Arrays.stream(this.relatedParties).noneMatch(p -> p.getString("name").equals(relatedPartyName))) {
            return new ValidatorResultDto(false, ResManager.loadKDString((String)"\u4ea4\u6613\u65b9\u672a\u5728\u5173\u8054\u65b9\u4fe1\u606f\u83dc\u5355\u5f53\u4e2d\u7ef4\u62a4", (String)"RelatedPartyValueValidator_0", (String)"taxc-ictm", (Object[])new Object[0]));
        }
        DynamicObject relatedParty = Arrays.stream(this.relatedParties).filter(p -> p.getString("name").equals(relatedPartyName)).findFirst().orElse(null);
        if (relatedParty != null && relatedParty.getString("enable").equals("0")) {
            return new ValidatorResultDto(false, ResManager.loadKDString((String)"\u4ea4\u6613\u65b9\u5df2\u5728\u5173\u8054\u65b9\u4fe1\u606f\u83dc\u5355\u5f53\u4e2d\u7981\u7528", (String)"RelatedPartyValueValidator_1", (String)"taxc-ictm", (Object[])new Object[0]));
        }
        if (!this.isContainNonRelatedParty && relatedPartyName.equals(ResManager.loadKDString((String)"\u975e\u5173\u8054\u65b9", (String)"RelatedPartyValueValidator_2", (String)"taxc-ictm", (Object[])new Object[0]))) {
            return new ValidatorResultDto(false, ResManager.loadKDString((String)"\u7981\u6b62\u5bfc\u5165\u975e\u5173\u8054\u4ea4\u6613", (String)"RelatedPartyValueValidator_3", (String)"taxc-ictm", (Object[])new Object[0]));
        }
        return this.doNextValidate(data, extendParams);
    }
}

