/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.opplugin.importdatavalidator;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.ictm.business.taxorg.IctmTaxOrgCommonBusiness;
import kd.taxc.ictm.common.dto.ValidatorResultDto;
import kd.taxc.ictm.opplugin.importdatavalidator.AbstractImportDataValidator;

public class TaxOrgValueValidator
extends AbstractImportDataValidator {
    public static final String ORG_SIGN = "org";
    public Map<String, Long> taxOrgNumberIdMap;
    public List<Long> orgIds;

    public TaxOrgValueValidator(List<String> orgNumbers) {
        this.taxOrgNumberIdMap = IctmTaxOrgCommonBusiness.getTaxOrgNumberIdMap(orgNumbers);
        this.orgIds = IctmTaxOrgCommonBusiness.getTaxcMainOrgIdByOrgIdAndIsTaxpayerWithPerm(this.taxOrgNumberIdMap.values());
    }

    @Override
    public ValidatorResultDto doValidate(DynamicObject data, Map<String, Object> extendParams) {
        String orgNumber = data.getDynamicObject(ORG_SIGN).getString("number");
        if (this.taxOrgNumberIdMap.get(orgNumber) == null || !this.orgIds.contains(this.taxOrgNumberIdMap.get(orgNumber))) {
            return new ValidatorResultDto(false, String.format(ResManager.loadKDString((String)"%1$s\u65e0\u65b0\u589e\u6743\u9650\u6216\u672a\u7ef4\u62a4\u5408\u8981\u6c42\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f/\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f", (String)"TaxOrgValueValidator_0", (String)"taxc-ictm", (Object[])new Object[0]), orgNumber));
        }
        return this.doNextValidate(data, extendParams);
    }
}

