/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.opplugin.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.ictm.business.taxmain.IctmTaxMainCommonBusiness;
import kd.taxc.ictm.common.constant.IctmEntityConstant;
import kd.taxc.ictm.formplugin.settle.SettleFacility;

public class MemberEntitySettleOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        final List<Long> orgIds = SettleFacility.getOrgListHasPermissionAll();
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                block7: {
                    block8: {
                        block6: {
                            if (!StringUtils.equals((CharSequence)"delete", (CharSequence)this.getOperateKey())) break block6;
                            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                                long id = dataEntity.getDataEntity().getLong("id");
                                DynamicObject bwbDyo = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ictm_member_settle");
                                if (orgIds.contains(bwbDyo.getLong("org.id"))) continue;
                                String number = bwbDyo.getString("org.number");
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ec5\u7528\u6237\u6709\u6743\u9650\u7684\u6210\u5458\u5b9e\u4f53\u6570\u636e\u53ef\u5220\u9664\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6: %s", (String)"MemberEntitySettleOp_0", (String)"taxc-ictm", (Object[])new Object[0]), number));
                            }
                            break block7;
                        }
                        if (!"changemethod".equalsIgnoreCase(this.getOperateKey())) break block8;
                        for (ExtendedDataEntity dataEntity : this.dataEntities) {
                            long id = dataEntity.getDataEntity().getLong("id");
                            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ictm_member_settle");
                            if (orgIds.contains(dynamicObject.getLong("org.id"))) continue;
                            String number = dynamicObject.getString("org.number");
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ec5\u7528\u6237\u6709\u6743\u9650\u7684\u6210\u5458\u5b9e\u4f53\u6570\u636e\u53ef\u53d8\u66f4\u6570\u636e\u751f\u6210\u65b9\u5f0f\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6 %s", (String)"MemberEntitySettleOp_1", (String)"taxc-ictm", (Object[])new Object[0]), number));
                        }
                        break block7;
                    }
                    if (!"save".equalsIgnoreCase(this.getOperateKey())) break block7;
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        long id = dataEntity.getDataEntity().getLong("id");
                        DynamicObject bwbDyoFromDb = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ictm_member_settle");
                        if (!orgIds.contains(bwbDyoFromDb.getLong("org.id"))) {
                            String number = bwbDyoFromDb.getString("org.number");
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ec5\u7528\u6237\u6709\u6743\u9650\u7684\u6210\u5458\u5b9e\u4f53\u6570\u636e\u53ef\u7f16\u8f91\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6: %s", (String)"MemberEntitySettleOp_2", (String)"taxc-ictm", (Object[])new Object[0]), number));
                        }
                        Date startDate = dataEntity.getDataEntity().getDate("startdate");
                        Date endDate = dataEntity.getDataEntity().getDate("enddate");
                        Date startDateOfDb = bwbDyoFromDb.getDate("startdate");
                        Date endDateOfDb = bwbDyoFromDb.getDate("enddate");
                        if (startDate == null || endDate == null || startDateOfDb == null || endDateOfDb == null) continue;
                        QFilter dateFilter = SettleFacility.getDateFilter(startDate, endDate);
                        dateFilter.and("org", "=", (Object)bwbDyoFromDb.getLong("org.id"));
                        dateFilter.and("id", "!=", (Object)bwbDyoFromDb.getLong("id"));
                        if (QueryServiceHelper.exists((String)"ictm_member_settle", (QFilter[])dateFilter.toArray())) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u7ec4\u7ec7\u4e0b\uff0c\u6570\u636e\u6db5\u76d6\u671f\u95f4\u5185\u5b58\u5728\u5176\u4ed6\u53f0\u8d26\u6570\u636e", (String)"MemberEntitySettleOp_3", (String)"taxc-ictm", (Object[])new Object[0]));
                            continue;
                        }
                        if (!"gzqs".equalsIgnoreCase(bwbDyoFromDb.getString("datagenermethod")) || startDate.compareTo(startDateOfDb) == 0 && endDate.compareTo(endDateOfDb) == 0) continue;
                        ArrayList<Long> orgIds2 = new ArrayList<Long>(8);
                        orgIds2.add(bwbDyoFromDb.getLong("org.id"));
                        List<Long> allOrgIds = SettleFacility.getAllOrgIds(startDate, endDate, orgIds2);
                        List<DynamicObject> allTaxMains = IctmTaxMainCommonBusiness.getAllTaxMainByOrgId(allOrgIds);
                        Map<Long, Long> acctcustomerMap = SettleFacility.getAcctcustomerMap(allTaxMains);
                        Map<Long, Long> acctsupplierMap = SettleFacility.getAcctsupplierMap(allTaxMains);
                        bwbDyoFromDb.set("startdate", (Object)startDate);
                        bwbDyoFromDb.set("enddate", (Object)endDate);
                        SettleFacility.fetchRuleValue(bwbDyoFromDb, acctcustomerMap, acctsupplierMap, false, false);
                        for (String filed : IctmEntityConstant.SETTLE_NUM_FILEDS) {
                            BigDecimal result = bwbDyoFromDb.getBigDecimal(filed);
                            result = result == null ? BigDecimal.ZERO : result;
                            dataEntity.getDataEntity().set(filed, (Object)result);
                            BigDecimal resultCny = bwbDyoFromDb.getBigDecimal(filed + "cny");
                            resultCny = resultCny == null ? BigDecimal.ZERO : result;
                            dataEntity.getDataEntity().set(filed + "cny", (Object)resultCny);
                        }
                        BigDecimal nonrelateincome = dataEntity.getDataEntity().getBigDecimal("allincome").subtract(dataEntity.getDataEntity().getBigDecimal("relateincome"));
                        dataEntity.getDataEntity().set("nonrelateincome", (Object)nonrelateincome);
                    }
                }
            }
        });
    }
}

