/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.baseinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class NotConfirmDysdsPlanBussiness {
    public static DynamicObject[] queryNotConfirmDysdsPlanById(List<Long> idList) {
        QFilter qFilter = new QFilter("id", "in", idList);
        return BusinessDataServiceHelper.load((String)"itp_notconfirm_dysds_plan", (String)"id,number,name,taxationsys,startdate,enddate,entryentity_item,entryentity_item.fetchitem,entryentity_org,entryentity_org.org", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject[] queryNotConfirmDysdsPlanByTaxaTionsys(List<Long> taxationsysIds) {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        qFilter.and("taxationsys", "in", taxationsysIds);
        return BusinessDataServiceHelper.load((String)"itp_notconfirm_dysds_plan", (String)"id,number,name,taxationsys,startdate,enddate,entryentity_item,entryentity_item.fetchitem,entryentity_org,entryentity_org.org", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject[] queryNotConfirmDysdsPlanByOrgAndTaxaTionsys(Long orgId, Long taxationsysId) {
        QFilter qFilter = new QFilter("entryentity_org.org", "in", Collections.singleton(orgId));
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        qFilter.and("taxationsys", "=", (Object)taxationsysId);
        return BusinessDataServiceHelper.load((String)"itp_notconfirm_dysds_plan", (String)"id,number,name,taxationsys,startdate,enddate,entryentity_item,entryentity_item.fetchitem,entryentity_org", (QFilter[])new QFilter[]{qFilter}, (String)"startdate");
    }

    public static List<Long> queryNotConfirmDysdsPlanItemsByOrgAndPeriod(Long orgId, Long taxationsysId, Date start, Date end) {
        ArrayList<Long> resultList = new ArrayList<Long>(12);
        if (ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)taxationsysId) || ObjectUtils.isEmpty((Object)start)) {
            return resultList;
        }
        DynamicObject[] dynamicObjects = NotConfirmDysdsPlanBussiness.queryNotConfirmDysdsPlanByOrgAndTaxaTionsys(orgId, taxationsysId);
        if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObjectCollection entryentity_item;
                Date startdate = dynamicObject.getDate("startdate");
                Date enddate = dynamicObject.getDate("enddate");
                if (startdate.getTime() > start.getTime() || enddate != null && enddate.getTime() < start.getTime() || !ObjectUtils.isNotEmpty((Object)(entryentity_item = dynamicObject.getDynamicObjectCollection("entryentity_item")))) continue;
                entryentity_item.stream().forEach(item -> resultList.add(item.getLong("fetchitem.id")));
            }
        }
        return resultList;
    }

    public static Map<String, Map<String, ImmutablePair<Date, Date>>> queryNotConfirmDysdsPlanOrderByTaxationsys(List<Long> taxationsysIds) {
        HashMap<String, Map<String, ImmutablePair<Date, Date>>> resultMap = new HashMap<String, Map<String, ImmutablePair<Date, Date>>>(12);
        DynamicObject[] dynamicObjects = NotConfirmDysdsPlanBussiness.queryNotConfirmDysdsPlanByTaxaTionsys(taxationsysIds);
        if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String taxationsysId = dynamicObject.getString("taxationsys.id");
                Date startdate = dynamicObject.getDate("startdate");
                Date enddate = dynamicObject.getDate("enddate");
                DynamicObjectCollection entryentity_item = dynamicObject.getDynamicObjectCollection("entryentity_org");
                if (!ObjectUtils.isNotEmpty((Object)entryentity_item)) continue;
                for (DynamicObject item : entryentity_item) {
                    HashMap<String, ImmutablePair> map;
                    ImmutablePair immutablePair = ImmutablePair.of((Object)startdate, (Object)enddate);
                    String orgId = item.getString("org.id");
                    String mapkey = taxationsysId + "_" + orgId;
                    if (resultMap.containsKey(mapkey)) {
                        map = (HashMap<String, ImmutablePair>)resultMap.get(mapkey);
                        map.put(dynamicObject.getString("id"), immutablePair);
                        continue;
                    }
                    map = new HashMap<String, ImmutablePair>(2);
                    map.put(dynamicObject.getString("id"), immutablePair);
                    resultMap.put(mapkey, map);
                }
            }
        }
        return resultMap;
    }

    public static Map<String, ImmutablePair<Date, Date>> queryNotConfirmDysdsPlanOrderByOrgAndTaxationsys(Long orgId, Long taxationsysId) {
        HashMap<String, ImmutablePair<Date, Date>> resultMap = new HashMap<String, ImmutablePair<Date, Date>>(12);
        DynamicObject[] dynamicObjects = NotConfirmDysdsPlanBussiness.queryNotConfirmDysdsPlanByOrgAndTaxaTionsys(orgId, taxationsysId);
        if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String id = dynamicObject.getString("id");
                Date startdate = dynamicObject.getDate("startdate");
                Date enddate = dynamicObject.getDate("enddate");
                ImmutablePair immutablePair = ImmutablePair.of((Object)startdate, (Object)enddate);
                resultMap.put(id, (ImmutablePair<Date, Date>)immutablePair);
            }
        }
        return resultMap;
    }

    public static List<Map<String, Object>> queryNotConfirmDysdsPlanOrderByOrgAndTaxationsys(Long orgId, Long taxationsysId, Date skssqq, Date start, Date skssqz) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(12);
        DynamicObject[] dynamicObjects = NotConfirmDysdsPlanBussiness.queryNotConfirmDysdsPlanByOrgAndTaxaTionsys(orgId, taxationsysId);
        if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                String id = dynamicObject.getString("id");
                Date startdate = dynamicObject.getDate("startdate");
                Date enddate = dynamicObject.getDate("enddate");
                DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("entryentity_item");
                ArrayList itemList = new ArrayList(12);
                if (ObjectUtils.isNotEmpty((Object)items)) {
                    itemList.addAll(items.stream().map(o -> o.getLong("fetchitem.id")).collect(Collectors.toList()));
                }
                ImmutablePair immutablePair = ImmutablePair.of((Object)startdate, (Object)enddate);
                map.put("id", id);
                map.put("date", immutablePair);
                map.put("fetchitems", itemList);
                if (enddate == null) {
                    if (start.getTime() < startdate.getTime()) continue;
                    resultList.add(map);
                    continue;
                }
                if (skssqq.getTime() >= startdate.getTime() && skssqq.getTime() <= enddate.getTime()) {
                    resultList.add(map);
                    continue;
                }
                if (skssqq.getTime() <= startdate.getTime() && skssqz.getTime() >= enddate.getTime()) {
                    resultList.add(map);
                    continue;
                }
                if (startdate.getTime() > skssqz.getTime() || enddate.getTime() <= skssqz.getTime()) continue;
                resultList.add(map);
            }
        }
        return resultList;
    }

    public static Map<String, Map<String, Object>> calculateFetchitemsPlan(List<Map<String, Object>> planList, List<Long> bbxmIdList, Date skssqq, Date skssqz, boolean isFirstPeriod) {
        Iterator wqrToQriterator;
        ImmutablePair pair;
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(12);
        if (ObjectUtils.isEmpty(bbxmIdList)) {
            return resultMap;
        }
        ArrayList<Long> dqwqrList = new ArrayList<Long>(12);
        ArrayList<Long> dqqrList = new ArrayList<Long>(12);
        HashMap<String, Object> objectMap = new HashMap<String, Object>(4);
        if (ObjectUtils.isEmpty(planList)) {
            dqqrList.addAll(bbxmIdList);
            objectMap.put("wqrList", dqwqrList);
            objectMap.put("qrList", dqqrList);
            resultMap.put("currentPlan", objectMap);
            HashMap wqrmap = new HashMap(2);
            resultMap.put("wqrToQr", wqrmap);
            HashMap qrmap = new HashMap(2);
            resultMap.put("qrToWqr", qrmap);
            return resultMap;
        }
        Map<String, Object> lastplan = planList.get(planList.size() - 1);
        String id = (String)lastplan.get("id");
        ImmutablePair immutablePair = (ImmutablePair)lastplan.get("date");
        List fetchitems = (List)lastplan.get("fetchitems");
        Date left = (Date)immutablePair.left;
        Date right = (Date)immutablePair.right;
        int i = 0;
        if (skssqq.getTime() >= left.getTime() && (right == null || skssqq.getTime() <= right.getTime())) {
            for (Long bbxmId : bbxmIdList) {
                if (fetchitems.contains(bbxmId)) {
                    dqwqrList.add(bbxmId);
                    continue;
                }
                dqqrList.add(bbxmId);
            }
            i = planList.size() - 2;
        } else {
            dqqrList.addAll(bbxmIdList);
            i = planList.size() - 1;
        }
        objectMap.put("wqrList", dqwqrList);
        objectMap.put("qrList", dqqrList);
        objectMap.put("planId", id);
        objectMap.put("startDate", left);
        objectMap.put("endDate", right);
        resultMap.put("currentPlan", objectMap);
        HashMap wqrmap = new HashMap(2);
        resultMap.put("wqrToQr", wqrmap);
        HashMap qrmap = new HashMap(2);
        resultMap.put("qrToWqr", qrmap);
        ArrayList recordWqrToQrList = new ArrayList(dqwqrList);
        ArrayList recordQrToWqrList = new ArrayList(dqqrList);
        while (i >= 0) {
            Map<String, Object> planMap = planList.get(i);
            pair = (ImmutablePair)planMap.get("date");
            List pfetchitems = (List)planMap.get("fetchitems");
            wqrToQriterator = recordWqrToQrList.iterator();
            while (wqrToQriterator.hasNext()) {
                Long wqr = (Long)wqrToQriterator.next();
                if (pfetchitems.contains(wqr)) continue;
                if (resultMap.containsKey("qrToWqr")) {
                    ((Map)resultMap.get("qrToWqr")).put(String.valueOf(wqr), pair);
                }
                wqrToQriterator.remove();
            }
            Iterator qrToWqrIterator = recordQrToWqrList.iterator();
            while (qrToWqrIterator.hasNext()) {
                Long qr = (Long)qrToWqrIterator.next();
                if (!pfetchitems.contains(qr)) continue;
                if (resultMap.containsKey("wqrToQr")) {
                    ((Map)resultMap.get("wqrToQr")).put(String.valueOf(qr), pair);
                }
                qrToWqrIterator.remove();
            }
            --i;
        }
        Map<String, Object> firstPlan = planList.get(0);
        pair = (ImmutablePair)firstPlan.get("date");
        Date firstPlanStart = (Date)pair.left;
        if (firstPlanStart.getTime() > DateUtils.getFirstDateOfYear((Date)skssqq).getTime() && !isFirstPeriod) {
            wqrToQriterator = recordWqrToQrList.iterator();
            Date lastDate = DateUtils.addMonth((Date)firstPlanStart, (int)-1);
            ImmutablePair datePair = ImmutablePair.of((Object)lastDate, (Object)DateUtils.getLastDateOfMonth((Date)lastDate));
            while (wqrToQriterator.hasNext()) {
                Long wqr = (Long)wqrToQriterator.next();
                if (resultMap.containsKey("qrToWqr")) {
                    ((Map)resultMap.get("qrToWqr")).put(String.valueOf(wqr), datePair);
                }
                wqrToQriterator.remove();
            }
        }
        return resultMap;
    }
}

