/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.fetchdata;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.itp.business.rule.ItpDraftCalculateServiceImpl;
import org.apache.commons.lang3.ObjectUtils;

public class ItpFetchDataBussiness {
    public static Map<String, String> dynRowBizTypeMap = new HashMap<String, String>();
    public static String FETCH_XXYHQY_ID;
    public static Map<String, String> cellMap;

    public static Map<String, String> getFetchConfigParams(DeclareRequestModel requestModel) {
        HashMap<String, String> businessMap = new HashMap<String, String>();
        TemplateVo templateVo = (TemplateVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_BASE_TEMPLATE, (Object[])new Object[]{requestModel.getModelId(), requestModel.getTemplateType(), String.valueOf(requestModel.getOrgId()), DateUtils.stringToDate((String)requestModel.getSkssqq(), (String)"yyyy-MM-dd"), DateUtils.stringToDate((String)requestModel.getSkssqz(), (String)"yyyy-MM-dd")});
        if (!ObjectUtils.isNotEmpty((Object)templateVo)) {
            return businessMap;
        }
        requestModel.setTemplateId(templateVo.getTemplateId());
        requestModel.setBaseTemplate(templateVo.getTemplate());
        Long templateId = templateVo.getTemplateId();
        ItpDraftCalculateServiceImpl itpCalculateService = new ItpDraftCalculateServiceImpl();
        Long taxationsysId = requestModel.getTaxationsys();
        QFilter accessWhereFilter = new QFilter("taxationsys", "=", (Object)taxationsysId);
        QFilter sharingPlanWhereFilter = new QFilter("taxationsys", "=", (Object)taxationsysId);
        HashSet dynBizTypeSet = new HashSet();
        dynRowBizTypeMap.forEach((key, value) -> dynBizTypeSet.add(value));
        QFilter templateIdQ = new QFilter("template", "=", (Object)templateId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"tpo_template_rule_fetch", (String)"reportitem,formula", (QFilter[])new QFilter[]{templateIdQ});
        List formulaList = col.stream().map(o -> o.getLong("formula")).collect(Collectors.toList());
        QFilter idQ = new QFilter("id", "in", formulaList);
        QFilter dataTypeQ = new QFilter("datatype", "=", (Object)"number");
        QFilter formulaQ = new QFilter("formula", "like", (Object)"{P[%");
        DynamicObjectCollection ruleFetchCol = QueryServiceHelper.query((String)"tpo_rule_fetch", (String)"name", (QFilter[])new QFilter[]{idQ, formulaQ, dataTypeQ});
        List ids = ruleFetchCol.stream().filter(row -> ItpFetchDataBussiness.isPositiveInteger(row.getString("name"))).map(o -> o.getLong("name")).collect(Collectors.toList());
        QFilter bizTypeFilter = new QFilter("biztype.number", "not in", dynBizTypeSet);
        QFilter inIdFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id", (QFilter[])new QFilter[]{bizTypeFilter, inIdFilter});
        List projectIdList = collection.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        String quarter = ItpFetchDataBussiness.calculateQuarter(requestModel.getSkssqq(), requestModel.getSkssqz()).toString();
        if (!"0".equals(quarter) && !"5".equals(quarter)) {
            projectIdList.add(Long.parseLong(FETCH_XXYHQY_ID));
        }
        accessWhereFilter.and(new QFilter("accessproject", "in", projectIdList));
        sharingPlanWhereFilter.and(new QFilter("ruleentity.rule.accessproject", "in", projectIdList));
        Long taxTypeId = 3L;
        HashMap<String, Object> extendsMap = new HashMap<String, Object>(16);
        extendsMap.put("originalSkssqq", DateUtils.stringToDate((String)requestModel.getSkssqq()));
        extendsMap.put("quarter", quarter);
        RuleEngineParamDto dto = new RuleEngineParamDto(requestModel.getOrgId(), taxTypeId, DateUtils.stringToDate((String)requestModel.getSkssqq()), DateUtils.stringToDate((String)requestModel.getSkssqz()), templateId, accessWhereFilter, sharingPlanWhereFilter, extendsMap, "sjjt");
        List list = itpCalculateService.calculateRuleAccess(dto);
        list.stream().forEach(row -> row.getRuleFetchCellSummaryList().forEach(cell -> {
            if (StringUtil.isNotEmpty((CharSequence)cell.getReportItem())) {
                businessMap.put(cell.getReportItem(), String.valueOf(cell.getAmount()));
                if (cellMap.values().contains(cell.getReportItem())) {
                    businessMap.put("xwqyyh_zcze", "1");
                }
            }
        }));
        return businessMap;
    }

    public static Map<String, String> getReportItemAccessProjectMap(RuleEngineParamDto engineParamDto, Set<String> accessProjectIdList) {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        if (engineParamDto.getExtendParams().containsKey("quarter")) {
            resultMap.put(FETCH_XXYHQY_ID, cellMap.get(engineParamDto.getExtendParams().get("quarter").toString()));
        }
        return resultMap;
    }

    public static boolean isPositiveInteger(String orginal) {
        return ItpFetchDataBussiness.isMatch("^\\+{0,1}[1-9]\\d*", orginal);
    }

    private static boolean isMatch(String regex, String orginal) {
        if (orginal == null || orginal.trim().equals("")) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher isNum = pattern.matcher(orginal);
        return isNum.matches();
    }

    public static Integer calculateQuarter(String skssqq, String skssqz) {
        if (ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
            return -1;
        }
        if (DateUtils.getMonthOfDate((Date)DateUtils.stringToDate2((String)skssqz)) - DateUtils.getMonthOfDate((Date)DateUtils.stringToDate2((String)skssqq)) == 11) {
            return 0;
        }
        if (DateUtils.stringToDate2((String)skssqq).getTime() == DateUtils.stringToDate2((String)skssqz).getTime()) {
            return 5;
        }
        int monthOfDate = DateUtils.getMonthOfDate((Date)DateUtils.stringToDate2((String)skssqz));
        if (monthOfDate < 4) {
            return 1;
        }
        if (monthOfDate < 7) {
            return 2;
        }
        if (monthOfDate < 10) {
            return 3;
        }
        return 4;
    }

    static {
        dynRowBizTypeMap.put("zcycgl_gaap_yjxcy_cyxm#1", "YWLB0005");
        dynRowBizTypeMap.put("zcycgl_gaap_zsxcy_cyxm#1", "YWLB0004");
        dynRowBizTypeMap.put("zcycgl_yjxcy_cyxm#1", "YWLB0002");
        dynRowBizTypeMap.put("zcycgl_zsxcy_cyxm#1", "YWLB0001");
        dynRowBizTypeMap.put("dqsds_yjxcy_cyxm#1", "YWLB0002");
        dynRowBizTypeMap.put("dqsds_zsxcy_cyxm#1", "YWLB0001");
        dynRowBizTypeMap.put("dqsds_jnsejm_xm#1", "YWLB0003");
        dynRowBizTypeMap.put("dqsds_jwsedm_xm#1", "YWLB0010");
        dynRowBizTypeMap.put("dysds_gaapzsxcy_sh_xm#1", "YWLB0004");
        dynRowBizTypeMap.put("dysds_zsxcy_sh_xm#1", "YWLB0001");
        dynRowBizTypeMap.put("dqsds_gaaptz_cyxm#1", "YWLB0005");
        dynRowBizTypeMap.put("dqsdswqr_gaapzsxcy_sh_xm#1", "YWLB0004");
        dynRowBizTypeMap.put("dysdswqr_zsxcy_sh_xm#1", "YWLB0001");
        dynRowBizTypeMap.put("sjjs_dqsdsfy_zmtzxm#1", "YWLB0007");
        dynRowBizTypeMap.put("sjjs_dysdsfy_zmtzxm#1", "YWLB0008");
        dynRowBizTypeMap.put("sjjs_yjhyjsds_zmtzxm#1", "YWLB0009");
        FETCH_XXYHQY_ID = "1987837335135459328";
        cellMap = new HashMap<String, String>(16);
        cellMap.put("1", "xwqyyh_zcze#xwqyyh_first_end");
        cellMap.put("2", "xwqyyh_zcze#xwqyyh_second_end");
        cellMap.put("3", "xwqyyh_zcze#xwqyyh_third_end");
        cellMap.put("4", "xwqyyh_zcze#xwqyyh_four_end");
    }
}

