/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.fetchdata;

import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.itp.business.jtysbthanrule.ItpJtThanDraftCalculateServiceImpl;
import kd.taxc.itp.business.jtysbthanrule.ItpJtThanDynEngineServiceImpl;
import org.apache.commons.lang3.ObjectUtils;

public class ItpJtThanFetchDataBussiness {
    public static Map<String, String> getFetchConfigParams(DeclareRequestModel requestModel, List<Long> idList) {
        HashMap<String, String> businessMap = new HashMap<String, String>();
        TemplateVo templateVo = (TemplateVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_BASE_TEMPLATE, (Object[])new Object[]{requestModel.getModelId(), requestModel.getTemplateType(), String.valueOf(requestModel.getOrgId()), DateUtils.stringToDate((String)requestModel.getSkssqq(), (String)"yyyy-MM-dd"), DateUtils.stringToDate((String)requestModel.getSkssqz(), (String)"yyyy-MM-dd")});
        if (!ObjectUtils.isNotEmpty((Object)templateVo)) {
            return businessMap;
        }
        requestModel.setTemplateId(templateVo.getTemplateId());
        requestModel.setBaseTemplate(templateVo.getTemplate());
        Long templateId = templateVo.getTemplateId();
        ItpJtThanDraftCalculateServiceImpl itpCalculateService = new ItpJtThanDraftCalculateServiceImpl();
        Long taxationsysId = requestModel.getTaxationsys();
        QFilter accessWhereFilter = new QFilter("taxationsys", "=", (Object)taxationsysId);
        QFilter sharingPlanWhereFilter = new QFilter("taxationsys", "=", (Object)taxationsysId);
        QFilter inIdFilter = new QFilter("id", "in", idList);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id", (QFilter[])new QFilter[]{inIdFilter});
        List projectIdList = collection.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        accessWhereFilter.and(new QFilter("accessproject", "in", projectIdList));
        sharingPlanWhereFilter.and(new QFilter("ruleentity.rule.accessproject", "in", projectIdList));
        Long taxTypeId = 3L;
        RuleEngineParamDto dto = new RuleEngineParamDto(requestModel.getOrgId(), taxTypeId, DateUtils.getFirstDateOfYear((Date)DateUtils.stringToDate((String)requestModel.getSkssqq())), DateUtils.stringToDate((String)requestModel.getSkssqz()), templateId, accessWhereFilter, sharingPlanWhereFilter, (Map)ImmutableBiMap.of((Object)"originalSkssqq", (Object)DateUtils.stringToDate((String)requestModel.getSkssqq())), "sbjtThan");
        List list = itpCalculateService.calculateRuleAccess(dto);
        list.stream().forEach(row -> row.getRuleFetchCellSummaryList().forEach(cell -> {
            if (StringUtil.isNotEmpty((CharSequence)cell.getReportItem())) {
                businessMap.put(cell.getReportItem(), String.valueOf(cell.getAmount()));
            }
        }));
        return businessMap;
    }

    public static List<DynamicObject> getFetchAccessconfigList(DeclareRequestModel requestModel, List<Long> idList) {
        Long templateId = requestModel.getTemplateId();
        Long taxSystemId = requestModel.getTaxationsys();
        Long orgId = requestModel.getOrgId();
        Date startDate = DateUtils.stringToDate2((String)requestModel.getSkssqq());
        Date endDate = DateUtils.stringToDate2((String)requestModel.getSkssqz());
        QFilter accessWhereFilter = new QFilter("taxationsys", "=", (Object)taxSystemId).and(new QFilter("enable", "=", (Object)Boolean.TRUE)).and(new QFilter("accessproject", "in", idList));
        QFilter sharingPlanWhereFilter = new QFilter("taxationsys", "=", (Object)taxSystemId);
        sharingPlanWhereFilter.and(new QFilter("ruleentity.rule.accessproject", "in", idList));
        RuleEngineParamDto ruleEngineParamDto = new RuleEngineParamDto(orgId, Long.valueOf(3L), DateUtils.getFirstDateOfYear((Date)startDate), endDate, templateId, accessWhereFilter, sharingPlanWhereFilter, (Map)ImmutableBiMap.of((Object)"originalSkssqq", (Object)startDate), "sbjtThan");
        Map<Long, List<DynamicObject>> allOrgMatchAccessConfigMap = new ItpJtThanDynEngineServiceImpl().getAllOrgMatchAccessConfigMap(ruleEngineParamDto);
        return allOrgMatchAccessConfigMap.get(requestModel.getOrgId());
    }

    public static Map<String, String> getFetchAccessconfigMap(DeclareRequestModel requestModel, List<Long> idList) {
        HashMap<String, String> resultMap = new HashMap<String, String>(12);
        List<DynamicObject> accessconfigList = ItpJtThanFetchDataBussiness.getFetchAccessconfigList(requestModel, idList);
        if (ObjectUtils.isNotEmpty(accessconfigList)) {
            DataEntityPropertyCollection properties = accessconfigList.get(0).getDataEntityType().getProperties();
            for (DynamicObject accessConfig : accessconfigList) {
                String projectId = ObjectUtils.isNotEmpty((Object)accessConfig) ? accessConfig.getString("accessproject.id") : "";
                properties.stream().forEach(property -> {
                    String name;
                    DynamicObjectCollection collection;
                    if (property instanceof EntryProp && ObjectUtils.isNotEmpty((Object)(collection = accessConfig.getDynamicObjectCollection(name = property.getName())))) {
                        resultMap.put(projectId + "_" + name, "1");
                    }
                });
            }
        }
        return resultMap;
    }

    public static List<Long> getFixedRowFetchDataItemIds() {
        ArrayList<Long> resultList = new ArrayList<Long>(12);
        resultList.add(1544976649957721088L);
        resultList.add(1544976651065366528L);
        resultList.add(1947992929025288192L);
        return resultList;
    }

    public static Map<String, String> getReportItemAccessProjectMap(RuleEngineParamDto engineParamDto, Set<String> accessProjectIdList) {
        HashMap<String, String> projectIdReportItemMap = new HashMap<String, String>();
        projectIdReportItemMap.put("1544976649957721088_entryentity", "dqsds_sqlr_bd#jtysbbd_sds");
        projectIdReportItemMap.put("1544976651065366528_entryentity", "dqsds_sqlr_jt#jtysbbd_sds");
        projectIdReportItemMap.put("1544976649957721088_entryentity1", "dqsds_sqlr_bd#jtysbbd_hjs");
        projectIdReportItemMap.put("1544976651065366528_entryentity1", "dqsds_sqlr_jt#jtysbbd_hjs");
        projectIdReportItemMap.put("1947992929025288192_entryentity", "dqsds_sedm#jtysbbd_sds");
        projectIdReportItemMap.put("1947992929025288192_entryentity1", "dqsds_sedm#jtysbbd_hjs");
        return projectIdReportItemMap;
    }
}

