/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.fetchitem;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class FetchItemsBussiness {
    public static List<Long> getFetchItems(Long taxSystemId) {
        ArrayList<Long> resultList = new ArrayList<Long>(12);
        QFilter qFilter = new QFilter("taxationsys", "is null", null).or(new QFilter("taxationsys", "=", (Object)0L));
        QFilter taxSysFilter = new QFilter("taxationsys", "=", (Object)taxSystemId).or(qFilter);
        QFilter fetchItemsFilter = new QFilter("isleaf", "=", (Object)Boolean.TRUE).and(new QFilter("enable", "=", (Object)"1")).and(taxSysFilter);
        DynamicObjectCollection fetchItems = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id,number,name,taxationsys,biztype.number", (QFilter[])new QFilter[]{fetchItemsFilter}, (String)"number asc");
        if (ObjectUtils.isNotEmpty((Object)fetchItems)) {
            resultList.addAll(fetchItems.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
        }
        return resultList;
    }

    public static List<Long> getFetchItemsByBiztype(String biztype) {
        ArrayList<Long> resultList = new ArrayList<Long>(12);
        QFilter qFilter = new QFilter("biztype.number", "=", (Object)biztype);
        DynamicObjectCollection fetchItems = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id,number,name,taxationsys,biztype.number", (QFilter[])new QFilter[]{qFilter}, (String)"number asc");
        if (ObjectUtils.isNotEmpty((Object)fetchItems)) {
            resultList.addAll(fetchItems.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
        }
        return resultList;
    }

    public static DynamicObjectCollection getFetchItemByIds(List<Long> ids) {
        QFilter idQfilter = new QFilter("id", "in", ids);
        return QueryServiceHelper.query((String)"itp_fetchitem", (String)"id,number,name,taxationsys,biztype.number", (QFilter[])new QFilter[]{idQfilter}, (String)"number asc");
    }

    public static DynamicObjectCollection getFetchItemEnableByIds(List<Long> ids) {
        QFilter idQfilter = new QFilter("id", "in", ids);
        idQfilter.and("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"itp_fetchitem", (String)"id,number,name,taxationsys,biztype.number", (QFilter[])new QFilter[]{idQfilter}, (String)"number asc");
    }

    public static DynamicObject[] loadFetchItemsByNumberList(List<String> numberList) {
        return BusinessDataServiceHelper.load((String)"itp_fetchitem", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", numberList).and("enable", "=", (Object)"1")});
    }
}

