/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.gaap;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.itp.common.dto.GaapDifferenceDto;
import kd.taxc.itp.common.enums.GaapFieldMapEnum;

public class CreateGaapDifferences {
    private static final Log LOGGER = LogFactory.getLog(CreateGaapDifferences.class);

    public static void createDifferencesDetails(long orgId, Date kjqj, boolean isRecalc) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"itp_gaap_accountset", (String)"id,groupaccount,localaccount,entryentity", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE).and("entryentity.org", "in", (Object)orgId)});
        if (dynamicObject != null) {
            String gaccount = dynamicObject.getString("groupaccount");
            String laccount = dynamicObject.getString("localaccount");
            List<GaapDifferenceDto> summuryGourpandLocalList = CreateGaapDifferences.getSummuryGourpandLocalMap(gaccount, laccount);
            HashMap<String, List<DynamicObject>> kmParentAndChildsMap = new HashMap<String, List<DynamicObject>>(12);
            CreateGaapDifferences.getGroupAllChildsNode(summuryGourpandLocalList, orgId, kmParentAndChildsMap);
            List<GaapDifferenceDto> calculateDetailsOfDifferenceList = CreateGaapDifferences.calculateDetailsOfDifference(summuryGourpandLocalList, orgId, kjqj, gaccount, laccount, kmParentAndChildsMap);
            CreateGaapDifferences.saveDifferencesDetails(calculateDetailsOfDifferenceList, orgId, kjqj, gaccount, laccount, isRecalc);
        }
    }

    private static List<GaapDifferenceDto> getSummuryGourpandLocalMap(String groupaccount, String localaccount) {
        QFilter groupaccountQfilter = new QFilter("groupaccount", "=", (Object)groupaccount);
        QFilter localaccountQfilter = new QFilter("localaccount", "=", (Object)localaccount);
        HashMap gourpandLocalMapMain = new HashMap(12);
        HashMap<String, List> gourpandLocalMapInfo = new HashMap<String, List>(12);
        DynamicObject account = BusinessDataServiceHelper.loadSingle((String)"itp_gaap_accountset", (String)"id,groupaccount,localaccount,groupsubjects,localsubjects,entryentity", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE).and(groupaccountQfilter).and(localaccountQfilter)});
        ArrayList<GaapDifferenceDto> resultList = new ArrayList<GaapDifferenceDto>(12);
        if (account != null) {
            DynamicObject[] subjectList;
            QFilter groupubjectQfilter = new QFilter("groupsubjects", "=", (Object)account.getString("groupsubjects"));
            QFilter localubjectQfilter = new QFilter("localsubjects", "=", (Object)account.getString("localsubjects"));
            QFilter enableQfilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            for (DynamicObject subject : subjectList = BusinessDataServiceHelper.load((String)"itp_gaap_subject", (String)"id,groupsubjects,localsubjects,entryentity.groupsubjectsid,entryentity.localsubjectsid,entryentity.compareform,entryentity.comparefield", (QFilter[])new QFilter[]{groupubjectQfilter, localubjectQfilter, enableQfilter})) {
                DynamicObjectCollection entrys = subject.getDynamicObjectCollection("entryentity");
                DynamicObject compareform = null;
                DynamicObject comparefield = null;
                for (DynamicObject entry : entrys) {
                    String groupsubjectsid = entry.getDynamicObject("groupsubjectsid").getString("id");
                    String localsubjectsid = entry.getString("localsubjectsid.id");
                    compareform = entry.getDynamicObject("compareform");
                    comparefield = entry.getDynamicObject("comparefield");
                    if (gourpandLocalMapMain.containsKey(groupsubjectsid)) {
                        List localsubjectList = (List)gourpandLocalMapInfo.get(groupsubjectsid);
                        ArrayList<String> localsubjectInfo = new ArrayList<String>(3);
                        localsubjectInfo.add(localsubjectsid);
                        localsubjectInfo.add(entry.getString("localsubjectsid.number"));
                        localsubjectInfo.add(compareform.getString("id"));
                        localsubjectInfo.add(compareform.getString("entityname"));
                        localsubjectInfo.add(comparefield.getString("id"));
                        localsubjectInfo.add(comparefield.getString("fieldname"));
                        localsubjectList.add(localsubjectInfo);
                        gourpandLocalMapInfo.put(groupsubjectsid, localsubjectList);
                        continue;
                    }
                    ArrayList<String> grouplist = new ArrayList<String>(2);
                    grouplist.add(groupsubjectsid);
                    grouplist.add(entry.getString("groupsubjectsid.number"));
                    gourpandLocalMapMain.put(groupsubjectsid, grouplist);
                    ArrayList localsubjectList = new ArrayList(1);
                    ArrayList<String> localsubjectInfo = new ArrayList<String>(3);
                    localsubjectInfo.add(localsubjectsid);
                    localsubjectInfo.add(entry.getString("localsubjectsid.number"));
                    localsubjectInfo.add(compareform.getString("id"));
                    localsubjectInfo.add(compareform.getString("entityname"));
                    localsubjectInfo.add(comparefield.getString("id"));
                    localsubjectInfo.add(comparefield.getString("fieldname"));
                    localsubjectList.add(localsubjectInfo);
                    gourpandLocalMapInfo.put(groupsubjectsid, localsubjectList);
                }
                String groupsubjects = subject.getString("groupsubjects");
                String localsubjects = subject.getString("localsubjects");
                Set entrySet = gourpandLocalMapMain.entrySet();
                for (Map.Entry next : entrySet) {
                    String keyId = (String)next.getKey();
                    List value = (List)next.getValue();
                    GaapDifferenceDto gaapDifferenceDto = new GaapDifferenceDto();
                    gaapDifferenceDto.setId(keyId);
                    gaapDifferenceDto.setNumber((String)value.get(1));
                    ArrayList<GaapDifferenceDto> gaapDifferenceDtoList = new ArrayList<GaapDifferenceDto>(12);
                    List listInfos = (List)gourpandLocalMapInfo.get(keyId);
                    String cform = "";
                    String cformId = "";
                    String cfield = "";
                    String cfieldId = "";
                    for (List listInfo : listInfos) {
                        GaapDifferenceDto gdo = new GaapDifferenceDto();
                        gdo.setId((String)listInfo.get(0));
                        gdo.setNumber((String)listInfo.get(1));
                        gdo.setCompareformId((String)listInfo.get(2));
                        cformId = (String)listInfo.get(2);
                        gdo.setCompareform((String)listInfo.get(3));
                        cform = (String)listInfo.get(3);
                        gdo.setComparefieldId((String)listInfo.get(4));
                        cfieldId = (String)listInfo.get(4);
                        gdo.setComparefieldId((String)listInfo.get(5));
                        cfield = (String)listInfo.get(5);
                        gaapDifferenceDtoList.add(gdo);
                    }
                    gaapDifferenceDto.setGroupsubjects(groupsubjects);
                    gaapDifferenceDto.setLocalsubjects(localsubjects);
                    gaapDifferenceDto.setCompareform(cform);
                    gaapDifferenceDto.setCompareformId(cformId);
                    GaapFieldMapEnum gaapFieldMap = GaapFieldMapEnum.getGaapFieldMapEnumByNumber(cfield);
                    if (gaapFieldMap != null) {
                        cfield = gaapFieldMap.getQueryField();
                    }
                    gaapDifferenceDto.setComparefield(cfield);
                    gaapDifferenceDto.setComparefieldId(cfieldId);
                    gaapDifferenceDto.setInfos(gaapDifferenceDtoList);
                    resultList.add(gaapDifferenceDto);
                }
            }
        }
        return resultList;
    }

    private static void getGroupAllChildsNode(List<GaapDifferenceDto> summuryGourpandLocalList, long orgId, Map<String, List<DynamicObject>> kmParentAndChildsMap) {
        DynamicObject[] dynamicObjectArray;
        DynamicObject[] groupsubjects;
        HashSet<String> kmJtNumbers = new HashSet<String>(12);
        HashSet<String> kmBdNumbers = new HashSet<String>(12);
        String gsubject = "";
        String lsubject = "";
        for (GaapDifferenceDto gaapDifferenceDto : summuryGourpandLocalList) {
            kmJtNumbers.add(gaapDifferenceDto.getNumber());
            gsubject = gaapDifferenceDto.getGroupsubjects();
            lsubject = gaapDifferenceDto.getLocalsubjects();
            List<GaapDifferenceDto> infos = gaapDifferenceDto.getInfos();
            for (GaapDifferenceDto info : infos) {
                kmBdNumbers.add(info.getNumber());
            }
        }
        for (DynamicObject groupsubject : groupsubjects = BusinessDataServiceHelper.load((String)"tdm_account", (String)"id,isleaf,org,number,accounttable", (QFilter[])new QFilter[]{new QFilter("number", "in", kmJtNumbers).and("org", "=", (Object)orgId)})) {
            String number;
            StringBuilder sb;
            if (!groupsubject.getString("accounttable").equalsIgnoreCase(gsubject) || kmParentAndChildsMap.containsKey((sb = new StringBuilder(number = groupsubject.getString("number")).append("_").append(gsubject).append("_").append("jt").append("_").append(orgId)).toString())) continue;
            List<DynamicObject> groupsubjectandchildsNodes = CreateGaapDifferences.getAllChildNodeByNumber(number, orgId, gsubject);
            kmParentAndChildsMap.put(sb.toString(), groupsubjectandchildsNodes);
        }
        for (DynamicObject localsubject : dynamicObjectArray = BusinessDataServiceHelper.load((String)"tdm_account", (String)"id,isleaf,org,number,accounttable", (QFilter[])new QFilter[]{new QFilter("number", "in", kmBdNumbers).and("org", "=", (Object)orgId)})) {
            String number;
            StringBuilder sb;
            if (!localsubject.getString("accounttable").equalsIgnoreCase(lsubject) || kmParentAndChildsMap.containsKey((sb = new StringBuilder(number = localsubject.getString("number")).append("_").append(lsubject).append("_").append("bd").append("_").append(orgId)).toString())) continue;
            List<DynamicObject> groupsubjectandchildsNodes = CreateGaapDifferences.getAllChildNodeByNumber(number, orgId, lsubject);
            kmParentAndChildsMap.put(sb.toString(), groupsubjectandchildsNodes);
        }
    }

    private static List<GaapDifferenceDto> calculateDetailsOfDifference(List<GaapDifferenceDto> summuryGourpandLocalList, long orgid, Date kjqj, String gaccount, String laccount, Map<String, List<DynamicObject>> kmParentAndChildsMap) {
        List<DynamicObject> dynamicObjects;
        int yearOfDate = DateUtils.getYearOfDate((Date)kjqj);
        int monthOfDate = DateUtils.getMonthOfDate((Date)kjqj);
        QFilter accountyearQfilter = new QFilter("accountyear", "=", (Object)String.valueOf(yearOfDate));
        QFilter accountperiodQfilter = monthOfDate < 10 ? new QFilter("accountperiod", "=", (Object)String.format("0%s", monthOfDate)) : new QFilter("accountperiod", "=", (Object)String.valueOf(monthOfDate));
        QFilter orgQfliter = new QFilter("org", "=", (Object)orgid);
        String queryFields = "id,billno,accountyear,accountcycle,closingamount,closinglocalcurrency,closingoriginalcurrency,creditamount,creditlocalcurrency,creditoriginalcurrency,debitamount,debitlocalcurrency,\ndebitoriginalcurrency,openingamount,openinglocalcurrency,openingoriginalcurrency,datasource,balance,balance.id,sourcesys,accountperiod,org,accountbookstype,balance_id,org_id,entryentity.accountdimension,entryentity.subopeninglocalcurrency,entryentity.debitcurrentamount,entryentity.creditcurrentamount,entryentity.subclosinglocalcurrency";
        DynamicObjectCollection kms = QueryServiceHelper.query((String)"tdm_balance_new", (String)queryFields, (QFilter[])new QFilter[]{orgQfliter, accountyearQfilter, accountperiodQfilter});
        HashMap<String, List<Object>> queryKmyeDatasMap = new HashMap<String, List<Object>>(12);
        for (DynamicObject dynamicObject : kms) {
            StringBuilder stringBuilder = new StringBuilder(dynamicObject.getString("balance.id")).append("_").append(dynamicObject.getString("accountbookstype"));
            if (queryKmyeDatasMap.containsKey(stringBuilder.toString())) {
                dynamicObjects = (List<DynamicObject>)queryKmyeDatasMap.get(stringBuilder.toString());
                dynamicObjects.add(dynamicObject);
                queryKmyeDatasMap.put(stringBuilder.toString(), dynamicObjects);
                continue;
            }
            ArrayList<DynamicObject> kmList = new ArrayList<DynamicObject>(2);
            kmList.add(dynamicObject);
            queryKmyeDatasMap.put(stringBuilder.toString(), kmList);
        }
        for (GaapDifferenceDto gaapDifferenceDto : summuryGourpandLocalList) {
            StringBuilder gkey = new StringBuilder(gaapDifferenceDto.getNumber()).append("_").append(gaapDifferenceDto.getGroupsubjects()).append("_").append("jt").append("_").append(orgid);
            dynamicObjects = kmParentAndChildsMap.get(gkey.toString());
            String fieldnumber = gaapDifferenceDto.getComparefield();
            BigDecimal groupSummary = BigDecimal.ZERO;
            if (dynamicObjects != null) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    StringBuilder stringBuilder = new StringBuilder(dynamicObject.getString("id")).append("_").append(gaccount);
                    if (!queryKmyeDatasMap.containsKey(stringBuilder.toString())) continue;
                    List dyns = (List)queryKmyeDatasMap.get(stringBuilder.toString());
                    for (DynamicObject dyn : dyns) {
                        if (!dyn.getString("accountbookstype").equalsIgnoreCase(gaccount)) continue;
                        groupSummary = groupSummary.add(dyn.getBigDecimal(fieldnumber));
                    }
                }
            }
            BigDecimal localAllSummary = BigDecimal.ZERO;
            List<GaapDifferenceDto> infos = gaapDifferenceDto.getInfos();
            if (infos != null) {
                for (GaapDifferenceDto info : infos) {
                    BigDecimal localSummary = BigDecimal.ZERO;
                    StringBuilder lkey = new StringBuilder(info.getNumber()).append("_").append(gaapDifferenceDto.getLocalsubjects()).append("_").append("bd").append("_").append(orgid);
                    List<DynamicObject> lkms = kmParentAndChildsMap.get(lkey.toString());
                    if (lkms != null) {
                        for (DynamicObject dynamicObject : lkms) {
                            StringBuilder stringBuilder = new StringBuilder(dynamicObject.getString("id")).append("_").append(laccount);
                            if (!queryKmyeDatasMap.containsKey(stringBuilder.toString())) continue;
                            List dyns = (List)queryKmyeDatasMap.get(stringBuilder.toString());
                            for (DynamicObject dyn : dyns) {
                                if (!dyn.getString("accountbookstype").equalsIgnoreCase(laccount)) continue;
                                localSummary = localSummary.add(dyn.getBigDecimal(fieldnumber));
                            }
                        }
                    }
                    info.setAccount(localSummary);
                    localAllSummary = localAllSummary.add(localSummary);
                }
            }
            gaapDifferenceDto.setAccount(groupSummary);
            gaapDifferenceDto.setGaapdifference(groupSummary.subtract(localAllSummary));
        }
        return summuryGourpandLocalList;
    }

    private static void saveDifferencesDetails(List<GaapDifferenceDto> calculateDetailsOfDifferenceList, long orgid, Date kjqj, String gaccount, String laccount, boolean isRecalc) {
        OperationResult operationResult;
        Long id;
        DynamicObject gaap;
        ArrayList<DynamicObject> forSaveObjArrMain = new ArrayList<DynamicObject>(10);
        ArrayList forSaveObjArrInfo = new ArrayList(10);
        if (isRecalc) {
            gaap = BusinessDataServiceHelper.loadSingle((String)"itp_gaap_difference", (String)MetadataUtil.getAllFieldString((String)"itp_gaap_difference"), (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgid).and("kjnd", "=", (Object)kjqj)});
            id = gaap.getLong("id");
            gaap.set("modifier", (Object)RequestContext.get().getCurrUserId());
            gaap.set("modifytime", (Object)new Date());
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"itp_gaap_difference_info", (String)"id", (QFilter[])new QFilter[]{new QFilter("gid", "=", (Object)id)});
            List ids = Arrays.stream(load).map(o -> o.get("id")).collect(Collectors.toList());
            operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"itp_gaap_difference_info", (Object[])ids.toArray(), (OperateOption)OperateOption.create());
        } else {
            gaap = BusinessDataServiceHelper.newDynamicObject((String)"itp_gaap_difference");
            id = DB.genLongId((String)"itp_gaap_difference");
            gaap.set("id", (Object)id);
            gaap.set("billno", (Object)CreateGaapDifferences.createNumber(orgid, kjqj));
            gaap.set("org", (Object)orgid);
            gaap.set("kjnd", (Object)kjqj);
            gaap.set("creator", (Object)RequestContext.get().getCurrUserId());
            gaap.set("createtime", (Object)new Date());
        }
        gaap.set("groupaccount", (Object)gaccount);
        gaap.set("localaccount", (Object)laccount);
        gaap.set("billstatus", (Object)"A");
        Stream.iterate(0, i -> i + 1).limit(calculateDetailsOfDifferenceList.size()).forEach(index -> {
            DynamicObject gaapinfo = BusinessDataServiceHelper.newDynamicObject((String)"itp_gaap_difference_info");
            GaapDifferenceDto gaapMain = (GaapDifferenceDto)calculateDetailsOfDifferenceList.get((int)index);
            gaapinfo.set("gid", (Object)id);
            gaapinfo.set("compareform", (Object)gaapMain.getCompareformId());
            gaapinfo.set("comparefield", (Object)gaapMain.getComparefieldId());
            gaapinfo.set("groupsubjectsid", (Object)gaapMain.getId());
            gaapinfo.set("groupaccountvalue", (Object)gaapMain.getAccount());
            gaapinfo.set("gaapdifference", (Object)gaapMain.getGaapdifference());
            DynamicObjectCollection childCollection = gaapinfo.getDynamicObjectCollection("entryentity");
            List<GaapDifferenceDto> infos = gaapMain.getInfos();
            Stream.iterate(0, i -> i + 1).limit(infos.size()).forEach(sex -> {
                GaapDifferenceDto gaapMainInfo = (GaapDifferenceDto)infos.get((int)sex);
                DynamicObject childCollectionRow = childCollection.addNew();
                childCollectionRow.set("seq", sex);
                childCollectionRow.set("localsubjectsid", (Object)gaapMainInfo.getId());
                childCollectionRow.set("localaccountvalue", (Object)gaapMainInfo.getAccount());
            });
            forSaveObjArrInfo.add(gaapinfo);
        });
        forSaveObjArrMain.add(gaap);
        Boolean iSsave = Boolean.TRUE;
        if (!isRecalc) {
            QFilter qFilter = new QFilter("org", "=", (Object)orgid).and("kjnd", "=", (Object)kjqj);
            iSsave = !QueryServiceHelper.exists((String)"itp_gaap_difference", (QFilter[])new QFilter[]{qFilter});
        }
        if (iSsave.booleanValue()) {
            LOGGER.info("sucess save");
            LOGGER.info(String.format("%s_%s", orgid, kjqj));
            OperationResult resultMain = OperationServiceHelper.executeOperate((String)"save", (String)"itp_gaap_difference", (DynamicObject[])forSaveObjArrMain.toArray(new DynamicObject[forSaveObjArrMain.size()]), (OperateOption)OperateOption.create());
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"itp_gaap_difference_info", (DynamicObject[])forSaveObjArrInfo.toArray(new DynamicObject[forSaveObjArrInfo.size()]), (OperateOption)OperateOption.create());
        }
    }

    private static String createNumber(long orgId, Date kjqj) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"itp_gaap_difference");
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("kjnd", (Object)kjqj);
        return codeRuleService.readNumber("itp_gaap_difference", dynamicObject, null);
    }

    private static List<DynamicObject> getAllChildNodeByNumber(String number, long orgid, String kmtype) {
        StringBuilder sb = new StringBuilder();
        QFilter qf = new QFilter("org", "=", (Object)orgid).and("number", "=", (Object)number);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tdm_account", (String)"id,isleaf,org,number,accounttable,longnumber,parent", (QFilter[])new QFilter[]{qf});
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(12);
        if (!ObjectUtils.isEmpty((Object)dynamicObject)) {
            if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("parent"))) {
                sb.append(number).append("%");
            } else {
                sb.append(dynamicObject.getString("longnumber")).append("%");
            }
            QFilter qFilter = new QFilter("org", "=", (Object)orgid).and("longnumber", "like", (Object)sb.toString());
            List<DynamicObject> tdm_account = Arrays.asList(BusinessDataServiceHelper.load((String)"tdm_account", (String)"id,isleaf,org,number,accounttable,longnumber,parent", (QFilter[])new QFilter[]{qFilter}));
            if (!ObjectUtils.isEmpty(tdm_account)) {
                ArrayList<DynamicObject> tdms = new ArrayList<DynamicObject>(tdm_account);
                String rootId = "";
                for (DynamicObject dyn : tdms) {
                    if (!number.equals(dyn.getString("number"))) continue;
                    rootId = dyn.getString("id");
                    result.add(dyn);
                    break;
                }
                CreateGaapDifferences.getChildNodeByrecursion(rootId, tdms, result);
                if (!ObjectUtils.isEmpty(result)) {
                    Iterator iterator = result.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject next = (DynamicObject)iterator.next();
                        if (kmtype.equalsIgnoreCase(next.getString("accounttable"))) continue;
                        iterator.remove();
                    }
                }
            }
        }
        return result;
    }

    private static void getChildNodeByrecursion(String parentId, List<DynamicObject> tdms, List<DynamicObject> result) {
        if (ObjectUtils.isEmpty(tdms) || StringUtils.isEmpty((CharSequence)parentId)) {
            return;
        }
        Iterator<DynamicObject> iterator = tdms.iterator();
        ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(tdms);
        while (iterator.hasNext()) {
            DynamicObject next = iterator.next();
            if (!parentId.equals(next.getString("parent.id"))) continue;
            result.add(next);
            tempList.remove(next);
            CreateGaapDifferences.getChildNodeByrecursion(next.getString("id"), tempList, result);
        }
    }
}

