/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.jtysbthanrule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.rule.impl.AbstractRuleAccessConfigService;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class ItpJtThanAccessConfigServiceImpl
extends AbstractRuleAccessConfigService {
    private static Log logger = LogFactory.getLog(ItpJtThanAccessConfigServiceImpl.class);

    public ItpJtThanAccessConfigServiceImpl() {
        this.accessConfigEntityName = "itp_jtthan_accessconfig";
        this.accessConfigSelectFields = MetadataUtil.getAllSubFieldString((String)this.accessConfigEntityName);
        this.sharingplanEntityName = "itp_jtthan_shardingplan";
        this.sharingplanSelectFields = MetadataUtil.getAllSubFieldString((String)this.sharingplanEntityName) + "," + this.sharingPlan_Rule_AccessProject;
    }

    public List<DynamicObject> queryMatchAccessConfig(Long orgId, QFilter accessWhereFilter, QFilter sharingPlanWhereFilter) {
        List<DynamicObject> privateAccessConfigList = this.queryPrivateAccessConfig(orgId, accessWhereFilter);
        List noRepeatPrivateAccessConfigList = privateAccessConfigList.stream().filter(this.distinctByKey(row -> row.getLong(this.accessConfig_ProjectId))).collect(Collectors.toList());
        List privateAccessProjectIds = noRepeatPrivateAccessConfigList.stream().map(row -> row.getLong(this.accessConfig_ProjectId)).collect(Collectors.toList());
        List<DynamicObject> sharingPlanList = this.querySharingPlanAccessConfig(orgId, sharingPlanWhereFilter);
        List publicAccessProjectIds = sharingPlanList.stream().filter(row -> !privateAccessProjectIds.contains(row.getLong(this.sharingPlan_Rule_AccessProject))).filter(this.distinctByKey(row -> row.getLong(this.sharingPlan_Rule_AccessProject))).map(o -> o.getLong(this.sharingPlan_Rule)).collect(Collectors.toList());
        ArrayList publicAccessConfigList = new ArrayList();
        if (ObjectUtils.isNotEmpty(publicAccessProjectIds)) {
            QFilter accessIdQ = new QFilter("id", "in", publicAccessProjectIds);
            QFilter publicFilter = new QFilter(this.accessConfig_RuleType, "=", (Object)"public");
            List list = this.buildEnableQfilter(this.accessConfigEntityName);
            list.stream().forEach(o -> accessIdQ.and(o));
            DynamicObject[] collection = BusinessDataServiceHelper.load((String)this.accessConfigEntityName, (String)this.accessConfigSelectFields, (QFilter[])new QFilter[]{accessIdQ, publicFilter});
            if (ObjectUtils.isNotEmpty((Object)collection)) {
                Collections.addAll(publicAccessConfigList, collection);
            }
        }
        ArrayList<DynamicObject> allAccessConfigList = new ArrayList<DynamicObject>();
        allAccessConfigList.addAll(noRepeatPrivateAccessConfigList);
        allAccessConfigList.addAll(publicAccessConfigList);
        return allAccessConfigList;
    }

    public List<DynamicObject> queryPrivateAccessConfig(Long orgId, QFilter accessWhereFilter) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        QFilter orgQ = new QFilter(this.accessConfig_Org, "=", (Object)orgId);
        QFilter privateFilter = new QFilter(this.accessConfig_RuleType, "=", (Object)"private");
        List enableQList = this.buildEnableQfilter(this.accessConfigEntityName);
        enableQList.stream().forEach(o -> accessWhereFilter.and(o));
        DynamicObject[] privateAccessConfigList = BusinessDataServiceHelper.load((String)this.accessConfigEntityName, (String)this.accessConfigSelectFields, (QFilter[])new QFilter[]{orgQ, accessWhereFilter, privateFilter});
        if (ObjectUtils.isNotEmpty((Object)privateAccessConfigList)) {
            Collections.addAll(list, privateAccessConfigList);
        }
        return list;
    }

    public List<DynamicObject> querySharingPlanAccessConfig(Long orgId, QFilter sharingPlanWhereFilter) {
        long startTime = System.currentTimeMillis();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        QFilter orgQ = new QFilter(this.sharingPlan_Org, "=", (Object)orgId);
        if (ObjectUtils.isNotEmpty((Object)sharingPlanWhereFilter)) {
            orgQ.and(sharingPlanWhereFilter);
        }
        List enableQList = this.buildEnableQfilter(this.sharingplanEntityName);
        enableQList.stream().forEach(o -> orgQ.and(o));
        DynamicObjectCollection sharingPlanList = QueryServiceHelper.query((String)this.sharingplanEntityName, (String)this.sharingplanSelectFields, (QFilter[])new QFilter[]{orgQ});
        if (ObjectUtils.isEmpty((Object)sharingPlanList)) {
            return list;
        }
        sharingPlanList.stream().forEach(o -> list.add((DynamicObject)o));
        List id = list.stream().map(row -> row.getString("id")).collect(Collectors.toList());
        logger.info("querySharingPlanAccessConfig[time = {}ms,org = {},pkId = {}]", new Object[]{System.currentTimeMillis() - startTime, orgId, StringUtil.join(id, (String)",")});
        return list;
    }
}

