/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.jtysbthanrule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.business.rule.RuleAccessConfigService;
import kd.taxc.bdtaxr.business.rule.impl.AbstractRuleEngineService;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCardDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchDetailDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleAccessDetailDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.itp.business.fetchdata.ItpJtThanFetchDataBussiness;
import kd.taxc.itp.business.jtysbthanrule.ItpJtThanAccessConfigServiceImpl;
import kd.taxc.itp.business.taxorg.ItpTaxcOrgGroupCommonBusiness;
import kd.taxc.itp.common.constant.DraftConstant;
import org.apache.commons.lang3.ObjectUtils;

public class ItpJtThanDraftEngineServiceImpl
extends AbstractRuleEngineService {
    private static Log logger = LogFactory.getLog(ItpJtThanDraftEngineServiceImpl.class);

    public ItpJtThanDraftEngineServiceImpl() {
        this.accessConfigEntityName = "itp_jtthan_accessconfig";
    }

    public static RuleAccessConfigService getRuleFetchBusiness() {
        return RuleAccessConfigServiceInner.ruleFetchBusiness;
    }

    protected RuleAccessConfigService registerRuleAccessConfigService() {
        return ItpJtThanDraftEngineServiceImpl.getRuleFetchBusiness();
    }

    protected List<RuleEngineParamDto> handleSummaryTaxOrgList(RuleEngineParamDto ruleEngineParamDto) {
        ArrayList<RuleEngineParamDto> allSummaryTaxOrglist = new ArrayList<RuleEngineParamDto>();
        allSummaryTaxOrglist.add(ruleEngineParamDto);
        QFilter orgIdFilter = new QFilter("orgrow.orgid", "=", (Object)ruleEngineParamDto.getTaxOrgId());
        QFilter declarationFilter = new QFilter("orgrow.declaration", "=", (Object)"2");
        QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
        Date skssqq = ruleEngineParamDto.getSkssqq();
        Date skssqz = ruleEngineParamDto.getSkssqz();
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        DynamicObjectCollection collection = ItpTaxcOrgGroupCommonBusiness.queryOrgGroupByDeclaration(ruleEngineParamDto.getTaxOrgId(), "2", "qysds", "2");
        List<Long> idList = collection.stream().filter(o -> null != DateUtils.getIntersectionDate((Date)o.getDate("effectdate"), (Date)o.getDate("invaliddate"), (Date)skssqq, (Date)skssqz)).map(s -> s.getLong("id")).distinct().collect(Collectors.toList());
        if (ObjectUtils.isNotEmpty(idList)) {
            QFilter idQ = new QFilter("id", "in", idList);
            List<DynamicObject> dynamicObjects = ItpTaxcOrgGroupCommonBusiness.queryOrgGroupByIdsAndDeclaration(idList, "3");
            List orgids = dynamicObjects.stream().map(o -> o.getLong("orgrow.orgid")).collect(Collectors.toList());
            orgids.stream().forEach(row -> allSummaryTaxOrglist.add(new RuleEngineParamDto(Long.getLong("orgrow.orgid"), ruleEngineParamDto.getSkssqq(), ruleEngineParamDto.getSkssqz(), ruleEngineParamDto.getTemplateId(), ruleEngineParamDto.getAccessWhereFilter(), ruleEngineParamDto.getSharingPlanWhereFilter(), ruleEngineParamDto.getExtendParams(), ruleEngineParamDto.getDraftPurpose())));
        }
        return allSummaryTaxOrglist;
    }

    protected RuleFetchMainDto handleBuildRuleFetchMainDto(RuleEngineParamDto engineParamDto, List<Map<Long, List<Map<String, List<RuleAccessDetailDto>>>>> allOrgAccessResult) {
        Date originalSkssqq = (Date)engineParamDto.getExtendParams().get("originalSkssqq");
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto(engineParamDto.getTaxOrgId(), originalSkssqq, engineParamDto.getSkssqz(), engineParamDto.getTemplateId(), engineParamDto.getDraftPurpose());
        HashSet<String> accessProjectIdList = new HashSet<String>();
        allOrgAccessResult.stream().forEach(orgMap -> orgMap.entrySet().stream().forEach(orgEntry -> ((List)orgEntry.getValue()).stream().forEach(ruleRow -> ruleRow.entrySet().stream().forEach(accessDetailList -> ((List)accessDetailList.getValue()).forEach(detailDto -> accessProjectIdList.add(detailDto.getAccessConfigObject().getString(this.accessConfig_ProjectId)))))));
        Map<String, String> rowColumnAccessProjectMap = this.getReportItemAccessProjectMap(engineParamDto, accessProjectIdList);
        HashMap cellSummaryDtoMap = new HashMap();
        allOrgAccessResult.stream().forEach(orgMap -> orgMap.entrySet().stream().forEach(orgEntry -> {
            Long orgId = (Long)orgEntry.getKey();
            List singleOrgAllAccessResultList = (List)orgEntry.getValue();
            for (Map singleAccessConfigResultMap : singleOrgAllAccessResultList) {
                singleAccessConfigResultMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(this.entryentity)).forEach(entry -> {
                    List accessDetailDtoList = (List)entry.getValue();
                    ArrayList<RuleFetchDetailDto> ruleFetchDetailDtoList = new ArrayList<RuleFetchDetailDto>(accessDetailDtoList.size());
                    BigDecimal sumFetchAmount = BigDecimal.ZERO;
                    BigDecimal sumOriginAmount = BigDecimal.ZERO;
                    DynamicObject accessConfigObject = null;
                    for (RuleAccessDetailDto accessDetailDto : accessDetailDtoList) {
                        if (ObjectUtils.isEmpty(accessConfigObject)) {
                            accessConfigObject = accessDetailDto.getAccessConfigObject();
                        }
                        RuleFetchDetailDto fetchDetailDto = new RuleFetchDetailDto(accessDetailDto.getSkssqq(), accessDetailDto.getSkssqz(), accessDetailDto.getBizName(), accessDetailDto.getDataSource(), accessDetailDto.getAmountField(), accessDetailDto.getBaseDataType(), accessDetailDto.getFetchType(), accessDetailDto.getFetchDirection(), accessDetailDto.getFetchAmount(), accessDetailDto.getOriginAmount(), accessDetailDto.getAbsolute(), accessDetailDto.getFilterCondition());
                        fetchDetailDto.setSkssqq(originalSkssqq);
                        fetchDetailDto.setConditionJson(accessDetailDto.getConditionJson());
                        ruleFetchDetailDtoList.add(fetchDetailDto);
                        sumFetchAmount = sumFetchAmount.add(accessDetailDto.getFetchAmount());
                        sumOriginAmount = sumOriginAmount.add(accessDetailDto.getOriginAmount());
                    }
                    String ruleId = ObjectUtils.isNotEmpty(accessConfigObject) ? accessConfigObject.getString("id") : "";
                    String ruleName = ObjectUtils.isNotEmpty(accessConfigObject) ? accessConfigObject.getString("name") : "";
                    String projectName = ObjectUtils.isNotEmpty((Object)accessConfigObject) ? accessConfigObject.getString(this.accessConfig_ProjectName) : "";
                    String projectId = ObjectUtils.isNotEmpty((Object)accessConfigObject) ? accessConfigObject.getString(this.accessConfig_ProjectId) : "";
                    RuleFetchCardDto cardDto = new RuleFetchCardDto(ruleName, ruleId, ruleName, orgId, sumFetchAmount);
                    cardDto.getRuleFetchDetailList().addAll(ruleFetchDetailDtoList);
                    if (ObjectUtils.isNotEmpty(cellSummaryDtoMap.get(projectId + (String)entry.getKey()))) {
                        RuleFetchCellSummaryDto cellSummaryDto = (RuleFetchCellSummaryDto)cellSummaryDtoMap.get(projectId);
                        cellSummaryDto.getRuleFetchCardList().add(cardDto);
                        cellSummaryDto.setAmount(cellSummaryDto.getAmount().add(sumFetchAmount));
                        cellSummaryDto.setOriginAmount(cellSummaryDto.getOriginAmount().add(sumOriginAmount));
                        cellSummaryDto.setRuleId(cellSummaryDto.getRuleId() + "#" + ruleId);
                        List cellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
                        if (!cellSummaryList.contains(cellSummaryDto)) {
                            ruleFetchMainDto.getRuleFetchCellSummaryList().add(cellSummaryDto);
                        }
                    } else {
                        ArrayList<RuleFetchCardDto> ruleFetchCardList = new ArrayList<RuleFetchCardDto>();
                        ruleFetchCardList.add(cardDto);
                        RuleFetchCellSummaryDto cellSummaryDto = new RuleFetchCellSummaryDto(this.accessConfigEntityName, ruleId, projectId, (String)rowColumnAccessProjectMap.get(projectId + "_" + (String)entry.getKey()), sumFetchAmount, sumOriginAmount, (String)entry.getKey());
                        cellSummaryDto.getRuleFetchCardList().addAll(ruleFetchCardList);
                        ruleFetchMainDto.getRuleFetchCellSummaryList().add(cellSummaryDto);
                        cellSummaryDtoMap.put(projectId + (String)entry.getKey(), cellSummaryDto);
                    }
                });
            }
        }));
        return ruleFetchMainDto;
    }

    protected Map<String, String> getReportItemAccessProjectMap(RuleEngineParamDto engineParamDto, Set<String> accessProjectIdList) {
        HashMap<String, String> reportItemAccessProjectMap = new HashMap<String, String>(16);
        reportItemAccessProjectMap.putAll(super.getReportItemAccessProjectMap(engineParamDto, accessProjectIdList));
        reportItemAccessProjectMap.putAll(ItpJtThanFetchDataBussiness.getReportItemAccessProjectMap(engineParamDto, accessProjectIdList));
        return reportItemAccessProjectMap;
    }

    protected void saveOrDelDraftData(RuleFetchMainDto fetchSummaryDtoList) {
    }

    protected Map<String, List<RuleAccessDetailDto>> handleBuildRuleAccessDetailDto(Long orgId, RuleEngineParamDto engineParamDto, DynamicObject accessConfig) {
        HashMap<String, List<RuleAccessDetailDto>> map = new HashMap<String, List<RuleAccessDetailDto>>(1);
        Date skssqq = engineParamDto.getSkssqq();
        Date skssqz = engineParamDto.getSkssqz();
        DataEntityPropertyCollection properties = accessConfig.getDataEntityType().getProperties();
        properties.stream().forEach(property -> {
            if (property instanceof EntryProp) {
                String name = property.getName();
                String suffix = name.substring(this.entryentity.length());
                DynamicObjectCollection collection = accessConfig.getDynamicObjectCollection(name);
                ArrayList<RuleAccessDetailDto> list = new ArrayList<RuleAccessDetailDto>(8);
                IDataEntityProperty vatRateProperty = MetadataServiceHelper.getDataEntityType((String)this.accessConfigEntityName).findProperty(this.vatrate + suffix);
                IDataEntityProperty baseDataTypeProperty = MetadataServiceHelper.getDataEntityType((String)this.accessConfigEntityName).findProperty("basedatatype" + suffix);
                Boolean isContainBasedatatype = false;
                if (null != baseDataTypeProperty) {
                    isContainBasedatatype = true;
                }
                for (DynamicObject row : collection) {
                    String bizName = row.getString(this.bizname + suffix);
                    String amountFieldEntity = "";
                    String amountFieldNum = "";
                    String baseDataType = "tctb_datasource_entry";
                    if (isContainBasedatatype.booleanValue()) {
                        if (StringUtil.equalsIgnoreCase((CharSequence)row.getString("basedatatype" + suffix), (CharSequence)"tctb_datasource_entry")) {
                            DynamicObject amountObject = BusinessDataServiceHelper.loadSingleFromCache((Object)row.getDynamicObject(this.amountfield + suffix).get("id"), (String)"tctb_datasource_entry", (String)"fieldsubname,fieldname");
                            amountFieldEntity = amountObject.getString("fieldsubname");
                            amountFieldNum = amountObject.getString("fieldname");
                        } else {
                            amountFieldEntity = row.getString("basedatatype" + suffix);
                            amountFieldNum = row.getDynamicObject(this.amountfield + suffix).getString("id");
                            baseDataType = row.getString("basedatatype" + suffix);
                        }
                    } else {
                        amountFieldEntity = row.getDynamicObject(this.amountfield + suffix).getString("fieldsubname");
                        amountFieldNum = row.getDynamicObject(this.amountfield + suffix).getString("fieldname");
                    }
                    Long amountFieldId = row.getDynamicObject(this.amountfield + suffix).getLong("id");
                    String dataDirection = row.getString(this.datadirection + suffix);
                    String absoluteB = row.getString(this.absolute + suffix);
                    String filterCondition = row.getString(this.filtercondition + suffix);
                    String dataType = row.getString(this.datatype + suffix);
                    Long dataSourceId = row.getDynamicObject(this.ftable + suffix).getLong("id");
                    String advancedConf = row.getString(this.advancedconf + suffix);
                    String conditionJsonS = row.getString(this.conditionjson + suffix);
                    String advancedConfJson = row.getString(this.advancedconfjson + suffix);
                    BigDecimal vatRate = null != vatRateProperty ? row.getBigDecimal(this.vatrate + suffix) : null;
                    RuleAccessDetailDto detailDto = new RuleAccessDetailDto(accessConfig, orgId, skssqq, skssqz, bizName, dataSourceId, amountFieldId, dataDirection, absoluteB, filterCondition, dataType, advancedConf, conditionJsonS, advancedConfJson, amountFieldEntity, amountFieldNum, vatRate, baseDataType);
                    list.add(detailDto);
                }
                map.put(name, list);
            }
        });
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            for (RuleAccessDetailDto dto : list) {
                dto.getBaseDataType();
                dto.setConditionJson(this.buildFilter(dto.getConditionJson(), dto.getBaseDataType(), engineParamDto.getTemplateId()));
            }
        }
        return map;
    }

    public String buildFilter(String conditionjson, String baseDataType, Long templateId) {
        if (StringUtil.isEmpty((CharSequence)conditionjson)) {
            return conditionjson;
        }
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)conditionjson, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        if (StringUtil.equalsIgnoreCase((CharSequence)baseDataType, (CharSequence)"tpo_col_member")) {
            Long jtysbbdTemplateId = DraftConstant.jtysbbd_jt_id;
            String templateNumber = "PRO-DECLARE-THAN-JT";
            String accountsettype = "jtzt";
            String templatetype = "jtysbbd_jt";
            if (DraftConstant.sdsjt_bd_id.equals(templateId)) {
                jtysbbdTemplateId = DraftConstant.jtysbbd_bd_id;
                accountsettype = "bdzt";
                templatetype = "jtysbbd_bd";
                templateNumber = "PRO-DECLARE-THAN-BD";
            }
            ArrayList<SimpleFilterRow> filterList = new ArrayList<SimpleFilterRow>();
            FilterValue templateIdFilterValue = new FilterValue();
            templateIdFilterValue.setId(jtysbbdTemplateId.toString());
            templateIdFilterValue.setValue((Object)templateNumber);
            filterList.add(new SimpleFilterRow("", CompareTypeEnum.EQUAL.getId(), "templateid.number", "", String.valueOf(LogicOperate.AND.getValue()), Collections.singletonList(templateIdFilterValue)));
            FilterValue templateTypeFilterValue = new FilterValue();
            templateTypeFilterValue.setValue((Object)templatetype);
            templateTypeFilterValue.setId(templatetype);
            filterList.add(new SimpleFilterRow("", CompareTypeEnum.EQUAL.getId(), "templatetype.number", "", String.valueOf(LogicOperate.AND.getValue()), Collections.singletonList(templateTypeFilterValue)));
            filterCondition.getFilterRow().addAll(filterList);
            Map lastConditionMap = ser.serializeToMap((Object)filterCondition, null);
            conditionjson = SerializationUtils.toJsonString((Object)lastConditionMap);
        }
        return conditionjson;
    }

    public Map<Long, List<DynamicObject>> getAllOrgMatchAccessConfigMap(RuleEngineParamDto engineParamDto) {
        return super.getAllOrgMatchAccessConfigMap(engineParamDto);
    }

    private static class RuleAccessConfigServiceInner {
        private static final RuleAccessConfigService ruleFetchBusiness = new ItpJtThanAccessConfigServiceImpl();

        private RuleAccessConfigServiceInner() {
        }
    }
}

