/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.jtysbthanrule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.EntryProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.business.rule.RuleAccessConfigService;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCardDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchDetailDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleAccessDetailDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.itp.business.jtysbthanrule.ItpJtThanDraftEngineServiceImpl;
import org.apache.commons.lang3.ObjectUtils;

public class ItpJtThanDynEngineServiceImpl
extends ItpJtThanDraftEngineServiceImpl {
    public ItpJtThanDynEngineServiceImpl() {
        this.accessConfigEntityName = "itp_jtthan_accessconfig";
    }

    @Override
    protected RuleAccessConfigService registerRuleAccessConfigService() {
        return ItpJtThanDynEngineServiceImpl.getRuleFetchBusiness();
    }

    public RuleFetchMainDto businessHandler(RuleEngineParamDto engineParamDto) {
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto(engineParamDto.getTaxOrgId(), engineParamDto.getSkssqq(), engineParamDto.getSkssqz(), engineParamDto.getTemplateId(), engineParamDto.getDraftPurpose());
        Map<Long, List<DynamicObject>> orgMatchAccessConfigMap = this.getAllOrgMatchAccessConfigMap(engineParamDto);
        ruleFetchMainDto = this.handleBuildRuleFetchMainDto(engineParamDto, this.getAllOrgAccessAmount(engineParamDto, orgMatchAccessConfigMap));
        return ruleFetchMainDto;
    }

    @Override
    protected Map<String, List<RuleAccessDetailDto>> handleBuildRuleAccessDetailDto(Long orgId, RuleEngineParamDto engineParamDto, DynamicObject accessConfig) {
        HashMap<String, List<RuleAccessDetailDto>> map = new HashMap<String, List<RuleAccessDetailDto>>(1);
        Date skssqq = engineParamDto.getSkssqq();
        Date skssqz = engineParamDto.getSkssqz();
        DataEntityPropertyCollection properties = accessConfig.getDataEntityType().getProperties();
        properties.stream().forEach(property -> {
            if (property instanceof EntryProp) {
                String name = property.getName();
                String suffix = name.substring(this.entryentity.length());
                DynamicObjectCollection collection = accessConfig.getDynamicObjectCollection(name);
                ArrayList<RuleAccessDetailDto> list = new ArrayList<RuleAccessDetailDto>(8);
                IDataEntityProperty vatRateProperty = MetadataServiceHelper.getDataEntityType((String)this.accessConfigEntityName).findProperty(this.vatrate + suffix);
                IDataEntityProperty baseDataTypeProperty = MetadataServiceHelper.getDataEntityType((String)this.accessConfigEntityName).findProperty("basedatatype" + suffix);
                Boolean isContainBasedatatype = false;
                if (null != baseDataTypeProperty) {
                    isContainBasedatatype = true;
                }
                for (DynamicObject row : collection) {
                    String bizName = row.getString(this.bizname + suffix);
                    String amountFieldEntity = "";
                    String amountFieldNum = "";
                    String baseDataType = "tctb_datasource_entry";
                    if (isContainBasedatatype.booleanValue()) {
                        if (StringUtil.equalsIgnoreCase((CharSequence)row.getString("basedatatype" + suffix), (CharSequence)"tctb_datasource_entry")) {
                            DynamicObject amountObject = BusinessDataServiceHelper.loadSingleFromCache((Object)row.getDynamicObject(this.amountfield + suffix).get("id"), (String)"tctb_datasource_entry", (String)"fieldsubname,fieldname");
                            amountFieldEntity = amountObject.getString("fieldsubname");
                            amountFieldNum = amountObject.getString("fieldname");
                        } else {
                            amountFieldEntity = row.getString("basedatatype" + suffix);
                            amountFieldNum = row.getDynamicObject(this.amountfield + suffix).getString("id");
                            baseDataType = row.getString("basedatatype" + suffix);
                        }
                    } else {
                        amountFieldEntity = row.getDynamicObject(this.amountfield + suffix).getString("fieldsubname");
                        amountFieldNum = row.getDynamicObject(this.amountfield + suffix).getString("fieldname");
                    }
                    Long amountFieldId = row.getDynamicObject(this.amountfield + suffix).getLong("id");
                    String dataDirection = row.getString(this.datadirection + suffix);
                    String absoluteB = row.getString(this.absolute + suffix);
                    String filterCondition = row.getString(this.filtercondition + suffix);
                    String dataType = row.getString(this.datatype + suffix);
                    Long dataSourceId = row.getDynamicObject(this.ftable + suffix).getLong("id");
                    String advancedConf = row.getString(this.advancedconf + suffix);
                    String conditionJsonS = row.getString(this.conditionjson + suffix);
                    String advancedConfJson = row.getString(this.advancedconfjson + suffix);
                    BigDecimal vatRate = null != vatRateProperty ? row.getBigDecimal(this.vatrate + suffix) : null;
                    RuleAccessDetailDto detailDto = new RuleAccessDetailDto(accessConfig, orgId, skssqq, skssqz, bizName, dataSourceId, amountFieldId, dataDirection, absoluteB, filterCondition, dataType, advancedConf, conditionJsonS, advancedConfJson, amountFieldEntity, amountFieldNum, vatRate, baseDataType);
                    list.add(detailDto);
                }
                map.put(name, list);
            }
        });
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            for (RuleAccessDetailDto dto : list) {
                dto.getBaseDataType();
                dto.setConditionJson(this.buildFilter(dto.getConditionJson(), dto.getBaseDataType(), engineParamDto.getTemplateId()));
            }
        }
        return map;
    }

    @Override
    protected RuleFetchMainDto handleBuildRuleFetchMainDto(RuleEngineParamDto engineParamDto, List<Map<Long, List<Map<String, List<RuleAccessDetailDto>>>>> allOrgAccessResult) {
        Date originalSkssqq = (Date)engineParamDto.getExtendParams().get("originalSkssqq");
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto(engineParamDto.getTaxOrgId(), originalSkssqq, engineParamDto.getSkssqz(), engineParamDto.getTemplateId(), engineParamDto.getDraftPurpose());
        HashSet<String> accessProjectIdList = new HashSet<String>();
        allOrgAccessResult.stream().forEach(orgMap -> orgMap.entrySet().stream().forEach(orgEntry -> ((List)orgEntry.getValue()).stream().forEach(ruleRow -> ruleRow.entrySet().stream().forEach(accessDetailList -> ((List)accessDetailList.getValue()).forEach(detailDto -> accessProjectIdList.add(detailDto.getAccessConfigObject().getString(this.accessConfig_ProjectId)))))));
        Map<String, String> rowColumnAccessProjectMap = this.getReportItemAccessProjectMap(engineParamDto, accessProjectIdList);
        HashMap cellSummaryDtoMap = new HashMap();
        allOrgAccessResult.stream().forEach(orgMap -> orgMap.entrySet().stream().forEach(orgEntry -> {
            Long orgId = (Long)orgEntry.getKey();
            List singleOrgAllAccessResultList = (List)orgEntry.getValue();
            ArrayList ruleFetchCellSummaryList = new ArrayList();
            ruleFetchMainDto.getRuleFetchCellSummaryList().addAll(ruleFetchCellSummaryList);
            for (Map singleAccessConfigResultMap : singleOrgAllAccessResultList) {
                singleAccessConfigResultMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(this.entryentity)).forEach(entry -> {
                    List accessDetailDtoList = (List)entry.getValue();
                    ArrayList<RuleFetchDetailDto> ruleFetchDetailDtoList = new ArrayList<RuleFetchDetailDto>(accessDetailDtoList.size());
                    BigDecimal sumFetchAmount = BigDecimal.ZERO;
                    BigDecimal sumOriginAmount = BigDecimal.ZERO;
                    DynamicObject accessConfigObject = null;
                    for (RuleAccessDetailDto accessDetailDto : accessDetailDtoList) {
                        if (ObjectUtils.isEmpty(accessConfigObject)) {
                            accessConfigObject = accessDetailDto.getAccessConfigObject();
                        }
                        RuleFetchDetailDto fetchDetailDto = new RuleFetchDetailDto(accessDetailDto.getSkssqq(), accessDetailDto.getSkssqz(), accessDetailDto.getBizName(), accessDetailDto.getDataSource(), accessDetailDto.getAmountField(), accessDetailDto.getBaseDataType(), accessDetailDto.getFetchType(), accessDetailDto.getFetchDirection(), accessDetailDto.getFetchAmount(), accessDetailDto.getOriginAmount(), accessDetailDto.getAbsolute(), accessDetailDto.getFilterCondition(), (String)entry.getKey());
                        fetchDetailDto.setSkssqq(originalSkssqq);
                        fetchDetailDto.setConditionJson(accessDetailDto.getConditionJson());
                        ruleFetchDetailDtoList.add(fetchDetailDto);
                        sumFetchAmount = sumFetchAmount.add(accessDetailDto.getFetchAmount());
                        sumOriginAmount = sumOriginAmount.add(accessDetailDto.getOriginAmount());
                    }
                    String ruleId = ObjectUtils.isNotEmpty(accessConfigObject) ? accessConfigObject.getString("id") : "";
                    String ruleName = ObjectUtils.isNotEmpty(accessConfigObject) ? accessConfigObject.getString("name") : "";
                    String projectName = ObjectUtils.isNotEmpty((Object)accessConfigObject) ? accessConfigObject.getString(this.accessConfig_ProjectName) : "";
                    String projectId = ObjectUtils.isNotEmpty((Object)accessConfigObject) ? accessConfigObject.getString(this.accessConfig_ProjectId) : "";
                    RuleFetchCardDto cardDto = new RuleFetchCardDto(ruleName, ruleId, ruleName, orgId, sumFetchAmount);
                    cardDto.getRuleFetchDetailList().addAll(ruleFetchDetailDtoList);
                    if (ObjectUtils.isNotEmpty(cellSummaryDtoMap.get(projectId + (String)entry.getKey()))) {
                        RuleFetchCellSummaryDto cellSummaryDto = (RuleFetchCellSummaryDto)cellSummaryDtoMap.get(projectId);
                        cellSummaryDto.getRuleFetchCardList().add(cardDto);
                        cellSummaryDto.setAmount(cellSummaryDto.getAmount().add(sumFetchAmount));
                        cellSummaryDto.setOriginAmount(cellSummaryDto.getOriginAmount().add(sumOriginAmount));
                        cellSummaryDto.setRuleId(cellSummaryDto.getRuleId() + "#" + ruleId);
                        List cellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
                        if (!cellSummaryList.contains(cellSummaryDto)) {
                            ruleFetchMainDto.getRuleFetchCellSummaryList().add(cellSummaryDto);
                        }
                    } else {
                        ArrayList<RuleFetchCardDto> ruleFetchCardList = new ArrayList<RuleFetchCardDto>();
                        ruleFetchCardList.add(cardDto);
                        RuleFetchCellSummaryDto cellSummaryDto = new RuleFetchCellSummaryDto(this.accessConfigEntityName, ruleId, projectId, (String)rowColumnAccessProjectMap.get(projectId), sumFetchAmount, sumOriginAmount, (String)entry.getKey());
                        cellSummaryDto.getRuleFetchCardList().addAll(ruleFetchCardList);
                        ruleFetchMainDto.getRuleFetchCellSummaryList().add(cellSummaryDto);
                        cellSummaryDtoMap.put(projectId + (String)entry.getKey(), cellSummaryDto);
                    }
                });
            }
        }));
        return ruleFetchMainDto;
    }

    @Override
    public Map<Long, List<DynamicObject>> getAllOrgMatchAccessConfigMap(RuleEngineParamDto engineParamDto) {
        return super.getAllOrgMatchAccessConfigMap(engineParamDto);
    }
}

