/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.papers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.itp.business.papers.ProvisionDeclarationComparisonBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class ItpDraftBussiness {
    public static DynamicObject queryDraftInfo(Long orgId, Date skssqq, Date skssqz, QFilter declareMainQueryParams) {
        QFilter defaultQfilter = new QFilter("org", "=", (Object)orgId);
        QFilter isexistfilter = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)DateUtils.getDayFirst((Date)skssqz));
        String declareMainTable = MultiTableEnum.TSD001.getDeclareMainTable();
        return BusinessDataServiceHelper.loadSingle((String)declareMainTable, (String)MetadataUtil.getAllSubFieldString((String)declareMainTable), (QFilter[])new QFilter[]{defaultQfilter, declareMainQueryParams, isexistfilter});
    }

    public static boolean isAnIntersection(String table, Long orgId, Long taxsystemId, Date sksqq, Date sksqz, String zt, String templateType, boolean isadjustperiod) {
        QFilter defaultQfilter = new QFilter("org", "=", (Object)orgId).and("templatetype", "=", (Object)templateType).and("taxsystem", "=", (Object)taxsystemId).and("accountsettype", "=", (Object)zt).and("isadjustperiod", "=", (Object)isadjustperiod);
        QFilter dateQfilter = new QFilter("skssqq", ">=", (Object)sksqq).and("skssqq", "<=", (Object)sksqz);
        QFilter q1 = new QFilter("skssqq", "<=", (Object)sksqq).and("skssqz", ">=", (Object)sksqz);
        QFilter q2 = new QFilter("skssqz", ">=", (Object)sksqq).and("skssqz", "<=", (Object)sksqz);
        dateQfilter.or(q1);
        dateQfilter.or(q2);
        return QueryServiceHelper.exists((String)table, (QFilter[])new QFilter[]{defaultQfilter, dateQfilter});
    }

    public static long getDraftId(String templatetype, Date skssqq, Date skssqz, QFilter universalQfilter) {
        QFilter qFilter = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)skssqz);
        if (ObjectUtils.isNotEmpty((Object)universalQfilter)) {
            qFilter.and(universalQfilter);
        }
        qFilter.and("templatetype", "=", (Object)templatetype);
        DynamicObject record = QueryServiceHelper.queryOne((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (!ObjectUtils.isEmpty((Object)record)) {
            return record.getLong("id");
        }
        return -1L;
    }

    public static String getPreSbbId(Long orgId, String templateType, Long taxSystemId, Date startDate, Date endDate, Boolean isadjustperiod, QFilter extendFilter) {
        DynamicObject preMain;
        QFilter declareMainFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("templatetype", "=", (Object)templateType)).and(new QFilter("skssqz", "=", (Object)endDate)).and(new QFilter("taxsystem", "=", (Object)taxSystemId)).and(new QFilter("isadjustperiod", "=", (Object)isadjustperiod));
        if (startDate != null) {
            declareMainFilter.and(new QFilter("skssqq", "=", (Object)startDate));
        }
        if (ObjectUtils.isNotEmpty((Object)extendFilter)) {
            declareMainFilter.and(extendFilter);
        }
        return (preMain = QueryServiceHelper.queryOne((String)"tpo_declare_main_tsd", (String)"id", (QFilter[])new QFilter[]{declareMainFilter})) == null ? "-1" : preMain.getString("id");
    }

    public static DynamicObject checkRecordIsexist(String maintable, String orgid, String type, String startDate, String endDate, QFilter qFilter) {
        DynamicObject dyo = YbnsrService.queryMultiDeclareMain((String)maintable, (long)Long.parseLong(orgid), (String)type, (String)startDate, (String)endDate, (QFilter)qFilter);
        return dyo;
    }

    public static Map.Entry<Integer, DynamicObject> getAuditedDeclareThanDraft(String templateType, Date skssqz, Long taxationsysId, Long orgId, String zttype, String adjustStatus, String status, Long draftId) {
        HashMap<Integer, DynamicObject> map = new HashMap<Integer, DynamicObject>();
        if (ObjectUtils.isEmpty((Object)skssqz) || ObjectUtils.isEmpty((Object)taxationsysId) || ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)zttype)) {
            return null;
        }
        Date yearDate = DateUtils.addYear((Date)skssqz, (int)-1);
        String template = "sdsjt_bd".equals(templateType) ? "jtysbbd_bd" : "jtysbbd_jt";
        DynamicObject[] dataCollection = ProvisionDeclarationComparisonBusiness.getData(taxationsysId, orgId, zttype, yearDate, template, status, adjustStatus.equals("yes") ? "yes" : "");
        if ("yes".equals(adjustStatus)) {
            Optional<DynamicObject> dataOptional = Arrays.stream(dataCollection).filter(p -> ((DynamicObject)p.getDynamicObjectCollection("entryentity").get(0)).getLong("draftid") == draftId.longValue()).findFirst();
            if (dataOptional.isPresent()) {
                map.put(dataCollection.length, dataOptional.get());
            } else {
                map.put(0, null);
            }
            return (Map.Entry)map.entrySet().stream().findFirst().get();
        }
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(dataCollection.length);
        for (DynamicObject dynamicObject : dataCollection) {
            DynamicObjectCollection entryEntities = dynamicObject.getDynamicObjectCollection("entryentity");
            if (!entryEntities.isEmpty() && !"no".equals(((DynamicObject)entryEntities.get(0)).getString("isadjuest"))) continue;
            dataList.add(dynamicObject);
        }
        if (dataCollection.length > 1 && dataList.size() == 1 && "sdbd".equals(((DynamicObject)dataList.get(0)).getString("comparisontype"))) {
            map.put(1, null);
            return (Map.Entry)map.entrySet().stream().findFirst().get();
        }
        DynamicObject data = null;
        if (dataList.size() == 1) {
            data = (DynamicObject)dataList.get(0);
        } else if (dataList.size() > 1) {
            data = dataList.stream().filter(o -> "hjbd".equals(o.getString("comparisontype"))).findFirst().get();
        }
        map.put(dataList.size(), data);
        return (Map.Entry)map.entrySet().stream().findFirst().get();
    }
}

