/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.papers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;

public class ItpMultiDataQueryBussiness {
    private static final Log logger = LogFactory.getLog(ItpMultiDataQueryBussiness.class);

    public static Long queryDraftId(String templatetype, Long orgId, Date skssqq, Date skssqz, QFilter extendQflters) {
        DynamicObject record;
        QFilter qFilter = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)skssqz);
        qFilter.and("templatetype", "=", (Object)templatetype).and("org", "=", (Object)orgId);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)extendQflters)) {
            qFilter.and(extendQflters);
        }
        if (!ObjectUtils.isEmpty((Object)(record = QueryServiceHelper.queryOne((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{qFilter})))) {
            return record.getLong("id");
        }
        return -1L;
    }

    public static DynamicObjectCollection queryCellvaluesByIdAndCellkeyList(Long id, List<String> cellKeyList) {
        QFilter filter = new QFilter("entryid", "=", (Object)id).and("cellnumber", "in", cellKeyList);
        return QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"id,cellnumber,value", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject[] queryDraftId(String templatetype, Long orgId, QFilter qFilter) {
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)templatetype) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)orgId)) {
            QFilter qf = new QFilter("templatetype", "=", (Object)templatetype);
            qf.and(new QFilter("org", "=", (Object)orgId));
            qf.and(qFilter);
            return BusinessDataServiceHelper.load((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id,skssqq,skssqz,billno,billstatus", (QFilter[])new QFilter[]{qf});
        }
        return null;
    }

    public static DynamicObject[] queryMutliMainTableData(String templatetype, Long orgId, Date skssqq, Date skssqz, QFilter qFilter) {
        QFilter filter = new QFilter("templatetype", "=", (Object)templatetype).and("org", "=", (Object)orgId).and("skssqq", ">=", (Object)skssqq).and("skssqz", "<=", (Object)skssqz);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)qFilter)) {
            filter.and(qFilter);
        }
        return BusinessDataServiceHelper.load((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id,skssqq,skssqz,billno,billstatus", (QFilter[])new QFilter[]{filter});
    }

    public static Map<String, Map<String, String>> queryMultiDetailDynCellValue(List<Long> mainIdList, List<String> dynrownoList, String bbxmEndNumber, String amountEndNumber, List<Long> fetchitemList) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(8);
        QFilter entryidQ = new QFilter("entryid", "in", mainIdList);
        QFilter dynRowNoQ = new QFilter("dynrowno", "in", dynrownoList);
        DataSet rowsData = QueryServiceHelper.queryDataSet((String)"batchQueryCellValue", (String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"index,cellnumber,value,dynrowno,entryid", (QFilter[])new QFilter[]{entryidQ, dynRowNoQ}, null);
        DataSet dynrownoDataSet = rowsData.copy().filter(new QFilter("cellnumber", "like", (Object)("%" + bbxmEndNumber)).toString());
        DataSet valueDataSet = rowsData.copy().filter(new QFilter("cellnumber", "like", (Object)("%" + amountEndNumber)).toString());
        JoinDataSet join = dynrownoDataSet.join(valueDataSet, JoinType.INNER);
        DataSet rows = join.on("dynrowno", "dynrowno").on("index", "index").on("entryid", "entryid").select(new String[]{"dynrowno", "cellnumber bbcellnumber", "value bbId", "entryid"}, new String[]{"cellnumber", "value"}).finish();
        while (rows.hasNext()) {
            Row row = rows.next();
            String bbId = row.getString("bbId");
            String entryid = row.getString("entryid");
            String value = row.getString("value");
            if (!resultMap.containsKey(entryid)) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put(bbId, value);
                resultMap.put(entryid, map);
                continue;
            }
            ((Map)resultMap.get(entryid)).put(bbId, value);
        }
        rowsData.close();
        dynrownoDataSet.close();
        valueDataSet.close();
        rows.close();
        return resultMap;
    }

    public static Map<String, Map<String, String>> queryMultiDetailFixCellValue(List<Long> mainIdList, List<String> bbxmList) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(8);
        QFilter entryidQ = new QFilter("entryid", "in", mainIdList);
        QFilter fixRowNoQ = new QFilter("cellnumber", "in", bbxmList);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"id,entryid,value,cellnumber", (QFilter[])new QFilter[]{entryidQ, fixRowNoQ});
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String entryid = dynamicObject.getString("entryid");
                String value = dynamicObject.getString("value");
                String cellnumber = dynamicObject.getString("cellnumber");
                if (resultMap.containsKey(entryid)) {
                    ((Map)resultMap.get(entryid)).put(cellnumber, value);
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put(cellnumber, value);
                resultMap.put(entryid, map);
            }
        }
        return resultMap;
    }

    public static HashMap<String, List<Map<String, Object>>> queryHistoryDeclare(Long orgId, Long templateId, Long taxsystemId, Date startDate, Date endDate) {
        DynamicObject preMain;
        HashMap<String, List<Map<String, Object>>> historyDeclare = new HashMap<String, List<Map<String, Object>>>(8);
        QFilter declareMainFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("templateid", "=", (Object)templateId)).and(new QFilter("skssqz", "=", (Object)endDate)).and(new QFilter("taxsystem", "=", (Object)taxsystemId));
        if (startDate != null) {
            declareMainFilter.and(new QFilter("skssqq", "=", (Object)startDate));
        }
        if ((preMain = QueryServiceHelper.queryOne((String)"tpo_declare_main_tsd", (String)"id", (QFilter[])new QFilter[]{declareMainFilter})) != null) {
            QFilter qFilter = new QFilter("entryid", "=", preMain.get("id")).and(new QFilter("dynrowno", "is not null", null)).and(new QFilter("dynrowno", "!=", (Object)""));
            DynamicObject[] expenses = BusinessDataServiceHelper.load((String)"tpo_declare_detail_tsd", (String)"id,entryid,cellnumber,row,column,dynrowno,index,valuetype,value,version", (QFilter[])new QFilter[]{qFilter});
            Map<String, List<DynamicObject>> groupRows = Arrays.stream(expenses).collect(Collectors.groupingBy(expense -> expense.getString("dynrowno")));
            LinkedHashMap sortedGroupRows = new LinkedHashMap(16);
            for (Map.Entry<String, List<DynamicObject>> entry : groupRows.entrySet()) {
                sortedGroupRows.put(entry.getKey(), entry.getValue().stream().sorted(Comparator.comparingLong(o -> o.getLong("index"))).collect(Collectors.toList()));
            }
            for (Map.Entry<String, List<Object>> entry : sortedGroupRows.entrySet()) {
                List<Object> rowList = entry.getValue();
                Map<Long, List<DynamicObject>> groupRowList = rowList.stream().collect(Collectors.groupingBy(expense -> expense.getLong("index")));
                ArrayList list = new ArrayList(16);
                for (Map.Entry<Long, List<DynamicObject>> entry2 : groupRowList.entrySet()) {
                    HashMap<String, Object> rowMap = new HashMap<String, Object>(8);
                    for (DynamicObject object : entry2.getValue()) {
                        String string = object.getString("cellnumber");
                        String[] split = string.split("#");
                        String s = split[0] + "#" + split[2];
                        Object value = object.get("value");
                        rowMap.put(s, value);
                    }
                    list.add(rowMap);
                }
                historyDeclare.put(entry.getKey(), list);
            }
        }
        logger.info("\u7ec4\u7ec7\uff1a{},\u6a21\u677fid{},\u7a0e\u6536\u5236\u5ea6:{}, \u65f6\u95f4:{} - {},\u83b7\u53d6\u76f8\u5173\u5386\u53f2\u62a5\u8868\u6570\u636e\uff1a{}", new Object[]{orgId, templateId, taxsystemId, startDate, endDate, JsonUtil.toJson(historyDeclare)});
        return historyDeclare;
    }

    public static HashMap<String, List<Map<String, Object>>> queryHistoryDeclareByDraftId(Long entryid) {
        HashMap<String, List<Map<String, Object>>> historyDeclare = new HashMap<String, List<Map<String, Object>>>(8);
        QFilter qFilter = new QFilter("entryid", "=", (Object)entryid).and(new QFilter("dynrowno", "is not null", null)).and(new QFilter("dynrowno", "!=", (Object)""));
        DynamicObject[] expenses = BusinessDataServiceHelper.load((String)"tpo_declare_detail_tsd", (String)"id,entryid,cellnumber,row,column,dynrowno,index,valuetype,value,version", (QFilter[])new QFilter[]{qFilter});
        Map<String, List<DynamicObject>> groupRows = Arrays.stream(expenses).collect(Collectors.groupingBy(expense -> expense.getString("dynrowno")));
        LinkedHashMap sortedGroupRows = new LinkedHashMap(16);
        for (Map.Entry<String, List<DynamicObject>> entry : groupRows.entrySet()) {
            sortedGroupRows.put(entry.getKey(), entry.getValue().stream().sorted(Comparator.comparingLong(o -> o.getLong("index"))).collect(Collectors.toList()));
        }
        for (Map.Entry<String, List<Object>> entry : sortedGroupRows.entrySet()) {
            List<Object> rowList = entry.getValue();
            Map<Long, List<DynamicObject>> groupRowList = rowList.stream().collect(Collectors.groupingBy(expense -> expense.getLong("index")));
            ArrayList list = new ArrayList(16);
            for (Map.Entry<Long, List<DynamicObject>> entry2 : groupRowList.entrySet()) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>(8);
                for (DynamicObject object : entry2.getValue()) {
                    String string = object.getString("cellnumber");
                    String[] split = string.split("#");
                    String s = split[0] + "#" + split[2];
                    Object value = object.get("value");
                    rowMap.put(s, value);
                }
                list.add(rowMap);
            }
            historyDeclare.put(entry.getKey(), list);
        }
        logger.info("\u5e95\u7a3fid\uff1a{}", (Object)entryid);
        return historyDeclare;
    }
}

