/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.papers;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tccit.RecoupDeficitStandBookServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.itp.business.baseinfo.ItpTaxLossConfigBussiness;
import kd.taxc.itp.business.papers.ItpMultiDataQueryBussiness;
import org.apache.commons.lang3.ObjectUtils;

public class ItpTaxLossDraftBussiness {
    private static final Log logger = LogFactory.getLog(ItpTaxLossDraftBussiness.class);

    public static Map<String, List<Map<String, Object>>> buildDynRowList(Long orgId, Long taxSystemId, Date startDate, Date endDate, Long templateId) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(8);
        DynamicObject obj = ItpTaxLossConfigBussiness.queryTaxLossConfigByValid(orgId, taxSystemId, endDate);
        if (ObjectUtils.isEmpty((Object)obj)) {
            return result;
        }
        Date yearfrom = obj.getDate("yearfrom");
        if (ObjectUtils.isEmpty((Object)yearfrom)) {
            return result;
        }
        int cropyear = DateUtils.getYearOfDate((Date)startDate);
        Integer lapseyear = ItpTaxLossDraftBussiness.calculate(orgId, taxSystemId, endDate);
        if (lapseyear == null) {
            return result;
        }
        List<Map<String, Object>> resultList = DateUtils.getYearOfDate((Date)yearfrom) == DateUtils.getYearOfDate((Date)startDate) ? ItpTaxLossDraftBussiness.initFirstPeriod(orgId, yearfrom, endDate, cropyear, lapseyear) : ItpTaxLossDraftBussiness.initNoFirstPeriod(orgId, templateId, taxSystemId, startDate, endDate, cropyear, lapseyear);
        result.put("tax_loss_jzgl_xm#1", resultList);
        return result;
    }

    public static List<Map<String, Object>> queryDataFromQysdsStandBook(Long orgId, Date yearfrom, Integer hanppenyear, Integer loseyear) {
        ArrayList<Map<String, Object>> bookList = new ArrayList<Map<String, Object>>(12);
        TaxResult last20YearsStandBook = RecoupDeficitStandBookServiceHelper.getLast20YearsStandBook((Long)orgId, (Date)yearfrom);
        if (last20YearsStandBook.isSuccess() && ObjectUtils.isNotEmpty((Object)last20YearsStandBook.getData())) {
            List dynamicObjectList = (List)last20YearsStandBook.getData();
            if (ObjectUtils.isEmpty((Object)dynamicObjectList)) {
                return bookList;
            }
            HashMap eachYearInfoMap = new HashMap(8);
            HashMap<String, BigDecimal> eachYearMbSumMap = new HashMap<String, BigDecimal>(8);
            for (DynamicObject dynamicObject : dynamicObjectList) {
                Date happenyear = dynamicObject.getDate("happenyear");
                Date ksdqnd = dynamicObject.getDate("ksdqnd");
                BigDecimal lossmoney = dynamicObject.getBigDecimal("lossmoney");
                Integer cropyear = DateUtils.getYearOfDate((Date)happenyear);
                Integer lapseyear = DateUtils.getYearOfDate((Date)ksdqnd);
                if (!eachYearInfoMap.containsKey(String.valueOf(cropyear))) {
                    eachYearInfoMap.put(String.valueOf(cropyear), new ArrayList(2));
                }
                HashMap<String, Object> standBookMap = new HashMap<String, Object>(8);
                standBookMap.put("happenyear", DateUtils.format((Date)happenyear));
                standBookMap.put("ksdqnd", ObjectUtils.isNotEmpty((Object)ksdqnd) ? DateUtils.format((Date)ksdqnd) : "-1");
                standBookMap.put("lossmoney", lossmoney);
                DynamicObjectCollection objectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                if (ObjectUtils.isNotEmpty((Object)objectCollection)) {
                    BigDecimal ljymbks = BigDecimal.ZERO;
                    for (DynamicObject obj : objectCollection) {
                        Date mbnd = obj.getDate("mbnd");
                        BigDecimal mbzcksje = obj.getBigDecimal("mbzcksje");
                        ljymbks = ljymbks.add(mbzcksje);
                        if (ObjectUtils.isEmpty((Object)mbnd)) continue;
                        if (!eachYearMbSumMap.containsKey(String.valueOf(DateUtils.getYearOfDate((Date)mbnd)))) {
                            eachYearMbSumMap.put(String.valueOf(DateUtils.getYearOfDate((Date)mbnd)), BigDecimal.ZERO);
                        }
                        eachYearMbSumMap.put(String.valueOf(DateUtils.getYearOfDate((Date)mbnd)), ((BigDecimal)eachYearMbSumMap.get(String.valueOf(DateUtils.getYearOfDate((Date)mbnd)))).add(mbzcksje));
                    }
                    standBookMap.put("ljymbks", ljymbks);
                }
                ((List)eachYearInfoMap.get(String.valueOf(cropyear))).add(standBookMap);
            }
            Set entries = eachYearInfoMap.entrySet();
            for (Map.Entry next : entries) {
                String entryKey = (String)next.getKey();
                List entryValue = (List)next.getValue();
                if (!eachYearMbSumMap.containsKey(entryKey) || !ObjectUtils.isNotEmpty((Object)entryValue)) continue;
                BigDecimal remove = (BigDecimal)eachYearMbSumMap.remove(entryKey);
                if (entryValue.size() == 1) {
                    ((Map)entryValue.get(0)).put("bnmbks", remove);
                    continue;
                }
                ((Map)entryValue.get(entryValue.size() - 1)).put("bnmbks", remove);
            }
            if (ObjectUtils.isNotEmpty(eachYearMbSumMap)) {
                Set entrySet = eachYearMbSumMap.entrySet();
                for (Map.Entry next : entrySet) {
                    String nextKey = (String)next.getKey();
                    BigDecimal nextValue = (BigDecimal)next.getValue();
                    HashMap<String, Object> map = new HashMap<String, Object>(8);
                    map.put("happenyear", nextKey + "-01-01");
                    if (loseyear != null && -1 != loseyear) {
                        Integer loss = loseyear - hanppenyear + Integer.parseInt(nextKey);
                        map.put("ksdqnd", loss + "-01-01");
                    } else {
                        map.put("ksdqnd", "-1");
                    }
                    map.put("bnmbks", nextValue);
                    ArrayList<HashMap<String, Object>> objects = new ArrayList<HashMap<String, Object>>();
                    objects.add(map);
                    eachYearInfoMap.put(nextKey, objects);
                }
            }
            for (Map.Entry next : eachYearInfoMap.entrySet()) {
                List value = (List)next.getValue();
                if (!ObjectUtils.isNotEmpty((Object)value)) continue;
                bookList.addAll(value);
            }
        }
        return bookList;
    }

    public static List<Map<String, Object>> initFirstPeriod(Long orgId, Date yearfrom, Date endDate, Integer cropyear, Integer lapseyear) {
        Set cropyears;
        logger.info("ItpTaxLossDraftBussiness initFirstPeriod : {}", (Object)endDate);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(12);
        List<Map<String, Object>> bookList = ItpTaxLossDraftBussiness.queryDataFromQysdsStandBook(orgId, yearfrom, cropyear, lapseyear);
        logger.info("ItpTaxLossDraftBussiness initFirstPeriod queryDataFromQysdsStandBook : {}", (Object)JsonUtil.toJson(bookList));
        ItpTaxLossDraftBussiness.addInPeriod(bookList, cropyear, lapseyear);
        HashMap bookListMap = new HashMap(12);
        HashMap integerListMap = new HashMap(12);
        for (Map<String, Object> bookMap : bookList) {
            Integer cy = ObjectUtils.isNotEmpty((Object)bookMap.get("happenyear")) ? DateUtils.getYearOfDate((Date)DateUtils.stringToDate2((String)bookMap.get("happenyear").toString())) : -1;
            Integer ly = ObjectUtils.isNotEmpty((Object)bookMap.get("ksdqnd")) && !"-1".equalsIgnoreCase(bookMap.get("ksdqnd").toString()) ? DateUtils.getYearOfDate((Date)DateUtils.stringToDate2((String)bookMap.get("ksdqnd").toString())) : -1;
            if (!bookListMap.containsKey(cy)) {
                bookListMap.put(cy, new ArrayList(2));
            }
            ((List)bookListMap.get(cy)).add(bookMap);
            if (!integerListMap.containsKey(ly)) {
                integerListMap.put(ly, new HashSet(2));
            }
            ((Set)integerListMap.get(ly)).add(cy);
        }
        ArrayList cropyearList = new ArrayList(bookListMap.keySet());
        ArrayList lapseyearList = new ArrayList(integerListMap.keySet());
        Collections.sort(cropyearList);
        Collections.sort(lapseyearList);
        boolean contains = lapseyearList.contains(-1);
        int i = 0;
        if (contains) {
            ++i;
        }
        while (i < lapseyearList.size()) {
            Integer lapyear = (Integer)lapseyearList.get(i);
            Set cropyears2 = (Set)integerListMap.get(lapyear);
            if (ObjectUtils.isNotEmpty((Object)cropyears2)) {
                ArrayList cropyearsList = new ArrayList(cropyears2);
                Collections.sort(cropyearsList);
                for (Integer cy : cropyearsList) {
                    List mapList = (List)bookListMap.get(cy);
                    ItpTaxLossDraftBussiness.packageData(mapList, lapyear, resultList);
                }
            }
            ++i;
        }
        if (contains && ObjectUtils.isNotEmpty((Object)(cropyears = (Set)integerListMap.get(-1)))) {
            ArrayList cropyearsList = new ArrayList(cropyears);
            Collections.sort(cropyearsList);
            for (Integer cy : cropyearsList) {
                List mapList = (List)bookListMap.get(cy);
                ItpTaxLossDraftBussiness.packageData(mapList, -1, resultList);
            }
        }
        logger.info("ItpTaxLossDraftBussiness initFirstPeriod resultList : {}", (Object)JsonUtil.toJson(resultList));
        return resultList;
    }

    public static List<Map<String, Object>> initNoFirstPeriod(Long orgId, Long templateId, Long taxSystemId, Date startDate, Date endDate, Integer cropyear, Integer lapseyear) {
        logger.info("ItpTaxLossDraftBussiness initNoFirstPeriod startDate : {}", (Object)startDate);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(12);
        int monthDiff = DateUtils.getMonthDiff((Date)startDate, (Date)endDate);
        HashMap<String, List<Map<String, Object>>> historyDeclare = ItpMultiDataQueryBussiness.queryHistoryDeclare(orgId, templateId, taxSystemId, DateUtils.addMonth((Date)startDate, (int)(-monthDiff)), DateUtils.getLastDateOfMonth2((Date)DateUtils.addMonth((Date)endDate, (int)(-monthDiff))));
        if (ObjectUtils.isNotEmpty(historyDeclare)) {
            int size;
            Set<Map.Entry<String, List<Map<String, Object>>>> entries = historyDeclare.entrySet();
            boolean isContainsBq = false;
            String jzkdkskye = "0.00";
            HashMap<String, Object> currentperiodMap = new HashMap<String, Object>(4);
            for (Map.Entry<String, List<Map<String, Object>>> entry : entries) {
                List<Map<String, Object>> taxlossList;
                int index;
                int taxlossSize;
                String entryKey = entry.getKey();
                if (!"tax_loss_jzgl_xm#1".startsWith(entryKey)) continue;
                for (int i = index = (taxlossSize = (taxlossList = entry.getValue()).size()) > 19 ? taxlossSize - 19 : 0; i < taxlossSize; ++i) {
                    String loss_cropyear;
                    Map<String, Object> objectMap = taxlossList.get(i);
                    String string = loss_cropyear = ObjectUtils.isNotEmpty((Object)objectMap.get("tax_loss_jzgl_xm#tax_loss_cropyear")) ? objectMap.get("tax_loss_jzgl_xm#tax_loss_cropyear").toString() : "0";
                    if (cropyear == Integer.parseInt(loss_cropyear) && index > 0) {
                        --index;
                    }
                    if (cropyear == Integer.parseInt(loss_cropyear)) {
                        currentperiodMap.putAll(objectMap);
                    }
                    if (cropyear != Integer.parseInt(loss_cropyear) + 1) continue;
                    jzkdkskye = ObjectUtils.isNotEmpty((Object)objectMap.get("tax_loss_jzgl_xm#tax_loss_qmye_jzkdkskye")) ? objectMap.get("tax_loss_jzgl_xm#tax_loss_qmye_jzkdkskye").toString() : "0.00";
                }
                while (index < taxlossSize) {
                    Map<String, Object> objectMap = taxlossList.get(index);
                    if (!ObjectUtils.isEmpty((Object)objectMap.get("tax_loss_jzgl_xm#tax_loss_cropyear"))) {
                        String loss_cropyear = ObjectUtils.isNotEmpty((Object)objectMap.get("tax_loss_jzgl_xm#tax_loss_cropyear")) ? objectMap.get("tax_loss_jzgl_xm#tax_loss_cropyear").toString() : "0";
                        String loss_lapseyear = "0";
                        if (objectMap.containsKey("tax_loss_jzgl_xm#tax_loss_lapseyear")) {
                            loss_lapseyear = " ".equalsIgnoreCase(objectMap.get("tax_loss_jzgl_xm#tax_loss_lapseyear").toString()) || "".equalsIgnoreCase(objectMap.get("tax_loss_jzgl_xm#tax_loss_lapseyear").toString()) ? "-1" : objectMap.get("tax_loss_jzgl_xm#tax_loss_lapseyear").toString();
                        }
                        if (cropyear != Integer.parseInt(loss_cropyear)) {
                            HashMap<String, Object> map;
                            if (!(lapseyear == -1 || lapseyear >= Integer.parseInt(loss_lapseyear) && -1 != Integer.parseInt(loss_lapseyear) || isContainsBq)) {
                                map = new HashMap<String, Object>(12);
                                map.put("tax_loss_jzgl_xm#tax_loss_cropyear", cropyear);
                                map.put("tax_loss_jzgl_xm#tax_loss_lapseyear", lapseyear);
                                map.put("tax_loss_jzgl_xm#tax_loss_qcye_kmbskqc", jzkdkskye);
                                map.put("tax_loss_jzgl_xm#tax_loss_qcye_bqbdtz", currentperiodMap.containsKey("tax_loss_jzgl_xm#tax_loss_qcye_bqbdtz") ? currentperiodMap.get("tax_loss_jzgl_xm#tax_loss_qcye_bqbdtz") : "0.00");
                                map.put("tax_loss_jzgl_xm#tax_loss_qcye_skqctz", currentperiodMap.containsKey("tax_loss_jzgl_xm#tax_loss_qcye_skqctz") ? currentperiodMap.get("tax_loss_jzgl_xm#tax_loss_qcye_skqctz") : "0.00");
                                resultList.add(map);
                                isContainsBq = true;
                            }
                            if (lapseyear == Integer.parseInt(loss_lapseyear) && cropyear < Integer.parseInt(loss_cropyear) && !isContainsBq) {
                                map = new HashMap(12);
                                String slapseyear = lapseyear == -1 ? " " : lapseyear.toString();
                                map.put("tax_loss_jzgl_xm#tax_loss_cropyear", cropyear);
                                map.put("tax_loss_jzgl_xm#tax_loss_lapseyear", slapseyear);
                                map.put("tax_loss_jzgl_xm#tax_loss_qcye_kmbskqc", jzkdkskye);
                                map.put("tax_loss_jzgl_xm#tax_loss_qcye_bqbdtz", currentperiodMap.containsKey("tax_loss_jzgl_xm#tax_loss_qcye_bqbdtz") ? currentperiodMap.get("tax_loss_jzgl_xm#tax_loss_qcye_bqbdtz") : "0.00");
                                map.put("tax_loss_jzgl_xm#tax_loss_qcye_skqctz", currentperiodMap.containsKey("tax_loss_jzgl_xm#tax_loss_qcye_skqctz") ? currentperiodMap.get("tax_loss_jzgl_xm#tax_loss_qcye_skqctz") : "0.00");
                                resultList.add(map);
                                isContainsBq = true;
                            }
                            resultList.add(objectMap);
                        }
                    }
                    ++index;
                }
                break block0;
            }
            if (!isContainsBq) {
                HashMap<String, Object> map = new HashMap<String, Object>(12);
                String slapseyear = lapseyear == -1 ? " " : lapseyear.toString();
                map.put("tax_loss_jzgl_xm#tax_loss_cropyear", cropyear);
                map.put("tax_loss_jzgl_xm#tax_loss_lapseyear", slapseyear);
                map.put("tax_loss_jzgl_xm#tax_loss_qcye_bqbdtz", currentperiodMap.containsKey("tax_loss_jzgl_xm#tax_loss_qcye_bqbdtz") ? currentperiodMap.get("tax_loss_jzgl_xm#tax_loss_qcye_bqbdtz") : "0.00");
                map.put("tax_loss_jzgl_xm#tax_loss_qcye_skqctz", currentperiodMap.containsKey("tax_loss_jzgl_xm#tax_loss_qcye_skqctz") ? currentperiodMap.get("tax_loss_jzgl_xm#tax_loss_qcye_skqctz") : "0.00");
                resultList.add(map);
            }
            if ((size = resultList.size()) > 1) {
                ((Map)resultList.get(size - 1)).put("tax_loss_jzgl_xm#tax_loss_qcye_kmbskqc", ((Map)resultList.get(size - 2)).get("tax_loss_jzgl_xm#tax_loss_qmye_jzkdkskye"));
            }
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(12);
            String slapseyear = lapseyear == -1 ? " " : lapseyear.toString();
            map.put("tax_loss_jzgl_xm#tax_loss_cropyear", cropyear);
            map.put("tax_loss_jzgl_xm#tax_loss_lapseyear", slapseyear);
            resultList.add(map);
        }
        logger.info("ItpTaxLossDraftBussiness initNoFirstPeriod  resultList: {}", (Object)JsonUtil.toJson(resultList));
        return resultList;
    }

    public static Integer calculate(Long orgId, Long taxSystemId, Date endDate) {
        if (ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)taxSystemId) || ObjectUtils.isEmpty((Object)endDate)) {
            return null;
        }
        DynamicObject dynamicObject = ItpTaxLossConfigBussiness.queryTaxLossConfigByValid(orgId, taxSystemId, endDate);
        if (ObjectUtils.isNotEmpty((Object)dynamicObject)) {
            Object kssxnx = dynamicObject.get("kssxnx");
            logger.info("ItpTaxLossDraftBussiness calculate kssxnx : {}", kssxnx);
            if (ObjectUtils.isEmpty((Object)kssxnx)) {
                return -1;
            }
            return DateUtils.getYearOfDate((Date)endDate) + (Integer)kssxnx;
        }
        return null;
    }

    private static void addInPeriod(List<Map<String, Object>> bookList, int cropyear, Integer lapseyear) {
        logger.info("ItpTaxLossDraftBussiness addInPeriod");
        Iterator<Map<String, Object>> iterator = bookList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> bookMap = iterator.next();
            Integer happenyear = ObjectUtils.isNotEmpty((Object)bookMap.get("happenyear")) ? DateUtils.getYearOfDate((Date)DateUtils.stringToDate2((String)bookMap.get("happenyear").toString())) : -1;
            if (cropyear != happenyear) continue;
            iterator.remove();
        }
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("happenyear", cropyear + "-01-01");
        if (-1 != lapseyear) {
            map.put("ksdqnd", lapseyear + "-01-01");
        }
        bookList.add(map);
        logger.info("ItpTaxLossDraftBussiness addInPeriod bookList : {}", (Object)JsonUtil.toJson(bookList));
    }

    public static void packageData(List<Map<String, Object>> mapList, Integer lapyear, List<Map<String, Object>> resultList) {
        if (ObjectUtils.isNotEmpty(mapList)) {
            for (Map<String, Object> bookMap : mapList) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
                Integer cropyear = ObjectUtils.isNotEmpty((Object)bookMap.get("happenyear")) ? DateUtils.getYearOfDate((Date)DateUtils.stringToDate2((String)bookMap.get("happenyear").toString())) : -1;
                Integer lapseyear = ObjectUtils.isNotEmpty((Object)bookMap.get("ksdqnd")) && !"-1".equalsIgnoreCase(bookMap.get("ksdqnd").toString()) ? DateUtils.getYearOfDate((Date)DateUtils.stringToDate2((String)bookMap.get("ksdqnd").toString())) : -1;
                if (lapseyear.intValue() != lapyear.intValue()) continue;
                String lossmoney = ObjectUtils.isNotEmpty((Object)bookMap.get("lossmoney")) ? bookMap.get("lossmoney").toString() : "0.00";
                String ljymbks = ObjectUtils.isNotEmpty((Object)bookMap.get("ljymbks")) ? bookMap.get("ljymbks").toString() : "0.00";
                String bnmbks = ObjectUtils.isNotEmpty((Object)bookMap.get("bnmbks")) ? bookMap.get("bnmbks").toString() : "0.00";
                resultMap.put("tax_loss_jzgl_xm#tax_loss_cropyear", cropyear != -1 ? cropyear : " ");
                resultMap.put("tax_loss_jzgl_xm#tax_loss_lapseyear", lapseyear != -1 ? lapseyear : " ");
                resultMap.put("tax_loss_jzgl_xm#tax_loss_bqbd_dnmbks", new BigDecimal(bnmbks).abs().negate().toString());
                resultMap.put("tax_loss_jzgl_xm#tax_loss_bqbd_dncsks", new BigDecimal(lossmoney).abs().toString());
                resultMap.put("tax_loss_jzgl_xm#tax_loss_qmye_gnljymbksje", new BigDecimal(ljymbks).abs().toString());
                resultList.add(resultMap);
            }
        }
    }
}

