/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.papers.adjust.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.itp.business.papers.ItpMultiDataQueryBussiness;
import kd.taxc.itp.business.papers.ProvisionDeclarationComparisonBusiness;
import kd.taxc.itp.business.papers.adjust.ItpDraftAdjustService;
import kd.taxc.itp.business.papers.adjust.impl.ItpDraftDynrownoAdjustServiceImpl;
import kd.taxc.itp.business.papers.adjust.impl.ItpDraftKmbksAdjustServiceImpl;
import kd.taxc.itp.business.papers.adjust.impl.ItpDraftTaxLossAdjustServiceImpl;
import kd.taxc.itp.business.papers.adjust.impl.ItpSecondDraftFixAdjustServiceImpl;
import kd.taxc.itp.business.papers.adjust.vo.QueryBussinessVo;
import org.apache.commons.lang3.ObjectUtils;

public class ItpDraftAdjustBussiness {
    private static Log logger = LogFactory.getLog(ItpDraftAdjustBussiness.class);

    public void adjust(Map<String, String> result, QueryBussinessVo vo, String operationType) {
        if ("adjustncs".equals(operationType)) {
            this.doAdjust(result, vo, operationType);
        }
        if ("canceladjust".equalsIgnoreCase(operationType)) {
            this.cancelAdjust(result, vo, operationType);
        }
    }

    public void doAdjust(Map<String, String> result, QueryBussinessVo vo, String operationType) {
        ItpDraftAdjustEnum[] values;
        DynamicObject dynamicObject = this.queryCompareMainDraft(vo, operationType);
        if (ObjectUtils.isNotEmpty((Object)dynamicObject) && ObjectUtils.isNotEmpty((Object)(values = ItpDraftAdjustEnum.values()))) {
            for (ItpDraftAdjustEnum value : values) {
                if (!value.adjustService.checkIsNeedAdjust(vo, dynamicObject)) continue;
                value.adjustService.doAdjust(result, vo, dynamicObject);
            }
        }
    }

    public void cancelAdjust(Map<String, String> result, QueryBussinessVo vo, String operationType) {
        ItpDraftAdjustEnum[] values;
        DynamicObject dynamicObject = this.queryCompareMainDraft(vo, operationType);
        if (ObjectUtils.isNotEmpty((Object)dynamicObject) && ObjectUtils.isNotEmpty((Object)(values = ItpDraftAdjustEnum.values()))) {
            for (ItpDraftAdjustEnum value : values) {
                if (!value.adjustService.checkIsNeedCancelAdjust(vo, dynamicObject)) continue;
                value.adjustService.cancelAdjust(result, vo, dynamicObject);
            }
        }
    }

    public DynamicObject queryCompareMainDraft(QueryBussinessVo vo, String operationType) {
        String adjustStatus = "adjustncs".equals(operationType) ? "no" : "yes";
        Long draftId = ItpMultiDataQueryBussiness.queryDraftId(vo.getTemplatetype(), vo.getOrgId(), vo.getSkssqq(), vo.getSkssqz(), new QFilter("taxsystem", "=", (Object)vo.getTaxsystem()));
        Map.Entry<Integer, DynamicObject> entry = this.getAuditedDeclareThanDraft(vo, draftId, adjustStatus, "C");
        vo.setSize(entry.getKey());
        return entry.getValue();
    }

    private Map.Entry<Integer, DynamicObject> getAuditedDeclareThanDraft(QueryBussinessVo vo, Long draftId, String adjustStatus, String status) {
        logger.info("ItpDraftAdjustBussiness getAuditedDeclareThanDraft draftId :{}", (Object)draftId);
        logger.info("ItpDraftAdjustBussiness getAuditedDeclareThanDraft adjustStatus :{}", (Object)adjustStatus);
        HashMap<Integer, DynamicObject> map = new HashMap<Integer, DynamicObject>();
        Date yearDate = DateUtils.addYear((Date)vo.getSkssqz(), (int)-1);
        String template = "sdsjt_bd".equals(vo.getTemplatetype()) ? "jtysbbd_bd" : "jtysbbd_jt";
        DynamicObject[] dataCollection = ProvisionDeclarationComparisonBusiness.getData(vo.getTaxsystem(), vo.getOrgId(), vo.getAccounttype(), yearDate, template, status, adjustStatus.equals("yes") ? "yes" : "");
        if ("yes".equals(adjustStatus)) {
            Optional<DynamicObject> dataOptional;
            if (ObjectUtils.isNotEmpty((Object)dataCollection) && ObjectUtils.isNotEmpty((Object)dataCollection[0].getDynamicObjectCollection("entryentity"))) {
                long draftid = ((DynamicObject)dataCollection[0].getDynamicObjectCollection("entryentity").get(0)).getLong("draftid");
                logger.info("ItpDraftAdjustBussiness getAuditedDeclareThanDraft adjust draftid :{}", (Object)draftid);
            }
            if ((dataOptional = Arrays.stream(dataCollection).filter(p -> ((DynamicObject)p.getDynamicObjectCollection("entryentity").get(0)).getLong("draftid") == draftId.longValue()).findFirst()).isPresent()) {
                map.put(dataCollection.length, dataOptional.get());
            } else {
                map.put(0, null);
            }
            return (Map.Entry)map.entrySet().stream().findFirst().get();
        }
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(dataCollection.length);
        for (DynamicObject dynamicObject : dataCollection) {
            DynamicObjectCollection entryEntities = dynamicObject.getDynamicObjectCollection("entryentity");
            if (!entryEntities.isEmpty() && !"no".equals(((DynamicObject)entryEntities.get(0)).getString("isadjuest"))) continue;
            dataList.add(dynamicObject);
        }
        if (dataCollection.length > 1 && dataList.size() == 1 && "sdbd".equals(((DynamicObject)dataList.get(0)).getString("comparisontype"))) {
            map.put(1, null);
            return (Map.Entry)map.entrySet().stream().findFirst().get();
        }
        DynamicObject data = null;
        if (dataList.size() == 1) {
            data = (DynamicObject)dataList.get(0);
        } else if (dataList.size() > 1) {
            data = dataList.stream().filter(o -> "hjbd".equals(o.getString("comparisontype"))).findFirst().get();
        }
        map.put(dataList.size(), data);
        return (Map.Entry)map.entrySet().stream().findFirst().get();
    }

    static enum ItpDraftAdjustEnum {
        ADJUST_TAX_LOSS(new ItpDraftTaxLossAdjustServiceImpl()),
        ADJUST_ZCYCGL_KMBKS(new ItpDraftKmbksAdjustServiceImpl()),
        ADJUST_SECOND_DRAFT(new ItpSecondDraftFixAdjustServiceImpl()),
        ADJUST_ZCYCGL_DYNROWNO(new ItpDraftDynrownoAdjustServiceImpl());

        private ItpDraftAdjustService adjustService;

        private ItpDraftAdjustEnum(ItpDraftAdjustService adjustService) {
            this.adjustService = adjustService;
        }
    }
}

