/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.papers.adjust.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.itp.business.papers.adjust.impl.AbstractItpDraftAdjustService;
import kd.taxc.itp.business.papers.adjust.vo.QueryBussinessVo;

public class ItpDraftDynrownoAdjustServiceImpl
extends AbstractItpDraftAdjustService {
    @Override
    public void doAdjust(Map<String, String> result, QueryBussinessVo vo, DynamicObject dynamicObject) {
        List<Map<String, String>> rowList = this.getDynRowList("zcycgl_gaap_zsxcy_cyxm", vo);
        List<Map<String, String>> rowListzs = this.getDynRowList("zcycgl_zsxcy_cyxm", vo);
        if (!ObjectUtils.isEmpty(rowList)) {
            rowList.addAll(rowListzs);
        } else {
            rowList = rowListzs;
        }
        if (ObjectUtils.isEmpty(rowList)) {
            return;
        }
        String bbxmColumn = "#zcycgl_bbxm";
        HashMap<String, String> bbxmkeyAndIdMap = new HashMap<String, String>(12);
        HashMap bbxmkeyAndNcstzValueMap = new HashMap(12);
        rowList.stream().forEach(row -> {
            Set keys = row.keySet();
            keys.stream().forEach(o -> {
                String temp;
                if (o.endsWith(bbxmColumn)) {
                    temp = o.substring(0, o.length() - bbxmColumn.length());
                    bbxmkeyAndIdMap.put((String)row.get(o), temp + "#zcycgl_ncye_tz");
                }
                if (o.endsWith("#zcycgl_ncye_tz")) {
                    temp = o.substring(0, o.length() - "#zcycgl_ncye_tz".length());
                    bbxmkeyAndNcstzValueMap.put(row.get(temp + bbxmColumn), row.get(o));
                }
            });
        });
        DataSet rows = this.queryThanRtaTableRowDataList(bbxmkeyAndIdMap, "adjustncs", dynamicObject, vo);
        while (rows.hasNext()) {
            Row next = rows.next();
            String nextValue = next.getString("value");
            if (!bbxmkeyAndIdMap.containsKey(next.getString("bbId")) || !this.checkStringCovertDecimal(nextValue) || new BigDecimal(nextValue).doubleValue() == 0.0) continue;
            String bbcellnumber = next.getString("bbcellnumber");
            String value = "";
            if (bbcellnumber.startsWith("dqsds_zsxcy_cyxm") && !((String)bbxmkeyAndIdMap.get(next.getString("bbId"))).contains("_zsxcy_cyxm")) continue;
            value = next.getString("value");
            result.put((String)bbxmkeyAndIdMap.get(next.getString("bbId")), value);
        }
        rows.close();
    }

    @Override
    public void cancelAdjust(Map<String, String> result, QueryBussinessVo vo, DynamicObject dynamicObject) {
        List<Map<String, String>> rowList = this.getDynRowList("zcycgl_gaap_zsxcy_cyxm", vo);
        List<Map<String, String>> rowListzs = this.getDynRowList("zcycgl_zsxcy_cyxm", vo);
        if (!ObjectUtils.isEmpty(rowList)) {
            rowList.addAll(rowListzs);
        } else {
            rowList = rowListzs;
        }
        if (ObjectUtils.isEmpty(rowList)) {
            return;
        }
        String bbxmColumn = "#zcycgl_bbxm";
        HashMap<String, String> bbxmkeyAndIdMap = new HashMap<String, String>(12);
        HashMap bbxmkeyAndNcstzValueMap = new HashMap(12);
        rowList.stream().forEach(row -> {
            Set keys = row.keySet();
            keys.stream().forEach(o -> {
                String temp;
                if (o.endsWith(bbxmColumn)) {
                    temp = o.substring(0, o.length() - bbxmColumn.length());
                    bbxmkeyAndIdMap.put((String)row.get(o), temp + "#zcycgl_ncye_tz");
                }
                if (o.endsWith("#zcycgl_ncye_tz")) {
                    temp = o.substring(0, o.length() - "#zcycgl_ncye_tz".length());
                    bbxmkeyAndNcstzValueMap.put(row.get(temp + bbxmColumn), row.get(o));
                }
            });
        });
        DataSet rows = this.queryThanRtaTableRowDataList(bbxmkeyAndIdMap, "canceladjust", dynamicObject, vo);
        while (rows.hasNext()) {
            Row next = rows.next();
            String nextValue = next.getString("value");
            if (!bbxmkeyAndIdMap.containsKey(next.getString("bbId")) || !this.checkStringCovertDecimal(nextValue) || new BigDecimal(nextValue).doubleValue() == 0.0) continue;
            String bbcellnumber = next.getString("bbcellnumber");
            String value = "";
            if (bbcellnumber.startsWith("dqsds_zsxcy_cyxm") && !((String)bbxmkeyAndIdMap.get(next.getString("bbId"))).contains("_zsxcy_cyxm")) continue;
            BigDecimal bbxmValue = new BigDecimal((String)bbxmkeyAndNcstzValueMap.get(next.getString("bbId")));
            BigDecimal bdbValue = new BigDecimal(next.getString("value"));
            value = bbxmValue.subtract(bdbValue).setScale(2, 4).toString();
            result.put((String)bbxmkeyAndIdMap.get(next.getString("bbId")), value);
        }
        rows.close();
    }

    private DataSet queryThanRtaTableRowDataList(Map<String, String> bbxmkeyAndIdMap, String operationType, DynamicObject data, QueryBussinessVo vo) {
        String columnDimension = "%#jtysbbd_rtacyxj";
        if (operationType.equals("canceladjust")) {
            if ("sdbd".equals(data.getString("comparisontype"))) {
                columnDimension = "%#jtysbbd_sjtz";
            } else if ("hjbd".equals(data.getString("comparisontype")) && vo.getSize() == 2) {
                columnDimension = "%#jtysbbd_hjtz";
            }
        }
        QFilter q1 = new QFilter("cellnumber", "like", (Object)"%#dqsds_bbxm");
        QFilter q2 = new QFilter("cellnumber", "like", (Object)columnDimension);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DeclareDetailTable", (String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"cellnumber,dynrowno,value,index", (QFilter[])new QFilter[]{new QFilter("dynrowno", "like", (Object)"dqsds_%").and("entryid", "=", (Object)data.getLong("id")).and(q1.or(q2))}, null);
        QFilter q3 = new QFilter("value", "in", bbxmkeyAndIdMap.keySet());
        QFilter q4 = new QFilter("cellnumber", "like", (Object)"%#dqsds_bbxm");
        DataSet dataSetBbxm = dataSet.copy().filter(q3.and(q4).toString());
        DataSet dataSetRta = dataSet.copy().filter(q2.toString());
        JoinDataSet join = dataSetBbxm.join(dataSetRta, JoinType.INNER);
        DataSet rows = join.on("dynrowno", "dynrowno").on("index", "index").select(new String[]{"dynrowno", "cellnumber bbcellnumber", "value bbId"}, new String[]{"cellnumber", "value"}).finish();
        dataSet.close();
        dataSetBbxm.close();
        dataSetRta.close();
        return rows;
    }

    private List<Map<String, String>> getDynRowList(String precellkey, QueryBussinessVo vo) {
        IPageCache childPagecache = vo.getChildrenPagecache();
        Map showAllMap = (Map)TreeUtils.getCache((IPageCache)childPagecache, (String)"showData", Map.class);
        ArrayList<Map<String, String>> rowList = new ArrayList<Map<String, String>>(2);
        if (ObjectUtils.isEmpty((Object)showAllMap)) {
            return rowList;
        }
        Stream<Map.Entry> entryStreambbxm = showAllMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(precellkey) && ((String)entry.getKey()).endsWith("#zcycgl_bbxm"));
        Set entrys = showAllMap.entrySet();
        Iterator iterator = entrys.iterator();
        HashMap entrytz = new HashMap(12);
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            String entrykey = (String)next.getKey();
            if (!entrykey.startsWith(precellkey) || !entrykey.endsWith("#zcycgl_ncye_tz")) continue;
            entrytz.put(entrykey, next.getValue());
        }
        entryStreambbxm.forEach(entry -> {
            HashMap map = new HashMap(2);
            String entryKey = (String)entry.getKey();
            map.put(entryKey, entry.getValue());
            Set entries = entrytz.entrySet();
            for (Map.Entry tz : entries) {
                String tzkey = (String)tz.getKey();
                if (!entryKey.substring(0, entryKey.length() - "#zcycgl_bbxm".length()).equals(tzkey.substring(0, tzkey.length() - "#zcycgl_ncye_tz".length()))) continue;
                String value = tz.getValue() == null || "".equals(tz.getValue()) ? "0.00" : (String)tz.getValue();
                map.put(tzkey, value);
                break;
            }
            rowList.add(map);
        });
        return rowList;
    }

    private boolean checkStringCovertDecimal(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        try {
            new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u9519\u8bef\u3002", (String)"ItpDraftDynrownoAdjustServiceImpl_0", (String)"taxc-itp", (Object[])new Object[0]));
        }
        return true;
    }
}

