/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.papers.adjust.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.itp.business.papers.ItpMultiDataQueryBussiness;
import kd.taxc.itp.business.papers.adjust.impl.AbstractItpDraftAdjustService;
import kd.taxc.itp.business.papers.adjust.vo.QueryBussinessVo;

public class ItpDraftKmbksAdjustServiceImpl
extends AbstractItpDraftAdjustService {
    private static Map<String, String> fixRowBizTypeMap = new HashMap<String, String>(2);

    @Override
    public void doAdjust(Map<String, String> result, QueryBussinessVo vo, DynamicObject dynamicObject) {
        BigDecimal rtaTz = this.adjustBqRtaTz(dynamicObject);
        result.put("zcycgl_kmbss#zcycgl_ncye_tz", rtaTz.toString());
    }

    @Override
    public void cancelAdjust(Map<String, String> result, QueryBussinessVo vo, DynamicObject dynamicObject) {
        IPageCache childrenPagecache = vo.getChildrenPagecache();
        BigDecimal rtaTz = this.adjustBqRtaTz(dynamicObject);
        List<Map<String, String>> fixrowno = this.getFixrowno(childrenPagecache);
        HashMap<String, String> fixRowRtaResultMap = new HashMap<String, String>(2);
        fixRowRtaResultMap.put("dqsds_bnmbks#jtysbbd_rtacyxj", org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)rtaTz) ? rtaTz.toString() : "0");
        fixrowno.stream().forEach(fixrow -> {
            String bbxmcellkey = (String)fixrow.get("bbxmcellkey");
            String value = (String)fixRowRtaResultMap.get(fixRowBizTypeMap.get(bbxmcellkey));
            if (StringUtils.isNotBlank((CharSequence)value)) {
                this.hjbdCancelAdjustKmbksHandle(result, vo.getChildrenPagecache(), fixRowRtaResultMap, bbxmcellkey);
            }
        });
    }

    @Override
    public boolean checkIsNeedAdjust(QueryBussinessVo vo, DynamicObject dynamicObject) {
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)dynamicObject)) {
            return false;
        }
        return !"sdbd".equalsIgnoreCase(dynamicObject.getString("comparisontype"));
    }

    @Override
    public boolean checkIsNeedCancelAdjust(QueryBussinessVo vo, DynamicObject dynamicObject) {
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)dynamicObject)) {
            return false;
        }
        return !"sdbd".equalsIgnoreCase(dynamicObject.getString("comparisontype"));
    }

    private void hjbdCancelAdjustKmbksHandle(Map<String, String> result, IPageCache childPagecache, Map<String, String> fixRowRtaResultMap, String bbxmcellkey) {
        Map showAllMap = (Map)TreeUtils.getCache((IPageCache)childPagecache, (String)"showData", Map.class);
        String curValue = (String)showAllMap.get(bbxmcellkey);
        String rtavalue = fixRowRtaResultMap.get("dqsds_bnmbks#jtysbbd_rtacyxj");
        BigDecimal resultValue = new BigDecimal(curValue).subtract(new BigDecimal(rtavalue));
        result.put(bbxmcellkey, resultValue.setScale(2, 4).toString());
    }

    private List<Map<String, String>> getFixrowno(IPageCache childPagecache) {
        Map showAllMap = (Map)TreeUtils.getCache((IPageCache)childPagecache, (String)"showData", Map.class);
        ArrayList<Map<String, String>> rowList = new ArrayList<Map<String, String>>(2);
        Set<Map.Entry<String, String>> entries = fixRowBizTypeMap.entrySet();
        entries.stream().forEach(entry -> {
            HashMap fixrowRtaMap = new HashMap(2);
            String value = ObjectUtils.isEmpty((Object)showAllMap) || StringUtils.isEmpty((CharSequence)((CharSequence)showAllMap.get(entry.getKey()))) ? "0.00" : (String)showAllMap.get(entry.getKey());
            fixrowRtaMap.put(entry.getKey(), value);
            fixrowRtaMap.put("bbxmcellkey", entry.getKey());
            rowList.add(fixrowRtaMap);
        });
        return rowList;
    }

    private BigDecimal adjustBqRtaTz(DynamicObject dynamicObject) {
        DynamicObjectCollection dynamicObjectCollection = ItpMultiDataQueryBussiness.queryCellvaluesByIdAndCellkeyList(dynamicObject.getLong("id"), Arrays.asList("dqsds_bnmbks#jtysbbd_rtacyxj", "dqsds_ynsds#jtysbbd_rtacyxj", "dqsds_ynsds#jtysbbd_jts", "dqsds_ynsds#jtysbbd_hjs", "dqsds_bnmbks#jtysbbd_jts", "dqsds_bnmbks#jtysbbd_hjs"));
        HashMap<String, String> rtaInfoMap = new HashMap<String, String>(2);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)dynamicObjectCollection)) {
            for (DynamicObject obj : dynamicObjectCollection) {
                rtaInfoMap.put(obj.getString("cellnumber"), obj.getString("value"));
            }
        }
        return this.calculBqRtaTz(rtaInfoMap);
    }

    private BigDecimal calculBqRtaTz(Map<String, String> rtaInfoMap) {
        String ynjtysbbd_jts = "dqsds_ynsds#jtysbbd_jts";
        String ynjtysbbd_hjs = "dqsds_ynsds#jtysbbd_hjs";
        String ynjtysbbd_rtacyxj = "dqsds_ynsds#jtysbbd_rtacyxj";
        String mbjtysbbd_rtacyxj = "dqsds_bnmbks#jtysbbd_rtacyxj";
        String mbjtysbbd_jts = "dqsds_bnmbks#jtysbbd_jts";
        String mbjtysbbd_hjs = "dqsds_bnmbks#jtysbbd_hjs";
        BigDecimal ynjts = rtaInfoMap.get(ynjtysbbd_jts) != null ? new BigDecimal(rtaInfoMap.get(ynjtysbbd_jts)) : BigDecimal.ZERO;
        BigDecimal ynhjs = rtaInfoMap.get(ynjtysbbd_hjs) != null ? new BigDecimal(rtaInfoMap.get(ynjtysbbd_hjs)) : BigDecimal.ZERO;
        BigDecimal ynrtacyxj = rtaInfoMap.get(ynjtysbbd_rtacyxj) != null ? new BigDecimal(rtaInfoMap.get(ynjtysbbd_rtacyxj)) : BigDecimal.ZERO;
        BigDecimal mbrtacyxj = rtaInfoMap.get(mbjtysbbd_rtacyxj) != null ? new BigDecimal(rtaInfoMap.get(mbjtysbbd_rtacyxj)) : BigDecimal.ZERO;
        BigDecimal mbjtysbbdjts = rtaInfoMap.get(mbjtysbbd_jts) != null ? new BigDecimal(rtaInfoMap.get(mbjtysbbd_jts)) : BigDecimal.ZERO;
        BigDecimal mbjtysbbdhjs = rtaInfoMap.get(mbjtysbbd_hjs) != null ? new BigDecimal(rtaInfoMap.get(mbjtysbbd_hjs)) : BigDecimal.ZERO;
        BigDecimal sumkmb = BigDecimal.ZERO;
        if (ynjts.compareTo(BigDecimal.ZERO) <= 0 && ynhjs.compareTo(BigDecimal.ZERO) <= 0) {
            return ynrtacyxj.negate();
        }
        if (ynjts.compareTo(BigDecimal.ZERO) >= 0 && ynhjs.compareTo(BigDecimal.ZERO) >= 0) {
            return mbrtacyxj.negate();
        }
        if (ynjts.compareTo(BigDecimal.ZERO) < 0 && ynhjs.compareTo(BigDecimal.ZERO) >= 0) {
            return ynjts.subtract(mbjtysbbdhjs);
        }
        if (ynjts.compareTo(BigDecimal.ZERO) >= 0 && ynhjs.compareTo(BigDecimal.ZERO) < 0) {
            return mbjtysbbdjts.subtract(ynhjs);
        }
        return sumkmb;
    }

    static {
        fixRowBizTypeMap.put("zcycgl_kmbss#zcycgl_ncye_tz", "dqsds_bnmbks#jtysbbd_rtacyxj");
    }
}

