/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.papers.adjust.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.itp.business.papers.ItpMultiDataQueryBussiness;
import kd.taxc.itp.business.papers.ItpTaxLossDraftBussiness;
import kd.taxc.itp.business.papers.adjust.impl.AbstractItpDraftAdjustService;
import kd.taxc.itp.business.papers.adjust.vo.QueryBussinessVo;
import org.apache.commons.lang3.ObjectUtils;

public class ItpDraftTaxLossAdjustServiceImpl
extends AbstractItpDraftAdjustService {
    private static Log logger = LogFactory.getLog(ItpDraftTaxLossAdjustServiceImpl.class);

    @Override
    public void doAdjust(Map<String, String> result, QueryBussinessVo vo, DynamicObject dynamicObject) {
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            return;
        }
        List<Map<String, String>> dynRowList = this.getDynRowList(vo);
        if (ObjectUtils.isEmpty(dynRowList)) {
            return;
        }
        BigDecimal sumkmbks = this.adjustBqRtaTz(dynRowList, result, vo, dynamicObject);
        logger.info("tax loss dnmb rta : {}", (Object)sumkmbks);
        if (sumkmbks.longValue() < 0L) {
            this.adjustLjymbks(dynRowList, result, vo, sumkmbks);
        }
        result.put("tax_loss_hj#tax_loss_lapseyear", "1");
    }

    @Override
    public void cancelAdjust(Map<String, String> result, QueryBussinessVo vo, DynamicObject dynamicObject) {
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            return;
        }
        List<Map<String, String>> dynRowList = this.getDynRowList(vo);
        if (ObjectUtils.isEmpty(dynRowList)) {
            return;
        }
        logger.info("ItpDraftTaxLossAdjustServiceImpl cancelAdjust dynamicObject id : {}", (Object)dynamicObject.getLong("id"));
        this.doCancelAdjust(result, dynRowList, dynamicObject);
        logger.info("ItpDraftTaxLossAdjustServiceImpl cancelAdjust success");
        result.put("tax_loss_hj#tax_loss_lapseyear", "0");
    }

    @Override
    public boolean checkIsNeedAdjust(QueryBussinessVo vo, DynamicObject dynamicObject) {
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            return false;
        }
        return !"sdbd".equalsIgnoreCase(dynamicObject.getString("comparisontype"));
    }

    @Override
    public boolean checkIsNeedCancelAdjust(QueryBussinessVo vo, DynamicObject dynamicObject) {
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            return false;
        }
        return !"sdbd".equalsIgnoreCase(dynamicObject.getString("comparisontype"));
    }

    private void doCancelAdjust(Map<String, String> result, List<Map<String, String>> dynRowList, DynamicObject dynamicObject) {
        String prefix = "tax_loss_jzgl_xm#";
        String lossQcyeRtaHj = "#tax_loss_qcye_rtahj_tz";
        String lossQcyeSksxje = "#tax_loss_qcye_sksxje";
        String lossQmyeGnljymbksje = "#tax_loss_qmye_gnljymbksje";
        for (int i = 0; i < dynRowList.size(); ++i) {
            Map<String, String> row = dynRowList.get(i);
            result.put(prefix + (i + 1) + lossQcyeRtaHj, ObjectUtils.isNotEmpty((Object)row.get(prefix + (i + 1) + lossQcyeRtaHj)) ? row.get(prefix + (i + 1) + lossQcyeRtaHj) : "0.00");
            result.put(prefix + (i + 1) + lossQcyeSksxje, ObjectUtils.isNotEmpty((Object)row.get(prefix + (i + 1) + lossQcyeSksxje)) ? row.get(prefix + (i + 1) + lossQcyeSksxje) : "0.00");
            result.put(prefix + (i + 1) + lossQmyeGnljymbksje, ObjectUtils.isNotEmpty((Object)row.get(prefix + (i + 1) + lossQmyeGnljymbksje)) ? row.get(prefix + (i + 1) + lossQmyeGnljymbksje) : "0.00");
        }
    }

    private BigDecimal adjustBqRtaTz(List<Map<String, String>> dynRowList, Map<String, String> result, QueryBussinessVo vo, DynamicObject dynamicObject) {
        DynamicObjectCollection dynamicObjectCollection = ItpMultiDataQueryBussiness.queryCellvaluesByIdAndCellkeyList(dynamicObject.getLong("id"), Arrays.asList("dqsds_bnmbks#jtysbbd_rtacyxj", "dqsds_ynsds#jtysbbd_rtacyxj", "dqsds_ynsds#jtysbbd_jts", "dqsds_ynsds#jtysbbd_hjs", "dqsds_bnmbks#jtysbbd_jts"));
        HashMap<String, String> rtaInfoMap = new HashMap<String, String>(2);
        if (ObjectUtils.isNotEmpty((Object)dynamicObjectCollection)) {
            for (DynamicObject obj : dynamicObjectCollection) {
                rtaInfoMap.put(obj.getString("cellnumber"), obj.getString("value"));
            }
        }
        BigDecimal sumkmb = BigDecimal.ZERO;
        if (ObjectUtils.isNotEmpty(dynRowList)) {
            int yearOfDate = DateUtils.getYearOfDate((Date)vo.getSkssqz());
            for (Map<String, String> map : dynRowList) {
                String index = map.get("index");
                String tax_loss_cropyear = "tax_loss_jzgl_xm#" + index + "#tax_loss_cropyear";
                String bqbd_dnmbks = "tax_loss_jzgl_xm#" + index + "#tax_loss_bqbd_dnmbks";
                String cropyear = map.get(tax_loss_cropyear);
                if (yearOfDate - 1 != Integer.parseInt(cropyear)) continue;
                sumkmb = this.calculBqRtaTz(cropyear, rtaInfoMap, map);
                result.put("tax_loss_jzgl_xm#" + index + "#tax_loss_qcye_rtahj_tz", sumkmb.toString());
                sumkmb = sumkmb.add(map.containsKey(bqbd_dnmbks) ? new BigDecimal(map.get(bqbd_dnmbks)) : BigDecimal.ZERO);
                break;
            }
        }
        return sumkmb;
    }

    private BigDecimal calculBqRtaTz(String cropyear, Map<String, String> rtaInfoMap, Map<String, String> preRowDataMap) {
        String ynjtysbbd_jts = "dqsds_ynsds#jtysbbd_jts";
        String ynjtysbbd_hjs = "dqsds_ynsds#jtysbbd_hjs";
        String ynjtysbbd_rtacyxj = "dqsds_ynsds#jtysbbd_rtacyxj";
        String mbjtysbbd_rtacyxj = "dqsds_bnmbks#jtysbbd_rtacyxj";
        String mbjtysbbd_jts = "dqsds_bnmbks#jtysbbd_jts";
        BigDecimal ynjts = rtaInfoMap.get(ynjtysbbd_jts) != null ? new BigDecimal(rtaInfoMap.get(ynjtysbbd_jts)) : BigDecimal.ZERO;
        BigDecimal ynhjs = rtaInfoMap.get(ynjtysbbd_hjs) != null ? new BigDecimal(rtaInfoMap.get(ynjtysbbd_hjs)) : BigDecimal.ZERO;
        BigDecimal ynrtacyxj = rtaInfoMap.get(ynjtysbbd_rtacyxj) != null ? new BigDecimal(rtaInfoMap.get(ynjtysbbd_rtacyxj)) : BigDecimal.ZERO;
        BigDecimal mbrtacyxj = rtaInfoMap.get(mbjtysbbd_rtacyxj) != null ? new BigDecimal(rtaInfoMap.get(mbjtysbbd_rtacyxj)) : BigDecimal.ZERO;
        BigDecimal mbjtysbbdjts = rtaInfoMap.get(mbjtysbbd_jts) != null ? new BigDecimal(rtaInfoMap.get(mbjtysbbd_jts)) : BigDecimal.ZERO;
        BigDecimal sumkmb = BigDecimal.ZERO;
        if (ynjts.compareTo(BigDecimal.ZERO) <= 0 && ynhjs.compareTo(BigDecimal.ZERO) <= 0) {
            if (ynjts.compareTo(ynhjs) > 0) {
                sumkmb = ynrtacyxj.abs();
            } else if (ynjts.compareTo(ynhjs) < 0) {
                sumkmb = ynrtacyxj.negate();
            }
            return sumkmb;
        }
        if (ynjts.compareTo(BigDecimal.ZERO) >= 0 && ynhjs.compareTo(BigDecimal.ZERO) >= 0) {
            return mbrtacyxj.negate();
        }
        if (ynjts.compareTo(BigDecimal.ZERO) < 0 && ynhjs.compareTo(BigDecimal.ZERO) >= 0) {
            return ynjts.add(mbrtacyxj.negate());
        }
        if (ynjts.compareTo(BigDecimal.ZERO) >= 0 && ynhjs.compareTo(BigDecimal.ZERO) < 0) {
            return mbjtysbbdjts.negate().add(ynhjs).abs();
        }
        return sumkmb;
    }

    private void adjustLjymbks(List<Map<String, String>> dynRowList, Map<String, String> result, QueryBussinessVo vo, BigDecimal sumkmbks) {
        if (ObjectUtils.isNotEmpty(dynRowList)) {
            int yearOfDate = DateUtils.getYearOfDate((Date)vo.getSkssqz());
            for (Map<String, String> dynrow : dynRowList) {
                String index = dynrow.get("index");
                String loss_lapseyear = "tax_loss_jzgl_xm#" + index + "#tax_loss_lapseyear";
                String qmye_gnljymbksje = "tax_loss_jzgl_xm#" + index + "#tax_loss_qmye_gnljymbksje";
                String qcye_sksxje = "tax_loss_jzgl_xm#" + index + "#tax_loss_qcye_sksxje";
                String bqbd_dncsks = "tax_loss_jzgl_xm#" + index + "#tax_loss_bqbd_dncsks";
                if (yearOfDate == Integer.parseInt(dynrow.get("tax_loss_jzgl_xm#" + index + "#tax_loss_cropyear"))) continue;
                String lapseyear = dynrow.get(loss_lapseyear);
                if (" ".equalsIgnoreCase(lapseyear) || "".equalsIgnoreCase(lapseyear)) {
                    lapseyear = "-1";
                }
                BigDecimal gnljymbksje = new BigDecimal(ObjectUtils.isNotEmpty((Object)dynrow.get(qmye_gnljymbksje)) ? dynrow.get(qmye_gnljymbksje) : "0.00");
                BigDecimal qcyesksxje = new BigDecimal(ObjectUtils.isNotEmpty((Object)dynrow.get(qcye_sksxje)) ? dynrow.get(qcye_sksxje) : "0.00");
                BigDecimal dncsks = new BigDecimal(ObjectUtils.isNotEmpty((Object)dynrow.get(bqbd_dncsks)) ? dynrow.get(bqbd_dncsks) : "0.00");
                if (gnljymbksje.add(qcyesksxje.abs()).compareTo(dncsks) == 0 || dncsks.longValue() <= 0L) continue;
                if (Integer.parseInt(lapseyear) != -1 && Integer.parseInt(lapseyear) < yearOfDate - 1) {
                    result.put(qcye_sksxje, dncsks.subtract(gnljymbksje).negate().toString());
                    continue;
                }
                boolean flag = sumkmbks.abs().add(gnljymbksje).add(qcyesksxje.abs()).subtract(dncsks).compareTo(BigDecimal.ZERO) > 0;
                BigDecimal lemb = flag ? dncsks : sumkmbks.abs().add(gnljymbksje);
                result.put(qmye_gnljymbksje, lemb.toString());
                if (!flag && Integer.parseInt(lapseyear) != -1 && Integer.parseInt(lapseyear) == yearOfDate - 1) {
                    result.put(qcye_sksxje, dncsks.subtract(lemb).negate().toString());
                    break;
                }
                sumkmbks = sumkmbks.abs().subtract(lemb.subtract(gnljymbksje));
            }
        }
    }

    private List<Map<String, String>> getDynRowList(QueryBussinessVo vo) {
        Long templateId = "sdsjt_jt".equalsIgnoreCase(vo.getTemplatetype()) ? 1535360343574841344L : 1551997998211269632L;
        Map<String, List<Map<String, Object>>> dynRowList = ItpTaxLossDraftBussiness.buildDynRowList(vo.getOrgId(), vo.getTaxsystem(), vo.getSkssqq(), vo.getSkssqz(), templateId);
        ArrayList<Map<String, String>> rowList = new ArrayList<Map<String, String>>(2);
        if (ObjectUtils.isNotEmpty(dynRowList)) {
            List<Map<String, Object>> mapList = dynRowList.get("tax_loss_jzgl_xm#1");
            for (int i = 0; i < mapList.size(); ++i) {
                HashMap<String, String> mp = new HashMap<String, String>(12);
                mp.put("index", String.valueOf(i + 1));
                for (Map.Entry<String, Object> next : mapList.get(i).entrySet()) {
                    String mapkey = "tax_loss_jzgl_xm#" + (i + 1) + next.getKey().substring("tax_loss_jzgl_xm".length());
                    if (!ObjectUtils.isNotEmpty((Object)next.getValue())) continue;
                    mp.put(mapkey, next.getValue().toString());
                }
                rowList.add(mp);
            }
        }
        return rowList;
    }
}

