/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.papers.adjust.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.itp.business.papers.adjust.impl.AbstractItpDraftAdjustService;
import kd.taxc.itp.business.papers.adjust.vo.QueryBussinessVo;

public class ItpSecondDraftFixAdjustServiceImpl
extends AbstractItpDraftAdjustService {
    private static Log logger = LogFactory.getLog(ItpSecondDraftFixAdjustServiceImpl.class);
    private static Map<String, String> dynRowAndSecondDraftFixRowMap = new HashMap<String, String>(3);

    @Override
    public void doAdjust(Map<String, String> result, QueryBussinessVo vo, DynamicObject data) {
        QFilter filter1 = new QFilter("cellnumber", "like", (Object)"%#dqsds_bbxm").and("entryid", "=", (Object)data.getLong("id")).and("value", "in", dynRowAndSecondDraftFixRowMap.keySet());
        DynamicObjectCollection dataCollection = QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"cellnumber,value", (QFilter[])new QFilter[]{filter1});
        String columnDimension = "#jtysbbd_rtacyxj";
        if ("sdbd".equals(data.getString("comparisontype"))) {
            columnDimension = "#jtysbbd_sjtz";
        } else if ("hjbd".equals(data.getString("comparisontype"))) {
            columnDimension = vo.getSize() == 2 ? "#jtysbbd_rtacyxj" : "#jtysbbd_hjtz";
        }
        logger.info("========setSecondDraftFixValueByDynamicRowValue======auditedDeclareThanDraft::key:" + vo.getSize() + "==========auditedDeclareThanDraft::value:" + data + "===============columnDimension:" + columnDimension);
        HashMap<String, String> cellNumberIdMap = new HashMap<String, String>();
        for (DynamicObject dyn : dataCollection) {
            String cellNumber = dyn.getString("cellnumber");
            cellNumberIdMap.put(cellNumber.substring(0, cellNumber.length() - "#dqsds_bbxm".length()) + columnDimension, dyn.getString("value"));
        }
        QFilter filter2 = new QFilter("entryid", "=", (Object)data.getLong("id")).and("cellnumber", "in", cellNumberIdMap.keySet());
        DynamicObjectCollection queryData = QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"cellnumber,value", (QFilter[])new QFilter[]{filter2});
        Map<String, String> secondDraftFixMapFromDataBase = this.getSecondDraftFixMapFromDataBase(vo);
        queryData.forEach(p -> {
            String id = (String)cellNumberIdMap.get(p.getString("cellnumber"));
            String cellKey = dynRowAndSecondDraftFixRowMap.get(id);
            String oldValueString = (String)secondDraftFixMapFromDataBase.get(cellKey);
            BigDecimal oldValue = !this.checkStringCovertDecimal(oldValueString) ? BigDecimal.ZERO : new BigDecimal(oldValueString);
            String newValue = oldValue.add(new BigDecimal(p.getString("value"))).setScale(2, 4).toString();
            result.put(cellKey, newValue);
        });
    }

    @Override
    public void cancelAdjust(Map<String, String> result, QueryBussinessVo vo, DynamicObject data) {
        QFilter filter1 = new QFilter("cellnumber", "like", (Object)"%#dqsds_bbxm").and("entryid", "=", (Object)data.getLong("id")).and("value", "in", dynRowAndSecondDraftFixRowMap.keySet());
        DynamicObjectCollection dataCollection = QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"cellnumber,value", (QFilter[])new QFilter[]{filter1});
        String columnDimension = "#jtysbbd_rtacyxj";
        if ("sdbd".equals(data.getString("comparisontype"))) {
            columnDimension = "#jtysbbd_sjtz";
        } else if ("hjbd".equals(data.getString("comparisontype"))) {
            columnDimension = vo.getSize() == 1 ? "#jtysbbd_rtacyxj" : "#jtysbbd_hjtz";
        }
        logger.info("========setSecondDraftFixValueByDynamicRowValue======auditedDeclareThanDraft::key:" + vo.getSize() + "==========auditedDeclareThanDraft::value:" + data + "===============columnDimension:" + columnDimension);
        HashMap<String, String> cellNumberIdMap = new HashMap<String, String>();
        for (DynamicObject dynamicObject : dataCollection) {
            String cellNumber = dynamicObject.getString("cellnumber");
            cellNumberIdMap.put(cellNumber.substring(0, cellNumber.length() - "#dqsds_bbxm".length()) + columnDimension, dynamicObject.getString("value"));
        }
        QFilter filter2 = new QFilter("entryid", "=", (Object)data.getLong("id")).and("cellnumber", "in", cellNumberIdMap.keySet());
        DynamicObjectCollection queryData = QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"cellnumber,value", (QFilter[])new QFilter[]{filter2});
        Map<String, String> secondDraftFixMap = this.getSecondDraftFixRowNeedRtaValue(vo);
        queryData.forEach(p -> {
            String id = (String)cellNumberIdMap.get(p.getString("cellnumber"));
            String cellKey = dynRowAndSecondDraftFixRowMap.get(id);
            String oldValueString = (String)secondDraftFixMap.get(cellKey);
            BigDecimal oldValue = !this.checkStringCovertDecimal(oldValueString) ? BigDecimal.ZERO : new BigDecimal(oldValueString);
            String newValue = oldValue.subtract(new BigDecimal(p.getString("value"))).setScale(2, 4).toString();
            result.put(cellKey, newValue);
        });
    }

    private Map<String, String> getSecondDraftFixRowNeedRtaValue(QueryBussinessVo vo) {
        String cacheKey = vo.getCacheKey();
        IPageCache childPagecache = vo.getChildrenPagecache();
        Map showAllMap = (Map)TreeUtils.getCache((IPageCache)childPagecache, (String)"showData", Map.class);
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)vo.getiPageCache(), (String)cacheKey, DeclareResponseModel.class);
        Map dataMap = responseModel.getData();
        Set entries = dataMap.entrySet();
        Collection<String> values = dynRowAndSecondDraftFixRowMap.values();
        HashMap<String, String> fixrowRtaMap = new HashMap<String, String>(3);
        entries.stream().forEach(entry -> {
            if (values.contains(entry.getKey())) {
                String value = StringUtils.isEmpty((CharSequence)((CharSequence)showAllMap.get(entry.getKey()))) ? "0.00" : (String)showAllMap.get(entry.getKey());
                fixrowRtaMap.put((String)entry.getKey(), value);
            }
        });
        return fixrowRtaMap;
    }

    private Map<String, String> getSecondDraftFixMapFromDataBase(QueryBussinessVo vo) {
        Map<String, String> map = new HashMap<String, String>(3);
        if (!ObjectUtils.isEmpty((Object)vo.getiPageCache().get("fixValuecache"))) {
            map = (Map)JSONObject.parseObject((String)vo.getiPageCache().get("fixValuecache"), Map.class);
        }
        return map;
    }

    private boolean checkStringCovertDecimal(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        try {
            new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u9519\u8bef\u3002", (String)"ItpSecondDraftFixAdjustServiceImpl_0", (String)"taxc-itp", (Object[])new Object[0]));
        }
        return true;
    }

    static {
        dynRowAndSecondDraftFixRowMap.put("1544973716989985792", "ggxcfjs_jyqndljjzkce#je");
        dynRowAndSecondDraftFixRowMap.put("1544973716101142528", "gyxjzzcxekcjs_yqndjzkkcdjze#gyxjzzcxekcjs_je");
        dynRowAndSecondDraftFixRowMap.put("1544973716981946369", "zgjyjfjs_yqndjzkce#zgjyjfjs_je");
    }
}

