/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.provision;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.itp.business.provision.ConditionObject;
import kd.taxc.itp.business.provision.impl.TaxesTotalFromDynRowCellValueServiceImpl;
import kd.taxc.itp.common.enums.CellValueCalConditionEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public interface GenerateProvisionBillService {
    public static final Log logger = LogFactory.getLog(ProvisionItemEnum.class);

    public Map<Boolean, Map<Long, String>> generateProvisionBill(List<Long> var1);

    public static enum ProvisionItemEnum {
        JTSX_0002("JTSX-0002"){

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                return this.getCellValue(draftDynamicObject.getLong("id"), "sjjs_dqsdsfy_bqtz#sjjs_je");
            }
        }
        ,
        JTSX_0003("JTSX-0003"){

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                return this.getCellValue(draftDynamicObject.getLong("id"), "sjjs_dqsdszcfz_ydqmye#sjjs_je");
            }
        }
        ,
        JTSX_0004("JTSX-0004"){

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                BigDecimal bigDecimal = this.getCellValue(draftDynamicObject.getLong("id"), "sjjs_dqsdszcfz_zmyjt#sjjs_je");
                return bigDecimal.negate();
            }
        }
        ,
        JTSX_0005("JTSX-0005"){

            @Override
            public Date getEntryDate(DynamicObject draftDynamicObject) {
                return this.getSjtzOrHjtzEntryDate("sjtzrznd", draftDynamicObject);
            }

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                BigDecimal bigDecimal = this.getCellValue(draftDynamicObject.getLong("id"), "dqsds_sjynsdse#jtysbbd_sjtz");
                return bigDecimal;
            }
        }
        ,
        JTSX_0006("JTSX-0006"){

            @Override
            public Date getEntryDate(DynamicObject draftDynamicObject) {
                return this.getSjtzOrHjtzEntryDate("sjtzrznd", draftDynamicObject);
            }

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                return this.getGaapZctzCellValue(draftDynamicObject, "dqsds_zsxcy#jtysbbd_sjtz", ProvisionItemEnum.JTYSBBD_SJTZ);
            }
        }
        ,
        JTSX_0007("JTSX-0007"){

            @Override
            public Date getEntryDate(DynamicObject draftDynamicObject) {
                return this.getSjtzOrHjtzEntryDate("hjtzrznd", draftDynamicObject);
            }

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                BigDecimal bigDecimal = this.getCellValue(draftDynamicObject.getLong("id"), "dqsds_sjynsdse#jtysbbd_hjtz");
                return bigDecimal;
            }
        }
        ,
        JTSX_0008("JTSX-0008"){

            @Override
            public Date getEntryDate(DynamicObject draftDynamicObject) {
                return this.getSjtzOrHjtzEntryDate("hjtzrznd", draftDynamicObject);
            }

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                return this.getGaapZctzCellValue(draftDynamicObject, "dqsds_zsxcy#jtysbbd_hjtz", "%jtysbbd_hjtz");
            }
        }
        ,
        JTSX_YS_0001("JTSX-YS-0001"){

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                return this.getCellValue(draftDynamicObject.getLong("id"), "sjjs_dqsdszc_ydqmye#sjjs_je");
            }
        }
        ,
        JTSX_YS_0002("JTSX-YS-0002"){

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                return BigDecimal.ZERO.subtract(this.getCellValue(draftDynamicObject.getLong("id"), "sjjs_dqsdszc_zmyjt#sjjs_je"));
            }
        }
        ,
        JTSX_YS_0003("JTSX-YS-0003"){

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                return this.getCellValue(draftDynamicObject.getLong("id"), "sjjs_dqsdsfz_ydqmye#sjjs_je");
            }
        }
        ,
        JTSX_YS_0004("JTSX-YS-0004"){

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                return BigDecimal.ZERO.subtract(this.getCellValue(draftDynamicObject.getLong("id"), "sjjs_dqsdsfz_zmyjt#sjjs_je"));
            }
        }
        ,
        JTSX_YS_0005("JTSX-YS-0005"){

            @Override
            public Date getEntryDate(DynamicObject draftDynamicObject) {
                return this.getSjtzOrHjtzEntryDate("sjtzrznd", draftDynamicObject);
            }

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                return this.getCommonTotal(draftDynamicObject, CellValueCalConditionEnum.GREATER_THAN_OR_EQUALS, "jtysbbd_sjtz");
            }
        }
        ,
        JTSX_YS_0006("JTSX-YS-0006"){

            @Override
            public Date getEntryDate(DynamicObject draftDynamicObject) {
                return this.getSjtzOrHjtzEntryDate("hjtzrznd", draftDynamicObject);
            }

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                return this.getCommonTotal(draftDynamicObject, CellValueCalConditionEnum.GREATER_THAN_OR_EQUALS, "jtysbbd_hjtz");
            }
        }
        ,
        JTSX_YS_0007("JTSX-YS-0007"){

            @Override
            public Date getEntryDate(DynamicObject draftDynamicObject) {
                return this.getSjtzOrHjtzEntryDate("sjtzrznd", draftDynamicObject);
            }

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                return this.getCommonTotal(draftDynamicObject, CellValueCalConditionEnum.LESS_THAN, "jtysbbd_sjtz");
            }
        }
        ,
        JTSX_YS_0008("JTSX-YS-0008"){

            @Override
            public Date getEntryDate(DynamicObject draftDynamicObject) {
                return this.getSjtzOrHjtzEntryDate("hjtzrznd", draftDynamicObject);
            }

            @Override
            public BigDecimal getTotal(DynamicObject draftDynamicObject) {
                return this.getCommonTotal(draftDynamicObject, CellValueCalConditionEnum.LESS_THAN, "jtysbbd_hjtz");
            }
        };

        private String provisionItemNumber;
        private static final String BIZTYPE_NUMBER_YWLB0004 = "YWLB0004";
        private static final String BIZTYPE_NUMBER_YWLB0001 = "YWLB0001";
        private static final String DQSDS_GAAPTZ_CYXM = "dqsds_gaaptz_cyxm#1";
        private static final String JTYSBBD_SJTZ = "%jtysbbd_sjtz";

        public Date getEntryDate(DynamicObject draftDynamicObject) {
            return draftDynamicObject.getDate("skssqz");
        }

        public Long getAccountOrg(DynamicObject draftDynamicObject) {
            Long taxorgId = draftDynamicObject.getLong("org.id");
            List orgTakeRelation = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxorgId), (Date)draftDynamicObject.getDate("skssqq"), (Date)draftDynamicObject.getDate("skssqz"));
            if (ObjectUtils.isNotEmpty((Object)orgTakeRelation)) {
                HashSet set = new HashSet(orgTakeRelation);
                if (set.size() == 1 && !((Long)set.stream().findFirst().get()).equals(0L)) {
                    return (Long)set.stream().findFirst().get();
                }
                if (set.size() == 2 && set.contains(taxorgId)) {
                    Long org = 0L;
                    for (Long id : set) {
                        if (id.equals(taxorgId)) continue;
                        org = id;
                        break;
                    }
                    return org;
                }
                if (set.size() > 2 && set.contains(taxorgId)) {
                    return taxorgId;
                }
                return null;
            }
            return null;
        }

        public abstract BigDecimal getTotal(DynamicObject var1);

        public BigDecimal getCommonTotal(DynamicObject draftDynamicObject, CellValueCalConditionEnum calCondition, String columnDimension) {
            String zcjtsqzValue = (String)SystemParamUtil.getAppParameter((String)"itp", (String)"zcjtsqz", (long)draftDynamicObject.getLong("org.id"));
            ArrayList<ConditionObject> conditions = new ArrayList<ConditionObject>();
            TaxesTotalFromDynRowCellValueServiceImpl taxesTotalCalculationService = new TaxesTotalFromDynRowCellValueServiceImpl();
            Long draftId = this.getCurYearLastSdsjt(draftDynamicObject);
            logger.info("===========getCommonTotal==========draftId:" + draftId);
            if ("qmye".equals(zcjtsqzValue)) {
                conditions.add(new ConditionObject(draftDynamicObject.getLong("id"), calCondition, BigDecimal.ZERO, "jtysbbd_jts", Stream.of(DQSDS_GAAPTZ_CYXM, "dqsds_zsxcy_cyxm#1").collect(Collectors.toList())));
            } else if ("bnjt".equals(zcjtsqzValue)) {
                conditions.add(new ConditionObject(draftId, calCondition, BigDecimal.ZERO, "dysds_qmye", Stream.of("dysds_gaapzsxcy_sh_xm#1", "dysds_zsxcy_sh_xm#1").collect(Collectors.toList())));
            } else {
                return BigDecimal.ZERO;
            }
            HashMap<String, Object> extendParam = new HashMap<String, Object>();
            extendParam.put("conditions", conditions);
            extendParam.put("bizTypeNumbers", Stream.of(BIZTYPE_NUMBER_YWLB0001, BIZTYPE_NUMBER_YWLB0004).collect(Collectors.toList()));
            extendParam.put("dynRowNos", Stream.of(DQSDS_GAAPTZ_CYXM, "dqsds_zsxcy_cyxm#1").collect(Collectors.toList()));
            extendParam.put("columnDimension", columnDimension);
            extendParam.put("isMultiplyTaxRate", Boolean.TRUE);
            String taxRateCellNumber = "dysds_dysdsl#dysds_snqnjts";
            BigDecimal taxRate = taxesTotalCalculationService.getCellValue(draftId, taxRateCellNumber).divide(new BigDecimal(100));
            extendParam.put("taxRate", taxRate);
            return taxesTotalCalculationService.getTaxesTotal(draftDynamicObject, extendParam);
        }

        protected String getParamValue(String paramKey, DynamicObject draftDynamicObject) {
            String[] params;
            List list;
            String accountsetType = draftDynamicObject.getString("accountsettype");
            String sjtzrznd = (String)SystemParamUtil.getAppParameter((String)"itp", (String)paramKey, (long)draftDynamicObject.getLong("org.id"));
            String paramValue = null;
            if (StringUtil.isNotEmpty((CharSequence)sjtzrznd) && ObjectUtils.isNotEmpty(list = Arrays.stream(params = sjtzrznd.split(",")).filter(o -> o.startsWith(accountsetType)).distinct().collect(Collectors.toList())) && list.size() == 1) {
                paramValue = (String)list.get(0);
            }
            return paramValue;
        }

        protected Date getSjtzOrHjtzEntryDate(String paramKey, DynamicObject draftDynamicObject) {
            String param = this.getParamValue(paramKey, draftDynamicObject);
            if (ObjectUtils.isNotEmpty((Object)param)) {
                if (param.endsWith("_bn")) {
                    Date currentDate = new Date();
                    int month = DateUtils.getMonthOfDate((Date)currentDate);
                    if (month == 1) {
                        return DateUtils.getLastDateOfMonth2((Date)currentDate);
                    }
                    return DateUtils.getLastDateOfMonth2((Date)DateUtils.addMonth((Date)currentDate, (int)-1));
                }
                if (param.endsWith("_sn")) {
                    return draftDynamicObject.getDate("skssqz");
                }
            }
            return null;
        }

        protected BigDecimal getCellValue(Long draftId, String cellNumber) {
            QFilter entryidQ = new QFilter("entryid", "=", (Object)draftId);
            QFilter cellnumberQ = new QFilter("cellnumber", "=", (Object)cellNumber);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_declare_detail_tsd", (String)"value", (QFilter[])new QFilter[]{entryidQ, cellnumberQ});
            if (ObjectUtils.isNotEmpty((Object)collection) && StringUtil.isNotEmpty((CharSequence)((DynamicObject)collection.get(0)).getString("value"))) {
                return new BigDecimal(((DynamicObject)collection.get(0)).getString("value"));
            }
            return BigDecimal.ZERO;
        }

        protected BigDecimal getGaapZctzCellValue(DynamicObject draftDynamicObject, String cellNumber, String culumnEndNumber) {
            QFilter fetchItemValueQ;
            QFilter dynRowNoQ;
            QFilter entryidQ;
            DynamicObjectCollection collection;
            long id;
            DynamicObjectCollection dynamicObjects;
            BigDecimal bigDecimal = this.getCellValue(draftDynamicObject.getLong("id"), cellNumber);
            Date preYearSkssqz = DateUtils.stringToDate((String)(DateUtils.getYearOfDate((Date)draftDynamicObject.getDate("skssqq")) + "-12-31"));
            DynamicObjectCollection dynamicObjectCollection = this.queryDeclareMain(draftDynamicObject.getLong("org.id"), draftDynamicObject.getLong("taxsystem.id"), preYearSkssqz, draftDynamicObject.getString("accountsettype"));
            BigDecimal dysdsSl = null;
            if (ObjectUtils.isNotEmpty((Object)dynamicObjectCollection) && ObjectUtils.isNotEmpty((Object)(dynamicObjects = QueryServiceHelper.query((String)"tpo_declare_detail_tsd", (String)"id,value,cellnumber", (QFilter[])new QFilter[]{new QFilter("entryid", "=", (Object)(id = ((DynamicObject)dynamicObjectCollection.get(0)).getLong("id"))).and("cellnumber", "=", (Object)"dysds_dysdsl#dysds_snqnjts")})))) {
                String value = ((DynamicObject)dynamicObjects.get(0)).getString("value") != null ? ((DynamicObject)dynamicObjects.get(0)).getString("value") : "0";
                dysdsSl = new BigDecimal(value).divide(new BigDecimal("100"), 2, 4);
            }
            if (ObjectUtils.isEmpty(dysdsSl)) {
                dysdsSl = new BigDecimal("0.25");
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)"jtysbbd_bd", (CharSequence)draftDynamicObject.getString("templatetype.number"))) {
                return bigDecimal.multiply(dysdsSl).setScale(2, 4);
            }
            List<String> fetchItemList = this.queryFetchItem(BIZTYPE_NUMBER_YWLB0004, draftDynamicObject.getLong("taxsystem.id"));
            if (ObjectUtils.isNotEmpty(fetchItemList) && ObjectUtils.isNotEmpty((Object)(collection = QueryServiceHelper.query((String)"tpo_declare_detail_tsd", (String)"index", (QFilter[])new QFilter[]{entryidQ = new QFilter("entryid", "=", (Object)draftDynamicObject.getLong("id")), dynRowNoQ = new QFilter("dynrowno", "=", (Object)DQSDS_GAAPTZ_CYXM), fetchItemValueQ = new QFilter("value", "in", fetchItemList)})))) {
                List list = collection.stream().map(o -> o.getInt("index")).collect(Collectors.toList());
                QFilter indexQ = new QFilter("index", "in", list);
                QFilter cellNumberEndQ = new QFilter("cellnumber", "like", (Object)culumnEndNumber);
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"tpo_declare_detail_tsd", (String)"value", (QFilter[])new QFilter[]{entryidQ, dynRowNoQ, indexQ, cellNumberEndQ});
                for (DynamicObject row : coll) {
                    bigDecimal = bigDecimal.add(row.getBigDecimal("value"));
                }
            }
            return bigDecimal.multiply(dysdsSl).setScale(2, 4);
        }

        private List<String> queryFetchItem(String bizTypeNumber, Long taxationSys) {
            QFilter enableQ = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter taxSystemQ = new QFilter("taxationsys", "=", (Object)taxationSys);
            QFilter bizTypeNumberQ = new QFilter("biztype.number", "=", (Object)bizTypeNumber);
            QFilter isLeafQ = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id", (QFilter[])new QFilter[]{enableQ, taxSystemQ, bizTypeNumberQ, isLeafQ});
            return collection.stream().map(row -> row.getString("id")).collect(Collectors.toList());
        }

        protected Long getCurYearLastSdsjt(DynamicObject draftDynamicObject) {
            long orgid = draftDynamicObject.getLong("org.id");
            long taxsystemId = draftDynamicObject.getLong("taxsystem.id");
            Date skssqq = draftDynamicObject.getDate("skssqq");
            Date skssqz = draftDynamicObject.getDate("skssqz");
            String accountsettype = draftDynamicObject.getString("accountsettype");
            String templateType = draftDynamicObject.getString("templatetype.number").equals("jtysbbd_bd") ? "sdsjt_bd" : "sdsjt_jt";
            QFilter filter = new QFilter("org.id", "=", (Object)orgid).and("taxsystem.id", "=", (Object)taxsystemId).and("skssqq", ">=", (Object)skssqq).and("skssqz", "<=", (Object)skssqz).and("accountsettype", "=", (Object)accountsettype).and("templatetype", "=", (Object)templateType).and("billstatus", "=", (Object)"C");
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_declare_main_tsd", (String)"id,skssqz", (QFilter[])new QFilter[]{filter});
            logger.info("=============getCurYearLastSdsjt======filter:" + filter + "==============collection:" + collection + "===============draftDynamicObject:" + draftDynamicObject);
            if (CollectionUtils.isEmpty((Collection)collection)) {
                return 0L;
            }
            return collection.stream().sorted(Comparator.comparing(p -> ((DynamicObject)p).getDate("skssqz")).reversed()).map(p -> p.getLong("id")).findFirst().orElse(0L);
        }

        private DynamicObjectCollection queryDeclareMain(Long orgId, Long taxationSysId, Date endDate, String accountSetType) {
            String templateNum = "jtzt".equalsIgnoreCase(accountSetType) ? "INCOME-TAX-ADJ-JT" : "INCOME-TAX-ADJ-BD";
            QFilter qFilter = new QFilter("number", "=", (Object)templateNum);
            DynamicObject template = QueryServiceHelper.queryOne((String)"tpo_template", (String)"id,number", (QFilter[])new QFilter[]{qFilter});
            if (orgId == null || taxationSysId == null || endDate == null || accountSetType == null || template == null) {
                return new DynamicObjectCollection();
            }
            QFilter mainFilter = new QFilter("org", "=", (Object)orgId).and("taxsystem", "=", (Object)taxationSysId).and("skssqz", "=", (Object)endDate).and("templateid", "=", template.get("id"));
            return QueryServiceHelper.query((String)"tpo_declare_main_tsd", (String)"id,org.name,org.number,org.id as orgid,skssqz,templatetype,taxsystem,remarks", (QFilter[])new QFilter[]{mainFilter}, (String)"org.number asc");
        }

        private ProvisionItemEnum(String provisionItemNumber) {
            this.provisionItemNumber = provisionItemNumber;
        }

        public String getProvisionItemNumber() {
            return this.provisionItemNumber;
        }

        public static ProvisionItemEnum getEnumByProvisionItem(String provisionItem) {
            for (ProvisionItemEnum provisionItemEnum : ProvisionItemEnum.values()) {
                if (!provisionItemEnum.getProvisionItemNumber().equals(provisionItem)) continue;
                return provisionItemEnum;
            }
            return null;
        }
    }

    public static enum TemplateProvisionItemEnum {
        INCOME_TAX_ADJ_BD("INCOME-TAX-ADJ-BD", new String[]{ProvisionItemEnum.JTSX_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0003.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0004.getProvisionItemNumber()}){

            @Override
            public String[] getHighPriorityProvisionItems(DynamicObject draftDynamicObject) {
                String dysdszcfzfkrzParamValue = String.valueOf(SystemParamUtil.getAppParameter((String)"itp", (String)"dysdszcfzfkrz", (long)draftDynamicObject.getLong("org.id")));
                if (Boolean.FALSE.toString().equalsIgnoreCase(dysdszcfzfkrzParamValue)) {
                    return null;
                }
                return new String[]{ProvisionItemEnum.JTSX_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0003.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0004.getProvisionItemNumber()};
            }
        }
        ,
        INCOME_TAX_ADJ_JT("INCOME-TAX-ADJ-JT", new String[]{ProvisionItemEnum.JTSX_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0003.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0004.getProvisionItemNumber()}){

            @Override
            public String[] getHighPriorityProvisionItems(DynamicObject draftDynamicObject) {
                String dysdszcfzfkrzParamValue = String.valueOf(SystemParamUtil.getAppParameter((String)"itp", (String)"dysdszcfzfkrz", (long)draftDynamicObject.getLong("org.id")));
                if (Boolean.FALSE.toString().equalsIgnoreCase(dysdszcfzfkrzParamValue)) {
                    return null;
                }
                return new String[]{ProvisionItemEnum.JTSX_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0003.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0004.getProvisionItemNumber()};
            }
        }
        ,
        PRO_DECLARE_THAN_BD("PRO-DECLARE-THAN-BD", new String[]{ProvisionItemEnum.JTSX_0005.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0006.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0007.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0008.getProvisionItemNumber()}){

            @Override
            public String[] getHighPriorityProvisionItems(DynamicObject draftDynamicObject) {
                return this.getJtYSbbdProvisionItems(draftDynamicObject);
            }
        }
        ,
        PRO_DECLARE_THAN_JT("PRO-DECLARE-THAN-JT", new String[]{ProvisionItemEnum.JTSX_0005.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0006.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0007.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0008.getProvisionItemNumber()}){

            @Override
            public String[] getHighPriorityProvisionItems(DynamicObject draftDynamicObject) {
                return this.getJtYSbbdProvisionItems(draftDynamicObject);
            }
        };

        private String template;
        private String[] provisionItems;

        private TemplateProvisionItemEnum(String template, String[] provisionItems) {
            this.template = template;
            this.provisionItems = provisionItems;
        }

        public String getTemplate() {
            return this.template;
        }

        public String[] getProvisionItems() {
            return this.provisionItems;
        }

        public String[] getProvisionItems(DynamicObject draftDynamicObject) {
            String[] highPriorityProvisionItems = this.getHighPriorityProvisionItems(draftDynamicObject);
            if (highPriorityProvisionItems == null || highPriorityProvisionItems.length == 0) {
                return this.provisionItems;
            }
            return highPriorityProvisionItems;
        }

        public static TemplateProvisionItemEnum getEnumByTemplate(String template) {
            for (TemplateProvisionItemEnum templateProvisionItemEnum : TemplateProvisionItemEnum.values()) {
                if (!templateProvisionItemEnum.getTemplate().equals(template)) continue;
                return templateProvisionItemEnum;
            }
            return null;
        }

        public String[] getHighPriorityProvisionItems(DynamicObject draftDynamicObject) {
            return null;
        }

        protected String[] getJtYSbbdProvisionItems(DynamicObject draftDynamicObject) {
            String dysdszcfzfkrzParamValue = String.valueOf(SystemParamUtil.getAppParameter((String)"itp", (String)"dysdszcfzfkrz", (long)draftDynamicObject.getLong("org.id")));
            String jtsdshjsbdParamValue = (String)SystemParamUtil.getAppParameter((String)"itp", (String)"jtsdshjsbd", (long)draftDynamicObject.getLong("org.id"));
            if ("true".equals(dysdszcfzfkrzParamValue)) {
                if ("tsbd".equals(jtsdshjsbdParamValue)) {
                    return new String[]{ProvisionItemEnum.JTSX_0005.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0005.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0007.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0007.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0006.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0008.getProvisionItemNumber()};
                }
                if ("sdbd".equals(draftDynamicObject.getString("comparisontype"))) {
                    return new String[]{ProvisionItemEnum.JTSX_0005.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0005.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0007.getProvisionItemNumber()};
                }
                return new String[]{ProvisionItemEnum.JTSX_0007.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0006.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_0008.getProvisionItemNumber()};
            }
            if ("tsbd".equals(jtsdshjsbdParamValue)) {
                return new String[]{ProvisionItemEnum.JTSX_0005.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0006.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0007.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0008.getProvisionItemNumber()};
            }
            if ("sdbd".equals(draftDynamicObject.getString("comparisontype"))) {
                return new String[]{ProvisionItemEnum.JTSX_0005.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0006.getProvisionItemNumber()};
            }
            return new String[]{ProvisionItemEnum.JTSX_0007.getProvisionItemNumber(), ProvisionItemEnum.JTSX_0008.getProvisionItemNumber()};
        }
    }
}

