/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.provision.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.itp.business.provision.TaxesTotalCalculationService;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractTaxesTotalCalculationServiceImpl
implements TaxesTotalCalculationService {
    private static final String APP_NUMBER = "itp";
    protected BigDecimal taxRate = new BigDecimal("0.25");

    public String getSystemConfigParameterValue(String parameterKey, DynamicObject draftDynamicObject) {
        if (draftDynamicObject == null || !draftDynamicObject.containsProperty("org")) {
            return null;
        }
        return (String)SystemParamUtil.getAppParameter((String)APP_NUMBER, (String)parameterKey, (long)draftDynamicObject.getLong("org.id"));
    }

    public BigDecimal getCellValue(Long draftId, String cellNumber) {
        List<String> cellValues = this.getCellValues(draftId, Stream.of(cellNumber).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(cellValues) && StringUtils.isNotEmpty((String)cellValues.get(0))) {
            return new BigDecimal(cellValues.get(0));
        }
        return BigDecimal.ZERO;
    }

    public List<String> getCellValues(Long draftId, List<String> cellNumbers) {
        QFilter queryFilter = new QFilter("entryid", "=", (Object)draftId).and("cellnumber", "in", cellNumbers);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_declare_detail_tsd", (String)"value", (QFilter[])new QFilter[]{queryFilter});
        return collection.stream().map(p -> p.getString("value")).collect(Collectors.toList());
    }

    public List<String> getFetchItemIds(List<String> bizTypeNumbers, DynamicObject draftDynamicObject) {
        if (CollectionUtils.isEmpty(bizTypeNumbers) || draftDynamicObject == null || !draftDynamicObject.containsProperty("taxsystem")) {
            return new ArrayList<String>();
        }
        QFilter queryFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and("taxationsys", "=", (Object)draftDynamicObject.getLong("taxsystem.id")).and("biztype.number", "in", bizTypeNumbers).and("isleaf", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id", (QFilter[])new QFilter[]{queryFilter});
        return collection.stream().map(row -> row.getString("id")).collect(Collectors.toList());
    }

    public List<BigDecimal> getDynamicRowCellBigDecimalValue(DynamicObject draftDynamicObject, List<String> fetchItemIds, List<String> dynRowNos, String columnDimension) {
        List<String> dynamicRowCellValues = this.getDynamicRowCellValue(draftDynamicObject, fetchItemIds, dynRowNos, columnDimension);
        return dynamicRowCellValues.stream().map(p -> new BigDecimal((String)p)).collect(Collectors.toList());
    }

    public List<String> getDynamicRowCellValue(DynamicObject draftDynamicObject, List<String> fetchItemIds, List<String> dynRowNos, String columnDimension) {
        if (draftDynamicObject == null || !draftDynamicObject.containsProperty("id") || CollectionUtils.isEmpty(fetchItemIds) || CollectionUtils.isEmpty(dynRowNos) || StringUtils.isEmpty((String)columnDimension)) {
            return new ArrayList<String>();
        }
        long draftId = draftDynamicObject.getLong("id");
        QFilter queryFilter = new QFilter("entryid", "=", (Object)draftId).and("dynrowno", "in", dynRowNos).and("value", "in", fetchItemIds);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_declare_detail_tsd", (String)"cellnumber", (QFilter[])new QFilter[]{queryFilter});
        columnDimension = columnDimension.startsWith("#") ? columnDimension : "#" + columnDimension;
        ArrayList<String> cellNumbers = new ArrayList<String>();
        for (DynamicObject object : collection) {
            String cellNumber = object.getString("cellnumber");
            cellNumbers.add(cellNumber.substring(0, cellNumber.lastIndexOf("#")) + columnDimension);
        }
        return this.getCellValues(draftId, cellNumbers);
    }

    public Map<String, BigDecimal> getDynRowFetchItemIdColumnValueMap(Long draftId, List<String> fetchItemIds, List<String> dynRowNos, String columnDimension) {
        QFilter queryFilter1 = new QFilter("entryid", "=", (Object)draftId).and("dynrowno", "in", dynRowNos).and("value", "in", fetchItemIds);
        DynamicObjectCollection collection1 = QueryServiceHelper.query((String)"tpo_declare_detail_tsd", (String)"cellnumber,value", (QFilter[])new QFilter[]{queryFilter1});
        ArrayList<String> cellNumbers = new ArrayList<String>();
        columnDimension = columnDimension.startsWith("#") ? columnDimension : "#" + columnDimension;
        for (DynamicObject object : collection1) {
            String cellNumber = object.getString("cellnumber");
            cellNumbers.add(cellNumber.substring(0, cellNumber.lastIndexOf("#")) + columnDimension);
        }
        QFilter queryFilter2 = new QFilter("entryid", "=", (Object)draftId).and("dynrowno", "in", dynRowNos).and("cellnumber", "in", cellNumbers);
        DynamicObjectCollection collection2 = QueryServiceHelper.query((String)"tpo_declare_detail_tsd", (String)"cellnumber,value", (QFilter[])new QFilter[]{queryFilter2});
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        collection2.forEach(p2 -> {
            String cellNumber2 = p2.getString("cellnumber");
            collection1.stream().filter(p1 -> {
                String cellNumber1 = p1.getString("cellnumber");
                return cellNumber1.substring(0, cellNumber1.lastIndexOf("#")).equals(cellNumber2.substring(0, cellNumber2.lastIndexOf("#")));
            }).findFirst().ifPresent(p1 -> result.put(p1.getString("value"), p2.getBigDecimal("value")));
        });
        return result;
    }

    public BigDecimal getMultiplyByTaxRateValue(BigDecimal value) {
        return value.multiply(this.taxRate).setScale(2, RoundingMode.HALF_UP);
    }
}

