/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.provision.impl;

import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.itp.business.provision.GenerateProvisionBillService;
import org.apache.commons.lang3.ObjectUtils;

public class GenerateProvisionBillServiceImpl
implements GenerateProvisionBillService {
    @Override
    public Map<Boolean, Map<Long, String>> generateProvisionBill(List<Long> draftIdList) {
        ArrayList<Map<String, Object>> requestParamList = new ArrayList<Map<String, Object>>(12);
        HashMap<Boolean, Map<Long, String>> responseMap = new HashMap<Boolean, Map<Long, String>>();
        HashMap successMap = new HashMap();
        HashMap<Long, String> failMap = new HashMap<Long, String>();
        responseMap.put(Boolean.TRUE, successMap);
        responseMap.put(Boolean.FALSE, failMap);
        if (ObjectUtils.isEmpty(draftIdList)) {
            return responseMap;
        }
        HashMap<String, Long> draftMap = new HashMap<String, Long>(12);
        DynamicObject[] draftObjects = BusinessDataServiceHelper.load((Object[])draftIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_declare_main_tsd"));
        List taxSystemList = Arrays.stream(draftObjects).map(o -> o.getLong("taxsystem.id")).distinct().collect(Collectors.toList());
        HashSet provisionItemSet = new HashSet();
        Arrays.stream(draftObjects).forEach(row -> {
            GenerateProvisionBillService.TemplateProvisionItemEnum itemEnum = GenerateProvisionBillService.TemplateProvisionItemEnum.getEnumByTemplate(row.getString("templateid.number"));
            if (null != itemEnum) {
                Arrays.stream(itemEnum.getProvisionItems((DynamicObject)row)).forEach(o -> provisionItemSet.add(o));
            }
        });
        QFilter enableQ = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter taxSystemQ = new QFilter("taxsystem", "in", taxSystemList);
        QFilter numberQ = new QFilter("number", "in", provisionItemSet);
        DynamicObjectCollection provisionItemCol = QueryServiceHelper.query((String)"itp_proviston_item", (String)"id,number,taxtype,taxsystem", (QFilter[])new QFilter[]{enableQ, numberQ, taxSystemQ});
        HashMap waitGenerateProvisionMap = new HashMap();
        provisionItemCol.stream().forEach(row -> {
            String taxSystem = row.getString("taxsystem");
            String number = row.getString("number");
            Long id = row.getLong("id");
            Long taxType = row.getLong("taxtype");
            if (waitGenerateProvisionMap.containsKey(taxSystem)) {
                ((Map)waitGenerateProvisionMap.get(taxSystem)).put(number, new Long[]{id, taxType});
            } else {
                HashMap<String, Long[]> map = new HashMap<String, Long[]>();
                map.put(number, new Long[]{id, taxType});
                waitGenerateProvisionMap.put(taxSystem, map);
            }
        });
        provisionItemCol.stream().collect(Collectors.toMap(a -> a.getString("taxsystem"), b -> ImmutableBiMap.of((Object)b.getString("number"), (Object)new Long[]{b.getLong("id"), b.getLong("taxtype")}), (m, n) -> n));
        for (DynamicObject draftRow : draftObjects) {
            Long draftId = draftRow.getLong("id");
            String draftBillNo = draftRow.getString("billno");
            draftMap.put(draftBillNo, draftId);
            String taxSystem = draftRow.getString("taxsystem.id");
            String templateNumber = draftRow.getString("templateid.number");
            if (waitGenerateProvisionMap.containsKey(taxSystem)) {
                Map waitProvisionItemMap = (Map)waitGenerateProvisionMap.get(taxSystem);
                GenerateProvisionBillService.TemplateProvisionItemEnum itemEnum = GenerateProvisionBillService.TemplateProvisionItemEnum.getEnumByTemplate(templateNumber);
                if (null != itemEnum) {
                    String[] provisionItems = itemEnum.getProvisionItems(draftRow);
                    boolean noAppear = true;
                    boolean notFindAccoutOrg = false;
                    for (String provisionItem : provisionItems) {
                        if (!waitProvisionItemMap.containsKey(provisionItem)) continue;
                        GenerateProvisionBillService.ProvisionItemEnum provisionItemEnum = GenerateProvisionBillService.ProvisionItemEnum.getEnumByProvisionItem(provisionItem);
                        if (null != provisionItemEnum.getAccountOrg(draftRow)) {
                            requestParamList.add(this.createParamsMap((Long[])waitProvisionItemMap.get(provisionItem), provisionItemEnum, draftRow));
                            noAppear = false;
                            continue;
                        }
                        notFindAccoutOrg = true;
                        noAppear = false;
                        break;
                    }
                    if (notFindAccoutOrg) {
                        failMap.put(draftId, String.format(ResManager.loadKDString((String)"%s\uff1a\u627e\u4e0d\u5230\u6216\u5b58\u5728\u591a\u4e2a\u59d4\u6258\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GenerateProvisionBillServiceImpl_0", (String)"taxc-itp", (Object[])new Object[0]), draftBillNo));
                    }
                    if (!noAppear) continue;
                    failMap.put(draftId, String.format(ResManager.loadKDString((String)"%s\uff1a\u627e\u4e0d\u5230\u53ef\u7528\u7684\u8ba1\u63d0\u4e8b\u9879\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GenerateProvisionBillServiceImpl_1", (String)"taxc-itp", (Object[])new Object[0]), draftBillNo));
                    continue;
                }
                failMap.put(draftId, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5e95\u7a3f\u7684\u6a21\u677f\u7f16\u53f7%2$s\u6682\u4e0d\u652f\u6301\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"GenerateProvisionBillServiceImpl_2", (String)"taxc-itp", (Object[])new Object[0]), draftBillNo, templateNumber));
                continue;
            }
            failMap.put(draftId, String.format(ResManager.loadKDString((String)"%s\uff1a\u7a0e\u6536\u5236\u5ea6\u4e0d\u652f\u6301\u6216\u627e\u4e0d\u5230\u53ef\u7528\u7684\u8ba1\u63d0\u4e8b\u9879\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GenerateProvisionBillServiceImpl_3", (String)"taxc-itp", (Object[])new Object[0]), draftBillNo));
        }
        String responseList = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxprovisionService", (String)"createTaxprovision", (Object[])new Object[]{SerializationUtils.toJsonString(requestParamList)});
        BaseResult data = (BaseResult)SerializationUtils.fromJsonString((String)responseList, BaseResult.class);
        if (data.getCode().equals(BaseResult.OK)) {
            List responses = (List)data.getData();
            responses.stream().forEach(rowMap -> {
                for (Map.Entry entry : rowMap.entrySet()) {
                    String draftBillNo = (String)entry.getKey();
                    successMap.put(draftMap.get(draftBillNo), "");
                }
            });
        }
        return responseMap;
    }

    private Map<String, Object> createParamsMap(Long[] provisionItemArray, GenerateProvisionBillService.ProvisionItemEnum provisionItemEnum, DynamicObject draftDynmicObject) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("coins", 1);
        map.put("provistonitem", provisionItemArray[0]);
        map.put("taxorg", draftDynmicObject.getLong("org.id"));
        map.put("taxsystem", draftDynmicObject.getLong("taxsystem.id"));
        map.put("taxtype", provisionItemArray[1]);
        map.put("startdate", draftDynmicObject.get("skssqq"));
        map.put("enddate", draftDynmicObject.get("skssqz"));
        map.put("entitynumber", draftDynmicObject.getString("billno"));
        String accountsetType = draftDynmicObject.getString("accountsettype");
        String accountsetTypeValue = null;
        if (StringUtil.equalsAnyIgnoreCase((CharSequence)accountsetType, (CharSequence[])new CharSequence[]{"jtzt"})) {
            accountsetTypeValue = ResManager.loadKDString((String)"\u96c6\u56e2\u8d26\u7c3f", (String)"GenerateProvisionBillServiceImpl_4", (String)"taxc-itp", (Object[])new Object[0]);
        } else if (StringUtil.equalsAnyIgnoreCase((CharSequence)accountsetType, (CharSequence[])new CharSequence[]{"bdzt"})) {
            accountsetTypeValue = ResManager.loadKDString((String)"\u672c\u5730\u8d26\u7c3f", (String)"GenerateProvisionBillServiceImpl_5", (String)"taxc-itp", (Object[])new Object[0]);
        }
        map.put("accountsettype", accountsetTypeValue);
        map.put("sourcedrafttype", draftDynmicObject.getString("templatetype.name"));
        map.put("entitytype", "tpo_declare_main_tsd");
        map.put("accountorg", provisionItemEnum.getAccountOrg(draftDynmicObject));
        map.put("entrydate", provisionItemEnum.getEntryDate(draftDynmicObject));
        map.put("total", provisionItemEnum.getTotal(draftDynmicObject));
        map.put("creator", RequestContext.get().getCurrUserId());
        map.put("modifier", RequestContext.get().getCurrUserId());
        return map;
    }
}

