/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.provision.impl;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.itp.business.provision.impl.AbstractTaxesTotalCalculationServiceImpl;

public class TaxesTotalFromCellValueServiceImpl
extends AbstractTaxesTotalCalculationServiceImpl {
    @Override
    public BigDecimal getTaxesTotal(DynamicObject draftDynamicObject, Map<String, Object> extendParams) {
        if (!extendParams.containsKey("cellNumber")) {
            return BigDecimal.ZERO;
        }
        String cellNumber = extendParams.get("cellNumber").toString();
        BigDecimal cellValue = this.getCellValue(draftDynamicObject.getLong("id"), cellNumber);
        if (extendParams.containsKey("isMultiplyTaxRate") && Boolean.parseBoolean(extendParams.get("isMultiplyTaxRate").toString())) {
            if (extendParams.containsKey("taxRate")) {
                this.taxRate = (BigDecimal)extendParams.get("taxRate");
            }
            cellValue = this.getMultiplyByTaxRateValue(cellValue);
        }
        if (extendParams.containsKey("isReverse") && Boolean.parseBoolean(extendParams.get("isReverse").toString())) {
            cellValue = BigDecimal.ZERO.subtract(cellValue);
        }
        return cellValue;
    }
}

