/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.provision.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.itp.business.provision.ConditionObject;
import kd.taxc.itp.business.provision.impl.AbstractTaxesTotalCalculationServiceImpl;

public class TaxesTotalFromDynRowCellValueServiceImpl
extends AbstractTaxesTotalCalculationServiceImpl {
    @Override
    public BigDecimal getTaxesTotal(DynamicObject draftDynamicObject, Map<String, Object> extendParams) {
        if (!(draftDynamicObject != null && extendParams.containsKey("bizTypeNumbers") && extendParams.containsKey("dynRowNos") && extendParams.containsKey("columnDimension"))) {
            return BigDecimal.ZERO;
        }
        List bizTypeNumbers = (List)extendParams.get("bizTypeNumbers");
        List<String> fetchItemIds = this.getFetchItemIds(bizTypeNumbers, draftDynamicObject);
        if (extendParams.containsKey("conditions")) {
            List conditions = (List)extendParams.get("conditions");
            fetchItemIds = this.getFetchItemIdsFilterByCondition(fetchItemIds, conditions);
        }
        List dynRowNos = (List)extendParams.get("dynRowNos");
        String columnDimension = (String)extendParams.get("columnDimension");
        List<BigDecimal> cellValues = this.getDynamicRowCellBigDecimalValue(draftDynamicObject, fetchItemIds, dynRowNos, columnDimension);
        BigDecimal value = BigDecimal.ZERO;
        for (BigDecimal cellValue : cellValues) {
            value = value.add(cellValue);
        }
        if (extendParams.containsKey("isMultiplyTaxRate") && Boolean.parseBoolean(extendParams.get("isMultiplyTaxRate").toString())) {
            if (extendParams.containsKey("taxRate")) {
                this.taxRate = (BigDecimal)extendParams.get("taxRate");
            }
            value = this.getMultiplyByTaxRateValue(value);
        }
        if (extendParams.containsKey("isReverse") && Boolean.parseBoolean(extendParams.get("isReverse").toString())) {
            value = BigDecimal.ZERO.subtract(value);
        }
        return value;
    }

    private List<String> getFetchItemIdsFilterByCondition(List<String> fetchItemIds, List<ConditionObject> conditions) {
        for (ConditionObject condition : conditions) {
            Map<String, BigDecimal> fetchItemIdColumnValueMap = this.getDynRowFetchItemIdColumnValueMap(condition.getDraftId(), fetchItemIds, condition.getDynRowNos(), condition.getColumnDimension());
            fetchItemIds = fetchItemIds.stream().filter(p -> fetchItemIdColumnValueMap.get(p) != null && condition.getConditionEnum().checkCondition((BigDecimal)fetchItemIdColumnValueMap.get(p), condition.getConditionValue())).collect(Collectors.toList());
        }
        return fetchItemIds;
    }
}

