/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.provision.jtplan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ItpJtPlanBussiness {
    public static Map<String, Set<Long>> queryProvisionSharePlanByOrgIdsAndCategoryId(List<Long> orgIds, long taxsystemId, Long categoryId, Date startDate, Date endDate) {
        HashMap<String, Set<Long>> planMap = new HashMap<String, Set<Long>>(12);
        if (ObjectUtils.isEmpty((Object)startDate) || ObjectUtils.isEmpty((Object)endDate)) {
            return planMap;
        }
        TaxResult querySharePlan = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryId(orgIds, (Long)categoryId, (Long)taxsystemId, (Date)startDate, (Date)endDate);
        if (ObjectUtils.isNotEmpty((Object)querySharePlan) && querySharePlan.isSuccess() && ObjectUtils.isNotEmpty((Object)querySharePlan.getData())) {
            DynamicObjectCollection sharePlans = (DynamicObjectCollection)querySharePlan.getData();
            for (DynamicObject sharePlan : sharePlans) {
                DynamicObjectCollection orgentity = sharePlan.getDynamicObjectCollection("orgentity");
                ArrayList<Long> orgs = new ArrayList<Long>(8);
                for (DynamicObject org : orgentity) {
                    if (!orgIds.contains(org.getDynamicObject("org").getLong("id"))) continue;
                    orgs.add(org.getDynamicObject("org").getLong("id"));
                }
                DynamicObjectCollection ruleentity = sharePlan.getDynamicObjectCollection("ruleentity");
                for (DynamicObject rule : ruleentity) {
                    DynamicObject plan = rule.getDynamicObject("rule");
                    if (ObjectUtils.isEmpty((Object)plan)) continue;
                    String booktype = plan.getString("booktype");
                    ArrayList accountsettypes = new ArrayList(8);
                    if (EmptyCheckUtils.isNotEmpty((Object)booktype)) {
                        String[] split = booktype.substring(1, booktype.length() - 1).split(",");
                        Arrays.stream(split).forEach(type -> {
                            if (EmptyCheckUtils.isNotEmpty((Object)type)) {
                                accountsettypes.add(type);
                            }
                        });
                    }
                    for (String accountsettype : accountsettypes) {
                        String taxsystem = plan.getString("taxsystem.id");
                        String taxarea = plan.getString("taxarea.id");
                        String taxtype = plan.getString("taxtype.id");
                        String cycle = plan.getString("cycle");
                        String planMapKey = String.format("%s-%s-%s-%s-%s", taxsystem, taxarea, taxtype, cycle, accountsettype);
                        Set planOrgs = planMap.computeIfAbsent(planMapKey, d -> new HashSet());
                        planOrgs.addAll(orgs);
                    }
                }
            }
        }
        return planMap;
    }

    public static Map<String, Set<Long>> querySharePlanByOrgIds(List<Long> orgList) {
        HashMap<String, Set<Long>> planMap = new HashMap<String, Set<Long>>(12);
        List sharePlans = (List)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIds(orgList).getData();
        if (ObjectUtils.isEmpty((Object)sharePlans)) {
            return planMap;
        }
        for (DynamicObject sharePlan : sharePlans) {
            DynamicObjectCollection orgentity = sharePlan.getDynamicObjectCollection("orgentity");
            ArrayList<Long> orgs = new ArrayList<Long>(8);
            for (DynamicObject org : orgentity) {
                if (!orgList.contains(org.getDynamicObject("org").getLong("id"))) continue;
                orgs.add(org.getDynamicObject("org").getLong("id"));
            }
            DynamicObjectCollection ruleentity = sharePlan.getDynamicObjectCollection("ruleentity");
            for (DynamicObject rule : ruleentity) {
                DynamicObject plan = rule.getDynamicObject("rule");
                if (ObjectUtils.isEmpty((Object)plan)) continue;
                String booktype = plan.getString("booktype");
                ArrayList accountsettypes = new ArrayList(8);
                if (EmptyCheckUtils.isNotEmpty((Object)booktype)) {
                    String[] split = booktype.substring(1, booktype.length() - 1).split(",");
                    Arrays.stream(split).forEach(type -> {
                        if (EmptyCheckUtils.isNotEmpty((Object)type)) {
                            accountsettypes.add(type);
                        }
                    });
                }
                for (String accountsettype : accountsettypes) {
                    String taxsystem = plan.getString("taxsystem.id");
                    String taxarea = plan.getString("taxarea.id");
                    String taxtype = plan.getString("taxtype.id");
                    String cycle = plan.getString("cycle");
                    String planMapKey = String.format("%s-%s-%s-%s-%s", taxsystem, taxarea, taxtype, cycle, accountsettype);
                    Set planOrgs = planMap.computeIfAbsent(planMapKey, d -> new HashSet());
                    planOrgs.addAll(orgs);
                }
            }
        }
        return planMap;
    }

    public static List<String> querySharePlanByOrgIdsAndTaxsystemZt(List<Long> orgList, long taxsystemId, String taxtype, String zt, Date startDate, Date endDate) {
        ArrayList<String> resultList = new ArrayList<String>(2);
        Map<String, Set<Long>> sharePlanByOrgIds = ItpJtPlanBussiness.queryProvisionSharePlanByOrgIdsAndCategoryId(orgList, taxsystemId, Long.valueOf(taxtype), startDate, endDate);
        if (ObjectUtils.isEmpty(sharePlanByOrgIds)) {
            return resultList;
        }
        for (Map.Entry<String, Set<Long>> next : sharePlanByOrgIds.entrySet()) {
            String nextKey = next.getKey();
            String[] split = nextKey.split("-");
            if (!String.valueOf(taxsystemId).equalsIgnoreCase(split[0]) || !taxtype.equalsIgnoreCase(split[2]) || !zt.equalsIgnoreCase(split[4])) continue;
            resultList.add(split[1]);
            resultList.add(split[3]);
            break;
        }
        return resultList;
    }

    public static List<String> querySharePlanByOrgIdsAndTaxsystemZt(List<Long> orgList, long taxsystemId, String zt, String taxtype) {
        ArrayList<String> resultList = new ArrayList<String>(2);
        Map<String, Set<Long>> sharePlanByOrgIds = ItpJtPlanBussiness.querySharePlanByOrgIds(orgList);
        if (ObjectUtils.isEmpty(sharePlanByOrgIds)) {
            return resultList;
        }
        for (Map.Entry<String, Set<Long>> next : sharePlanByOrgIds.entrySet()) {
            String nextKey = next.getKey();
            String[] split = nextKey.split("-");
            if (!String.valueOf(taxsystemId).equalsIgnoreCase(split[0]) || !taxtype.equalsIgnoreCase(split[2]) || !zt.equalsIgnoreCase(split[4])) continue;
            resultList.add(split[1]);
            resultList.add(split[3]);
            break;
        }
        return resultList;
    }

    public static String getProvisionTaxareagroup(Long orgId, Long taxationsysId, Long categoryId, String zt, Date skssqq, Date skssqz) {
        if (ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)taxationsysId) || ObjectUtils.isEmpty((Object)categoryId) || ObjectUtils.isEmpty((Object)zt) || ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
            return "0";
        }
        List<String> jtPlanList = ItpJtPlanBussiness.querySharePlanByOrgIdsAndTaxsystemZt(Collections.singletonList(orgId), taxationsysId, categoryId.toString(), zt, skssqq, skssqz);
        if (ObjectUtils.isNotEmpty(jtPlanList)) {
            return jtPlanList.get(0);
        }
        if (taxationsysId == 1L) {
            return "1708040530098667520";
        }
        return "0";
    }

    public static String getProvisionTaxareagroup(Long orgId, Long taxationsysId, String zt) {
        if (ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)taxationsysId) || ObjectUtils.isEmpty((Object)zt)) {
            return "0";
        }
        List<String> jtPlanList = ItpJtPlanBussiness.querySharePlanByOrgIdsAndTaxsystemZt(Collections.singletonList(orgId), taxationsysId, zt, "3");
        if (ObjectUtils.isNotEmpty(jtPlanList)) {
            return jtPlanList.get(0);
        }
        if (taxationsysId == 1L) {
            return "1708040530098667520";
        }
        return "0";
    }

    public static String getProvisionPeriod(Long orgId, Long taxationsysId, String zt) {
        if (ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)taxationsysId) || ObjectUtils.isEmpty((Object)zt)) {
            return null;
        }
        List<String> jtPlanList = ItpJtPlanBussiness.querySharePlanByOrgIdsAndTaxsystemZt(Collections.singletonList(orgId), taxationsysId, zt, "3");
        if (ObjectUtils.isNotEmpty(jtPlanList)) {
            return jtPlanList.get(1);
        }
        return null;
    }

    public static String getProvisionPeriod(Long orgId, Long taxationsysId, Long taxtype, String zt, Date skssqq, Date skssqz) {
        if (ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)taxationsysId) || ObjectUtils.isEmpty((Object)taxtype) || ObjectUtils.isEmpty((Object)zt) || ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
            return null;
        }
        List<String> jtPlanList = ItpJtPlanBussiness.querySharePlanByOrgIdsAndTaxsystemZt(Collections.singletonList(orgId), taxationsysId, taxtype.toString(), zt, skssqq, skssqz);
        if (ObjectUtils.isNotEmpty(jtPlanList)) {
            return jtPlanList.get(1);
        }
        return null;
    }

    public static Map<String, Date> preTaxPeriod(String provisionPeriod, Date now) {
        Date endDate;
        Date startDate;
        HashMap<String, Date> result = new HashMap<String, Date>();
        Date xtqDate = DateUtils.addMonth((Date)now, (int)-1);
        if ("season".equals(provisionPeriod)) {
            Date date = DateUtils.addMonth((Date)now, (int)-3);
            startDate = DateUtils.getFirstDateOfSeason((Date)date);
            endDate = DateUtils.getLastDateOfSeason((Date)date);
        } else if ("year".equals(provisionPeriod)) {
            startDate = DateUtils.getFirstDateOfYear((Date)now);
            endDate = DateUtils.getLastDateOfYear((Date)now);
        } else {
            startDate = DateUtils.getFirstDateOfMonth((Date)xtqDate);
            endDate = kd.taxc.bdtaxr.common.utils.date.DateUtils.getDayFirst((Date)DateUtils.getLastDateOfMonth((Date)xtqDate));
        }
        result.put("startDate", startDate);
        result.put("endDate", endDate);
        return result;
    }
}

