/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.rule;

import java.util.Date;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.rule.RuleAccessConfigService;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.rule.dto.RuleAccessDetailDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.itp.business.rule.ItpDraftEngineServiceImpl;
import org.apache.commons.lang3.ObjectUtils;

public class ItpDraftDynEngineServiceImpl
extends ItpDraftEngineServiceImpl {
    private static Log logger = LogFactory.getLog(ItpDraftDynEngineServiceImpl.class);

    public ItpDraftDynEngineServiceImpl() {
        this.accessConfigEntityName = "itp_accessconfig";
    }

    @Override
    protected RuleAccessConfigService registerRuleAccessConfigService() {
        return ItpDraftDynEngineServiceImpl.getRuleFetchBusiness();
    }

    public RuleFetchMainDto businessHandler(RuleEngineParamDto engineParamDto) {
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto(engineParamDto.getTaxOrgId(), engineParamDto.getSkssqq(), engineParamDto.getSkssqz(), engineParamDto.getTemplateId(), engineParamDto.getDraftPurpose());
        Map orgMatchAccessConfigMap = this.getAllOrgMatchAccessConfigMap(engineParamDto);
        ruleFetchMainDto = this.handleBuildRuleFetchMainDto(engineParamDto, this.getAllOrgAccessAmount(engineParamDto, orgMatchAccessConfigMap));
        return ruleFetchMainDto;
    }

    @Override
    protected Date[] timeConversionBeforeCustomSourceQuery(RuleEngineParamDto engineParamDto, RuleAccessDetailDto detailRowDto) {
        Date customsourceSkssqz;
        Date customsourceSkssqq;
        boolean convertDate = true;
        if (ObjectUtils.isNotEmpty((Object)detailRowDto)) {
            boolean bl = convertDate = !"snzhqs".equals(detailRowDto.getAdvancedConfJson());
        }
        if ((customsourceSkssqq = (Date)engineParamDto.getExtendParams().get("customsource_skssqq")) == null) {
            Date date = customsourceSkssqq = convertDate ? DateUtils.getFirstDateOfYear((Date)engineParamDto.getSkssqq()) : engineParamDto.getSkssqq();
            if (!convertDate) {
                try {
                    String filterString;
                    boolean flag;
                    if (ObjectUtils.isNotEmpty((Object)detailRowDto.getConditionJson()) && (flag = (filterString = FilterBuilderUtils.buildFilter((String)detailRowDto.getConditionJson(), (String)MultiTableEnum.TSD001.getDeclareMainTable()).toString()).contains("isadjustperiod = '1'"))) {
                        customsourceSkssqq = engineParamDto.getSkssqz();
                    }
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                }
            }
        }
        if ((customsourceSkssqz = (Date)engineParamDto.getExtendParams().get("customsource_skssqz")) == null) {
            customsourceSkssqz = engineParamDto.getSkssqz();
        }
        return new Date[]{customsourceSkssqq, customsourceSkssqz};
    }
}

