/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.rule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.business.rule.RuleAccessConfigService;
import kd.taxc.bdtaxr.business.rule.impl.AbstractRuleEngineService;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCardDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchDetailDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.rule.dto.RuleAccessDetailDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.itp.business.fetchdata.ItpFetchDataBussiness;
import kd.taxc.itp.business.rule.ItpDraftAccessConfigServiceImpl;
import kd.taxc.itp.business.taxorg.ItpTaxcOrgGroupCommonBusiness;
import kd.taxc.itp.common.constant.DraftConstant;
import org.apache.commons.lang3.ObjectUtils;

public class ItpDraftEngineServiceImpl
extends AbstractRuleEngineService {
    private static Log logger = LogFactory.getLog(ItpDraftEngineServiceImpl.class);

    public ItpDraftEngineServiceImpl() {
        this.accessConfigEntityName = "itp_accessconfig";
    }

    public static RuleAccessConfigService getRuleFetchBusiness() {
        return RuleAccessConfigServiceInner.ruleFetchBusiness;
    }

    protected RuleAccessConfigService registerRuleAccessConfigService() {
        return ItpDraftEngineServiceImpl.getRuleFetchBusiness();
    }

    protected Date[] timeConversionBeforeCustomSourceQuery(RuleEngineParamDto engineParamDto, RuleAccessDetailDto detailRowDto) {
        Date customsourceSkssqz;
        Date customsourceSkssqq;
        DynamicObject accessConfigObject = detailRowDto.getAccessConfigObject();
        if (ObjectUtils.isNotEmpty((Object)accessConfigObject) && ObjectUtils.isNotEmpty((Object)accessConfigObject.getString("accessproject.id")) && ItpFetchDataBussiness.FETCH_XXYHQY_ID.equals(accessConfigObject.getString("accessproject.id"))) {
            Date skssqq = engineParamDto.getSkssqq();
            Date skssqz = engineParamDto.getSkssqz();
            if (ObjectUtils.isNotEmpty((Object)skssqq) && ObjectUtils.isNotEmpty((Object)skssqz) && DateUtils.getMonthOfDate((Date)skssqz) - DateUtils.getMonthOfDate((Date)skssqq) == 2) {
                return new Date[]{DateUtils.getFirstDateOfMonth((Date)skssqz), skssqz};
            }
        }
        boolean convertDate = true;
        if (ObjectUtils.isNotEmpty((Object)detailRowDto)) {
            boolean bl = convertDate = !"snzhqs".equals(detailRowDto.getAdvancedConfJson());
        }
        if ((customsourceSkssqq = (Date)engineParamDto.getExtendParams().get("customsource_skssqq")) == null) {
            Date date = customsourceSkssqq = convertDate ? DateUtils.getFirstDateOfYear((Date)engineParamDto.getSkssqq()) : engineParamDto.getSkssqq();
            if (!convertDate) {
                try {
                    String filterString;
                    boolean flag;
                    if (ObjectUtils.isNotEmpty((Object)detailRowDto.getConditionJson()) && (flag = (filterString = FilterBuilderUtils.buildFilter((String)detailRowDto.getConditionJson(), (String)MultiTableEnum.TSD001.getDeclareMainTable()).toString()).contains("isadjustperiod = '1'"))) {
                        customsourceSkssqq = engineParamDto.getSkssqz();
                    }
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                }
            }
        }
        if ((customsourceSkssqz = (Date)engineParamDto.getExtendParams().get("customsource_skssqz")) == null) {
            customsourceSkssqz = engineParamDto.getSkssqz();
        }
        return new Date[]{customsourceSkssqq, customsourceSkssqz};
    }

    protected List<RuleEngineParamDto> handleSummaryTaxOrgList(RuleEngineParamDto ruleEngineParamDto) {
        ArrayList<RuleEngineParamDto> allSummaryTaxOrglist = new ArrayList<RuleEngineParamDto>();
        allSummaryTaxOrglist.add(ruleEngineParamDto);
        QFilter orgIdFilter = new QFilter("orgrow.orgid", "=", (Object)ruleEngineParamDto.getTaxOrgId());
        QFilter declarationFilter = new QFilter("orgrow.declaration", "=", (Object)"2");
        QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
        Date skssqq = ruleEngineParamDto.getSkssqq();
        Date skssqz = ruleEngineParamDto.getSkssqz();
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        DynamicObjectCollection collection = ItpTaxcOrgGroupCommonBusiness.queryOrgGroupByDeclaration(ruleEngineParamDto.getTaxOrgId(), "2", "qysds", "2");
        List<Long> idList = collection.stream().filter(o -> null != DateUtils.getIntersectionDate((Date)o.getDate("effectdate"), (Date)o.getDate("invaliddate"), (Date)skssqq, (Date)skssqz)).map(s -> s.getLong("id")).distinct().collect(Collectors.toList());
        if (ObjectUtils.isNotEmpty(idList)) {
            QFilter idQ = new QFilter("id", "in", idList);
            List<DynamicObject> dynamicObjects = ItpTaxcOrgGroupCommonBusiness.queryOrgGroupByIdsAndDeclaration(idList, "3");
            List orgids = dynamicObjects.stream().map(o -> o.getLong("orgrow.orgid")).collect(Collectors.toList());
            orgids.stream().forEach(row -> allSummaryTaxOrglist.add(new RuleEngineParamDto(Long.getLong("orgrow.orgid"), ruleEngineParamDto.getSkssqq(), ruleEngineParamDto.getSkssqz(), ruleEngineParamDto.getTemplateId(), ruleEngineParamDto.getAccessWhereFilter(), ruleEngineParamDto.getSharingPlanWhereFilter(), ruleEngineParamDto.getExtendParams(), ruleEngineParamDto.getDraftPurpose())));
        }
        return allSummaryTaxOrglist;
    }

    protected RuleFetchMainDto handleBuildRuleFetchMainDto(RuleEngineParamDto engineParamDto, List<Map<Long, List<Map<String, List<RuleAccessDetailDto>>>>> allOrgAccessResult) {
        Date originalSkssqq = (Date)engineParamDto.getExtendParams().get("originalSkssqq");
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto(engineParamDto.getTaxOrgId(), originalSkssqq, engineParamDto.getSkssqz(), engineParamDto.getTemplateId(), engineParamDto.getDraftPurpose());
        HashSet<String> accessProjectIdList = new HashSet<String>();
        allOrgAccessResult.stream().forEach(orgMap -> orgMap.entrySet().stream().forEach(orgEntry -> ((List)orgEntry.getValue()).stream().forEach(ruleRow -> ruleRow.entrySet().stream().forEach(accessDetailList -> ((List)accessDetailList.getValue()).forEach(detailDto -> accessProjectIdList.add(detailDto.getAccessConfigObject().getString(this.accessConfig_ProjectId)))))));
        Map<String, String> rowColumnAccessProjectMap = this.getReportItemAccessProjectMap(engineParamDto, accessProjectIdList);
        HashMap cellSummaryDtoMap = new HashMap();
        allOrgAccessResult.stream().forEach(orgMap -> orgMap.entrySet().stream().forEach(orgEntry -> {
            Long orgId = (Long)orgEntry.getKey();
            List singleOrgAllAccessResultList = (List)orgEntry.getValue();
            for (Map singleAccessConfigResultMap : singleOrgAllAccessResultList) {
                singleAccessConfigResultMap.entrySet().stream().filter(entry -> StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)this.entryentity)).forEach(entry -> {
                    List accessDetailDtoList = (List)entry.getValue();
                    ArrayList<RuleFetchDetailDto> ruleFetchDetailDtoList = new ArrayList<RuleFetchDetailDto>(accessDetailDtoList.size());
                    BigDecimal sumFetchAmount = BigDecimal.ZERO;
                    BigDecimal sumOriginAmount = BigDecimal.ZERO;
                    DynamicObject accessConfigObject = null;
                    for (RuleAccessDetailDto accessDetailDto : accessDetailDtoList) {
                        if (ObjectUtils.isEmpty(accessConfigObject)) {
                            accessConfigObject = accessDetailDto.getAccessConfigObject();
                        }
                        RuleFetchDetailDto fetchDetailDto = new RuleFetchDetailDto(accessDetailDto.getSkssqq(), accessDetailDto.getSkssqz(), accessDetailDto.getBizName(), accessDetailDto.getDataSource(), accessDetailDto.getAmountField(), accessDetailDto.getBaseDataType(), accessDetailDto.getFetchType(), accessDetailDto.getFetchDirection(), accessDetailDto.getFetchAmount(), accessDetailDto.getOriginAmount(), accessDetailDto.getAbsolute(), accessDetailDto.getFilterCondition());
                        if (ObjectUtils.isNotEmpty((Object)accessConfigObject) && ObjectUtils.isNotEmpty((Object)accessConfigObject.getString("accessproject.id")) && ItpFetchDataBussiness.FETCH_XXYHQY_ID.equals(accessConfigObject.getString("accessproject.id"))) {
                            Date skssqz = engineParamDto.getSkssqz();
                            fetchDetailDto.setSkssqq(DateUtils.getFirstDateOfMonth((Date)skssqz));
                        } else {
                            fetchDetailDto.setSkssqq(DateUtils.getFirstDateOfYear((Date)originalSkssqq));
                        }
                        fetchDetailDto.setConditionJson(accessDetailDto.getConditionJson());
                        ruleFetchDetailDtoList.add(fetchDetailDto);
                        sumFetchAmount = sumFetchAmount.add(accessDetailDto.getFetchAmount());
                        sumOriginAmount = sumOriginAmount.add(accessDetailDto.getOriginAmount());
                    }
                    String ruleId = ObjectUtils.isNotEmpty(accessConfigObject) ? accessConfigObject.getString("id") : "";
                    String ruleName = ObjectUtils.isNotEmpty(accessConfigObject) ? accessConfigObject.getString("name") : "";
                    String projectName = ObjectUtils.isNotEmpty((Object)accessConfigObject) ? accessConfigObject.getString(this.accessConfig_ProjectName) : "";
                    String projectId = ObjectUtils.isNotEmpty((Object)accessConfigObject) ? accessConfigObject.getString(this.accessConfig_ProjectId) : "";
                    RuleFetchCardDto cardDto = new RuleFetchCardDto(ruleName, ruleId, ruleName, orgId, sumFetchAmount);
                    cardDto.getRuleFetchDetailList().addAll(ruleFetchDetailDtoList);
                    if (ObjectUtils.isNotEmpty(cellSummaryDtoMap.get(projectId))) {
                        RuleFetchCellSummaryDto cellSummaryDto = (RuleFetchCellSummaryDto)cellSummaryDtoMap.get(projectId);
                        cellSummaryDto.getRuleFetchCardList().add(cardDto);
                        cellSummaryDto.setAmount(cellSummaryDto.getAmount().add(sumFetchAmount));
                        cellSummaryDto.setOriginAmount(cellSummaryDto.getOriginAmount().add(sumOriginAmount));
                        cellSummaryDto.setRuleId(cellSummaryDto.getRuleId() + "#" + ruleId);
                        List cellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
                        if (!cellSummaryList.contains(cellSummaryDto)) {
                            ruleFetchMainDto.getRuleFetchCellSummaryList().add(cellSummaryDto);
                        }
                    } else {
                        ArrayList<RuleFetchCardDto> ruleFetchCardList = new ArrayList<RuleFetchCardDto>();
                        ruleFetchCardList.add(cardDto);
                        RuleFetchCellSummaryDto cellSummaryDto = new RuleFetchCellSummaryDto(this.accessConfigEntityName, ruleId, projectId, (String)rowColumnAccessProjectMap.get(projectId), sumFetchAmount, sumOriginAmount);
                        cellSummaryDto.getRuleFetchCardList().addAll(ruleFetchCardList);
                        ruleFetchMainDto.getRuleFetchCellSummaryList().add(cellSummaryDto);
                        cellSummaryDtoMap.put(projectId, cellSummaryDto);
                    }
                });
            }
        }));
        return ruleFetchMainDto;
    }

    protected void saveOrDelDraftData(RuleFetchMainDto fetchSummaryDtoList) {
    }

    protected Map<String, List<RuleAccessDetailDto>> handleBuildRuleAccessDetailDto(Long orgId, RuleEngineParamDto engineParamDto, DynamicObject accessConfig) {
        Map map = super.handleBuildRuleAccessDetailDto(orgId, engineParamDto, accessConfig);
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            for (RuleAccessDetailDto dto : list) {
                dto.getBaseDataType();
                dto.setConditionJson(this.buildFilter(dto.getAdvancedConfJson(), dto.getConditionJson(), dto.getBaseDataType(), engineParamDto.getTemplateId()));
            }
        }
        return map;
    }

    protected Map<String, String> getReportItemAccessProjectMap(RuleEngineParamDto engineParamDto, Set<String> accessProjectIdList) {
        HashMap<String, String> reportItemAccessProjectMap = new HashMap<String, String>(16);
        reportItemAccessProjectMap.putAll(super.getReportItemAccessProjectMap(engineParamDto, accessProjectIdList));
        reportItemAccessProjectMap.putAll(ItpFetchDataBussiness.getReportItemAccessProjectMap(engineParamDto, accessProjectIdList));
        return reportItemAccessProjectMap;
    }

    public String buildFilter(String advancedConfJson, String conditionjson, String baseDataType, Long templateId) {
        if (StringUtil.isEmpty((CharSequence)conditionjson)) {
            return conditionjson;
        }
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)conditionjson, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        if (StringUtil.equalsIgnoreCase((CharSequence)baseDataType, (CharSequence)"tpo_col_member")) {
            Long template_Id = 0L;
            String template_Number = "";
            String template_type = "";
            if ("snzhqs".equals(advancedConfJson)) {
                template_Id = DraftConstant.sdsjt_jt_id;
                template_Number = "INCOME-TAX-ADJ-JT";
                template_type = "sdsjt_jt";
                if (DraftConstant.sdsjt_bd_id.equals(templateId)) {
                    template_Id = DraftConstant.sdsjt_bd_id;
                    template_type = "sdsjt_bd";
                    template_Number = "INCOME-TAX-ADJ-BD";
                }
            } else {
                template_Id = DraftConstant.jtysbbd_jt_id;
                template_Number = "PRO-DECLARE-THAN-JT";
                template_type = "jtysbbd_jt";
                if (DraftConstant.sdsjt_bd_id.equals(templateId)) {
                    template_Id = DraftConstant.jtysbbd_bd_id;
                    template_type = "jtysbbd_bd";
                    template_Number = "PRO-DECLARE-THAN-BD";
                }
            }
            ArrayList<SimpleFilterRow> filterList = new ArrayList<SimpleFilterRow>();
            FilterValue templateIdFilterValue = new FilterValue();
            templateIdFilterValue.setId(template_Id.toString());
            templateIdFilterValue.setValue((Object)template_Number);
            filterList.add(new SimpleFilterRow("", CompareTypeEnum.EQUAL.getId(), "templateid.number", "", String.valueOf(LogicOperate.AND.getValue()), Collections.singletonList(templateIdFilterValue)));
            FilterValue templateTypeFilterValue = new FilterValue();
            templateTypeFilterValue.setValue((Object)template_type);
            templateTypeFilterValue.setId(template_type);
            filterList.add(new SimpleFilterRow("", CompareTypeEnum.EQUAL.getId(), "templatetype.number", "", String.valueOf(LogicOperate.AND.getValue()), Collections.singletonList(templateTypeFilterValue)));
            filterCondition.getFilterRow().addAll(filterList);
            Map lastConditionMap = ser.serializeToMap((Object)filterCondition, null);
            conditionjson = SerializationUtils.toJsonString((Object)lastConditionMap);
        }
        return conditionjson;
    }

    private static class RuleAccessConfigServiceInner {
        private static final RuleAccessConfigService ruleFetchBusiness = new ItpDraftAccessConfigServiceImpl();

        private RuleAccessConfigServiceInner() {
        }
    }
}

