/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.ruletemplate;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.ruletemplate.RuleTemplateBusiness;
import kd.taxc.bdtaxr.common.constant.EntityV3Constant;
import kd.taxc.bdtaxr.common.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.enums.ruletemplate.RuleCodeEnum;
import kd.taxc.bdtaxr.common.enums.ruletemplate.RuleTypeEnum;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.itp.common.dto.ItpRuleTemplateDto;
import org.apache.commons.lang3.ObjectUtils;

public class ItpRuleTemplateBusiness {
    public static void propertyChanged(PropertyChangedArgs e, ItpRuleTemplateDto itpRuleTemplateDto, IFormView view) {
        IDataModel dataModel = view.getModel();
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (itpRuleTemplateDto.getTable().equals(propertyName)) {
            DynamicObject newValue;
            int rowIndex = changeData.getRowIndex();
            dataModel.setValue(itpRuleTemplateDto.getAbsolute(), null, rowIndex);
            dataModel.setValue(itpRuleTemplateDto.getFiltercondition(), null, rowIndex);
            dataModel.setValue(itpRuleTemplateDto.getConditionjson(), null, rowIndex);
            dataModel.setValue(itpRuleTemplateDto.getAbsolute(), (Object)Boolean.FALSE, rowIndex);
            dataModel.setValue(itpRuleTemplateDto.getAmountfield(), null, rowIndex);
            IDataEntityProperty property = dataModel.getProperty(itpRuleTemplateDto.getAdvancedconf());
            if (property != null) {
                dataModel.setValue(itpRuleTemplateDto.getAdvancedconf(), null, rowIndex);
            }
            if ((newValue = (DynamicObject)changeData.getNewValue()) != null) {
                String entityname = newValue.getString("entityname");
                if (EntityV3Constant.ENTITY_V3.containsKey(entityname)) {
                    dataModel.setValue(itpRuleTemplateDto.getBasedatatype(), (Object)"tpo_col_member", rowIndex);
                } else {
                    dataModel.setValue(itpRuleTemplateDto.getBasedatatype(), (Object)"tctb_datasource_entry", rowIndex);
                }
            }
        } else if (itpRuleTemplateDto.getAmountfield().equals(propertyName)) {
            DynamicObject changeField = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = dataModel.getEntryCurrentRowIndex(itpRuleTemplateDto.getEntryentity());
            if (changeField == null) {
                return;
            }
            DynamicObject tableValue = (DynamicObject)dataModel.getValue(itpRuleTemplateDto.getTable(), rowIndex);
            if (tableValue != null) {
                Optional<DynamicObject> first;
                String entityname = tableValue.getString("entityname");
                if (EntityV3Constant.ENTITY_V3.containsKey(entityname)) {
                    dataModel.setValue(itpRuleTemplateDto.getAbsolute(), (Object)Boolean.FALSE, rowIndex);
                } else {
                    String value = changeField.getString("fieldname");
                    DynamicObject obj = ItpRuleTemplateBusiness.queryDatasourceEntry(tableValue, value);
                    if (obj != null) {
                        String table = obj.getString("fieldsubname");
                        BiPredicate<String, String> tdmBalance = ItpRuleTemplateBusiness.predicate("tdm_balance_new", Lists.newArrayList((Object[])new String[]{"closinglocalcurrency", "openinglocalcurrency"}));
                        BiPredicate<String, String> glBalance = ItpRuleTemplateBusiness.predicate("gl_balance", Lists.newArrayList((Object[])new String[]{"beginlocal", "endlocal"}));
                        if (tdmBalance.test(table, value) || glBalance.test(table, value)) {
                            dataModel.setValue(itpRuleTemplateDto.getAbsolute(), (Object)Boolean.TRUE, rowIndex);
                        } else {
                            dataModel.setValue(itpRuleTemplateDto.getAbsolute(), (Object)Boolean.FALSE, rowIndex);
                        }
                    }
                }
                DynamicObject amountfield = (DynamicObject)dataModel.getValue(itpRuleTemplateDto.getAmountfield(), rowIndex);
                long entryId = amountfield.getLong("id");
                String defaultValue = null;
                if (EntityV3Constant.ENTITY_V3.containsKey(tableValue.getString("entityname"))) {
                    first = tableValue.getDynamicObjectCollection("entryentity").stream().filter(o -> "column".equals(o.getString("fieldname"))).findFirst();
                    if (first.isPresent()) {
                        amountfield = first.get();
                    }
                    defaultValue = ItpRuleTemplateBusiness.getDefaultAdvanceFromFormParams(tableValue.getLong("id"), null, view);
                } else {
                    first = tableValue.getDynamicObjectCollection("entryentity").stream().filter(o -> entryId == o.getLong("id")).findFirst();
                    if (first.isPresent()) {
                        amountfield = first.get();
                    }
                }
                if (amountfield != null) {
                    RuleTemplateBusiness.setAdvanceConfDefaultValue((IDataModel)dataModel, (int)rowIndex, (DynamicObject)tableValue, (DynamicObject)amountfield, (String)itpRuleTemplateDto.getAdvancedconf(), (String)itpRuleTemplateDto.getAdvancedconfjson(), (String)defaultValue);
                }
            }
        }
    }

    public static void beforeDoOperation(BeforeDoOperationEventArgs args, IFormView formView, ItpRuleTemplateDto itpRuleTemplateDto, IFormPlugin formPlugin) {
        if (args.getSource() instanceof Donothing && ((Donothing)args.getSource()).getOperateKey().endsWith(itpRuleTemplateDto.getSuffix())) {
            EntryGrid entryentity = (EntryGrid)formView.getControl(itpRuleTemplateDto.getEntryentity());
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)formView.getModel().getValue(itpRuleTemplateDto.getTable(), focusRow);
            if (tabletype == null) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"ItpRuleTemplateBusiness_0", (String)"taxc-itp", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String ischild = tabletype.getString("ischild");
            String entityNumber = tabletype.getString("name");
            if (itpRuleTemplateDto.getSetting().equals(((Donothing)args.getSource()).getOperateKey())) {
                if ("false".equals(ischild) && StringUtil.isNotBlank((CharSequence)tabletype.getString("subname"))) {
                    entityNumber = tabletype.getString("subname");
                }
                ItpRuleTemplateBusiness.openSettingPage(focusRow, tabletype.getLong("id"), entityNumber, itpRuleTemplateDto.getEntryentity(), itpRuleTemplateDto.getConditionjson(), itpRuleTemplateDto.getFiltercondition(), itpRuleTemplateDto.getSetting(), formView, formPlugin);
            } else if (itpRuleTemplateDto.getSetadvancedconf().equals(((Donothing)args.getSource()).getOperateKey())) {
                ItpRuleTemplateBusiness.operateAdvanceConfig(args, formView, itpRuleTemplateDto, formPlugin);
            }
        }
    }

    public static String getDefaultAdvanceFromFormParams(Long datasourceId, String filedKey, IFormView formView) {
        String key1 = datasourceId + "_" + filedKey;
        String defaultValue = (String)formView.getFormShowParameter().getCustomParam(key1);
        if (StringUtil.isNotEmpty((CharSequence)defaultValue)) {
            return defaultValue;
        }
        String key2 = datasourceId + "_*";
        return (String)formView.getFormShowParameter().getCustomParam(key2);
    }

    public static void openSettingPage(int rowIndex, long entityId, String entityNumber, String entityfield, String conditionjson, String filtercondition, String actionId, IFormView formView, IFormPlugin formPlugin) {
        DynamicObject org;
        IDataEntityProperty orgProperty;
        DynamicObject selectedRow = formView.getModel().getEntryRowEntity(entityfield, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filterconditions");
        CloseCallBack closeCallBack = new CloseCallBack(formPlugin, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        formshowParameter.setCustomParam("description", selectedRow.get(filtercondition));
        Object ruleType = formView.getFormShowParameter().getCustomParams().get("ruletype");
        if (null != ruleType) {
            formshowParameter.setCustomParam("ruletype", ruleType);
        }
        if ((orgProperty = formView.getModel().getProperty("org")) != null && (org = (DynamicObject)formView.getModel().getValue("org")) != null) {
            formshowParameter.setCustomParam("orgid", (Object)org.getString("id"));
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formView.showForm(formshowParameter);
    }

    public static void operateAdvanceConfig(BeforeDoOperationEventArgs args, IFormView formView, ItpRuleTemplateDto itpRuleTemplateDto, IFormPlugin formPlugin) {
        EntryGrid entryentity = (EntryGrid)formView.getControl(itpRuleTemplateDto.getEntryentity());
        int focusRow = entryentity.getEntryState().getFocusRow();
        String advancedconfjson = (String)formView.getModel().getValue(itpRuleTemplateDto.getAdvancedconfjson(), focusRow);
        String datatype = (String)formView.getModel().getValue(itpRuleTemplateDto.getDatatype(), focusRow);
        BigDecimal vatrate = BigDecimal.ZERO;
        if (datatype.equals("jsflqs") || datatype.equals("cysldsqs")) {
            vatrate = (BigDecimal)formView.getModel().getValue(itpRuleTemplateDto.getVatrate(), focusRow);
        }
        AdvanceConfDto advanceConfDto = new AdvanceConfDto(advancedconfjson, datatype, vatrate);
        ItpRuleTemplateBusiness.operationConfigClick(formView.getModel(), formView, advanceConfDto, args, entryentity, formPlugin, itpRuleTemplateDto);
    }

    public static void setRuleConfig(BeforeF7SelectEvent evt, IDataModel dataModel, IFormView formView, ItpRuleTemplateDto itpRuleTemplateDto) {
        String fieldName = evt.getProperty().getName();
        int rowIndex = dataModel.getEntryCurrentRowIndex(itpRuleTemplateDto.getEntryentity());
        if (fieldName.equals(itpRuleTemplateDto.getAmountfield())) {
            DynamicObject tabletype = (DynamicObject)dataModel.getValue(itpRuleTemplateDto.getTable(), rowIndex);
            if (tabletype == null) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"ItpRuleTemplateBusiness_0", (String)"taxc-itp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String entityname = tabletype.getString("entityname");
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            if (!EntityV3Constant.ENTITY_V3.containsKey(entityname)) {
                DynamicObject taxation;
                QFilter id = new QFilter("tableid", "=", tabletype.get("id")).and("state", "=", (Object)"1").and("isamount", "=", (Object)"1");
                formShowParameter.getListFilterParameter().setFilter(id);
                String entityName = ((BasedataEdit)evt.getSource()).getView().getFormShowParameter().getFormId();
                if (RuleTypeEnum.REDUCE.getEntry().equals(entityName) && "tdm_balance_new".equals(tabletype.get("name"))) {
                    QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                    formShowParameter.getListFilterParameter().setFilter(fieldFilter);
                }
                if (RuleTypeEnum.INCOME.getEntry().equals(entityName) && null != (taxation = (DynamicObject)dataModel.getValue("taxation")) && taxation.getString("number").equals("MS") && "tdm_balance_new".equals(tabletype.get("name"))) {
                    QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                    formShowParameter.getListFilterParameter().setFilter(fieldFilter);
                }
            } else {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u5217\u7ef4\u6210\u5458\u9009\u62e9", (String)"ItpRuleTemplateBusiness_1", (String)"taxc-itp", (Object[])new Object[0]));
            }
        }
        if (fieldName.equals(itpRuleTemplateDto.getTable())) {
            String formId;
            String ruleType;
            DynamicObject org;
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            IDataEntityProperty property = dataModel.getProperty("org");
            if (property != null && (org = (DynamicObject)dataModel.getValue("org")) != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            if (StringUtil.isNotBlank((CharSequence)(ruleType = RuleCodeEnum.getRuleType((String)(formId = formView.getFormShowParameter().getFormId()))))) {
                QFilter filter = new QFilter("basedataid.billno", "=", (Object)ruleType);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
            }
        }
    }

    public static void operationConfigClick(IDataModel dataModel, IFormView formView, AdvanceConfDto advanceConfDto, BeforeDoOperationEventArgs args, EntryGrid entryentity, IFormPlugin plugin, ItpRuleTemplateDto itpRuleTemplateDto) {
        int focusRow = entryentity.getEntryState().getFocusRow();
        DynamicObject tabletype = (DynamicObject)dataModel.getValue(itpRuleTemplateDto.getTable(), focusRow);
        DynamicObject amountfield = (DynamicObject)dataModel.getValue(itpRuleTemplateDto.getAmountfield(), focusRow);
        String entitySuffix = ((Donothing)args.getSource()).getOperateKey();
        entitySuffix = entitySuffix.replace(itpRuleTemplateDto.getSetadvancedconf(), "");
        if (amountfield == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d6\u6570\u5b57\u6bb5\u3002", (String)"ItpRuleTemplateBusiness_2", (String)"taxc-itp", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Long fieldEntityId = null;
        if (EntityV3Constant.ENTITY_V3.containsKey(tabletype.getString("entityname"))) {
            Optional<DynamicObject> first = tabletype.getDynamicObjectCollection("entryentity").stream().filter(o -> "column".equals(o.getString("fieldname"))).findFirst();
            if (first.isPresent()) {
                fieldEntityId = first.get().getLong("id");
            }
        } else {
            fieldEntityId = amountfield.getLong("id");
        }
        if (fieldEntityId != null) {
            QFilter tableFilter = new QFilter("id", "=", (Object)tabletype.getLong("id"));
            QFilter fieldFilter = new QFilter("entryentity.id", "=", (Object)fieldEntityId);
            DynamicObject obj = QueryServiceHelper.queryOne((String)"tctb_custom_datasource", (String)"entryentity.accesslogic", (QFilter[])new QFilter[]{tableFilter, fieldFilter});
            if (ObjectUtils.isNotEmpty((Object)obj)) {
                ItpRuleTemplateBusiness.openAdvancedConfPage(advanceConfDto, formView, focusRow, tabletype.getLong("id"), itpRuleTemplateDto.getSetadvancedconf() + entitySuffix, plugin, obj.getString("entryentity.accesslogic"));
            }
        }
    }

    private static void openAdvancedConfPage(AdvanceConfDto advanceConfDto, IFormView formView, int rowIndex, long entityId, String actionId, IFormPlugin plugin, String accesslogic) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_advancedconf");
        CloseCallBack closeCallBack = new CloseCallBack(plugin, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formshowParameter.getCustomParams().put("advancedConfData", accesslogic);
        formshowParameter.getCustomParams().put("advancedConfValue", advanceConfDto.getAdvancedconfjson());
        formshowParameter.getCustomParams().put("datatype", advanceConfDto.getDatatype());
        formshowParameter.getCustomParams().put("vatrate", advanceConfDto.getVatrate());
        formshowParameter.getCustomParams().put("yzvatrate", advanceConfDto.getYzvatrate());
        formshowParameter.getCustomParams().put("jsbl", advanceConfDto.getJsbl());
        formshowParameter.getCustomParams().put("advanceconfKey", advanceConfDto.getAdvanceconfKey());
        formshowParameter.getCustomParams().put("convert_rate_json", advanceConfDto.getConvertExrateJson());
        formshowParameter.getCustomParams().put("onlyRead", advanceConfDto.getOnlyRead());
        formView.showForm(formshowParameter);
    }

    public static void closedCallBack(ClosedCallBackEvent evt, IFormView formView, ItpRuleTemplateDto itpruleTemplatedao) {
        int currentRowIndex;
        Map filterData;
        if (itpruleTemplatedao.getSetting().equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            currentRowIndex = formView.getModel().getEntryCurrentRowIndex(itpruleTemplatedao.getEntryentity());
            formView.getModel().setValue(itpruleTemplatedao.getFiltercondition(), filterData.get("filterdescription"), currentRowIndex);
            formView.getModel().setValue(itpruleTemplatedao.getConditionjson(), filterData.get("filtervalue"), currentRowIndex);
        }
        if (itpruleTemplatedao.getSetadvancedconf().equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            Object datatype;
            currentRowIndex = formView.getModel().getEntryCurrentRowIndex(itpruleTemplatedao.getEntryentity());
            formView.getModel().setValue(itpruleTemplatedao.getAdvancedconf(), filterData.get("advancedconf"), currentRowIndex);
            formView.getModel().setValue(itpruleTemplatedao.getAdvancedconfjson(), filterData.get("advancedconfjson"), currentRowIndex);
            if (formView.getModel().getDataEntityType().getAllFields().containsKey("exratejson")) {
                formView.getModel().setValue("exratejson", filterData.get("convert_rate_json"), currentRowIndex);
            }
            if ((datatype = formView.getModel().getValue(itpruleTemplatedao.getDatatype(), currentRowIndex)).equals("jsflqs") || datatype.equals("cysldsqs") || datatype.equals("sehshsj")) {
                formView.getModel().setValue(itpruleTemplatedao.getVatrate(), filterData.get("vatrate"), currentRowIndex);
            } else if (datatype.equals("gjqs")) {
                formView.getModel().setValue("jsbl", filterData.get("jsbl"), currentRowIndex);
            } else if (datatype.equals("yjjsflqs")) {
                formView.getModel().setValue(itpruleTemplatedao.getVatrate(), filterData.get("vatrate"), currentRowIndex);
                formView.getModel().setValue("yzvatrate", filterData.get("yzvatrate"), currentRowIndex);
            }
        }
    }

    private static String[] splitSelectKey(String selectKey) {
        String[] key = selectKey.split(",");
        return key;
    }

    private static BiPredicate<String, String> predicate(String table, List<String> columns) {
        BiPredicate<String, String> predicate = (table1, amountValue1) -> table.equals(table1) && columns.contains(amountValue1);
        return predicate;
    }

    private static DynamicObject queryDatasourceEntry(DynamicObject tableValue, String value) {
        QFilter tableIdQfilter = new QFilter("tableid", "=", tableValue.get("id"));
        QFilter fieldnameQfilter = new QFilter("fieldname", "=", (Object)value);
        return QueryServiceHelper.queryOne((String)"tctb_datasource_entry", (String)"fieldsubname", (QFilter[])new QFilter[]{tableIdQfilter, fieldnameQfilter});
    }
}

