/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.business.taxorg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.IFormView;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.perm.PermDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.view.ViewDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ItpTaxOrgCommonBusiness {
    public static boolean isTaxcMainByOrgId(Long orgId) {
        TaxResult taxcMainByOrgId = TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgId);
        if (!ObjectUtils.isEmpty((Object)taxcMainByOrgId) && taxcMainByOrgId.isSuccess() && ((Boolean)taxcMainByOrgId.getData()).booleanValue()) {
            return (Boolean)taxcMainByOrgId.getData();
        }
        return false;
    }

    public static List<Long> queryTaxcOrgIdWithPerm(IFormView view) {
        TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdWithPerm((Long)RequestContext.get().getCurrUserId(), (String)view.getFormShowParameter().getAppId(), (String)view.getEntityId(), (String)"47150e89000000ac", null);
        if (listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            return (List)listTaxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public static List<Long> queryOrgIdByViewWithPerm(String viewNumber) {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)RequestContext.get().getCurrUserId(), (String)viewNumber);
        if (taxResult.isSuccess() && !ObjectUtils.isEmpty((Object)taxResult.getData())) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public static List<Long> getAllPermOrgs(IFormView view, String permItemId) {
        TaxResult permOrgs = PermDataServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)view.getFormShowParameter().getAppId(), (String)view.getEntityId(), (String)permItemId);
        if (permOrgs.isSuccess() && !ObjectUtils.isEmpty((Object)permOrgs.getData())) {
            return (List)permOrgs.getData();
        }
        return new ArrayList<Long>();
    }

    public static DynamicObject queryTaxcMainByOrgId(Long orgId) {
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        if (taxResult.isSuccess() && !ObjectUtils.isEmpty((Object)taxResult.getData())) {
            return (DynamicObject)taxResult.getData();
        }
        return null;
    }

    public static List<Long> queryTaxcMainOrgIdByIsTaxpayerWithPerm() {
        TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), null);
        if (listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            return (List)listTaxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public static List<Long> queryTaxcMain() {
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainByIsTaxpayer(null);
        if (listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            return ((List)listTaxResult.getData()).stream().map(o -> o.getLong("orgid.id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    public static List<DynamicObject> queryTaxcOrgByOrgIds(List<Long> orgIds) {
        TaxResult listTaxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIds(orgIds, null);
        if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            return (List)listTaxResult.getData();
        }
        return new ArrayList<DynamicObject>();
    }

    public static List<Long> queryTaxOrgWithPerm(long userId) {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)userId, (String)"40", (boolean)true);
        if (StringUtil.equalsIgnoreCase((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public static boolean check(IFormView view, String orgId, String appId, String categoryType) {
        if (orgId == null) {
            return true;
        }
        List<Long> taxOrgWithPerm = ItpTaxOrgCommonBusiness.queryTaxcMainOrgIdByIsTaxpayerWithPerm();
        if (org.apache.commons.lang3.ObjectUtils.isEmpty(taxOrgWithPerm) || !taxOrgWithPerm.contains(Long.valueOf(orgId))) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7eb3\u7a0e\u4e3b\u4f53\u3002", (String)"ItpTaxOrgCommonBusiness_0", (String)"taxc-itp", (Object[])new Object[0]));
            return true;
        }
        TaxResult taxResult = TaxcLicenseCheckDataServiceHelper.check((Long)Long.valueOf(orgId), (String)appId);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)taxResult) && taxResult.isSuccess() && Boolean.TRUE.equals(taxResult.getData())) {
            view.showErrorNotification(taxResult.getMessage());
            return true;
        }
        return false;
    }

    public static boolean check(String orgId, String appId, String categoryType) {
        if (orgId == null) {
            return true;
        }
        if (!ItpTaxOrgCommonBusiness.isTaxcMainByOrgId(Long.parseLong(orgId))) {
            return true;
        }
        TaxResult taxResult = TaxcLicenseCheckDataServiceHelper.check((Long)Long.valueOf(orgId), (String)appId);
        return org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)taxResult) && taxResult.isSuccess() && Boolean.TRUE.equals(taxResult.getData());
    }

    public static Long getParameterSettingValueDefaultOrgId(Long curUserOrgId, Long userId) {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)userId, (String)"40", (boolean)true);
        if (taxResult.isSuccess()) {
            if (((List)taxResult.getData()).contains(curUserOrgId)) {
                return curUserOrgId;
            }
            if (!CollectionUtils.isEmpty((Collection)((Collection)taxResult.getData()))) {
                return (Long)((List)taxResult.getData()).get(0);
            }
        } else {
            return null;
        }
        TaxResult taxResult1 = ViewDataServiceHelper.getRootOrgId();
        if (taxResult1.isSuccess()) {
            return (Long)taxResult1.getData();
        }
        return null;
    }

    public static boolean checkTaxcMainIsHighTechCompany(Long orgId, Long taxationsys, Date skssqq, Date skssqz) {
        DynamicObject dynamicObject;
        DynamicObjectCollection apitudeentryentity;
        if (taxationsys != 1L) {
            return false;
        }
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(Collections.singletonList(orgId), (Long)taxationsys, (boolean)true);
        if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData()) && !ObjectUtils.isEmpty((Object)(apitudeentryentity = (dynamicObject = (DynamicObject)((List)listTaxResult.getData()).get(0)).getDynamicObjectCollection("apitudeentryentity")))) {
            for (DynamicObject apitudeentry : apitudeentryentity) {
                String apitudetype = apitudeentry.getString("apitudetype");
                String companytype = apitudeentry.getString("companytype.number");
                boolean yxsy = apitudeentry.getBoolean("yxsy");
                Date apitudestartdate = apitudeentry.getDate("apitudestartdate");
                Date apitudeenddate = apitudeentry.getDate("apitudeenddate");
                if (!"4".equals(apitudetype) || !"HT001".equals(companytype) || !yxsy) continue;
                if (ObjectUtils.isEmpty((Object)apitudeenddate)) {
                    if (skssqq.getTime() < apitudestartdate.getTime()) continue;
                    return true;
                }
                if (skssqq.getTime() >= apitudestartdate.getTime() && skssqq.getTime() <= apitudeenddate.getTime()) {
                    return true;
                }
                if (skssqz.getTime() < apitudestartdate.getTime() || skssqz.getTime() > apitudeenddate.getTime()) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Long> queryValidTaxOrg(Long taxationsysId) {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), (Long)taxationsysId, (boolean)true);
        if (StringUtil.equalsIgnoreCase((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public static List<Long> queryTaxcOrgIdByIsTaxpayerWithPerm() {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdsWithPerm((Long)RequestContext.get().getCurrUserId(), null);
        if (!ObjectUtils.isEmpty((Object)taxResult) && taxResult.isSuccess() && !ObjectUtils.isEmpty((Object)taxResult.getData())) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }
}

