/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.common.enums;

import java.math.BigDecimal;

public enum CellValueCalConditionEnum {
    EQUALS{

        @Override
        public boolean checkCondition(BigDecimal value, BigDecimal conditionValue) {
            return value.compareTo(conditionValue) == 0;
        }
    }
    ,
    GREATER_THAN{

        @Override
        public boolean checkCondition(BigDecimal value, BigDecimal conditionValue) {
            return value.compareTo(conditionValue) > 0;
        }
    }
    ,
    GREATER_THAN_OR_EQUALS{

        @Override
        public boolean checkCondition(BigDecimal value, BigDecimal conditionValue) {
            return value.compareTo(conditionValue) >= 0;
        }
    }
    ,
    LESS_THAN{

        @Override
        public boolean checkCondition(BigDecimal value, BigDecimal conditionValue) {
            return value.compareTo(conditionValue) < 0;
        }
    }
    ,
    LESS_THEN_OR_EQUALS{

        @Override
        public boolean checkCondition(BigDecimal value, BigDecimal conditionValue) {
            return value.compareTo(conditionValue) <= 0;
        }
    }
    ,
    TRUE_CONDITION{

        @Override
        public boolean checkCondition(BigDecimal value, BigDecimal conditionValue) {
            return true;
        }
    };


    public abstract boolean checkCondition(BigDecimal var1, BigDecimal var2);
}

