/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.common.enums;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.taxc.itp.common.enums.CellValueCalConditionEnum;

public enum CellValueCalEnum {
    DQSDSZC_NCYE_JE("sjjs_dqsdszc_ncye#sjjs_je", Stream.of("dysds_zsxcy_sh_xm", "dysds_gaapzsxcy_sh_xm").collect(Collectors.toList()), "dysds_ncye_hjje", "dysds_qmye", CellValueCalConditionEnum.GREATER_THAN_OR_EQUALS, BigDecimal.ZERO),
    DQSDSZC_BNYJT_JE("sjjs_dqsdszc_bnyjt#sjjs_je", Stream.of("dysds_zsxcy_sh_xm", "dysds_gaapzsxcy_sh_xm").collect(Collectors.toList()), "dysds_bnbd_hj", "dysds_qmye", CellValueCalConditionEnum.GREATER_THAN_OR_EQUALS, BigDecimal.ZERO),
    DQSDSFZ_NCYE_JE("sjjs_dqsdsfz_ncye#sjjs_je", Stream.of("dysds_zsxcy_sh_xm", "dysds_gaapzsxcy_sh_xm").collect(Collectors.toList()), "dysds_ncye_hjje", "dysds_qmye", CellValueCalConditionEnum.LESS_THAN, BigDecimal.ZERO),
    DQSDSFZ_BNYJT_JE("sjjs_dqsdsfz_bnyjt#sjjs_je", Stream.of("dysds_zsxcy_sh_xm", "dysds_gaapzsxcy_sh_xm").collect(Collectors.toList()), "dysds_bnbd_hj", "dysds_qmye", CellValueCalConditionEnum.LESS_THAN, BigDecimal.ZERO);

    private String fixCellKey;
    private List<String> dynCellRowDimension;
    private String dynCellColDimension;
    private String dynConditionCellColDimension;
    private CellValueCalConditionEnum condition;
    private BigDecimal conditionValue;

    private CellValueCalEnum(String fixCellKey, List<String> dynCellRowDimension, String dynCellColDimension, String dynConditionCellColDimension, CellValueCalConditionEnum condition, BigDecimal conditionValue) {
        this.fixCellKey = fixCellKey;
        this.dynCellRowDimension = dynCellRowDimension;
        this.dynCellColDimension = dynCellColDimension;
        this.dynConditionCellColDimension = dynConditionCellColDimension;
        this.condition = condition;
        this.conditionValue = conditionValue;
    }

    public static CellValueCalEnum getCellValueCalEnumByCellKey(String cellKey) {
        for (CellValueCalEnum cellValueCalEnum : CellValueCalEnum.values()) {
            if (!cellValueCalEnum.getFixCellKey().equals(cellKey)) continue;
            return cellValueCalEnum;
        }
        return null;
    }

    public String getFixCellKey() {
        return this.fixCellKey;
    }

    public List<String> getDynCellRowDimension() {
        return this.dynCellRowDimension;
    }

    public String getDynCellColDimension() {
        return this.dynCellColDimension;
    }

    public String getDynConditionCellColDimension() {
        return this.dynConditionCellColDimension;
    }

    public CellValueCalConditionEnum getCondition() {
        return this.condition;
    }

    public BigDecimal getConditionValue() {
        return this.conditionValue;
    }
}

