/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.common.model.result;

public class BaseResult<T> {
    public static final Integer OK = 200;
    public static final Integer FAIL = 500;
    public static final Integer ERROR = 502;
    private Integer code;
    private String message;
    private T data;

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public BaseResult() {
    }

    public BaseResult(Integer code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public BaseResult(Integer code, T data) {
        this.code = code;
        this.data = data;
    }

    public BaseResult(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public BaseResult(Integer code) {
        this.code = code;
    }

    public static <T> BaseResult<T> ok(String message) {
        return new BaseResult<T>(OK, message);
    }

    public static <T> BaseResult<T> ok() {
        return new BaseResult<T>(OK);
    }

    public static <T> BaseResult<T> ok(String message, T data) {
        return new BaseResult<T>(OK, message, data);
    }

    public static <T> BaseResult<T> ok(T data) {
        return new BaseResult<T>(OK, data);
    }

    public static <T> BaseResult<T> fail(String message) {
        return new BaseResult<T>(FAIL, message);
    }

    public static <T> BaseResult<T> fail(String message, T data) {
        return new BaseResult<T>(FAIL, message, data);
    }
}

