/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.accessconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.itp.business.taxationsys.ItpTaxationsysCommonBusiness;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ItpJtThanAccessconfigListPlugin
extends AbstractListPlugin {
    private static final String TBL_SHARE = "tblshare";
    private static final String TBL_PRIUSE = "tblpriuse";
    private static final String TBL_COPY = "tblcopy";
    private static final String SPECIFIEDSHARING = "specifiedsharing";
    private static final String TBLENABLE = "tblenable";
    private static final String SPECIFIED_SHARING = "specified_sharing";
    private static final String PUBLIC = "public";
    private static final String NEW_TYPE = "newtype";
    private static final String ONE = "1";

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getCommonFilterColumns();
        for (FilterColumn column : filterColumnList) {
            DynamicObject dynamicObject;
            if (!"taxationsys.name".equals(column.getFieldName()) || ObjectUtils.isEmpty((Object)(dynamicObject = ItpTaxationsysCommonBusiness.querySingleTaxAtionsysByNum(TaxationsysMappingEnum.CHN.getNumber()))) || !StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("name"))) continue;
            column.setDefaultValues(new Object[]{dynamicObject.getString("id")});
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String newtype = this.getPageCache().get(NEW_TYPE);
        String oid = null;
        if (newtype != null) {
            List<Long> taxOrgList;
            if (TBL_SHARE.equalsIgnoreCase(newtype) || TBL_PRIUSE.equalsIgnoreCase(newtype)) {
                this.getPageCache().put(newtype, ONE);
                List orgid = this.getControlFilters().getFilter("org.id");
                oid = orgid != null && orgid.size() == 1 && !"".equalsIgnoreCase(orgid.get(0).toString()) ? String.valueOf(orgid.get(0)) : null;
            } else if (TBL_COPY.equalsIgnoreCase(newtype)) {
                oid = this.getPageCache().get(TBL_COPY);
            }
            if (oid != null && !(taxOrgList = ItpTaxOrgCommonBusiness.queryTaxOrgWithPerm(RequestContext.get().getCurrUserId())).contains(Long.parseLong(oid))) {
                oid = null;
                e.getParameter().setCustomParam("setnull", (Object)true);
            }
            e.getParameter().setCustomParam("orgid", (Object)oid);
            this.getPageCache().put(NEW_TYPE, null);
        }
        if (newtype != null) {
            if (newtype.equalsIgnoreCase(TBL_SHARE)) {
                e.getParameter().getCustomParams().put("ruletype", PUBLIC);
            } else if (newtype.equalsIgnoreCase(TBL_COPY)) {
                this.setRuleType(e);
            }
        } else {
            this.setRuleType(e);
        }
    }

    private void setRuleType(BeforeShowBillFormEvent e) {
        Object[] selectRowsDetails = this.getSelectRowsDetail();
        if (!ObjectUtils.isEmpty((Object[])selectRowsDetails)) {
            Long focusRowPkId = (Long)this.getFocusRowPkId();
            for (Object selectRowsDetail : selectRowsDetails) {
                if (selectRowsDetail.getLong("id") != focusRowPkId.longValue()) continue;
                String ruletype = selectRowsDetail.getString("ruletype");
                e.getParameter().getCustomParams().put("ruletype", ruletype);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBL_SHARE) || StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBL_PRIUSE) || StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBL_COPY)) {
            this.getPageCache().put(NEW_TYPE, itemKey);
            if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBL_COPY) && this.getSelectRowsDetail() != null && this.getSelectRowsDetail().length == 1) {
                this.getPageCache().put(TBL_COPY, String.valueOf(this.getSelectRowsDetail()[0].get("org.id")));
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)SPECIFIEDSHARING)) {
            if (this.getSelectedRows().isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ItpJtThanAccessconfigListPlugin_0", (String)"taxc-itp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject[] dynamicObjects = this.getSelectRowsDetail();
            Arrays.stream(dynamicObjects).forEach(row -> {
                if (!StringUtils.equalsIgnoreCase((CharSequence)row.getString("enable"), (CharSequence)ONE)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u53ef\u7528\u7684\u6570\u636e\u624d\u80fd\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ItpJtThanAccessconfigListPlugin_1", (String)"taxc-itp", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)row.getString("ruletype"), (CharSequence)PUBLIC)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u53ef\u5206\u914d\u89c4\u5219\u624d\u80fd\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ItpJtThanAccessconfigListPlugin_2", (String)"taxc-itp", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            });
        } else if (StringUtil.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBLENABLE)) {
            DynamicObject[] selectedRows = this.getSelectRowsDetail();
            HashSet<Long> privateSet = new HashSet<Long>();
            HashSet<Long> orgSet = new HashSet<Long>();
            HashSet<Long> accessprojectSet = new HashSet<Long>();
            for (DynamicObject o2 : selectedRows) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)o2.getString("ruletype"), (CharSequence)"private")) continue;
                privateSet.add(o2.getLong("id"));
                orgSet.add(o2.getLong("org.id"));
                accessprojectSet.add(o2.getLong("accessproject.id"));
            }
            if (!privateSet.isEmpty()) {
                Arrays.stream(selectedRows).forEach(o -> {
                    privateSet.add(o.getLong("id"));
                    orgSet.add(o.getLong("org.id"));
                    accessprojectSet.add(o.getLong("accessproject.id"));
                });
                QFilter status = new QFilter("enable", "=", (Object)Boolean.TRUE);
                QFilter ruletype = new QFilter("ruletype", "=", (Object)"private");
                QFilter noInid = new QFilter("id", "not in", (Object)privateSet.toArray());
                QFilter org = new QFilter("org", "in", (Object)orgSet.toArray());
                QFilter accessproject = new QFilter("accessproject", "in", (Object)accessprojectSet.toArray());
                QFilter inIdQ = new QFilter("id", "in", (Object)privateSet.toArray());
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"accessconfigList", (String)"itp_jtthan_accessconfig", (String)"org.id org,accessproject.id accessproject", (QFilter[])new QFilter[]{inIdQ, ruletype}, null);
                DataSet smartGroupByDataSet = dataSet.groupBy(new String[]{"org", "accessproject"}).count("total").finish();
                while (smartGroupByDataSet.hasNext()) {
                    Row row2 = smartGroupByDataSet.next();
                    if (row2.getInteger("total") <= 1) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u548c\u53d6\u6570\u9879\u76ee\u76f8\u540c\u65f6\uff0c\u81ea\u7528\u89c4\u5219\u4e0d\u5141\u8bb8\u540c\u65f6\u542f\u7528\u591a\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ItpJtThanAccessconfigListPlugin_3", (String)"taxc-itp", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (QueryServiceHelper.exists((String)"itp_jtthan_accessconfig", (QFilter[])new QFilter[]{status, ruletype, noInid, org, accessproject})) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u548c\u53d6\u6570\u9879\u76ee\u76f8\u540c\u65f6\uff0c\u81ea\u7528\u89c4\u5219\u4e0d\u5141\u8bb8\u540c\u65f6\u542f\u7528\u591a\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ItpJtThanAccessconfigListPlugin_3", (String)"taxc-itp", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if (SPECIFIED_SHARING.equalsIgnoreCase(evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"itp_jtthan_shardingplan", (boolean)true);
            ListSelectedRowCollection accessConfigRows = this.getSelectedRows();
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ListSelectedRow accessConfigRow : accessConfigRows) {
                Long primaryKeyValue = (Long)accessConfigRow.getPrimaryKeyValue();
                ids.add(primaryKeyValue);
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"itp_jtthan_accessconfig", (String)"id,taxationsys.id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            Set collect = dynamicObjects.stream().map(m -> m.getLong("taxationsys.id")).collect(Collectors.toSet());
            if (collect.size() != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u3002", (String)"ItpJtThanAccessconfigListPlugin_4", (String)"taxc-itp", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter("taxationsys", "=", (Object)((DynamicObject)dynamicObjects.get(0)).getLong("taxationsys.id"));
            listShowParameter.getListFilterParameter().setFilter(filter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SPECIFIEDSHARING));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)SPECIFIEDSHARING) && (returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection) {
            StringBuilder message = new StringBuilder();
            ListSelectedRowCollection returnDataRows = (ListSelectedRowCollection)returnData;
            ListSelectedRowCollection accessConfigRows = this.getSelectedRows();
            DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])returnDataRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"itp_jtthan_shardingplan"));
            Arrays.stream(objects).forEach(planObject -> {
                DynamicObjectCollection ruleCollection = planObject.getDynamicObjectCollection("ruleentity");
                List rules = ruleCollection.stream().map(o -> o.getLong("rule.id")).collect(Collectors.toList());
                List ruleNames = ruleCollection.stream().map(o -> o.getString("rule.accessproject.name")).collect(Collectors.toList());
                List seletRules = accessConfigRows.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toList());
                List existsRules = (List)CollectionUtils.intersection(rules, seletRules);
                DynamicObject[] selRules = BusinessDataServiceHelper.load((Object[])seletRules.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"itp_jtthan_accessconfig"));
                HashMap map = new HashMap(8);
                Arrays.stream(selRules).forEach(o -> map.put(o.getLong("id"), o.getString("accessproject.name")));
                accessConfigRows.forEach(o -> {
                    Long id = (Long)o.getPrimaryKeyValue();
                    if (!rules.contains(id) && !ruleNames.contains(map.get(id))) {
                        DynamicObject dynamicObject = ruleCollection.addNew();
                        dynamicObject.set("rule", o.getPrimaryKeyValue());
                    }
                    if (!rules.contains(id) && ruleNames.contains(map.get(id))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848:\u201c%1$s\u201d,\u5b58\u5728\u76f8\u540c\u7684\u53d6\u6570\u9879\u76ee:%2$s\u3002", (String)"ItpJtThanAccessconfigListPlugin_5", (String)"taxc-itp", (Object[])new Object[0]), planObject.getString("name"), map.get(id)));
                        message.append("\r\n");
                    }
                });
                if (!existsRules.isEmpty()) {
                    ArrayList messages = new ArrayList();
                    ruleCollection.forEach(o -> {
                        if (existsRules.contains(o.getLong("rule.id"))) {
                            messages.add(o.getString("rule.number"));
                        }
                    });
                    message.append(String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848:\u201c%1$s\u201d,\u5df2\u914d\u7f6e\u89c4\u5219:%2$s\u3002", (String)"ItpJtThanAccessconfigListPlugin_6", (String)"taxc-itp", (Object[])new Object[0]), planObject.getString("name"), String.join((CharSequence)", ", messages)));
                    message.append("\r\n");
                }
            });
            SaveServiceHelper.save((DynamicObject[])objects);
            if (StringUtils.isNotBlank((CharSequence)message)) {
                this.getView().showTipNotification(message.toString());
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u5171\u4eab\u65b9\u6848\u6210\u529f\u3002", (String)"ItpJtThanAccessconfigListPlugin_8", (String)"taxc-itp", (Object[])new Object[0]));
            }
        }
    }

    private DynamicObject[] getSelectRowsDetail() {
        return BusinessDataServiceHelper.load((Object[])this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"itp_jtthan_accessconfig"));
    }
}

