/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.accessconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.itp.business.ruletemplate.ItpRuleTemplateBusiness;
import kd.taxc.itp.business.taxationsys.ItpTaxationsysCommonBusiness;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;
import kd.taxc.itp.common.dto.ItpRuleTemplateDto;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ItpJtThanAccessconfigPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String TABLE = "table";
    private static final String TAXATION_SYS = "taxationsys";
    private static final String ACCESS_PROJECT = "accessproject";
    private static final String TBL_SHARE = "tblshare";
    private static final String TBL_PRIUSE = "tblpriuse";
    private static final String RULE_TYPE = "ruletype";
    private static final String ONE = "1";
    private static final String ENTRY_ENTITY_1 = "entryentity1";
    private static final String KEY_FILTERCONDITION_1 = "filtercondition1";
    private static final String KEY_CONDITIONJSON_1 = "conditionjson1";
    protected static final String KEY_AMOUNTFIELD_1 = "amountfield1";
    protected static final String KEY_TABLE_1 = "table1";
    private static final ItpRuleTemplateDto itpruleTemplatedao = new ItpRuleTemplateDto("1");
    private static final List<Long> IDS = Arrays.asList(1544973714876405763L, 1544973716101142528L, 1544973716989985792L, 1544973716981946369L, 1544973714876405761L, 1544973714876056577L, 1544973714876405762L, 1544973714876056578L, 1544973718390883330L, 1779061472333143040L, 1544976651065366530L);

    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accessproject = (BasedataEdit)this.getControl(ACCESS_PROJECT);
        accessproject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table = (BasedataEdit)this.getControl(TABLE);
        table.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxationsys = (BasedataEdit)this.getControl(TAXATION_SYS);
        taxationsys.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ItemClassEdit amountfield = (ItemClassEdit)this.getControl("amountfield");
        amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit amountfield1 = (BasedataEdit)this.getControl(KEY_AMOUNTFIELD_1);
        amountfield1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit tablefield = (BasedataEdit)this.getControl(KEY_TABLE_1);
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e", (String)"ItpJtThanAccessconfigPlugin_0", (String)"taxc-itp", (Object[])new Object[0]));
    }

    public void initialize() {
        super.initialize();
        this.getView().getFormShowParameter().getCustomParams().put("1944347182954030080_*", "snzhqs");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ItpRuleTemplateBusiness.propertyChanged(e, itpruleTemplatedao, this.getView());
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (TAXATION_SYS.equals(name)) {
            this.getModel().setValue(ACCESS_PROJECT, null);
        } else if (ACCESS_PROJECT.equalsIgnoreCase(name)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                this.getModel().setValue("name", (Object)newValue.getString("name"));
            } else {
                this.getModel().setValue("name", null);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ItpRuleTemplateBusiness.beforeDoOperation(args, this.getView(), itpruleTemplatedao, (IFormPlugin)this);
    }

    public void afterBindData(EventObject e) {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getView().getParentView().getPageCache().get(TBL_SHARE), (CharSequence)ONE)) {
            this.getModel().setValue(RULE_TYPE, (Object)"public");
            this.getView().getParentView().getPageCache().remove(TBL_SHARE);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getView().getParentView().getPageCache().get(TBL_PRIUSE), (CharSequence)ONE)) {
            this.getModel().setValue(RULE_TYPE, (Object)"private");
            this.getView().getParentView().getPageCache().remove(TBL_PRIUSE);
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ItpRuleTemplateBusiness.setRuleConfig(evt, this.getModel(), this.getView(), itpruleTemplatedao);
        String name = evt.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"org")) {
            List<Long> allTaxOrgs = ItpTaxOrgCommonBusiness.queryTaxcOrgIdWithPerm(this.getView());
            List<Object> orgList = new ArrayList();
            if (allTaxOrgs != null) {
                orgList = allTaxOrgs;
            }
            QFilter idFilter = new QFilter("id", "in", orgList);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getTreeFilterParameter().getQFilters().add(idFilter);
            formShowParameter.getListFilterParameter().getQFilters().add(idFilter);
        } else if (ACCESS_PROJECT.equalsIgnoreCase(name)) {
            DynamicObjectCollection accessconfig;
            Set oldAccessConfigSet;
            DynamicObject taxationsys = (DynamicObject)this.getModel().getValue(TAXATION_SYS);
            if (taxationsys == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"ItpJtThanAccessconfigPlugin_1", (String)"taxc-itp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"ItpJtThanAccessconfigPlugin_2", (String)"taxc-itp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter accessconfigFilter = new QFilter("org", "=", (Object)org.getLong("id")).and(new QFilter(TAXATION_SYS, "=", (Object)taxationsys.getLong("id"))).and(new QFilter(RULE_TYPE, "=", this.getModel().getValue(RULE_TYPE)));
            HashSet<Object> oldAccessConfigs = new HashSet<Object>(12);
            if ("private".equals(this.getModel().getValue(RULE_TYPE)) && !ObjectUtils.isEmpty(oldAccessConfigSet = (accessconfig = QueryServiceHelper.query((String)"itp_jtthan_accessconfig", (String)"id,number,name,taxationsys,accessproject.id", (QFilter[])new QFilter[]{accessconfigFilter})).stream().map(m -> m.getLong("accessproject.id")).collect(Collectors.toSet()))) {
                oldAccessConfigs.addAll(oldAccessConfigSet);
            }
            oldAccessConfigs.addAll(IDS);
            QFilter filter = new QFilter(TAXATION_SYS, "=", (Object)taxationsys.getLong("id")).and(new QFilter("isleaf", "=", (Object)Boolean.TRUE)).and(new QFilter("enable", "=", (Object)ONE));
            if ("private".equals(this.getModel().getValue(RULE_TYPE))) {
                filter.and(new QFilter("id", "not in", oldAccessConfigs));
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id", (QFilter[])new QFilter[]{filter});
            Set ids = query.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter(TAXATION_SYS, "is null", null).or(new QFilter(TAXATION_SYS, "=", (Object)0L));
            DynamicObjectCollection noTaxSystemListFetchItems = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
            Set noTaxSystemListFetchItemIds = noTaxSystemListFetchItems.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
            noTaxSystemListFetchItemIds.removeAll(oldAccessConfigs);
            ids.addAll(noTaxSystemListFetchItemIds);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
            formShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)TABLE)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tctb_datasource_peek_rule", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)"RULE-CIT-WP")});
            Long id = dynamicObject == null ? 0L : dynamicObject.getLong("id");
            QFilter peekrule = new QFilter("peekrule.fbasedataid", "=", (Object)id);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(peekrule);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)TAXATION_SYS)) {
            QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            List<Long> validTaxationsys = ItpTaxationsysCommonBusiness.queryValidTaxationsys();
            qFilter.and("id", "in", validTaxationsys);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)KEY_TABLE_1)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tctb_datasource_peek_rule", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)"RULE-CIT-WP")});
            Long id = dynamicObject == null ? 0L : dynamicObject.getLong("id");
            QFilter peekrule = new QFilter("peekrule.fbasedataid", "=", (Object)id);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(peekrule);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        if (!ObjectUtils.isEmpty(orgid)) {
            this.getModel().setValue("org", orgid);
        }
        if (orgid == null) {
            String defaultOrg = this.getDefaultOrg();
            if (StringUtils.isEmpty((CharSequence)defaultOrg)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ItpJtThanAccessconfigPlugin_3", (String)"taxc-itp", (Object[])new Object[0]));
            } else {
                this.getModel().setValue("org", (Object)Long.parseLong(defaultOrg));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        ItpRuleTemplateBusiness.closedCallBack(evt, this.getView(), itpruleTemplatedao);
    }

    private String getDefaultOrg() {
        String currOrgId = String.valueOf(RequestContext.get().getOrgId());
        List<Long> allTaxOrgs = ItpTaxOrgCommonBusiness.queryTaxcOrgIdWithPerm(this.getView());
        if (!CollectionUtils.isEmpty(allTaxOrgs) && allTaxOrgs.contains(Long.parseLong(currOrgId))) {
            return currOrgId;
        }
        if (!ObjectUtils.isEmpty(allTaxOrgs)) {
            return allTaxOrgs.get(0).toString();
        }
        return null;
    }

    protected void openSettingPage(int rowIndex, long entityId, String entityNumber) {
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(ENTRY_ENTITY_1, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "setting1");
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(KEY_CONDITIONJSON_1));
        formshowParameter.setCustomParam("description", selectedRow.get(KEY_FILTERCONDITION_1));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object ruleType = this.getView().getFormShowParameter().getCustomParams().get(RULE_TYPE);
        if (null != ruleType) {
            formshowParameter.setCustomParam(RULE_TYPE, ruleType);
        }
        if (org != null) {
            formshowParameter.setCustomParam("orgid", (Object)org.getString("id"));
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }
}

