/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.baseinfo.firstFullconfimdysds;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.itp.business.fetchitem.FetchItemsBussiness;
import kd.taxc.itp.business.taxationsys.ItpTaxationsysCommonBusiness;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class ItpFirstFullConfirmDysdsPlanPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fetchitem = (BasedataEdit)this.getControl("fetchitem");
        fetchitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxationsys = (BasedataEdit)this.getControl("taxationsys");
        taxationsys.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object taxationsys = this.getView().getFormShowParameter().getCustomParams().get("taxationsys");
        Object billStatus = this.getView().getFormShowParameter().getCustomParams().get("billStatus");
        if (ObjectUtils.isNotEmpty(billStatus) && ObjectUtils.isNotEmpty(taxationsys) && "addNew".equalsIgnoreCase(billStatus.toString())) {
            this.getModel().setValue("taxationsys", taxationsys);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        TreeFilterParameter treeFilterParameter = listShowParameter.getTreeFilterParameter();
        QFilter qFilter = null;
        if ("org".equalsIgnoreCase(name)) {
            DynamicObjectCollection orgs = this.getModel().getEntryEntity("entryentity_org");
            List selectIds = orgs.stream().map(o -> o.getLong("org.id")).collect(Collectors.toList());
            List<Long> taxorgList = ItpTaxOrgCommonBusiness.queryTaxcMain();
            taxorgList.removeAll(selectIds);
            qFilter = new QFilter("id", "in", taxorgList);
        } else if ("fetchitem".equalsIgnoreCase(name)) {
            DynamicObject taxationsys = this.getModel().getDataEntity().getDynamicObject("taxationsys");
            if (ObjectUtils.isEmpty((Object)taxationsys)) {
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"ItpFirstFullConfirmDysdsPlanPlugin_0", (String)"taxc-itp", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection orgs = this.getModel().getEntryEntity("entryentity_item");
            List selectIds = orgs.stream().map(o -> o.getLong("fetchitem.id")).collect(Collectors.toList());
            List<Long> fetchItems = FetchItemsBussiness.getFetchItems(taxationsys.getLong("id"));
            fetchItems.removeAll(selectIds);
            qFilter = new QFilter("id", "in", fetchItems);
        } else if ("taxationsys".equalsIgnoreCase(name)) {
            List<Long> validTaxationsys = ItpTaxationsysCommonBusiness.queryValidTaxationsys();
            qFilter = new QFilter("id", "in", validTaxationsys);
        }
        if (ObjectUtils.isNotEmpty(qFilter)) {
            listFilterParameter.getQFilters().add(qFilter);
            treeFilterParameter.getQFilters().add(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("taxationsys".equalsIgnoreCase(name)) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            this.showConfirmTips(name, oldValue);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("taxationsys".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getModel().deleteEntryData("entryentity_item");
                this.getModel().createNewEntryRow("entryentity_item");
                this.getPageCache().put("resetTaxationsys", "false");
            } else {
                this.getPageCache().put("resetTaxationsys", "true");
                this.getModel().setValue("taxationsys", (Object)this.getPageCache().get("taxationsys"));
            }
        }
    }

    private void showConfirmTips(String fieldKey, Object oldValue) {
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)"taxationsys")) {
            String resetTaxationsys;
            String string = resetTaxationsys = this.getPageCache().get("resetTaxationsys") != null ? this.getPageCache().get("resetTaxationsys") : "";
            if (!"true".equalsIgnoreCase(resetTaxationsys)) {
                this.getPageCache().put("taxationsys", oldValue == null ? "" : ((DynamicObject)oldValue).getString("id"));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
                if (this.hasEntryRows()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u3010\u7a0e\u6536\u5236\u5ea6\u3011\uff0c\u5c06\u6e05\u7a7a\u53d6\u6570\u9879\u76ee\u4e2d\u7684\u6570\u636e\uff0c\u786e\u8ba4\u8981\u4fee\u6539\u5417\uff1f", (String)"ItpFirstFullConfirmDysdsPlanPlugin_1", (String)"taxc-itp", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                }
            } else {
                this.getPageCache().put("resetTaxationsys", "");
            }
        }
    }

    private boolean hasEntryRows() {
        int size = this.getModel().getEntryRowCount("entryentity_item");
        if (size > 1) {
            return true;
        }
        return size == 1 && this.getModel().getValue("fetchitem") != null;
    }
}

