/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.baseinfo.gaap;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;

public class AccountSetPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long id = this.getModel().getDataEntity().getLong("id");
        if (!"0".equalsIgnoreCase(String.valueOf(id))) {
            long orgId = RequestContext.get().getOrgId();
            List<Long> allPermOrgs = ItpTaxOrgCommonBusiness.getAllPermOrgs(this.getView(), "4715a0df000000ac");
            if (!allPermOrgs.contains(orgId)) {
                this.getModel().setValue("checkmodify", (Object)false);
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject e) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        map.put("heightLimit", false);
        this.getView().updateControlMetadata("entryentity", map);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        TreeFilterParameter treeFilterParameter = listShowParameter.getTreeFilterParameter();
        if ("org".equalsIgnoreCase(name)) {
            DynamicObjectCollection orgs = this.getModel().getEntryEntity("entryentity");
            List selectIds = orgs.stream().map(o -> o.getLong("org.id")).collect(Collectors.toList());
            DynamicObject[] enableplans = BusinessDataServiceHelper.load((String)"itp_gaap_accountset", (String)"id,entryentity.org", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE).and("id", "not in", this.getModel().getDataEntity().getPkValue())});
            ArrayList isExistIds = new ArrayList(12);
            for (DynamicObject enableplan : enableplans) {
                DynamicObjectCollection orgColls = (DynamicObjectCollection)enableplan.get("entryentity");
                for (DynamicObject orgColl : orgColls) {
                    isExistIds.add(orgColl.getLong("org.id"));
                }
            }
            if (selectIds != null) {
                selectIds.addAll(isExistIds);
            } else {
                selectIds = isExistIds;
            }
            List<Long> allTaxOrgs = ItpTaxOrgCommonBusiness.queryOrgIdByViewWithPerm("10");
            if (!ObjectUtils.isEmpty(allTaxOrgs)) {
                QFilter authFilter = new QFilter("id", "in", allTaxOrgs);
                listFilterParameter.setFilter(authFilter);
                treeFilterParameter.getQFilters().add(authFilter);
            }
            if (selectIds != null && selectIds.size() > 0) {
                QFilter qFilter = new QFilter("id", "not in", selectIds);
                listFilterParameter.getQFilters().add(qFilter);
                treeFilterParameter.getQFilters().add(qFilter);
            }
        }
    }
}

