/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.baseinfo.gaap;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;
import kd.taxc.itp.common.constant.GaapConstant;
import kd.taxc.itp.common.util.DealMessageUtils;
import kd.taxc.itp.common.util.JobUtils;
import org.apache.commons.lang3.ObjectUtils;

public class GaapDifferenceCalculatePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(GaapDifferenceCalculatePlugin.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("GaapDifferenceCalculatePlugin", new DistributeCacheHAPolicy(true, true));
    private static final String RECALC = "4730fc9f000025ae";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        boolean validAccountsetPlan;
        super.beforeBindData(e);
        long orgId = RequestContext.get().getOrgId();
        List<Long> validOrgIds = ItpTaxOrgCommonBusiness.queryOrgIdByViewWithPerm("10");
        if (validOrgIds.contains(orgId) && (validAccountsetPlan = this.getValidAccountsetPlan(orgId))) {
            Long[] o = new Long[]{orgId};
            this.getModel().setValue("org", (Object)o);
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        evt.getFormShowParameter().getCustomParams().put("orgFuncId", "10");
        evt.getFormShowParameter().getCustomParams().put("orgViewSchemeNumber", "10");
        if ("org".equals(key)) {
            List<Long> validAccountsetPlanOrgIds;
            List<Long> oids = ItpTaxOrgCommonBusiness.queryOrgIdByViewWithPerm("10");
            if (ObjectUtils.isNotEmpty(oids)) {
                LOGGER.info("ItpTaxOrgCommonBusiness.queryOrgIdByViewWithPerm size" + oids.size());
            }
            if (ObjectUtils.isNotEmpty(validAccountsetPlanOrgIds = this.getValidAccountsetPlanOrgIds())) {
                LOGGER.info("validAccountsetPlanOrgIds size" + validAccountsetPlanOrgIds.size());
            }
            oids.retainAll(validAccountsetPlanOrgIds);
            LOGGER.info("result size" + oids.size());
            ListShowParameter ls = (ListShowParameter)evt.getFormShowParameter();
            ls.getListFilterParameter().setFilter(new QFilter("id", "in", oids));
            ls.getTreeFilterParameter().getQFilters().add(new QFilter("id", "in", oids));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing && "sure".equals(((Donothing)args.getSource()).getOperateKey())) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            MulBasedataDynamicObjectCollection colls = (MulBasedataDynamicObjectCollection)dataEntity.get("org");
            List oids = colls.stream().map(o -> o.getLong(2)).collect(Collectors.toList());
            String kjnd = DateUtils.format((Date)((Date)this.getModel().getValue("kjnd")));
            QFilter orgQfilter = new QFilter("org", "in", oids);
            QFilter dateQfilter = new QFilter("kjnd", "=", (Object)DateUtils.stringToDate((String)kjnd));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"itp_gaap_difference", (String)"id,billno,org,kjnd", (QFilter[])new QFilter[]{orgQfilter, dateQfilter});
            StringBuilder failMessage = new StringBuilder();
            String operateName = ResManager.loadKDString((String)"\u8ba1\u7b97", (String)"GaapDifferenceCalculatePlugin_2", (String)"taxc-itp", (Object[])new Object[0]);
            String operateDescription = ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25\u3002", (String)"GaapDifferenceCalculatePlugin_3", (String)"taxc-itp", (Object[])new Object[0]);
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    failMessage.append(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8ba1\u7b97\u5b8c\u6210\u7684GAAP\u5dee\u5f02\uff0c\u7f16\u53f7\uff1a%s\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8ba1\u7b97\u8303\u56f4\u3002", (String)"GaapDifferenceCalculatePlugin_0", (String)"taxc-itp", (Object[])new Object[0]), dynamicObject.getString("billno"))).append(GaapConstant.SEPARATOR);
                }
            }
            if (failMessage.length() > 0) {
                DealMessageUtils.dealMessage(this.getView(), failMessage);
                OperatorDialogUtils.operateDialog((String)"sdsjt", (String)"itp_gaap_difference", (String)operateName, (String)operateDescription);
                args.setCancel(true);
            } else {
                StringBuilder mapkey = new StringBuilder(kjnd).append("_").append("gaap");
                if (cache.get(mapkey.toString()) != null) {
                    List orgids = SerializationUtils.fromJsonStringToList((String)((String)cache.get(mapkey.toString())), Long.class);
                    for (Long id : orgids) {
                        oids.remove(id);
                    }
                } else {
                    cache.put(mapkey.toString(), (Object)JSONObject.toJSONString(oids), 30, TimeUnit.SECONDS);
                }
                HashMap<String, Object> params = new HashMap<String, Object>(2);
                ArrayList<String> statusList = new ArrayList<String>(2);
                statusList.add("SCHEDULED");
                statusList.add("BEGIN");
                QFilter statusQfliter = new QFilter("status", "in", statusList);
                DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"tctb_task_monitor_detail", (String)"id,taxorg", (QFilter[])new QFilter[]{new QFilter("taxorg", "in", oids).and("skssqq", "=", (Object)DateUtils.stringToDate((String)kjnd)).and("taskappid", "=", (Object)"itp").and("taskdefine", "=", (Object)"2XQ+1WYTB9YN"), statusQfliter});
                LOGGER.info("GaapDifferenceTask  query tctb_task_monitor_detail start");
                if (dyns != null && dyns.length > 0) {
                    LOGGER.info(String.valueOf(dyns.length));
                    for (DynamicObject dyn : dyns) {
                        oids.remove(dyn.getLong("taxorg.id"));
                    }
                    LOGGER.info(String.valueOf(dyns.length));
                }
                LOGGER.info("GaapDifferenceTask  query tctb_task_monitor_detail end");
                if (oids.size() > 0) {
                    params.put("orgIds", oids);
                    params.put("kjqj", kjnd);
                    JobUtils.dispatch("itp", "GaapDifferenceTask", "kd.taxc.itp.business.task.GaapDifferenceTask", params, RequestContext.get().getCurrUserId());
                }
                String operateDescription1 = ResManager.loadKDString((String)"\u8ba1\u7b97\u6210\u529f\u3002", (String)"GaapDifferenceCalculatePlugin_4", (String)"taxc-itp", (Object[])new Object[0]);
                OperatorDialogUtils.operateDialog((String)"sdsjt", (String)"itp_gaap_difference", (String)operateName, (String)operateDescription1);
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u5df2\u89e6\u53d1\u540e\u53f0\u8ba1\u7b97\u4efb\u52a1\u3002", (String)"GaapDifferenceCalculatePlugin_1", (String)"taxc-itp", (Object[])new Object[0]));
            }
        }
    }

    private List<Long> getValidAccountsetPlanOrgIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject[] enables = BusinessDataServiceHelper.load((String)"itp_gaap_accountset", (String)"id,groupaccount,localaccount,groupsubjects,localsubjects,entryentity,entryentity.org", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (enables != null && enables.length > 0) {
            String str;
            DynamicObject[] dys = BusinessDataServiceHelper.load((String)"itp_gaap_subject", (String)"id,groupsubjects,localsubjects", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)});
            HashMap<String, String> map = new HashMap<String, String>(12);
            for (DynamicObject dy : dys) {
                str = String.format("%s_%s", dy.getString("groupsubjects"), dy.getString("localsubjects"));
                map.put(str, str);
            }
            for (DynamicObject dynamicObject : enables) {
                str = String.format("%s_%s", dynamicObject.getString("groupsubjects"), dynamicObject.getString("localsubjects"));
                if (!map.containsKey(str)) continue;
                DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
                ids.addAll(collection.stream().map(o -> o.getLong("org.id")).collect(Collectors.toList()));
            }
        }
        return ids;
    }

    private boolean getValidAccountsetPlan(Long orgId) {
        DynamicObject[] enables = BusinessDataServiceHelper.load((String)"itp_gaap_accountset", (String)"id,groupaccount,localaccount,groupsubjects,localsubjects,entryentity", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE).and("entryentity.org", "in", (Object)orgId)});
        if (enables != null && enables.length > 0) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"itp_gaap_subject", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE).and("groupsubjects", "in", (Object)enables[0].getString("groupsubjects")).and("localsubjects", "=", (Object)enables[0].getString("localsubjects"))});
            return dynamicObject != null;
        }
        return false;
    }
}

