/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.baseinfo.gaap;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.itp.business.gaap.CreateGaapDifferences;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;

public class GaapDifferencePlugin
extends AbstractBillPlugIn
implements SetFilterListener {
    private static final String RECALC = "4730fc9f000025ae";

    public void initialize() {
        super.initialize();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String gid = "";
        if (customParams.get("gid") != null) {
            gid = customParams.get("gid").toString();
        }
        this.getPageCache().put("gid", gid);
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.addSetFilterListener(this::setFilter);
    }

    public void afterLoadData(EventObject e) {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if (pkValue != null) {
            this.getPageCache().put("gid", pkValue.toString());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long id = this.getModel().getDataEntity().getLong("id");
        if (!"0".equalsIgnoreCase(String.valueOf(id))) {
            long orgId = RequestContext.get().getOrgId();
            List<Long> allPermOrgs = ItpTaxOrgCommonBusiness.getAllPermOrgs(this.getView(), RECALC);
            if (!allPermOrgs.contains(orgId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"recalc"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing && "recalc".equalsIgnoreCase(((Donothing)args.getSource()).getOperateKey())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            Date kjnd = DateUtils.stringToDate((String)DateUtils.format((Date)((Date)this.getModel().getValue("kjnd"))));
            CreateGaapDifferences.createDifferencesDetails(org.getLong("id"), kjnd, Boolean.TRUE);
            this.getView().invokeOperation("refresh");
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        if (!"".equalsIgnoreCase(this.getPageCache().get("gid"))) {
            setFilterEvent.getQFilters().add(new QFilter("gid", "=", (Object)Long.valueOf(this.getPageCache().get("gid"))));
        }
    }
}

