/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.baseinfo.taxlosses;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.itp.business.taxationsys.ItpTaxationsysCommonBusiness;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;

public class TaxLossesConfigPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxationsys = (BasedataEdit)this.getControl("taxationsys");
        taxationsys.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("org".equals(key)) {
            DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
            if (taxationsys != null) {
                List<Long> isTaxpayerOrg = ItpTaxOrgCommonBusiness.queryValidTaxOrg(taxationsys.getLong("id"));
                DynamicObjectCollection orgentryentityCollection = this.getModel().getEntryEntity("orgentryentity");
                ArrayList orgIds = orgentryentityCollection == null ? new ArrayList() : orgentryentityCollection.stream().filter(m -> m.getLong("org.id") != 0L).map(m -> m.getLong("org.id")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("id", "in", isTaxpayerOrg).and("id", "not in", orgIds);
                evt.addCustomQFilter(qFilter);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"TaxLossesConfigPlugin_1", (String)"taxc-itp", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if ("taxationsys".equals(key)) {
            List<Long> ids = ItpTaxationsysCommonBusiness.queryValidTaxationsys();
            QFilter qFilter = new QFilter("id", "in", ids);
            evt.addCustomQFilter(qFilter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMustInput();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("applicationscope".equals(name)) {
            this.getModel().deleteEntryData("orgentryentity");
        } else if ("taxationsys".equals(name)) {
            this.setMustInput();
        }
    }

    private void setMustInput() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        FieldEdit control = (FieldEdit)this.getControl("kssxnx");
        control.setMustInput(dataEntity.get("taxationsys") != null && dataEntity.getLong("taxationsys.id") == 1L);
    }
}

