/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.declarereport;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiQueryListPlugin;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractItpDeclareReportMultiListPlugin
extends AbstractDeclareReportMultiQueryListPlugin {
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("org.id".equalsIgnoreCase(args.getFieldName())) {
            List<Long> taxpayers = ItpTaxOrgCommonBusiness.queryTaxcOrgIdByIsTaxpayerWithPerm();
            QFilter orgFilter = new QFilter("id", "in", taxpayers);
            args.getQfilters().add(orgFilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        FilterContainerInitEvent contInitEvent = args.getFilterContainerInitEvent();
        List filterColumnList = contInitEvent.getCommonFilterColumns();
        for (FilterColumn column : filterColumnList) {
            Object org;
            if ("org.name".equals(column.getFieldName())) {
                List<Long> idList = ItpTaxOrgCommonBusiness.queryTaxcOrgIdByIsTaxpayerWithPerm();
                long orgId = RequestContext.get().getOrgId();
                List<DynamicObject> orgCol = ItpTaxOrgCommonBusiness.queryTaxcOrgByOrgIds(idList);
                List comboItems = orgCol.stream().map(dyo -> {
                    ComboItem item = new ComboItem();
                    item.setValue(dyo.getString("id"));
                    item.setCaption(new LocaleString(dyo.getString("org.name")));
                    return item;
                }).collect(Collectors.toList());
                CommonFilterColumn typeColumn = (CommonFilterColumn)column;
                typeColumn.setComboItems(comboItems);
                if (idList.contains(orgId)) {
                    typeColumn.setDefaultValue(String.valueOf(orgId));
                } else if (!CollectionUtils.isEmpty(idList)) {
                    typeColumn.setDefaultValue(String.valueOf(idList.get(0)));
                }
            }
            if ((org = customParams.get("orgid")) != null && column.getFieldName().equals("org.name") && column instanceof CommonFilterColumn) {
                column.setDefaultValue(org.toString());
                continue;
            }
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
            if (null == skssqq || null == skssqz || !column.getFieldName().equals("skssqq")) continue;
            column.setDefaultValues(new Object[]{DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz)});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection selectedRows = args.getListSelectedData();
        if (args.getSource() instanceof Donothing && StringUtil.equalsIgnoreCase((CharSequence)"checkjtd", (CharSequence)((Donothing)args.getSource()).getOperateKey())) {
            if (ObjectUtils.isNotEmpty((Object)selectedRows) && selectedRows.size() > 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"AbstractItpDeclareReportMultiListPlugin_0", (String)"taxc-itp", (Object[])new Object[0]));
            }
        } else if (args.getSource() instanceof Donothing && StringUtil.equalsIgnoreCase((CharSequence)"deletejtd", (CharSequence)((Donothing)args.getSource()).getOperateKey())) {
            HashMap<String, String> showErrorMap = new HashMap<String, String>(12);
            HashSet<String> notStatusA = new HashSet<String>();
            HashSet<String> statusA = new HashSet<String>();
            List entityNumberList = selectedRows.stream().map(o -> o.getBillNo()).collect(Collectors.toList());
            QFilter billNoQ = new QFilter("entitynumber", "in", entityNumberList);
            DynamicObjectCollection jtdCollection = QueryServiceHelper.query((String)"itp_proviston_taxes", (String)"billno,billstatus,entitynumber", (QFilter[])new QFilter[]{billNoQ});
            for (DynamicObject jtdRow : jtdCollection) {
                String entityNumber = jtdRow.getString("entitynumber");
                if (StringUtil.equalsIgnoreCase((CharSequence)jtdRow.getString("billstatus"), (CharSequence)"A")) {
                    statusA.add(entityNumber);
                    continue;
                }
                notStatusA.add(entityNumber);
                showErrorMap.put(entityNumber, String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u6682\u5b58\u7684\u5168\u90e8\u8ba1\u63d0\u5355\u53ef\u4ee5\u5220\u9664\u3002", (String)"AbstractItpDeclareReportMultiListPlugin_1", (String)"taxc-itp", (Object[])new Object[0]), entityNumber));
            }
            statusA.removeIf(s -> notStatusA.contains(s));
            List noPassDraftList = entityNumberList.stream().filter(o -> !statusA.contains(o)).filter(o -> !notStatusA.contains(o)).collect(Collectors.toList());
            noPassDraftList.stream().forEach(number -> showErrorMap.put((String)number, String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u6570\u636e\u672a\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"AbstractItpDeclareReportMultiListPlugin_2", (String)"taxc-itp", (Object[])new Object[0]), number)));
            if (ObjectUtils.isNotEmpty(showErrorMap)) {
                if (showErrorMap.size() == 1) {
                    this.getView().showErrorNotification((String)((Map.Entry)showErrorMap.entrySet().stream().findFirst().get()).getValue());
                } else {
                    ArrayList errorMsg = new ArrayList(12);
                    showErrorMap.entrySet().stream().forEach(row -> errorMsg.add(row.getValue()));
                    FormShowParameter parameters = new FormShowParameter();
                    parameters.getOpenStyle().setShowType(ShowType.Modal);
                    parameters.setFormId("bos_operationresult");
                    parameters.setShowTitle(false);
                    parameters.setCustomParam("operateName", (Object)"");
                    parameters.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u5220\u9664\u8ba1\u63d0\u5355", (String)"AbstractItpDeclareReportMultiListPlugin_11", (String)"taxc-itp", (Object[])new Object[0]));
                    parameters.setCustomParam("errorMsg", errorMsg);
                    this.getView().showForm(parameters);
                }
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"checkjtd")) {
            String entityId = ((Donothing)evt.getSource()).getEntityId();
            Map billNosMap = evt.getOperationResult().getBillNos();
            Collection billNos = billNosMap.values();
            ArrayList resultbillNos = new ArrayList(billNos);
            List ids = evt.getOperationResult().getSuccessPkIds();
            String operateName = ResManager.loadKDString((String)"\u67e5\u770b\u8ba1\u63d0\u5355", (String)"AbstractItpDeclareReportMultiListPlugin_4", (String)"taxc-itp", (Object[])new Object[0]);
            if (ObjectUtils.isNotEmpty((Object)ids)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)entityId, (String)"billno,org.id ,taxsystem.id,templatetype");
                this.openProvistonBillPage(dynamicObject.getString("org.id"), dynamicObject.getString("taxsystem.id"), dynamicObject.getString("billno"));
                String templatetype = dynamicObject.getString("templatetype.number");
                String billEntity = dynamicObject.getDataEntityType().getName();
                if (resultbillNos.size() > 0) {
                    String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a%s\u67e5\u770b\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"AbstractItpDeclareReportMultiListPlugin_5", (String)"taxc-itp", (Object[])new Object[0]), resultbillNos.get(0));
                    OperatorDialogUtils.operateDialog((String)templatetype, (String)billEntity, (String)operateName, (String)operateDescription);
                }
            } else if (resultbillNos.size() > 0) {
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a%s\u67e5\u770b\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"AbstractItpDeclareReportMultiListPlugin_6", (String)"taxc-itp", (Object[])new Object[0]), resultbillNos.get(0));
                OperatorDialogUtils.operateDialog((String)((String)this.getTemplateTypeList().get(0)), (String)entityId, (String)operateName, (String)operateDescription);
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"newjtd")) {
            String entityId = ((Donothing)evt.getSource()).getEntityId();
            OperationResult operationResult = evt.getOperationResult();
            StringBuilder successMessage = new StringBuilder();
            StringBuilder failMessage = new StringBuilder();
            this.getLogResultMessage(operationResult, successMessage, failMessage);
            String operateName = ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u63d0\u5355", (String)"AbstractItpDeclareReportMultiListPlugin_7", (String)"taxc-itp", (Object[])new Object[0]);
            StringBuilder resultMessage = new StringBuilder();
            if (failMessage.length() > 0) {
                resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a%s\u751f\u6210\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"AbstractItpDeclareReportMultiListPlugin_8", (String)"taxc-itp", (Object[])new Object[0]), failMessage));
            }
            if (successMessage.length() > 0) {
                resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a%s\u751f\u6210\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"AbstractItpDeclareReportMultiListPlugin_9", (String)"taxc-itp", (Object[])new Object[0]), successMessage));
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"newjtd") && operationResult.getBillCount() == operationResult.getSuccessPkIds().size()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"AbstractItpDeclareReportMultiListPlugin_10", (String)"taxc-itp", (Object[])new Object[0]));
            }
            OperatorDialogUtils.operateDialog((String)((String)this.getTemplateTypeList().get(0)), (String)entityId, (String)operateName, (String)resultMessage.toString());
            this.getView().invokeOperation("refresh");
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"deletejtd")) {
            String entityId = ((Donothing)evt.getSource()).getEntityId();
            String operateName = ResManager.loadKDString((String)"\u5220\u9664\u8ba1\u63d0\u5355", (String)"AbstractItpDeclareReportMultiListPlugin_11", (String)"taxc-itp", (Object[])new Object[0]);
            OperationResult operationResult = evt.getOperationResult();
            StringBuilder successMessage = new StringBuilder();
            StringBuilder failMessage = new StringBuilder();
            this.getLogResultMessage(operationResult, successMessage, failMessage);
            StringBuilder resultMessage = new StringBuilder();
            if (failMessage.length() > 0) {
                resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a%s\u5220\u9664\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"AbstractItpDeclareReportMultiListPlugin_12", (String)"taxc-itp", (Object[])new Object[0]), failMessage));
            }
            if (successMessage.length() > 0) {
                resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u201c%s\u201d\u5220\u9664\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"AbstractItpDeclareReportMultiListPlugin_13", (String)"taxc-itp", (Object[])new Object[0]), successMessage));
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"deletejtd") && operationResult.getBillCount() == operationResult.getSuccessPkIds().size()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"AbstractItpDeclareReportMultiListPlugin_14", (String)"taxc-itp", (Object[])new Object[0]));
            }
            OperatorDialogUtils.operateDialog((String)((String)this.getTemplateTypeList().get(0)), (String)entityId, (String)operateName, (String)resultMessage.toString());
            this.getView().invokeOperation("refresh");
        }
    }

    private void getLogResultMessage(OperationResult operationResult, StringBuilder successMessage, StringBuilder failMessage) {
        List successPkIds = operationResult.getSuccessPkIds();
        Map billNos = operationResult.getBillNos();
        Set entries = billNos.entrySet();
        for (Map.Entry entry : entries) {
            if (successPkIds.contains(Long.valueOf(entry.getKey().toString()))) {
                if (successMessage.length() > 0) {
                    successMessage.append(" ");
                }
                successMessage.append((String)entry.getValue());
                continue;
            }
            if (failMessage.length() > 0) {
                failMessage.append(" ");
            }
            failMessage.append((String)entry.getValue());
        }
    }

    private void openProvistonBillPage(String orgId, String taxsystem, String draftBillNo) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("itp_proviston_taxes");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("isFromDraft", "true");
        hashMap.put("entitynumber", draftBillNo);
        hashMap.put("orgId", orgId);
        hashMap.put("taxsystem", taxsystem);
        hashMap.put("taxtype.number", "003");
        listShowParameter.setCustomParams((Map)hashMap);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    protected boolean setCustomCheckInfo(AfterDoOperationEventArgs evt) {
        OperationResult opResult = evt.getOperationResult();
        this.getView().invokeOperation("refresh");
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        if (!evt.getOperationResult().isShowMessage()) {
            if (ObjectUtils.isNotEmpty((Object)allErrorOrValidateInfo) && allErrorOrValidateInfo.size() == 1) {
                this.getView().showErrorNotification(((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage());
            } else if (ObjectUtils.isNotEmpty((Object)allErrorOrValidateInfo)) {
                StringBuilder msg1 = new StringBuilder();
                for (IOperateInfo operateInfo : allErrorOrValidateInfo) {
                    msg1.append(operateInfo.getMessage());
                    msg1.append(SEPARATOR);
                }
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(msg1.toString());
                this.getView().showOperationResult(operationResult);
            }
            return false;
        }
        return !ObjectUtils.isNotEmpty((Object)evt.getOperationResult().getAllErrorOrValidateInfo());
    }
}

