/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.fetchdata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicCustomFormulaPlugin;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;

public abstract class AbstractItpDynamicCustomFormulaPlugin
extends AbstractDynamicCustomFormulaPlugin {
    private static Log logger = LogFactory.getLog(AbstractItpDynamicCustomFormulaPlugin.class);

    public Map<String, FormulaVo> query(List<DynamicRowModel> dynList) {
        logger.info("AbstractItpDynamicCustomFormulaPlugin start create custom FormulaVo");
        HashMap<String, FormulaVo> formulaMap = new HashMap<String, FormulaVo>();
        if (!ObjectUtils.isEmpty(dynList)) {
            List<String> mergeDynamicRegion = this.getMergeDynamicRegion();
            if (ObjectUtils.isEmpty(mergeDynamicRegion)) {
                return null;
            }
            int i = 0;
            for (DynamicRowModel dyn : dynList) {
                if (!mergeDynamicRegion.contains(dyn.getDynRowNo()) || dyn.getRowList() == null) continue;
                for (int k = 0; k < dyn.getRowList().size(); ++k) {
                    Map row = (Map)dyn.getRowList().get(k);
                    Set entries = row.entrySet();
                    Map<String, Map<String, String>> afterMergeDynamicRegion = this.getAfterMergeDynamicRegion();
                    Set<Map.Entry<String, Map<String, String>>> rowRelation = afterMergeDynamicRegion.entrySet();
                    String preformulaKey = "";
                    for (Map.Entry<String, Map<String, String>> mapEntry : rowRelation) {
                        preformulaKey = mapEntry.getKey();
                    }
                    Map<String, String> levyMapping = afterMergeDynamicRegion.get(preformulaKey);
                    Set<String> oldLevyValues = levyMapping.keySet();
                    String entryKey = "";
                    for (Map.Entry entry : entries) {
                        FormulaVo formulaVo = new FormulaVo();
                        entryKey = (String)entry.getKey();
                        String[] split = entryKey.split("#");
                        String oldSuffixkey = "#" + split[1];
                        String newsuffixkey = levyMapping.get(oldSuffixkey);
                        if (!oldLevyValues.contains(oldSuffixkey)) continue;
                        String formulaKey = preformulaKey + (i + 1) + newsuffixkey;
                        String formula = "{Q[" + entryKey.substring(0, entryKey.length() - split[1].length()) + (k + 1) + oldSuffixkey + "]}";
                        formulaVo.setFormula(formula);
                        formulaVo.setFormulaKey(formulaKey);
                        formulaMap.put(formulaKey, formulaVo);
                    }
                    String[] entrys = entryKey.split("#");
                    this.createColumnFormulaNotInDynamic(formulaMap, preformulaKey, entrys[0] + "#", i + 1, k + 1);
                    ++i;
                }
            }
        }
        this.extendDealFormula(dynList, formulaMap);
        if (!ObjectUtils.isEmpty(formulaMap)) {
            logger.info("AbstractItpDynamicCustomFormulaPlugin FormulaVo   " + formulaMap.size());
        }
        logger.info("AbstractItpDynamicCustomFormulaPlugin start create custom FormulaVo");
        return formulaMap;
    }

    public abstract List<String> getMergeDynamicRegion();

    public abstract Map<String, Map<String, String>> getAfterMergeDynamicRegion();

    public void createColumnFormulaNotInDynamic(Map<String, FormulaVo> formulaMap, String newPreformulaKey, String oldPreformulaKey, int newRow, int oldRow) {
    }

    public void extendDealFormula(List<DynamicRowModel> dynList, Map<String, FormulaVo> formulaMap) {
    }
}

