/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.fetchdata;

import com.google.common.collect.ImmutableBiMap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.common.annotation.GlobalDynamicRowPluginFlag;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.refactor.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.tctb.common.util.ObjectUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.itp.business.fetchdata.ItpFetchDataBussiness;
import kd.taxc.itp.business.papers.ItpMultiDataQueryBussiness;
import kd.taxc.itp.business.rule.ItpDraftDynCalculateServiceImpl;
import org.apache.commons.collections.CollectionUtils;

@GlobalDynamicRowPluginFlag
public class ItpDynamicRowListFetchPlugin
extends AbstractDynamicListBasePlugin {
    private static final Log logger = LogFactory.getLog(ItpDynamicRowListFetchPlugin.class);
    public static Map<String, String> dynRowBizTypeMap = ItpFetchDataBussiness.dynRowBizTypeMap;
    public static final String TAX_SYSTEM = "taxsystem";
    public static final String TEMPLATE_ID = "templateId";

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        String dynRowNo;
        Map<String, List<Map<String, Object>>> fetchItemListMap = this.batchFetchDynRowListWithCache(bussinessParamsVo);
        return fetchItemListMap.get(dynRowNo = bussinessParamsVo.getExtendParams().get("dynRowNo").toString()) == null ? new ArrayList() : fetchItemListMap.get(dynRowNo);
    }

    public List<DynamicRowModel> globalDynrowQuery(BussinessParamsVo bussinessParamsVo) {
        Map<String, List<Map<String, Object>>> fetchItemListMap = this.batchFetchDynRowListWithCache(bussinessParamsVo);
        Long templateId = (Long)bussinessParamsVo.getExtendParams().get(TEMPLATE_ID);
        return this.buildGlobalDynRow(templateId, fetchItemListMap);
    }

    private List<DynamicRowModel> buildGlobalDynRow(Long templateId, Map<String, List<Map<String, Object>>> fetchItemListMap) {
        ArrayList<DynamicRowModel> list = new ArrayList<DynamicRowModel>(8);
        if (null == fetchItemListMap) {
            return list;
        }
        for (Map.Entry<String, List<Map<String, Object>>> entry : fetchItemListMap.entrySet()) {
            DynamicRowModel dynamicRowModel = new DynamicRowModel();
            dynamicRowModel.setTemplateId(templateId);
            dynamicRowModel.setDynRowNo(entry.getKey());
            ArrayList rowList = new ArrayList(8);
            entry.getValue().stream().forEach(row -> rowList.add(new HashMap<String, String>(){
                {
                    for (Map.Entry rowEntry : row.entrySet()) {
                        this.put(rowEntry.getKey(), ObjectUtils.getStringByType(rowEntry.getValue()));
                    }
                }
            }));
            dynamicRowModel.setRowList(rowList);
            list.add(dynamicRowModel);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<Map<String, Object>>> batchFetchDynRowListWithCache(BussinessParamsVo bussinessParamsVo) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(8);
        Map extendParams = bussinessParamsVo.getExtendParams();
        if (bussinessParamsVo.getStartDate() == null || bussinessParamsVo.getEndDate() == null || extendParams.get(TEMPLATE_ID) == null || extendParams.get(TAX_SYSTEM) == null || bussinessParamsVo.getOrgId() == null) {
            return result;
        }
        Long templateId = (Long)extendParams.get(TEMPLATE_ID);
        Long taxSystemId = Long.parseLong((String)extendParams.get(TAX_SYSTEM));
        Long orgId = Long.parseLong(bussinessParamsVo.getOrgId());
        Date startDate = bussinessParamsVo.getStartDate();
        Date endDate = bussinessParamsVo.getEndDate();
        Long preyearendsbbid = org.apache.commons.lang3.ObjectUtils.isEmpty(extendParams.get("preyearendsbbid")) ? -1L : Long.parseLong(extendParams.get("preyearendsbbid").toString());
        Long preperiodsbbid = org.apache.commons.lang3.ObjectUtils.isEmpty(extendParams.get("preperiodsbbid")) ? -1L : Long.parseLong(extendParams.get("preperiodsbbid").toString());
        String cacheId = bussinessParamsVo.getExtendParams().get("cacheId") == null ? UUID.randomUUID() : bussinessParamsVo.getExtendParams().get("cacheId").toString();
        ItpDynamicRowListFetchPlugin itpDynamicRowListFetchPlugin = this;
        synchronized (itpDynamicRowListFetchPlugin) {
            Map cacheResult = (Map)CacheUtils.get((String)cacheId);
            if (cacheResult != null) {
                return cacheResult;
            }
            logger.info("\u5f53\u671f\u52a8\u6001\u884c\u53d6\u6570\u53c2\u6570[\u7ec4\u7ec7\uff1a{},\u6a21\u677fid:{},\u7a0e\u6536\u5236\u5ea6:{}, \u65f6\u95f4:{} - {}]", new Object[]{orgId, templateId, taxSystemId, startDate, endDate});
            HashMap<String, List<Map<String, Object>>> preYearEndDeclare = ItpMultiDataQueryBussiness.queryHistoryDeclareByDraftId(preyearendsbbid);
            HashMap<String, List<Map<String, Object>>> prePeriodDeclareInSameYear = ItpMultiDataQueryBussiness.queryHistoryDeclareByDraftId(preperiodsbbid);
            DynamicObjectCollection fetchItems = this.getFetchItems(taxSystemId);
            RuleFetchMainDto ruleFetchMainDto = this.calculateRuleAccess(orgId, templateId, taxSystemId, startDate, endDate, fetchItems);
            Map<Long, BigDecimal> calculateRuleAccessResult = ruleFetchMainDto.getRuleFetchCellSummaryList().stream().collect(Collectors.toMap(cell -> Long.parseLong(cell.getRuleItem()), cell -> cell.getAmount() == null ? BigDecimal.ZERO : cell.getAmount().setScale(2, RoundingMode.HALF_UP)));
            logger.info("\u5f97\u5230\u53d6\u6570\u8ba1\u7b97\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(calculateRuleAccessResult));
            for (Map.Entry<String, String> entry : dynRowBizTypeMap.entrySet()) {
                String dynRowNo = entry.getKey();
                List<DynamicObject> fetchItemsByBizType = fetchItems.stream().filter(m -> dynRowBizTypeMap.get(dynRowNo).equalsIgnoreCase(m.getString("biztype.number"))).collect(Collectors.toList());
                if ("dqsds_gaaptz_cyxm#1".equals(entry.getKey())) {
                    List specialFetchItemsByBizType = fetchItems.stream().filter(m -> m.getString("biztype.number").equalsIgnoreCase("YWLB0004")).collect(Collectors.toList());
                    if (fetchItemsByBizType != null) {
                        fetchItemsByBizType.addAll(specialFetchItemsByBizType);
                    } else {
                        fetchItemsByBizType = specialFetchItemsByBizType;
                    }
                }
                if (CollectionUtils.isEmpty(fetchItemsByBizType)) {
                    result.put(dynRowNo, new ArrayList());
                    logger.info("\u83b7\u53d6{}\u52a8\u6001\u884c\u6807\u8bc6\u6240\u6709\u76f8\u5173\u53d6\u6570\u9879\u76ee\u6761\u6570\uff1a{}", (Object)dynRowNo, (Object)0);
                    continue;
                }
                List<Map<String, Object>> mapList = this.getDynListMapByDynRowNo(dynRowNo, fetchItemsByBizType, ruleFetchMainDto, calculateRuleAccessResult, preYearEndDeclare, prePeriodDeclareInSameYear, bussinessParamsVo);
                result.put(dynRowNo, mapList);
            }
            CacheUtils.put((String)cacheId, result);
            logger.info("\u83b7\u53d6\u6240\u6709\u52a8\u6001\u884c\u8ba1\u7b97\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(result));
            if (ruleFetchMainDto.getRuleFetchCellSummaryList().size() > 0) {
                RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
                List ruleFetchCellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
                logger.info("ruleFetchCellSummaryList:{}", (Object)ruleFetchCellSummaryList.size());
                ArrayList ruleFetchCardDtoList = new ArrayList(12);
                for (RuleFetchCellSummaryDto ruleFetchCellSummaryDto : ruleFetchCellSummaryList) {
                    if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)ruleFetchCellSummaryDto.getRuleFetchCardList())) continue;
                    ruleFetchCardDtoList.addAll(ruleFetchCellSummaryDto.getRuleFetchCardList());
                }
                logger.info("ruleFetchCellSummaryDto : {}", (Object)JsonUtil.toJson(ruleFetchCardDtoList));
                ruleFetchService.addCellData(ruleFetchMainDto);
                logger.info("ruleFetchCellSummaryList save success");
            }
        }
        return result;
    }

    private List<Map<String, Object>> getDynListMapByDynRowNo(String dynRowNo, List<DynamicObject> fetchItemsByBizType, RuleFetchMainDto ruleFetchMainDto, Map<Long, BigDecimal> calculateRuleAccessResult, HashMap<String, List<Map<String, Object>>> preYearEndDeclare, HashMap<String, List<Map<String, Object>>> prePeriodDeclareInSameYear, BussinessParamsVo bussinessParamsVo) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject fetchItem : fetchItemsByBizType) {
            BigDecimal bnbdTz;
            BigDecimal snqnjts;
            Long xmId = fetchItem.getLong("id");
            BigDecimal zdqsAmount = calculateRuleAccessResult.get(xmId) == null ? BigDecimal.ZERO : calculateRuleAccessResult.get(xmId);
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            String prefix = dynRowNo.split("#")[0];
            if (dynRowNo.startsWith("zcycgl_")) {
                map.put(prefix + "#zcycgl_bbxm", xmId);
                map.put(prefix + "#zcycgl_bnbd_zdqs", zdqsAmount);
                this.setReportItem(xmId, mapList, prefix, "zcycgl_bnbd_zdqs", ruleFetchMainDto);
                snqnjts = this.getCellValue(xmId, preYearEndDeclare.get(dynRowNo), prefix + "#zcycgl_bbxm", prefix + "#zcycgl_bnbd_hj");
                map.put(prefix + "#zcycgl_snqnjts", snqnjts);
                if ("zcycgl_gaap_yjxcy_cyxm#1".equalsIgnoreCase(dynRowNo)) {
                    map.put(prefix + "#zcycgl_ncye_tz", BigDecimal.ZERO);
                    map.put(prefix + "#zcycgl_ncye_hjje", BigDecimal.ZERO);
                } else if ("zcycgl_yjxcy_cyxm#1".equalsIgnoreCase(dynRowNo)) {
                    map.put(prefix + "#zcycgl_ncye_snmye", BigDecimal.ZERO);
                    map.put(prefix + "#zcycgl_ncye_tz", BigDecimal.ZERO);
                } else if ("zcycgl_gaap_zsxcy_cyxm#1".equalsIgnoreCase(dynRowNo) || "zcycgl_zsxcy_cyxm#1".equalsIgnoreCase(dynRowNo)) {
                    BigDecimal ncyeSnmye = this.getCellValue(xmId, preYearEndDeclare.get(dynRowNo), prefix + "#zcycgl_bbxm", prefix + "#zcycgl_qmye");
                    map.put(prefix + "#zcycgl_ncye_snmye", ncyeSnmye);
                    BigDecimal ncyeTz = this.getCellValue(xmId, prePeriodDeclareInSameYear.get(dynRowNo), prefix + "#zcycgl_bbxm", prefix + "#zcycgl_ncye_tz");
                    map.put(prefix + "#zcycgl_ncye_tz", ncyeTz);
                    BigDecimal dysds_qmye = BigDecimal.ZERO;
                    BigDecimal dysds_snqnjit = BigDecimal.ZERO;
                    if ("zcycgl_gaap_zsxcy_cyxm#1".equalsIgnoreCase(dynRowNo)) {
                        dysds_qmye = this.getCellValue(xmId, preYearEndDeclare.get("dysds_gaapzsxcy_sh_xm#1"), "dysds_gaapzsxcy_sh_xm#dysds_bbxm", "dysds_gaapzsxcy_sh_xm#dysds_qmye");
                        dysds_snqnjit = this.getCellValue(xmId, preYearEndDeclare.get("dysds_gaapzsxcy_sh_xm#1"), "dysds_gaapzsxcy_sh_xm#dysds_bbxm", "dysds_gaapzsxcy_sh_xm#dysds_bnbd_hj");
                    } else if ("zcycgl_zsxcy_cyxm#1".equalsIgnoreCase(dynRowNo)) {
                        dysds_qmye = this.getCellValue(xmId, preYearEndDeclare.get("dysds_zsxcy_sh_xm#1"), "dysds_zsxcy_sh_xm#dysds_bbxm", "dysds_zsxcy_sh_xm#dysds_qmye");
                        dysds_snqnjit = this.getCellValue(xmId, preYearEndDeclare.get("dysds_zsxcy_sh_xm#1"), "dysds_zsxcy_sh_xm#dysds_bbxm", "dysds_zsxcy_sh_xm#dysds_bnbd_hj");
                    }
                    map.put(prefix + "#zcycgl_dysds_snnmye", dysds_qmye);
                    map.put(prefix + "#dysds_snqnjit", dysds_snqnjit);
                    BigDecimal dysdswqr_qmye = BigDecimal.ZERO;
                    BigDecimal dysdswqr_snqnjit = BigDecimal.ZERO;
                    if ("zcycgl_gaap_zsxcy_cyxm#1".equalsIgnoreCase(dynRowNo)) {
                        dysdswqr_qmye = this.getCellValue(xmId, preYearEndDeclare.get("dqsdswqr_gaapzsxcy_sh_xm#1"), "dqsdswqr_gaapzsxcy_sh_xm#dysds_bbxm", "dqsdswqr_gaapzsxcy_sh_xm#dysds_qmye");
                        dysdswqr_snqnjit = this.getCellValue(xmId, preYearEndDeclare.get("dqsdswqr_gaapzsxcy_sh_xm#1"), "dqsdswqr_gaapzsxcy_sh_xm#dysds_bbxm", "dqsdswqr_gaapzsxcy_sh_xm#dysds_bnbd_hj");
                    } else if ("zcycgl_zsxcy_cyxm#1".equalsIgnoreCase(dynRowNo)) {
                        dysdswqr_qmye = this.getCellValue(xmId, preYearEndDeclare.get("dysdswqr_zsxcy_sh_xm#1"), "dysdswqr_zsxcy_sh_xm#dysds_bbxm", "dysdswqr_zsxcy_sh_xm#dysds_qmye");
                        dysdswqr_snqnjit = this.getCellValue(xmId, preYearEndDeclare.get("dysdswqr_zsxcy_sh_xm#1"), "dysdswqr_zsxcy_sh_xm#dysds_bbxm", "dysdswqr_zsxcy_sh_xm#dysds_bnbd_hj");
                    }
                    map.put(prefix + "#zcycgl_dysdswqr_snnmye", dysdswqr_qmye);
                    map.put(prefix + "#dysdswqr_snqnjit", dysdswqr_snqnjit);
                }
                bnbdTz = this.getCellValue(xmId, prePeriodDeclareInSameYear.get(dynRowNo), prefix + "#zcycgl_bbxm", prefix + "#zcycgl_bnbd_tz");
                map.put(prefix + "#zcycgl_bnbd_tz", bnbdTz);
            } else if ("dqsds_jnsejm_xm#1".equals(dynRowNo) || "dqsds_jwsedm_xm#1".equals(dynRowNo)) {
                map.put(prefix + "#dqsds_bbxm", xmId);
                map.put(prefix + "#dqsds_bndb_zdqs", zdqsAmount);
                this.setReportItem(xmId, mapList, prefix, "dqsds_bndb_zdqs", ruleFetchMainDto);
                snqnjts = this.getCellValue(xmId, preYearEndDeclare.get(dynRowNo), prefix + "#dqsds_bbxm", prefix + "#dqsds_hj");
                map.put(prefix + "#dqsds_snqnjts", snqnjts);
                bnbdTz = this.getCellValue(xmId, prePeriodDeclareInSameYear.get(dynRowNo), prefix + "#dqsds_bbxm", prefix + "#dqsds_bndb_tz");
                map.put(prefix + "#dqsds_bndb_tz", bnbdTz);
            } else if (dynRowNo.startsWith("sjjs_")) {
                map.put(prefix + "#sjjs_xm", xmId);
                map.put(prefix + "#sjjs_je", zdqsAmount);
                this.setReportItem(xmId, mapList, prefix, "sjjs_je", ruleFetchMainDto);
                if ("sjjs_dqsdsfy_zmtzxm#1".equals(dynRowNo) || "sjjs_dysdsfy_zmtzxm#1".equals(dynRowNo)) {
                    map.put(prefix + "#sjjs_seq", "3." + (mapList.size() + 1));
                } else if ("sjjs_yjhyjsds_zmtzxm#1".equals(dynRowNo)) {
                    map.put(prefix + "#sjjs_seq", "4." + (mapList.size() + 1));
                }
            }
            mapList.add(map);
        }
        return mapList;
    }

    private DynamicObjectCollection getFetchItems(Long taxSystemId) {
        Collection<String> values = dynRowBizTypeMap.values();
        QFilter qFilter = new QFilter("taxationsys", "is null", null).or(new QFilter("taxationsys", "=", (Object)0L));
        QFilter taxSysFilter = new QFilter("taxationsys", "=", (Object)taxSystemId).or(qFilter);
        QFilter fetchItemsFilter = new QFilter("isleaf", "=", (Object)Boolean.TRUE).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("biztype.number", "in", values)).and(taxSysFilter);
        DynamicObjectCollection fetchItems = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id,number,name,taxationsys,biztype.number", (QFilter[])new QFilter[]{fetchItemsFilter}, (String)"number asc");
        logger.info("\u83b7\u53d6\u6240\u6709\u76f8\u5173\u53d6\u6570\u9879\u76ee\u6761\u6570\uff1a{}", (Object)(CollectionUtils.isEmpty((Collection)fetchItems) ? 0 : fetchItems.size()));
        return fetchItems;
    }

    private RuleFetchMainDto calculateRuleAccess(Long orgId, Long templateId, Long taxSystemId, Date startDate, Date endDate, DynamicObjectCollection fetchItems) {
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto();
        if (CollectionUtils.isEmpty((Collection)fetchItems)) {
            return ruleFetchMainDto;
        }
        Set ids = fetchItems.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
        QFilter accessWhereFilter = new QFilter("taxationsys", "=", (Object)taxSystemId).and(new QFilter("enable", "=", (Object)Boolean.TRUE)).and(new QFilter("accessproject", "in", ids));
        QFilter sharingPlanWhereFilter = new QFilter("taxationsys", "=", (Object)taxSystemId);
        sharingPlanWhereFilter.and(new QFilter("ruleentity.rule.accessproject", "in", ids));
        RuleEngineParamDto paramDto = new RuleEngineParamDto(orgId, Long.valueOf(3L), startDate, endDate, templateId, accessWhereFilter, sharingPlanWhereFilter, (Map)ImmutableBiMap.of((Object)"originalSkssqq", (Object)startDate), "sjjt");
        try {
            ItpDraftDynCalculateServiceImpl service = new ItpDraftDynCalculateServiceImpl();
            List ruleFetchMainDtoList = service.calculateRuleAccess(paramDto);
            return (RuleFetchMainDto)ruleFetchMainDtoList.get(0);
        }
        catch (Exception e) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error("\u52a8\u6001\u884c\u53d6\u6570\u62a5\u9519:{}", (Object)exceptionStackTraceMessage);
            return ruleFetchMainDto;
        }
    }

    private void setReportItem(Long xmId, List<Map<String, Object>> mapList, String prefix, String suffix, RuleFetchMainDto fetchMainDto) {
        if (fetchMainDto == null) {
            return;
        }
        List ruleFetchCellSummaryList = fetchMainDto.getRuleFetchCellSummaryList();
        if (ruleFetchCellSummaryList == null) {
            return;
        }
        for (RuleFetchCellSummaryDto summaryDto : ruleFetchCellSummaryList) {
            if (!summaryDto.getRuleItem().equalsIgnoreCase(xmId.toString())) continue;
            summaryDto.setReportItem(prefix + "#" + (mapList.size() + 1) + "#" + suffix);
        }
    }

    private BigDecimal getCellValue(Long id, List<Map<String, Object>> mapList, String idKey, String numKey) {
        if (CollectionUtils.isEmpty(mapList) || id == null) {
            return BigDecimal.ZERO;
        }
        for (Map<String, Object> map : mapList) {
            String s;
            String string = s = map.get(idKey) == null ? null : map.get(idKey).toString();
            if (!id.toString().equalsIgnoreCase(s)) continue;
            return map.get(numKey) == null ? BigDecimal.ZERO : new BigDecimal(map.get(numKey).toString());
        }
        return BigDecimal.ZERO;
    }
}

