/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.fetchdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicCustomFormulaPlugin;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.itp.business.baseinfo.NotConfirmDysdsPlanBussiness;
import kd.taxc.itp.business.papers.ItpMultiDataQueryBussiness;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ItpDysdsWqrBnbdDynamicCustomFormulaPlugin
extends AbstractDynamicCustomFormulaPlugin {
    private static Log logger = LogFactory.getLog(ItpDysdsWqrBnbdDynamicCustomFormulaPlugin.class);

    public Map<String, FormulaVo> queryByDeclareRequestModel(DeclareRequestModel requestModel, List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> formulaMap = new HashMap<String, FormulaVo>();
        HashMap<String, List<Map<String, String>>> zcycglMap = new HashMap<String, List<Map<String, String>>>(2);
        if (ObjectUtils.isNotEmpty(dynList)) {
            for (DynamicRowModel dyn : dynList) {
                String dynRowNo = dyn.getDynRowNo();
                if (!"zcycgl_gaap_zsxcy_cyxm#1".equalsIgnoreCase(dynRowNo) && !"zcycgl_zsxcy_cyxm#1".equalsIgnoreCase(dynRowNo)) continue;
                zcycglMap.put(dynRowNo, dyn.getRowList());
            }
        }
        String orgId = "";
        String taxationsysId = "";
        String startdate = "";
        String enddate = "";
        String accountsettype = "";
        String isShowWqr = "false";
        if (ObjectUtils.isNotEmpty((Object)requestModel)) {
            orgId = String.valueOf(requestModel.getOrgId());
            taxationsysId = requestModel.getTaxationsys().toString();
            startdate = requestModel.getSkssqq();
            enddate = requestModel.getSkssqz();
            if (requestModel.getExtendParams().containsKey("accountsettype")) {
                accountsettype = requestModel.getExtendParams().get("accountsettype").toString();
            }
            if (ObjectUtils.isNotEmpty((Object)requestModel.getBusinessMap()) && "true".equalsIgnoreCase((String)requestModel.getBusinessMap().get("isShowWqr"))) {
                isShowWqr = "true";
            }
        }
        if ("false".equalsIgnoreCase(isShowWqr)) {
            return formulaMap;
        }
        ArrayList<Long> bbxmIdList = new ArrayList<Long>(12);
        if (ObjectUtils.isNotEmpty(zcycglMap)) {
            Set entries = zcycglMap.entrySet();
            for (Map.Entry entry : entries) {
                List entryValueList = (List)entry.getValue();
                if (!ObjectUtils.isNotEmpty((Object)entryValueList)) continue;
                for (Map map : entryValueList) {
                    Set entrySet = map.entrySet();
                    for (Map.Entry o : entrySet) {
                        String okey = (String)o.getKey();
                        String ovalue = (String)o.getValue();
                        if (!okey.endsWith("_bbxm")) continue;
                        bbxmIdList.add(Long.parseLong(ovalue));
                    }
                }
            }
        }
        if (ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)taxationsysId) || ObjectUtils.isEmpty((Object)startdate) || ObjectUtils.isEmpty((Object)enddate) || ObjectUtils.isEmpty((Object)accountsettype)) {
            return formulaMap;
        }
        String templatetype = "jtzt".equalsIgnoreCase(accountsettype) ? "sdsjt_jt" : "sdsjt_bd";
        Date skssqq = DateUtils.stringToDate2((String)startdate);
        Date skssqz = DateUtils.stringToDate2((String)enddate);
        if (ObjectUtils.isNotEmpty(bbxmIdList)) {
            String start = DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)skssqq));
            boolean isFirstPeriod = false;
            if (DateUtils.getFirstDateOfYear((Date)skssqq).getTime() == skssqq.getTime()) {
                isFirstPeriod = true;
            }
            List<Map<String, Object>> planList = NotConfirmDysdsPlanBussiness.queryNotConfirmDysdsPlanOrderByOrgAndTaxationsys(Long.parseLong(orgId), Long.parseLong(taxationsysId), DateUtils.stringToDate2((String)start), skssqq, skssqz);
            Map<String, Map<String, Object>> calculateFetchitemsPlan = NotConfirmDysdsPlanBussiness.calculateFetchitemsPlan(planList, bbxmIdList, skssqq, skssqz, isFirstPeriod);
            Map<String, Map<String, Map<String, String>>> queryHistoryPeriodCellVaule = this.queryHistoryPeriodCellVaule(calculateFetchitemsPlan, bbxmIdList, templatetype, Long.parseLong(orgId), skssqq, skssqz, isFirstPeriod);
            this.buildDynFormula(skssqq, skssqz, calculateFetchitemsPlan, formulaMap, dynList, zcycglMap, isFirstPeriod, queryHistoryPeriodCellVaule, requestModel);
        }
        return formulaMap;
    }

    private Map<String, Map<String, Map<String, String>>> queryHistoryPeriodCellVaule(Map<String, Map<String, Object>> calculateFetchitemsPlan, List<Long> bbxmIdList, String templatetype, Long orgId, Date skssqq, Date skssqz, boolean isFirstPeriod) {
        if (isFirstPeriod) {
            return new HashMap<String, Map<String, Map<String, String>>>();
        }
        String accountsettype = "sdsjt_jt".equalsIgnoreCase(templatetype) ? "jtzt" : "bdzt";
        QFilter filter = new QFilter("accountsettype", "=", (Object)accountsettype);
        return this.queryMultiDetailDynCellValue(templatetype, orgId, skssqq, skssqz, filter, bbxmIdList);
    }

    private void buildDynFormula(Date skssqq, Date skssqz, Map<String, Map<String, Object>> calculateFetchitemsPlan, Map<String, FormulaVo> formulaMap, List<DynamicRowModel> dynList, Map<String, List<Map<String, String>>> zcycglMap, boolean isFirstPeriod, Map<String, Map<String, Map<String, String>>> queryHistoryPeriodCellVaule, DeclareRequestModel requestModel) {
        if (ObjectUtils.isEmpty(calculateFetchitemsPlan) || ObjectUtils.isEmpty(dynList)) {
            return;
        }
        int month = DateUtils.getMonthOfDate((Date)skssqz) - DateUtils.getMonthOfDate((Date)skssqq);
        Map<String, Object> currentPlan = calculateFetchitemsPlan.get("currentPlan");
        List dqwqrList = (List)currentPlan.get("wqrList");
        List dqqrList = (List)currentPlan.get("qrList");
        Map<String, Object> wqrToQrMap = calculateFetchitemsPlan.get("wqrToQr");
        Map<String, Object> qrToWqrMap = calculateFetchitemsPlan.get("qrToWqr");
        Map<String, Map<String, String>> zdqsMap = queryHistoryPeriodCellVaule.get("zcycgl_bnbd_zdqs");
        Map<String, Map<String, String>> tzMap = queryHistoryPeriodCellVaule.get("zcycgl_bnbd_tz");
        for (DynamicRowModel dyn : dynList) {
            List rowList;
            List<Map<String, String>> mapList;
            String dynRowNo = dyn.getDynRowNo();
            if ("dqsdswqr_gaapzsxcy_sh_xm#1".equalsIgnoreCase(dynRowNo)) {
                mapList = zcycglMap.get("zcycgl_gaap_zsxcy_cyxm#1");
                rowList = dyn.getRowList();
                this.calculateCellFormal(mapList, rowList, "dqsdswqr_gaapzsxcy_sh_xm#", "#dysds_bnbd_zdqs", "zcycgl_gaap_zsxcy_cyxm#zcycgl_bbxm", "zcycgl_gaap_zsxcy_cyxm#", "#zcycgl_bnbd_zdqs", zdqsMap, formulaMap, isFirstPeriod, month, dqwqrList, dqqrList, wqrToQrMap, qrToWqrMap, requestModel);
                this.calculateCellFormal(mapList, rowList, "dqsdswqr_gaapzsxcy_sh_xm#", "#dysds_bnbd_tz", "zcycgl_gaap_zsxcy_cyxm#zcycgl_bbxm", "zcycgl_gaap_zsxcy_cyxm#", "#zcycgl_bnbd_tz", tzMap, formulaMap, isFirstPeriod, month, dqwqrList, dqqrList, wqrToQrMap, qrToWqrMap, requestModel);
                continue;
            }
            if (!"dysdswqr_zsxcy_sh_xm#1".equalsIgnoreCase(dynRowNo)) continue;
            mapList = zcycglMap.get("zcycgl_zsxcy_cyxm#1");
            rowList = dyn.getRowList();
            this.calculateCellFormal(mapList, rowList, "dysdswqr_zsxcy_sh_xm#", "#dysds_bnbd_tz", "zcycgl_zsxcy_cyxm#zcycgl_bbxm", "zcycgl_zsxcy_cyxm#", "#zcycgl_bnbd_tz", tzMap, formulaMap, isFirstPeriod, month, dqwqrList, dqqrList, wqrToQrMap, qrToWqrMap, requestModel);
            this.calculateCellFormal(mapList, rowList, "dysdswqr_zsxcy_sh_xm#", "#dysds_bnbd_zdqs", "zcycgl_zsxcy_cyxm#zcycgl_bbxm", "zcycgl_zsxcy_cyxm#", "#zcycgl_bnbd_zdqs", zdqsMap, formulaMap, isFirstPeriod, month, dqwqrList, dqqrList, wqrToQrMap, qrToWqrMap, requestModel);
        }
    }

    private void calculateCellFormal(List<Map<String, String>> mapList, List<Map<String, String>> rowList, String prefix, String suffix, String oldBbxmItem, String oldBbxmFix, String oldAmountFix, Map<String, Map<String, String>> historyDataMap, Map<String, FormulaVo> formulaMap, boolean isFirstPeriod, int month, List<Long> dqwqrList, List<Long> dqqrList, Map<String, Object> wqrToQrMap, Map<String, Object> qrToWqrMap, DeclareRequestModel requestModel) {
        if (ObjectUtils.isEmpty(mapList) || ObjectUtils.isEmpty(rowList)) {
            return;
        }
        for (int i = 0; i < rowList.size(); ++i) {
            FormulaVo formulaVo = new FormulaVo();
            formulaVo.setFormulaType("1");
            String formulaKey = prefix + (i + 1) + suffix;
            formulaVo.setFormulaKey(formulaKey);
            Map<String, String> map = mapList.get(i);
            String formula = "";
            if (map.containsKey(oldBbxmItem)) {
                String bbId = map.get(oldBbxmItem);
                String dynRowTaxableIncomeNo = ObjectUtils.isNotEmpty((Object)prefix) && ObjectUtils.isNotEmpty((Object)prefix.split("#")) ? prefix.split("#")[0] : "";
                boolean isFirstDysds = false;
                if (ObjectUtils.isNotEmpty((Object)requestModel.getBusinessMap()) && requestModel.getBusinessMap().containsKey(bbId + "_fdy") && "1".equals(requestModel.getBusinessMap().get(bbId + "_fdy"))) {
                    isFirstDysds = true;
                }
                if (!isFirstDysds) {
                    if (isFirstPeriod) {
                        if (dqqrList.contains(Long.parseLong(bbId))) {
                            formula = "{P[" + dynRowTaxableIncomeNo + "_" + formulaKey + "]}";
                        } else if (dqwqrList.contains(Long.parseLong(bbId))) {
                            formula = "DataFormatUtils.decimalFormat({Q[" + oldBbxmFix + (i + 1) + oldAmountFix + "]} * {Q[dysds_dysdsl" + suffix + "]} / 100  ,'#.00')";
                        }
                    } else {
                        String value;
                        logger.info("dqqrList size :{}", (Object)dqqrList.size());
                        if (dqqrList.contains(Long.parseLong(bbId))) {
                            logger.info("dqqrList.contains :{}", (Object)bbId);
                            formula = wqrToQrMap.containsKey(bbId) ? (value = this.calculateHistoryCellValue(wqrToQrMap, bbId, historyDataMap, month)) : "{P[" + dynRowTaxableIncomeNo + "_" + formulaKey + "]}";
                        } else if (dqwqrList.contains(Long.parseLong(bbId))) {
                            if (qrToWqrMap.containsKey(bbId)) {
                                value = this.calculateHistoryCellValue(qrToWqrMap, bbId, historyDataMap, month);
                                formula = "DataFormatUtils.decimalFormat({Q[" + oldBbxmFix + (i + 1) + oldAmountFix + "]} * {Q[dysds_dysdsl" + suffix + "]} /100 ,'#.00') -  DataFormatUtils.decimalFormat(" + value + " ,'#.00')";
                            } else {
                                formula = "DataFormatUtils.decimalFormat({Q[" + oldBbxmFix + (i + 1) + oldAmountFix + "]} * {Q[dysds_dysdsl" + suffix + "]} / 100  ,'#.00')";
                            }
                        }
                    }
                } else {
                    formula = "{P[" + dynRowTaxableIncomeNo + "_" + formulaKey + "]}";
                }
            }
            if (!ObjectUtils.isNotEmpty((Object)formula)) continue;
            logger.info("formula:{} {}", (Object)formulaKey, (Object)formula);
            formulaVo.setFormula(formula);
            formulaMap.put(formulaKey, formulaVo);
        }
    }

    private Map<String, Map<String, Map<String, String>>> queryMultiDetailDynCellValue(String templatetype, Long orgId, Date skssqq, Date skssqz, QFilter qFilter, List<Long> fetchitemList) {
        HashMap<String, Map<String, Map<String, String>>> resultMap = new HashMap<String, Map<String, Map<String, String>>>(12);
        int month = DateUtils.getMonthOfDate((Date)skssqz) - DateUtils.getMonthOfDate((Date)skssqq);
        DynamicObject[] dynamicObjects = ItpMultiDataQueryBussiness.queryMutliMainTableData(templatetype, orgId, DateUtils.getFirstDateOfYear((Date)skssqq), skssqz, qFilter);
        ArrayList<Long> idList = new ArrayList<Long>(12);
        if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                Date skssqq1 = dynamicObject.getDate("skssqq");
                Date skssqz1 = dynamicObject.getDate("skssqz");
                if (DateUtils.getMonthOfDate((Date)skssqz1) - DateUtils.getMonthOfDate((Date)skssqq1) != month) continue;
                idList.add(dynamicObject.getLong("id"));
            }
        }
        Map<String, Map<String, String>> bnbdzdMap = ItpMultiDataQueryBussiness.queryMultiDetailDynCellValue(idList, Arrays.asList("zcycgl_gaap_zsxcy_cyxm#1", "zcycgl_zsxcy_cyxm#1"), "zcycgl_bbxm", "zcycgl_bnbd_zdqs", fetchitemList);
        Map<String, Map<String, String>> bnbdtzMap = ItpMultiDataQueryBussiness.queryMultiDetailDynCellValue(idList, Arrays.asList("zcycgl_gaap_zsxcy_cyxm#1", "zcycgl_zsxcy_cyxm#1"), "zcycgl_bbxm", "zcycgl_bnbd_tz", fetchitemList);
        Map<String, Map<String, String>> multiDetailFixCellValue = ItpMultiDataQueryBussiness.queryMultiDetailFixCellValue(idList, Arrays.asList("dqsds_sl#dqsds_bndb_zdqs", "dqsds_sl#dqsds_bndb_tz"));
        HashMap resultbnbdzdMap = new HashMap(12);
        HashMap resultbnbdtzMap = new HashMap(12);
        if (ObjectUtils.isNotEmpty(bnbdzdMap) || ObjectUtils.isNotEmpty(bnbdtzMap)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String id = dynamicObject.getString("id");
                Date skssqq1 = dynamicObject.getDate("skssqq");
                Date skssqz1 = dynamicObject.getDate("skssqz");
                String mapkey = DateUtils.format((Date)skssqq1) + "_" + DateUtils.format((Date)skssqz1);
                if (bnbdzdMap.containsKey(id)) {
                    if (!resultbnbdzdMap.containsKey(mapkey)) {
                        HashMap objectObjectHashMap = new HashMap(2);
                        resultbnbdzdMap.put(mapkey, objectObjectHashMap);
                    }
                    ((Map)resultbnbdzdMap.get(mapkey)).putAll(bnbdzdMap.get(id));
                    ((Map)resultbnbdzdMap.get(mapkey)).put("startDate", DateUtils.format((Date)skssqq1));
                    ((Map)resultbnbdzdMap.get(mapkey)).put("endDate", DateUtils.format((Date)skssqz1));
                    ((Map)resultbnbdzdMap.get(mapkey)).put("taxrate", multiDetailFixCellValue.get(id).get("dqsds_sl#dqsds_bndb_zdqs"));
                }
                if (!bnbdtzMap.containsKey(id)) continue;
                if (!resultbnbdtzMap.containsKey(mapkey)) {
                    resultbnbdtzMap.put(mapkey, new HashMap());
                }
                ((Map)resultbnbdtzMap.get(mapkey)).putAll(bnbdtzMap.get(id));
                ((Map)resultbnbdtzMap.get(mapkey)).put("startDate", DateUtils.format((Date)skssqq1));
                ((Map)resultbnbdtzMap.get(mapkey)).put("endDate", DateUtils.format((Date)skssqz1));
                ((Map)resultbnbdtzMap.get(mapkey)).put("taxrate", multiDetailFixCellValue.get(id).get("dqsds_sl#dqsds_bndb_tz"));
            }
        }
        resultMap.put("zcycgl_bnbd_zdqs", resultbnbdzdMap);
        resultMap.put("zcycgl_bnbd_tz", resultbnbdtzMap);
        return resultMap;
    }

    private String calculateHistoryCellValue(Map<String, Object> planMap, String bbId, Map<String, Map<String, String>> cellvalueMap, int month) {
        ImmutablePair immutablePair = (ImmutablePair)planMap.get(bbId);
        Date right = (Date)immutablePair.right;
        String value = "0";
        if (ObjectUtils.isNotEmpty((Object)right)) {
            String format = "";
            if (month == 0) {
                format = DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)right)) + "_" + DateUtils.format((Date)right);
            } else {
                Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)right);
                Date lastDateOfSeason = DateUtils.getLastDateOfSeason((Date)firstDateOfSeason);
                format = DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)firstDateOfSeason)) + "_" + DateUtils.format((Date)lastDateOfSeason);
            }
            if (cellvalueMap.containsKey(format)) {
                Map<String, String> bdxmMap = cellvalueMap.get(format);
                value = bdxmMap.get(bbId);
                String taxrate = bdxmMap.get("taxrate") != null ? bdxmMap.get("taxrate") : "0";
                value = "(" + value + " * " + taxrate + ") / 100";
            }
        }
        return value;
    }
}

